/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Determine position, velocity and altitude using GPS.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/GPSV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*,
    converting_callback_receiver::ConvertingCallbackReceiver,
    converting_receiver::{BrickletRecvTimeoutError, ConvertingReceiver},
    device::*,
    ip_connection::GetRequestSender,
    low_level_traits::*,
};
pub enum GpsV2BrickletFunction {
    GetCoordinates,
    GetStatus,
    GetAltitude,
    GetMotion,
    GetDateTime,
    Restart,
    GetSatelliteSystemStatusLowLevel,
    GetSatelliteStatus,
    SetFixLedConfig,
    GetFixLedConfig,
    SetCoordinatesCallbackPeriod,
    GetCoordinatesCallbackPeriod,
    SetStatusCallbackPeriod,
    GetStatusCallbackPeriod,
    SetAltitudeCallbackPeriod,
    GetAltitudeCallbackPeriod,
    SetMotionCallbackPeriod,
    GetMotionCallbackPeriod,
    SetDateTimeCallbackPeriod,
    GetDateTimeCallbackPeriod,
    SetSbasConfig,
    GetSbasConfig,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackPulsePerSecond,
    CallbackCoordinates,
    CallbackStatus,
    CallbackAltitude,
    CallbackMotion,
    CallbackDateTime,
}
impl From<GpsV2BrickletFunction> for u8 {
    fn from(fun: GpsV2BrickletFunction) -> Self {
        match fun {
            GpsV2BrickletFunction::GetCoordinates => 1,
            GpsV2BrickletFunction::GetStatus => 2,
            GpsV2BrickletFunction::GetAltitude => 3,
            GpsV2BrickletFunction::GetMotion => 4,
            GpsV2BrickletFunction::GetDateTime => 5,
            GpsV2BrickletFunction::Restart => 6,
            GpsV2BrickletFunction::GetSatelliteSystemStatusLowLevel => 7,
            GpsV2BrickletFunction::GetSatelliteStatus => 8,
            GpsV2BrickletFunction::SetFixLedConfig => 9,
            GpsV2BrickletFunction::GetFixLedConfig => 10,
            GpsV2BrickletFunction::SetCoordinatesCallbackPeriod => 11,
            GpsV2BrickletFunction::GetCoordinatesCallbackPeriod => 12,
            GpsV2BrickletFunction::SetStatusCallbackPeriod => 13,
            GpsV2BrickletFunction::GetStatusCallbackPeriod => 14,
            GpsV2BrickletFunction::SetAltitudeCallbackPeriod => 15,
            GpsV2BrickletFunction::GetAltitudeCallbackPeriod => 16,
            GpsV2BrickletFunction::SetMotionCallbackPeriod => 17,
            GpsV2BrickletFunction::GetMotionCallbackPeriod => 18,
            GpsV2BrickletFunction::SetDateTimeCallbackPeriod => 19,
            GpsV2BrickletFunction::GetDateTimeCallbackPeriod => 20,
            GpsV2BrickletFunction::SetSbasConfig => 27,
            GpsV2BrickletFunction::GetSbasConfig => 28,
            GpsV2BrickletFunction::GetSpitfpErrorCount => 234,
            GpsV2BrickletFunction::SetBootloaderMode => 235,
            GpsV2BrickletFunction::GetBootloaderMode => 236,
            GpsV2BrickletFunction::SetWriteFirmwarePointer => 237,
            GpsV2BrickletFunction::WriteFirmware => 238,
            GpsV2BrickletFunction::SetStatusLedConfig => 239,
            GpsV2BrickletFunction::GetStatusLedConfig => 240,
            GpsV2BrickletFunction::GetChipTemperature => 242,
            GpsV2BrickletFunction::Reset => 243,
            GpsV2BrickletFunction::WriteUid => 248,
            GpsV2BrickletFunction::ReadUid => 249,
            GpsV2BrickletFunction::GetIdentity => 255,
            GpsV2BrickletFunction::CallbackPulsePerSecond => 21,
            GpsV2BrickletFunction::CallbackCoordinates => 22,
            GpsV2BrickletFunction::CallbackStatus => 23,
            GpsV2BrickletFunction::CallbackAltitude => 24,
            GpsV2BrickletFunction::CallbackMotion => 25,
            GpsV2BrickletFunction::CallbackDateTime => 26,
        }
    }
}
pub const GPS_V2_BRICKLET_RESTART_TYPE_HOT_START: u8 = 0;
pub const GPS_V2_BRICKLET_RESTART_TYPE_WARM_START: u8 = 1;
pub const GPS_V2_BRICKLET_RESTART_TYPE_COLD_START: u8 = 2;
pub const GPS_V2_BRICKLET_RESTART_TYPE_FACTORY_RESET: u8 = 3;
pub const GPS_V2_BRICKLET_SATELLITE_SYSTEM_GPS: u8 = 0;
pub const GPS_V2_BRICKLET_SATELLITE_SYSTEM_GLONASS: u8 = 1;
pub const GPS_V2_BRICKLET_SATELLITE_SYSTEM_GALILEO: u8 = 2;
pub const GPS_V2_BRICKLET_FIX_NO_FIX: u8 = 1;
pub const GPS_V2_BRICKLET_FIX_2D_FIX: u8 = 2;
pub const GPS_V2_BRICKLET_FIX_3D_FIX: u8 = 3;
pub const GPS_V2_BRICKLET_FIX_LED_CONFIG_OFF: u8 = 0;
pub const GPS_V2_BRICKLET_FIX_LED_CONFIG_ON: u8 = 1;
pub const GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_FIX: u8 = 3;
pub const GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_PPS: u8 = 4;
pub const GPS_V2_BRICKLET_SBAS_ENABLED: u8 = 0;
pub const GPS_V2_BRICKLET_SBAS_DISABLED: u8 = 1;
pub const GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const GPS_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const GPS_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const GPS_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Coordinates {
    pub latitude: u32,
    pub ns: char,
    pub longitude: u32,
    pub ew: char,
}
impl FromByteSlice for Coordinates {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> Coordinates {
        Coordinates {
            latitude: <u32>::from_le_byte_slice(&bytes[0..4]),
            ns: <char>::from_le_byte_slice(&bytes[4..5]),
            longitude: <u32>::from_le_byte_slice(&bytes[5..9]),
            ew: <char>::from_le_byte_slice(&bytes[9..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Status {
    pub has_fix: bool,
    pub satellites_view: u8,
}
impl FromByteSlice for Status {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Status {
        Status { has_fix: <bool>::from_le_byte_slice(&bytes[0..1]), satellites_view: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Altitude {
    pub altitude: i32,
    pub geoidal_separation: i32,
}
impl FromByteSlice for Altitude {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Altitude {
        Altitude { altitude: <i32>::from_le_byte_slice(&bytes[0..4]), geoidal_separation: <i32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Motion {
    pub course: u32,
    pub speed: u32,
}
impl FromByteSlice for Motion {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> Motion {
        Motion { course: <u32>::from_le_byte_slice(&bytes[0..4]), speed: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTime {
    pub date: u32,
    pub time: u32,
}
impl FromByteSlice for DateTime {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTime {
        DateTime { date: <u32>::from_le_byte_slice(&bytes[0..4]), time: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SatelliteSystemStatusLowLevel {
    pub satellite_numbers_length: u8,
    pub satellite_numbers_data: [u8; 12],
    pub fix: u8,
    pub pdop: u16,
    pub hdop: u16,
    pub vdop: u16,
}
impl FromByteSlice for SatelliteSystemStatusLowLevel {
    fn bytes_expected() -> usize { 20 }
    fn from_le_byte_slice(bytes: &[u8]) -> SatelliteSystemStatusLowLevel {
        SatelliteSystemStatusLowLevel {
            satellite_numbers_length: <u8>::from_le_byte_slice(&bytes[0..1]),
            satellite_numbers_data: <[u8; 12]>::from_le_byte_slice(&bytes[1..13]),
            fix: <u8>::from_le_byte_slice(&bytes[13..14]),
            pdop: <u16>::from_le_byte_slice(&bytes[14..16]),
            hdop: <u16>::from_le_byte_slice(&bytes[16..18]),
            vdop: <u16>::from_le_byte_slice(&bytes[18..20]),
        }
    }
}
impl LowLevelRead<u8, SatelliteSystemStatusResult> for SatelliteSystemStatusLowLevel {
    fn ll_message_length(&self) -> usize { self.satellite_numbers_length as usize }

    fn ll_message_chunk_offset(&self) -> usize { 0 }

    fn ll_message_chunk_data(&self) -> &[u8] { &self.satellite_numbers_data }

    fn get_result(&self) -> SatelliteSystemStatusResult {
        SatelliteSystemStatusResult { fix: self.fix, pdop: self.pdop, hdop: self.hdop, vdop: self.vdop }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SatelliteStatus {
    pub elevation: i16,
    pub azimuth: i16,
    pub snr: i16,
}
impl FromByteSlice for SatelliteStatus {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> SatelliteStatus {
        SatelliteStatus {
            elevation: <i16>::from_le_byte_slice(&bytes[0..2]),
            azimuth: <i16>::from_le_byte_slice(&bytes[2..4]),
            snr: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct CoordinatesEvent {
    pub latitude: u32,
    pub ns: char,
    pub longitude: u32,
    pub ew: char,
}
impl FromByteSlice for CoordinatesEvent {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> CoordinatesEvent {
        CoordinatesEvent {
            latitude: <u32>::from_le_byte_slice(&bytes[0..4]),
            ns: <char>::from_le_byte_slice(&bytes[4..5]),
            longitude: <u32>::from_le_byte_slice(&bytes[5..9]),
            ew: <char>::from_le_byte_slice(&bytes[9..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StatusEvent {
    pub has_fix: bool,
    pub satellites_view: u8,
}
impl FromByteSlice for StatusEvent {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> StatusEvent {
        StatusEvent { has_fix: <bool>::from_le_byte_slice(&bytes[0..1]), satellites_view: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AltitudeEvent {
    pub altitude: i32,
    pub geoidal_separation: i32,
}
impl FromByteSlice for AltitudeEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> AltitudeEvent {
        AltitudeEvent { altitude: <i32>::from_le_byte_slice(&bytes[0..4]), geoidal_separation: <i32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct MotionEvent {
    pub course: u32,
    pub speed: u32,
}
impl FromByteSlice for MotionEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> MotionEvent {
        MotionEvent { course: <u32>::from_le_byte_slice(&bytes[0..4]), speed: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DateTimeEvent {
    pub date: u32,
    pub time: u32,
}
impl FromByteSlice for DateTimeEvent {
    fn bytes_expected() -> usize { 8 }
    fn from_le_byte_slice(bytes: &[u8]) -> DateTimeEvent {
        DateTimeEvent { date: <u32>::from_le_byte_slice(&bytes[0..4]), time: <u32>::from_le_byte_slice(&bytes[4..8]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SatelliteSystemStatusResult {
    pub fix: u8,
    pub pdop: u16,
    pub hdop: u16,
    pub vdop: u16,
}

/// Determine position, velocity and altitude using GPS
#[derive(Clone)]
pub struct GpsV2Bricklet {
    device: Device,
}
impl GpsV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 276;
    pub const DEVICE_DISPLAY_NAME: &'static str = "GPS Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> GpsV2Bricklet {
        let mut result = GpsV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 1) };
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetCoordinates) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetAltitude) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetMotion) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetDateTime) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::Restart) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetSatelliteSystemStatusLowLevel) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetSatelliteStatus) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetFixLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetFixLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetCoordinatesCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetCoordinatesCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetStatusCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetStatusCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetAltitudeCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetAltitudeCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetMotionCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetMotionCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetDateTimeCallbackPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetDateTimeCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetSbasConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetSbasConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetBootloaderMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetWriteFirmwarePointer) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetStatusLedConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(GpsV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::gps_v2_bricklet::GpsV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::gps_v2_bricklet::GpsV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: GpsV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: GpsV2BrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered precisely once per second,
    /// see [PPS](https://en.wikipedia.org/wiki/Pulse-per-second_signal)__.
    ///
    /// The precision of two subsequent pulses will be skewed because
    /// of the latency in the USB/RS485/Ethernet connection. But in the
    /// long run this will be very precise. For example a count of
    /// 3600 pulses will take exactly 1 hour.
    pub fn get_pulse_per_second_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackPulsePerSecond))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_coordinates_callback_period`]. The parameters are the same
    /// as for [`get_coordinates`].
    ///
    /// The [`get_coordinates_callback_receiver`] receiver is only triggered if the coordinates changed
    /// since the last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_coordinates_callback_receiver(&self) -> ConvertingCallbackReceiver<CoordinatesEvent> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackCoordinates))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_status_callback_period`]. The parameters are the same
    /// as for [`get_status`].
    ///
    /// The [`get_status_callback_receiver`] receiver is only triggered if the status changed since the
    /// last triggering.
    pub fn get_status_callback_receiver(&self) -> ConvertingCallbackReceiver<StatusEvent> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackStatus))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_altitude_callback_period`]. The parameters are the same
    /// as for [`get_altitude`].
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude changed since the
    /// last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_altitude_callback_receiver(&self) -> ConvertingCallbackReceiver<AltitudeEvent> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackAltitude))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_motion_callback_period`]. The parameters are the same
    /// as for [`get_motion`].
    ///
    /// The [`get_motion_callback_receiver`] receiver is only triggered if the motion changed since the
    /// last triggering and if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_motion_callback_receiver(&self) -> ConvertingCallbackReceiver<MotionEvent> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackMotion))
    }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_date_time_callback_period`]. The parameters are the same
    /// as for [`get_date_time`].
    ///
    /// The [`get_date_time_callback_receiver`] receiver is only triggered if the date or time changed
    /// since the last triggering.
    pub fn get_date_time_callback_receiver(&self) -> ConvertingCallbackReceiver<DateTimeEvent> {
        self.device.get_callback_receiver(u8::from(GpsV2BrickletFunction::CallbackDateTime))
    }

    /// Returns the GPS coordinates. Latitude and longitude are given in the
    /// ``DD.dddddd°`` format, the value 57123468 means 57.123468°.
    /// The parameter ``ns`` and ``ew`` are the cardinal directions for
    /// latitude and longitude. Possible values for ``ns`` and ``ew`` are 'N', 'S', 'E'
    /// and 'W' (north, south, east and west).
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_coordinates(&self) -> ConvertingReceiver<Coordinates> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetCoordinates), payload)
    }

    /// Returns if a fix is currently available as well as the, the number of
    /// satellites that are in view.
    ///
    /// There is also a [green LED](gps_v2_bricklet_fix_led) on the Bricklet that
    /// indicates the fix status.
    pub fn get_status(&self) -> ConvertingReceiver<Status> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetStatus), payload)
    }

    /// Returns the current altitude and corresponding geoidal separation.
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_altitude(&self) -> ConvertingReceiver<Altitude> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetAltitude), payload)
    }

    /// Returns the current course and speed. A course of 0° means the Bricklet is
    /// traveling north bound and 90° means it is traveling east bound.
    ///
    /// Please note that this only returns useful values if an actual movement
    /// is present.
    ///
    /// This data is only valid if there is currently a fix as indicated by
    /// [`get_status`].
    pub fn get_motion(&self) -> ConvertingReceiver<Motion> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetMotion), payload)
    }

    /// Returns the current date and time. The date is
    /// given in the format ``ddmmyy`` and the time is given
    /// in the format ``hhmmss.sss``. For example, 140713 means
    /// 14.07.13 as date and 195923568 means 19:59:23.568 as time.
    pub fn get_date_time(&self) -> ConvertingReceiver<DateTime> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetDateTime), payload)
    }

    /// Restarts the GPS Bricklet, the following restart types are available:
    ///
    ///  Value| Description
    ///  --- | ---
    ///  0| Hot start (use all available data in the NV store)
    ///  1| Warm start (don't use ephemeris at restart)
    ///  2| Cold start (don't use time| position| almanacs and ephemeris at restart)
    ///  3| Factory reset (clear all system/user configurations at restart)
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_RESTART_TYPE_HOT_START
    ///	* GPS_V2_BRICKLET_RESTART_TYPE_WARM_START
    ///	* GPS_V2_BRICKLET_RESTART_TYPE_COLD_START
    ///	* GPS_V2_BRICKLET_RESTART_TYPE_FACTORY_RESET
    pub fn restart(&self, restart_type: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(restart_type));

        self.device.set(u8::from(GpsV2BrickletFunction::Restart), payload)
    }

    /// Returns the
    ///
    /// * satellite numbers list (up to 12 items)
    /// * fix value,
    /// * PDOP value,
    /// * HDOP value and
    /// * VDOP value
    ///
    /// for a given satellite system. Currently GPS and GLONASS are supported, Galileo
    /// is not yet supported.
    ///
    /// The GPS and GLONASS satellites have unique numbers and the satellite list gives
    /// the numbers of the satellites that are currently utilized. The number 0 is not
    /// a valid satellite number and can be ignored in the list.
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_SATELLITE_SYSTEM_GPS
    ///	* GPS_V2_BRICKLET_SATELLITE_SYSTEM_GLONASS
    ///	* GPS_V2_BRICKLET_SATELLITE_SYSTEM_GALILEO
    ///	* GPS_V2_BRICKLET_FIX_NO_FIX
    ///	* GPS_V2_BRICKLET_FIX_2D_FIX
    ///	* GPS_V2_BRICKLET_FIX_3D_FIX
    pub fn get_satellite_system_status_low_level(&self, satellite_system: u8) -> ConvertingReceiver<SatelliteSystemStatusLowLevel> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(satellite_system));

        self.device.get(u8::from(GpsV2BrickletFunction::GetSatelliteSystemStatusLowLevel), payload)
    }

    /// Returns the
    ///
    /// * satellite numbers list (up to 12 items)
    /// * fix value,
    /// * PDOP value,
    /// * HDOP value and
    /// * VDOP value
    ///
    /// for a given satellite system. Currently GPS and GLONASS are supported, Galileo
    /// is not yet supported.
    ///
    /// The GPS and GLONASS satellites have unique numbers and the satellite list gives
    /// the numbers of the satellites that are currently utilized. The number 0 is not
    /// a valid satellite number and can be ignored in the list.
    pub fn get_satellite_system_status(
        &self,
        satellite_system: u8,
    ) -> Result<(Vec<u8>, SatelliteSystemStatusResult), BrickletRecvTimeoutError> {
        let ll_result = self.device.get_high_level(0, &mut || self.get_satellite_system_status_low_level(satellite_system).recv())?;
        Ok((ll_result.0, ll_result.1))
    }

    /// Returns the current elevation, azimuth and SNR
    /// for a given satellite and satellite system.
    ///
    /// The satellite number here always goes from 1 to 32. For GLONASS it corresponds to
    /// the satellites 65-96.
    ///
    /// Galileo is not yet supported.
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_SATELLITE_SYSTEM_GPS
    ///	* GPS_V2_BRICKLET_SATELLITE_SYSTEM_GLONASS
    ///	* GPS_V2_BRICKLET_SATELLITE_SYSTEM_GALILEO
    pub fn get_satellite_status(&self, satellite_system: u8, satellite_number: u8) -> ConvertingReceiver<SatelliteStatus> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(satellite_system));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(satellite_number));

        self.device.get(u8::from(GpsV2BrickletFunction::GetSatelliteStatus), payload)
    }

    /// Sets the fix LED configuration. By default the LED shows if
    /// the Bricklet got a GPS fix yet. If a fix is established the LED turns on.
    /// If there is no fix then the LED is turned off.
    ///
    /// You can also turn the LED permanently on/off, show a heartbeat or let it blink
    /// in sync with the PPS (pulse per second) output of the GPS module.
    ///
    /// If the Bricklet is in bootloader mode, the LED is off.
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_FIX_LED_CONFIG_OFF
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_ON
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_HEARTBEAT
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_FIX
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_PPS
    pub fn set_fix_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(GpsV2BrickletFunction::SetFixLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_fix_led_config`]
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_FIX_LED_CONFIG_OFF
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_ON
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_HEARTBEAT
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_FIX
    ///	* GPS_V2_BRICKLET_FIX_LED_CONFIG_SHOW_PPS
    pub fn get_fix_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetFixLedConfig), payload)
    }

    /// Sets the period with which the [`get_coordinates_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_coordinates_callback_receiver`] receiver is only triggered if the coordinates changed
    /// since the last triggering.
    pub fn set_coordinates_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsV2BrickletFunction::SetCoordinatesCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_coordinates_callback_period`].
    pub fn get_coordinates_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetCoordinatesCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_status_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_status_callback_receiver`] receiver is only triggered if the status changed since the
    /// last triggering.
    pub fn set_status_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsV2BrickletFunction::SetStatusCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_status_callback_period`].
    pub fn get_status_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetStatusCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_altitude_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_altitude_callback_receiver`] receiver is only triggered if the altitude changed since the
    /// last triggering.
    pub fn set_altitude_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsV2BrickletFunction::SetAltitudeCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_altitude_callback_period`].
    pub fn get_altitude_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetAltitudeCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_motion_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_motion_callback_receiver`] receiver is only triggered if the motion changed since the
    /// last triggering.
    pub fn set_motion_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsV2BrickletFunction::SetMotionCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_motion_callback_period`].
    pub fn get_motion_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetMotionCallbackPeriod), payload)
    }

    /// Sets the period with which the [`get_date_time_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_date_time_callback_receiver`] receiver is only triggered if the date or time changed
    /// since the last triggering.
    pub fn set_date_time_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(GpsV2BrickletFunction::SetDateTimeCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_date_time_callback_period`].
    pub fn get_date_time_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetDateTimeCallbackPeriod), payload)
    }

    /// If [SBAS](https://en.wikipedia.org/wiki/GNSS_augmentation#Satellite-based_augmentation_system)__ is enabled,
    /// the position accuracy increases (if SBAS satellites are in view),
    /// but the update rate is limited to 5Hz. With SBAS disabled the update rate is increased to 10Hz.
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_SBAS_ENABLED
    ///	* GPS_V2_BRICKLET_SBAS_DISABLED
    pub fn set_sbas_config(&self, sbas_config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sbas_config));

        self.device.set(u8::from(GpsV2BrickletFunction::SetSbasConfig), payload)
    }

    /// Returns the SBAS configuration as set by [`set_sbas_config`]
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_SBAS_ENABLED
    ///	* GPS_V2_BRICKLET_SBAS_DISABLED
    pub fn get_sbas_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetSbasConfig), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(GpsV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* GPS_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(GpsV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(GpsV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(GpsV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * GPS_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* GPS_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(GpsV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(GpsV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(GpsV2BrickletFunction::GetIdentity), payload)
    }
}
