/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures dust density.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DustDetector_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DustDetectorBrickletFunction {
    GetDustDensity,
    SetDustDensityCallbackPeriod,
    GetDustDensityCallbackPeriod,
    SetDustDensityCallbackThreshold,
    GetDustDensityCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetMovingAverage,
    GetMovingAverage,
    GetIdentity,
    CallbackDustDensity,
    CallbackDustDensityReached,
}
impl From<DustDetectorBrickletFunction> for u8 {
    fn from(fun: DustDetectorBrickletFunction) -> Self {
        match fun {
            DustDetectorBrickletFunction::GetDustDensity => 1,
            DustDetectorBrickletFunction::SetDustDensityCallbackPeriod => 2,
            DustDetectorBrickletFunction::GetDustDensityCallbackPeriod => 3,
            DustDetectorBrickletFunction::SetDustDensityCallbackThreshold => 4,
            DustDetectorBrickletFunction::GetDustDensityCallbackThreshold => 5,
            DustDetectorBrickletFunction::SetDebouncePeriod => 6,
            DustDetectorBrickletFunction::GetDebouncePeriod => 7,
            DustDetectorBrickletFunction::SetMovingAverage => 10,
            DustDetectorBrickletFunction::GetMovingAverage => 11,
            DustDetectorBrickletFunction::GetIdentity => 255,
            DustDetectorBrickletFunction::CallbackDustDensity => 8,
            DustDetectorBrickletFunction::CallbackDustDensityReached => 9,
        }
    }
}
pub const DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DustDensityCallbackThreshold {
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for DustDensityCallbackThreshold {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> DustDensityCallbackThreshold {
        DustDensityCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u16>::from_le_byte_slice(&bytes[1..3]),
            max: <u16>::from_le_byte_slice(&bytes[3..5]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures dust density
#[derive(Clone)]
pub struct DustDetectorBricklet {
    device: Device,
}
impl DustDetectorBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 260;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Dust Detector Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DustDetectorBricklet {
        let mut result = DustDetectorBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetDustDensity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::SetDustDensityCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetDustDensityCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::SetDustDensityCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetDustDensityCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::SetMovingAverage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetMovingAverage) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DustDetectorBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dust_detector_bricklet::DustDetectorBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dust_detector_bricklet::DustDetectorBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DustDetectorBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: DustDetectorBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_dust_density_callback_period`]. The parameter is the
    /// dust density of the sensor.
    ///
    /// Der [`get_dust_density_callback_receiver`] receiver is only triggered if the dust density value has
    /// changed since the last triggering.
    ///
    /// [`set_dust_density_callback_period`]: #method.set_dust_density_callback_period
    /// [`get_dust_density_callback_receiver`]: #method.get_dust_density_callback_receiver
    pub fn get_dust_density_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(DustDetectorBrickletFunction::CallbackDustDensity))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_dust_density_callback_threshold`] is reached.
    /// The parameter is the dust density of the sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_dust_density_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(DustDetectorBrickletFunction::CallbackDustDensityReached))
    }

    /// Returns the dust density.
    ///
    /// If you want to get the dust density periodically, it is recommended
    /// to use the [`get_dust_density_callback_receiver`] receiver and set the period with
    /// [`set_dust_density_callback_period`].
    pub fn get_dust_density(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetDustDensity), payload)
    }

    /// Sets the period with which the [`get_dust_density_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_dust_density_callback_receiver`] receiver is only triggered if the dust density has
    /// changed since the last triggering.
    pub fn set_dust_density_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(DustDetectorBrickletFunction::SetDustDensityCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_dust_density_callback_period`].
    pub fn get_dust_density_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetDustDensityCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_dust_density_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the dust density value is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the dust density value is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the dust density value is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the dust density value is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_dust_density_callback_threshold(&self, option: char, min: u16, max: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[3..5].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(DustDetectorBrickletFunction::SetDustDensityCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_dust_density_callback_threshold`].
    ///
    /// Associated constants:
    /// * DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DUST_DETECTOR_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_dust_density_callback_threshold(&self) -> ConvertingReceiver<DustDensityCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetDustDensityCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_dust_density_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_dust_density_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(DustDetectorBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the dust density.
    ///
    /// Setting the length to 0 will turn the averaging completely off. With less
    /// averaging, there is more noise on the data.
    pub fn set_moving_average(&self, average: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(average));

        self.device.set(u8::from(DustDetectorBrickletFunction::SetMovingAverage), payload)
    }

    /// Returns the length moving average as set by [`set_moving_average`].
    pub fn get_moving_average(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetMovingAverage), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DustDetectorBrickletFunction::GetIdentity), payload)
    }
}
