/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Two tactile buttons with built-in blue LEDs.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DualButtonV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DualButtonV2BrickletFunction {
    SetLedState,
    GetLedState,
    GetButtonState,
    SetSelectedLedState,
    SetStateChangedCallbackConfiguration,
    GetStateChangedCallbackConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackStateChanged,
}
impl From<DualButtonV2BrickletFunction> for u8 {
    fn from(fun: DualButtonV2BrickletFunction) -> Self {
        match fun {
            DualButtonV2BrickletFunction::SetLedState => 1,
            DualButtonV2BrickletFunction::GetLedState => 2,
            DualButtonV2BrickletFunction::GetButtonState => 3,
            DualButtonV2BrickletFunction::SetSelectedLedState => 5,
            DualButtonV2BrickletFunction::SetStateChangedCallbackConfiguration => 6,
            DualButtonV2BrickletFunction::GetStateChangedCallbackConfiguration => 7,
            DualButtonV2BrickletFunction::GetSpitfpErrorCount => 234,
            DualButtonV2BrickletFunction::SetBootloaderMode => 235,
            DualButtonV2BrickletFunction::GetBootloaderMode => 236,
            DualButtonV2BrickletFunction::SetWriteFirmwarePointer => 237,
            DualButtonV2BrickletFunction::WriteFirmware => 238,
            DualButtonV2BrickletFunction::SetStatusLedConfig => 239,
            DualButtonV2BrickletFunction::GetStatusLedConfig => 240,
            DualButtonV2BrickletFunction::GetChipTemperature => 242,
            DualButtonV2BrickletFunction::Reset => 243,
            DualButtonV2BrickletFunction::WriteUid => 248,
            DualButtonV2BrickletFunction::ReadUid => 249,
            DualButtonV2BrickletFunction::GetIdentity => 255,
            DualButtonV2BrickletFunction::CallbackStateChanged => 4,
        }
    }
}
pub const DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_ON: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_LED_STATE_ON: u8 = 2;
pub const DUAL_BUTTON_V2_BRICKLET_LED_STATE_OFF: u8 = 3;
pub const DUAL_BUTTON_V2_BRICKLET_BUTTON_STATE_PRESSED: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_BUTTON_STATE_RELEASED: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_LED_LEFT: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_LED_RIGHT: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct LedState {
    pub led_l: u8,
    pub led_r: u8,
}
impl FromByteSlice for LedState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> LedState {
        LedState { led_l: <u8>::from_le_byte_slice(&bytes[0..1]), led_r: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ButtonState {
    pub button_l: u8,
    pub button_r: u8,
}
impl FromByteSlice for ButtonState {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> ButtonState {
        ButtonState { button_l: <u8>::from_le_byte_slice(&bytes[0..1]), button_r: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct StateChangedEvent {
    pub button_l: u8,
    pub button_r: u8,
    pub led_l: u8,
    pub led_r: u8,
}
impl FromByteSlice for StateChangedEvent {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> StateChangedEvent {
        StateChangedEvent {
            button_l: <u8>::from_le_byte_slice(&bytes[0..1]),
            button_r: <u8>::from_le_byte_slice(&bytes[1..2]),
            led_l: <u8>::from_le_byte_slice(&bytes[2..3]),
            led_r: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Two tactile buttons with built-in blue LEDs
#[derive(Clone)]
pub struct DualButtonV2Bricklet {
    device: Device,
}
impl DualButtonV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2119;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Dual Button Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DualButtonV2Bricklet {
        let mut result = DualButtonV2Bricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetLedState) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetLedState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetButtonState) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetSelectedLedState) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetStateChangedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetStateChangedCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DualButtonV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dual_button_v2_bricklet::DualButtonV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dual_button_v2_bricklet::DualButtonV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DualButtonV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: DualButtonV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is called whenever a button is pressed.
    ///
    /// Possible states for buttons are:
    ///
    /// * 0 = pressed
    /// * 1 = released
    ///
    /// Possible states for LEDs are:
    ///
    /// * 0 = AutoToggleOn: Auto toggle enabled and LED on.
    /// * 1 = AutoToggleOff: Auto toggle enabled and LED off.
    /// * 2 = On: LED on (auto toggle is disabled).
    /// * 3 = Off: LED off (auto toggle is disabled).
    ///
    /// This receiver can be enabled with [`set_state_changed_callback_configuration`].
    ///
    /// [`set_state_changed_callback_configuration`]: #method.set_state_changed_callback_configuration
    pub fn get_state_changed_callback_receiver(&self) -> ConvertingCallbackReceiver<StateChangedEvent> {
        self.device.get_callback_receiver(u8::from(DualButtonV2BrickletFunction::CallbackStateChanged))
    }

    /// Sets the state of the LEDs. Possible states are:
    ///
    /// * 0 = AutoToggleOn: Enables auto toggle with initially enabled LED.
    /// * 1 = AutoToggleOff: Activates auto toggle with initially disabled LED.
    /// * 2 = On: Enables LED (auto toggle is disabled).
    /// * 3 = Off: Disables LED (auto toggle is disabled).
    ///
    /// In auto toggle mode the LED is toggled automatically at each press of a button.
    ///
    /// If you just want to set one of the LEDs and don't know the current state
    /// of the other LED, you can get the state with [`get_led_state`] or you
    /// can use [`set_selected_led_state`].
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_OFF
    pub fn set_led_state(&self, led_l: u8, led_r: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(led_l));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(led_r));

        self.device.set(u8::from(DualButtonV2BrickletFunction::SetLedState), payload)
    }

    /// Returns the current state of the LEDs, as set by [`set_led_state`].
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_OFF
    pub fn get_led_state(&self) -> ConvertingReceiver<LedState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetLedState), payload)
    }

    /// Returns the current state for both buttons. Possible states are:
    ///
    /// * 0 = pressed
    /// * 1 = released
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_BUTTON_STATE_PRESSED
    ///	* DUAL_BUTTON_V2_BRICKLET_BUTTON_STATE_RELEASED
    pub fn get_button_state(&self) -> ConvertingReceiver<ButtonState> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetButtonState), payload)
    }

    /// Sets the state of the selected LED.
    ///
    /// The other LED remains untouched.
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_LED_LEFT
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_RIGHT
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_AUTO_TOGGLE_OFF
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_LED_STATE_OFF
    pub fn set_selected_led_state(&self, led: u8, state: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(led));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(state));

        self.device.set(u8::from(DualButtonV2BrickletFunction::SetSelectedLedState), payload)
    }

    /// If you enable this receiver, the [`get_state_changed_callback_receiver`] receiver is triggered
    /// every time a button is pressed/released
    pub fn set_state_changed_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(DualButtonV2BrickletFunction::SetStateChangedCallbackConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_state_changed_callback_configuration`].
    pub fn get_state_changed_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetStateChangedCallbackConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(DualButtonV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DUAL_BUTTON_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(DualButtonV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(DualButtonV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DualButtonV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DUAL_BUTTON_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DualButtonV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(DualButtonV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DualButtonV2BrickletFunction::GetIdentity), payload)
    }
}
