/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures distance up to 150cm with infrared light.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/DistanceIRV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DistanceIrV2BrickletFunction {
    GetDistance,
    SetDistanceCallbackConfiguration,
    GetDistanceCallbackConfiguration,
    GetAnalogValue,
    SetAnalogValueCallbackConfiguration,
    GetAnalogValueCallbackConfiguration,
    SetMovingAverageConfiguration,
    GetMovingAverageConfiguration,
    SetDistanceLedConfig,
    GetDistanceLedConfig,
    SetSensorType,
    GetSensorType,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackDistance,
    CallbackAnalogValue,
}
impl From<DistanceIrV2BrickletFunction> for u8 {
    fn from(fun: DistanceIrV2BrickletFunction) -> Self {
        match fun {
            DistanceIrV2BrickletFunction::GetDistance => 1,
            DistanceIrV2BrickletFunction::SetDistanceCallbackConfiguration => 2,
            DistanceIrV2BrickletFunction::GetDistanceCallbackConfiguration => 3,
            DistanceIrV2BrickletFunction::GetAnalogValue => 5,
            DistanceIrV2BrickletFunction::SetAnalogValueCallbackConfiguration => 6,
            DistanceIrV2BrickletFunction::GetAnalogValueCallbackConfiguration => 7,
            DistanceIrV2BrickletFunction::SetMovingAverageConfiguration => 9,
            DistanceIrV2BrickletFunction::GetMovingAverageConfiguration => 10,
            DistanceIrV2BrickletFunction::SetDistanceLedConfig => 11,
            DistanceIrV2BrickletFunction::GetDistanceLedConfig => 12,
            DistanceIrV2BrickletFunction::SetSensorType => 13,
            DistanceIrV2BrickletFunction::GetSensorType => 14,
            DistanceIrV2BrickletFunction::GetSpitfpErrorCount => 234,
            DistanceIrV2BrickletFunction::SetBootloaderMode => 235,
            DistanceIrV2BrickletFunction::GetBootloaderMode => 236,
            DistanceIrV2BrickletFunction::SetWriteFirmwarePointer => 237,
            DistanceIrV2BrickletFunction::WriteFirmware => 238,
            DistanceIrV2BrickletFunction::SetStatusLedConfig => 239,
            DistanceIrV2BrickletFunction::GetStatusLedConfig => 240,
            DistanceIrV2BrickletFunction::GetChipTemperature => 242,
            DistanceIrV2BrickletFunction::Reset => 243,
            DistanceIrV2BrickletFunction::WriteUid => 248,
            DistanceIrV2BrickletFunction::ReadUid => 249,
            DistanceIrV2BrickletFunction::GetIdentity => 255,
            DistanceIrV2BrickletFunction::CallbackDistance => 4,
            DistanceIrV2BrickletFunction::CallbackAnalogValue => 8,
        }
    }
}
pub const DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF: u8 = 0;
pub const DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_ON: u8 = 1;
pub const DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE: u8 = 3;
pub const DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A41: u8 = 0;
pub const DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A21: u8 = 1;
pub const DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A02: u8 = 2;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct DistanceCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u16,
    pub max: u16,
}
impl FromByteSlice for DistanceCallbackConfiguration {
    fn bytes_expected() -> usize { 10 }
    fn from_le_byte_slice(bytes: &[u8]) -> DistanceCallbackConfiguration {
        DistanceCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u16>::from_le_byte_slice(&bytes[6..8]),
            max: <u16>::from_le_byte_slice(&bytes[8..10]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AnalogValueCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
    pub option: char,
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for AnalogValueCallbackConfiguration {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> AnalogValueCallbackConfiguration {
        AnalogValueCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
            option: <char>::from_le_byte_slice(&bytes[5..6]),
            min: <u32>::from_le_byte_slice(&bytes[6..10]),
            max: <u32>::from_le_byte_slice(&bytes[10..14]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures distance up to 150cm with infrared light
#[derive(Clone)]
pub struct DistanceIrV2Bricklet {
    device: Device,
}
impl DistanceIrV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2125;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Distance IR Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DistanceIrV2Bricklet {
        let mut result = DistanceIrV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetDistance) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetDistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetDistanceCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetAnalogValue) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetAnalogValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetAnalogValueCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetMovingAverageConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetMovingAverageConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetDistanceLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetDistanceLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetSensorType) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetSensorType) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::WriteFirmware) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::SetStatusLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DistanceIrV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::distance_ir_v2_bricklet::DistanceIrV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::distance_ir_v2_bricklet::DistanceIrV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DistanceIrV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: DistanceIrV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_distance_callback_configuration`].
    ///
    /// The parameter is the same as [`get_distance`].
    ///
    /// [`get_distance`]: #method.get_distance
    /// [`set_distance_callback_configuration`]: #method.set_distance_callback_configuration
    pub fn get_distance_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(DistanceIrV2BrickletFunction::CallbackDistance))
    }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_analog_value_callback_configuration`].
    ///
    /// The parameter is the same as [`get_analog_value`].
    pub fn get_analog_value_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(DistanceIrV2BrickletFunction::CallbackAnalogValue))
    }

    /// Returns the distance measured by the sensor. Possible
    /// distance ranges are 40 to 300, 100 to 800 and 200 to 1500, depending on the
    /// selected IR sensor.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_distance_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_distance_callback_configuration`].
    pub fn get_distance(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetDistance), payload)
    }

    /// The period is the period with which the [`get_distance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_distance_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_distance_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u16,
        max: u16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 10];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..8].copy_from_slice(&<u16>::to_le_byte_vec(min));
        payload[8..10].copy_from_slice(&<u16>::to_le_byte_vec(max));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetDistanceCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_distance_callback_configuration`].
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_distance_callback_configuration(&self) -> ConvertingReceiver<DistanceCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetDistanceCallbackConfiguration), payload)
    }

    /// Returns the analog value as read by a analog-to-digital converter.
    ///
    /// This is unfiltered raw data. We made sure that the integration time
    /// of the ADC is shorter then the measurement interval of the sensor
    /// (10ms vs 16.5ms). So there is no information lost.
    ///
    /// If you want to do your own calibration or create your own lookup table
    /// you can use this value.
    ///
    ///
    /// If you want to get the value periodically, it is recommended to use the
    /// [`get_analog_value_callback_receiver`] receiver. You can set the receiver configuration
    /// with [`set_analog_value_callback_configuration`].
    pub fn get_analog_value(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetAnalogValue), payload)
    }

    /// The period is the period with which the [`get_analog_value_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change
    /// within the period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// It is furthermore possible to constrain the receiver with thresholds.
    ///
    /// The `option`-parameter together with min/max sets a threshold for the [`get_analog_value_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Threshold is turned off
    ///  'o'|    Threshold is triggered when the value is *outside* the min and max values
    ///  'i'|    Threshold is triggered when the value is *inside* or equal to the min and max values
    ///  '<'|    Threshold is triggered when the value is smaller than the min value (max is ignored)
    ///  '>'|    Threshold is triggered when the value is greater than the min value (max is ignored)
    ///
    /// If the option is set to 'x' (threshold turned off) the receiver is triggered with the fixed period.
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_analog_value_callback_configuration(
        &self,
        period: u32,
        value_has_to_change: bool,
        option: char,
        min: u32,
        max: u32,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 14];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));
        payload[5..6].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[6..10].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[10..14].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetAnalogValueCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by [`set_analog_value_callback_configuration`].
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* DISTANCE_IR_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_analog_value_callback_configuration(&self) -> ConvertingReceiver<AnalogValueCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetAnalogValueCallbackConfiguration), payload)
    }

    /// Sets the length of a [moving averaging](https://en.wikipedia.org/wiki/Moving_average)__
    /// for the distance.
    ///
    /// Setting the length to 1 will turn the averaging off. With less averaging, there
    /// is more noise on the data.
    ///
    /// New data is gathered every ~10ms. With a moving average of length 1000 the
    /// resulting averaging window has a length of approximately 10s. If you want to do
    /// long term measurements the longest moving average will give the cleanest results.
    pub fn set_moving_average_configuration(&self, moving_average_length: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(moving_average_length));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetMovingAverageConfiguration), payload)
    }

    /// Returns the moving average configuration as set by [`set_moving_average_configuration`].
    pub fn get_moving_average_configuration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetMovingAverageConfiguration), payload)
    }

    /// Configures the distance LED to be either turned off, turned on, blink in
    /// heartbeat mode or show the distance (brighter = object is nearer).
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_ON
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE
    pub fn set_distance_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetDistanceLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_distance_led_config`]
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_ON
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DISTANCE_IR_V2_BRICKLET_DISTANCE_LED_CONFIG_SHOW_DISTANCE
    pub fn get_distance_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetDistanceLedConfig), payload)
    }

    /// Sets the sensor type.
    ///
    /// The Bricklet comes configured with the correct sensor type
    /// and the type is saved in flash (i.e. the Bricklet retains the information if
    /// power is lost).
    ///
    /// If you want to change the sensor you can set the type in Brick Viewer,
    /// you will likely never need to call this function from your program.
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A41
    ///	* DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A21
    ///	* DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A02
    pub fn set_sensor_type(&self, sensor: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(sensor));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetSensorType), payload)
    }

    /// Returns the sensor type as set by [`set_sensor_type`].
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A41
    ///	* DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A21
    ///	* DISTANCE_IR_V2_BRICKLET_SENSOR_TYPE_2Y0A02
    pub fn get_sensor_type(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetSensorType), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(DistanceIrV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* DISTANCE_IR_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(DistanceIrV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* DISTANCE_IR_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DistanceIrV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(DistanceIrV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DistanceIrV2BrickletFunction::GetIdentity), payload)
    }
}
