/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Drives one brushed DC motor with up to 28V and 5A (peak).
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricks/DC_Brick_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum DcBrickFunction {
    SetVelocity,
    GetVelocity,
    GetCurrentVelocity,
    SetAcceleration,
    GetAcceleration,
    SetPwmFrequency,
    GetPwmFrequency,
    FullBrake,
    GetStackInputVoltage,
    GetExternalInputVoltage,
    GetCurrentConsumption,
    Enable,
    Disable,
    IsEnabled,
    SetMinimumVoltage,
    GetMinimumVoltage,
    SetDriveMode,
    GetDriveMode,
    SetCurrentVelocityPeriod,
    GetCurrentVelocityPeriod,
    SetSpitfpBaudrateConfig,
    GetSpitfpBaudrateConfig,
    GetSendTimeoutCount,
    SetSpitfpBaudrate,
    GetSpitfpBaudrate,
    GetSpitfpErrorCount,
    EnableStatusLed,
    DisableStatusLed,
    IsStatusLedEnabled,
    GetProtocol1BrickletName,
    GetChipTemperature,
    Reset,
    WriteBrickletPlugin,
    ReadBrickletPlugin,
    GetIdentity,
    CallbackUnderVoltage,
    CallbackEmergencyShutdown,
    CallbackVelocityReached,
    CallbackCurrentVelocity,
}
impl From<DcBrickFunction> for u8 {
    fn from(fun: DcBrickFunction) -> Self {
        match fun {
            DcBrickFunction::SetVelocity => 1,
            DcBrickFunction::GetVelocity => 2,
            DcBrickFunction::GetCurrentVelocity => 3,
            DcBrickFunction::SetAcceleration => 4,
            DcBrickFunction::GetAcceleration => 5,
            DcBrickFunction::SetPwmFrequency => 6,
            DcBrickFunction::GetPwmFrequency => 7,
            DcBrickFunction::FullBrake => 8,
            DcBrickFunction::GetStackInputVoltage => 9,
            DcBrickFunction::GetExternalInputVoltage => 10,
            DcBrickFunction::GetCurrentConsumption => 11,
            DcBrickFunction::Enable => 12,
            DcBrickFunction::Disable => 13,
            DcBrickFunction::IsEnabled => 14,
            DcBrickFunction::SetMinimumVoltage => 15,
            DcBrickFunction::GetMinimumVoltage => 16,
            DcBrickFunction::SetDriveMode => 17,
            DcBrickFunction::GetDriveMode => 18,
            DcBrickFunction::SetCurrentVelocityPeriod => 19,
            DcBrickFunction::GetCurrentVelocityPeriod => 20,
            DcBrickFunction::SetSpitfpBaudrateConfig => 231,
            DcBrickFunction::GetSpitfpBaudrateConfig => 232,
            DcBrickFunction::GetSendTimeoutCount => 233,
            DcBrickFunction::SetSpitfpBaudrate => 234,
            DcBrickFunction::GetSpitfpBaudrate => 235,
            DcBrickFunction::GetSpitfpErrorCount => 237,
            DcBrickFunction::EnableStatusLed => 238,
            DcBrickFunction::DisableStatusLed => 239,
            DcBrickFunction::IsStatusLedEnabled => 240,
            DcBrickFunction::GetProtocol1BrickletName => 241,
            DcBrickFunction::GetChipTemperature => 242,
            DcBrickFunction::Reset => 243,
            DcBrickFunction::WriteBrickletPlugin => 246,
            DcBrickFunction::ReadBrickletPlugin => 247,
            DcBrickFunction::GetIdentity => 255,
            DcBrickFunction::CallbackUnderVoltage => 21,
            DcBrickFunction::CallbackEmergencyShutdown => 22,
            DcBrickFunction::CallbackVelocityReached => 23,
            DcBrickFunction::CallbackCurrentVelocity => 24,
        }
    }
}
pub const DC_BRICK_DRIVE_MODE_DRIVE_BRAKE: u8 = 0;
pub const DC_BRICK_DRIVE_MODE_DRIVE_COAST: u8 = 1;
pub const DC_BRICK_COMMUNICATION_METHOD_NONE: u8 = 0;
pub const DC_BRICK_COMMUNICATION_METHOD_USB: u8 = 1;
pub const DC_BRICK_COMMUNICATION_METHOD_SPI_STACK: u8 = 2;
pub const DC_BRICK_COMMUNICATION_METHOD_CHIBI: u8 = 3;
pub const DC_BRICK_COMMUNICATION_METHOD_RS485: u8 = 4;
pub const DC_BRICK_COMMUNICATION_METHOD_WIFI: u8 = 5;
pub const DC_BRICK_COMMUNICATION_METHOD_ETHERNET: u8 = 6;
pub const DC_BRICK_COMMUNICATION_METHOD_WIFI_V2: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpBaudrateConfig {
    pub enable_dynamic_baudrate: bool,
    pub minimum_dynamic_baudrate: u32,
}
impl FromByteSlice for SpitfpBaudrateConfig {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpBaudrateConfig {
        SpitfpBaudrateConfig {
            enable_dynamic_baudrate: <bool>::from_le_byte_slice(&bytes[0..1]),
            minimum_dynamic_baudrate: <u32>::from_le_byte_slice(&bytes[1..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone)]
pub struct Protocol1BrickletName {
    pub protocol_version: u8,
    pub firmware_version: [u8; 3],
    pub name: String,
}
impl FromByteSlice for Protocol1BrickletName {
    fn bytes_expected() -> usize { 44 }
    fn from_le_byte_slice(bytes: &[u8]) -> Protocol1BrickletName {
        Protocol1BrickletName {
            protocol_version: <u8>::from_le_byte_slice(&bytes[0..1]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[1..4]),
            name: <String>::from_le_byte_slice(&bytes[4..44]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Drives one brushed DC motor with up to 28V and 5A (peak)
#[derive(Clone)]
pub struct DcBrick {
    device: Device,
}
impl DcBrick {
    pub const DEVICE_IDENTIFIER: u16 = 11;
    pub const DEVICE_DISPLAY_NAME: &'static str = "DC Brick";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> DcBrick {
        let mut result = DcBrick { device: Device::new([2, 0, 3], uid, req_sender, 0) };
        result.device.response_expected[u8::from(DcBrickFunction::SetVelocity) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetCurrentVelocity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetAcceleration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetAcceleration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetPwmFrequency) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetPwmFrequency) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::FullBrake) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetStackInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetExternalInputVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetCurrentConsumption) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::Enable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::Disable) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::IsEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetMinimumVoltage) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DcBrickFunction::GetMinimumVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetDriveMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetDriveMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetCurrentVelocityPeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(DcBrickFunction::GetCurrentVelocityPeriod) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetSpitfpBaudrateConfig) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetSendTimeoutCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::SetSpitfpBaudrate) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::GetSpitfpBaudrate) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetSpitfpErrorCount) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::EnableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::DisableStatusLed) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::IsStatusLedEnabled) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetProtocol1BrickletName) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetChipTemperature) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::WriteBrickletPlugin) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(DcBrickFunction::ReadBrickletPlugin) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(DcBrickFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::dc_brick::DcBrick::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::dc_brick::DcBrick::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: DcBrickFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: DcBrickFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered when the input voltage drops below the value set by
    /// [`set_minimum_voltage`]. The parameter is the current voltage.
    ///
    /// [`set_minimum_voltage`]: #method.set_minimum_voltage
    pub fn get_under_voltage_callback_receiver(&self) -> ConvertingCallbackReceiver<u16> {
        self.device.get_callback_receiver(u8::from(DcBrickFunction::CallbackUnderVoltage))
    }

    /// This receiver is triggered if either the current consumption
    /// is too high (above 5A) or the temperature of the driver chip is too high
    /// (above 175°C). These two possibilities are essentially the same, since the
    /// temperature will reach this threshold immediately if the motor consumes too
    /// much current. In case of a voltage below 3.3V (external or stack) this
    /// receiver is triggered as well.
    ///
    /// If this receiver is triggered, the driver chip gets disabled at the same time.
    /// That means, [`enable`] has to be called to drive the motor again.
    ///
    /// # Note
    ///  This receiver only works in Drive/Brake mode (see [`set_drive_mode`]). In
    ///  Drive/Coast mode it is unfortunately impossible to reliably read the
    ///  overcurrent/overtemperature signal from the driver chip.
    pub fn get_emergency_shutdown_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(DcBrickFunction::CallbackEmergencyShutdown))
    }

    /// This receiver is triggered whenever a set velocity is reached. For example:
    /// If a velocity of 0 is present, acceleration is set to 5000 and velocity
    /// to 10000, the [`get_velocity_reached_callback_receiver`] receiver will be triggered after about
    /// 2 seconds, when the set velocity is actually reached.
    ///
    /// # Note
    ///  Since we can't get any feedback from the DC motor, this only works if the
    ///  acceleration (see [`set_acceleration`]) is set smaller or equal to the
    ///  maximum acceleration of the motor. Otherwise the motor will lag behind the
    ///  control value and the receiver will be triggered too early.
    pub fn get_velocity_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(DcBrickFunction::CallbackVelocityReached))
    }

    /// This receiver is triggered with the period that is set by
    /// [`set_current_velocity_period`]. The parameter is the *current*
    /// velocity used by the motor.
    ///
    /// The [`get_current_velocity_callback_receiver`] receiver is only triggered after the set period
    /// if there is a change in the velocity.
    pub fn get_current_velocity_callback_receiver(&self) -> ConvertingCallbackReceiver<i16> {
        self.device.get_callback_receiver(u8::from(DcBrickFunction::CallbackCurrentVelocity))
    }

    /// Sets the velocity of the motor. Whereas -32767 is full speed backward,
    /// 0 is stop and 32767 is full speed forward. Depending on the
    /// acceleration (see [`set_acceleration`]), the motor is not immediately
    /// brought to the velocity but smoothly accelerated.
    ///
    /// The velocity describes the duty cycle of the PWM with which the motor is
    /// controlled, e.g. a velocity of 3277 sets a PWM with a 10% duty cycle.
    /// You can not only control the duty cycle of the PWM but also the frequency,
    /// see [`set_pwm_frequency`].
    pub fn set_velocity(&self, velocity: i16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<i16>::to_le_byte_vec(velocity));

        self.device.set(u8::from(DcBrickFunction::SetVelocity), payload)
    }

    /// Returns the velocity as set by [`set_velocity`].
    pub fn get_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetVelocity), payload)
    }

    /// Returns the *current* velocity of the motor. This value is different
    /// from [`get_velocity`] whenever the motor is currently accelerating
    /// to a goal set by [`set_velocity`].
    pub fn get_current_velocity(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetCurrentVelocity), payload)
    }

    /// Sets the acceleration of the motor. It is given in *velocity/s*. An
    /// acceleration of 10000 means, that every second the velocity is increased
    /// by 10000 (or about 30% duty cycle).
    ///
    /// For example: If the current velocity is 0 and you want to accelerate to a
    /// velocity of 16000 (about 50% duty cycle) in 10 seconds, you should set
    /// an acceleration of 1600.
    ///
    /// If acceleration is set to 0, there is no speed ramping, i.e. a new velocity
    /// is immediately given to the motor.
    pub fn set_acceleration(&self, acceleration: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(acceleration));

        self.device.set(u8::from(DcBrickFunction::SetAcceleration), payload)
    }

    /// Returns the acceleration as set by [`set_acceleration`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetAcceleration), payload)
    }

    /// Sets the frequency of the PWM with which the motor is driven.
    /// Often a high frequency
    /// is less noisy and the motor runs smoother. However, with a low frequency
    /// there are less switches and therefore fewer switching losses. Also with
    /// most motors lower frequencies enable higher torque.
    ///
    /// If you have no idea what all this means, just ignore this function and use
    /// the default frequency, it will very likely work fine.
    pub fn set_pwm_frequency(&self, frequency: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(frequency));

        self.device.set(u8::from(DcBrickFunction::SetPwmFrequency), payload)
    }

    /// Returns the PWM frequency as set by [`set_pwm_frequency`].
    pub fn get_pwm_frequency(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetPwmFrequency), payload)
    }

    /// Executes an active full brake.
    ///
    /// # Warning
    ///  This function is for emergency purposes,
    ///  where an immediate brake is necessary. Depending on the current velocity and
    ///  the strength of the motor, a full brake can be quite violent.
    ///
    /// Call [`set_velocity`] with 0 if you just want to stop the motor.
    pub fn full_brake(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::FullBrake), payload)
    }

    /// Returns the stack input voltage. The stack input voltage is the
    /// voltage that is supplied via the stack, i.e. it is given by a
    /// Step-Down or Step-Up Power Supply.
    pub fn get_stack_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetStackInputVoltage), payload)
    }

    /// Returns the external input voltage. The external input voltage is
    /// given via the black power input connector on the DC Brick.
    ///
    /// If there is an external input voltage and a stack input voltage, the motor
    /// will be driven by the external input voltage. If there is only a stack
    /// voltage present, the motor will be driven by this voltage.
    ///
    /// # Warning
    ///  This means, if you have a high stack voltage and a low external voltage,
    ///  the motor will be driven with the low external voltage. If you then remove
    ///  the external connection, it will immediately be driven by the high
    ///  stack voltage.
    pub fn get_external_input_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetExternalInputVoltage), payload)
    }

    /// Returns the current consumption of the motor.
    pub fn get_current_consumption(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetCurrentConsumption), payload)
    }

    /// Enables the driver chip. The driver parameters can be configured (velocity,
    /// acceleration, etc) before it is enabled.
    pub fn enable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::Enable), payload)
    }

    /// Disables the driver chip. The configurations are kept (velocity,
    /// acceleration, etc) but the motor is not driven until it is enabled again.
    ///
    /// # Warning
    ///  Disabling the driver chip while the motor is still turning can damage the
    ///  driver chip. The motor should be stopped calling [`set_velocity`] with 0
    ///  before disabling the motor power. The [`set_velocity`] function will **not**
    ///  wait until the motor is actually stopped. You have to explicitly wait for the
    ///  appropriate time after calling the [`set_velocity`] function before calling
    ///  the [`disable`] function.
    pub fn disable(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::Disable), payload)
    }

    /// Returns *true* if the driver chip is enabled, *false* otherwise.
    pub fn is_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::IsEnabled), payload)
    }

    /// Sets the minimum voltage, below which the [`get_under_voltage_callback_receiver`] receiver
    /// is triggered. The minimum possible value that works with the DC Brick is 6V.
    /// You can use this function to detect the discharge of a battery that is used
    /// to drive the motor. If you have a fixed power supply, you likely do not need
    /// this functionality.
    pub fn set_minimum_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(DcBrickFunction::SetMinimumVoltage), payload)
    }

    /// Returns the minimum voltage as set by [`set_minimum_voltage`]
    pub fn get_minimum_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetMinimumVoltage), payload)
    }

    /// Sets the drive mode. Possible modes are:
    ///
    /// * 0 = Drive/Brake
    /// * 1 = Drive/Coast
    ///
    /// These modes are different kinds of motor controls.
    ///
    /// In Drive/Brake mode, the motor is always either driving or braking. There
    /// is no freewheeling. Advantages are: A more linear correlation between
    /// PWM and velocity, more exact accelerations and the possibility to drive
    /// with slower velocities.
    ///
    /// In Drive/Coast mode, the motor is always either driving or freewheeling.
    /// Advantages are: Less current consumption and less demands on the motor and
    /// driver chip.
    ///
    /// Associated constants:
    /// * DC_BRICK_DRIVE_MODE_DRIVE_BRAKE
    ///	* DC_BRICK_DRIVE_MODE_DRIVE_COAST
    pub fn set_drive_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(DcBrickFunction::SetDriveMode), payload)
    }

    /// Returns the drive mode, as set by [`set_drive_mode`].
    ///
    /// Associated constants:
    /// * DC_BRICK_DRIVE_MODE_DRIVE_BRAKE
    ///	* DC_BRICK_DRIVE_MODE_DRIVE_COAST
    pub fn get_drive_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetDriveMode), payload)
    }

    /// Sets a period with which the [`get_current_velocity_callback_receiver`] receiver is triggered.
    /// A period of 0 turns the receiver off.
    pub fn set_current_velocity_period(&self, period: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(period));

        self.device.set(u8::from(DcBrickFunction::SetCurrentVelocityPeriod), payload)
    }

    /// Returns the period as set by [`set_current_velocity_period`].
    pub fn get_current_velocity_period(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetCurrentVelocityPeriod), payload)
    }

    /// The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
    /// enabled, the Brick will try to adapt the baudrate for the communication
    /// between Bricks and Bricklets according to the amount of data that is transferred.
    ///
    /// The baudrate will be increased exponentially if lots of data is sent/received and
    /// decreased linearly if little data is sent/received.
    ///
    /// This lowers the baudrate in applications where little data is transferred (e.g.
    /// a weather station) and increases the robustness. If there is lots of data to transfer
    /// (e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.
    ///
    /// In cases where some data has to transferred as fast as possible every few seconds
    /// (e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
    /// the dynamic baudrate off to get the highest possible performance.
    ///
    /// The maximum value of the baudrate can be set per port with the function
    /// [`set_spitfp_baudrate`]. If the dynamic baudrate is disabled, the baudrate
    /// as set by [`set_spitfp_baudrate`] will be used statically.
    ///
    ///
    /// .. versionadded:: 2.3.5$nbsp;(Firmware)
    pub fn set_spitfp_baudrate_config(&self, enable_dynamic_baudrate: bool, minimum_dynamic_baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_dynamic_baudrate));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(minimum_dynamic_baudrate));

        self.device.set(u8::from(DcBrickFunction::SetSpitfpBaudrateConfig), payload)
    }

    /// Returns the baudrate config, see [`set_spitfp_baudrate_config`].
    ///
    ///
    /// .. versionadded:: 2.3.5$nbsp;(Firmware)
    pub fn get_spitfp_baudrate_config(&self) -> ConvertingReceiver<SpitfpBaudrateConfig> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetSpitfpBaudrateConfig), payload)
    }

    /// Returns the timeout count for the different communication methods.
    ///
    /// The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.
    ///
    /// This function is mostly used for debugging during development, in normal operation
    /// the counters should nearly always stay at 0.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    ///
    /// Associated constants:
    /// * DC_BRICK_COMMUNICATION_METHOD_NONE
    ///	* DC_BRICK_COMMUNICATION_METHOD_USB
    ///	* DC_BRICK_COMMUNICATION_METHOD_SPI_STACK
    ///	* DC_BRICK_COMMUNICATION_METHOD_CHIBI
    ///	* DC_BRICK_COMMUNICATION_METHOD_RS485
    ///	* DC_BRICK_COMMUNICATION_METHOD_WIFI
    ///	* DC_BRICK_COMMUNICATION_METHOD_ETHERNET
    ///	* DC_BRICK_COMMUNICATION_METHOD_WIFI_V2
    pub fn get_send_timeout_count(&self, communication_method: u8) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(communication_method));

        self.device.get(u8::from(DcBrickFunction::GetSendTimeoutCount), payload)
    }

    /// Sets the baudrate for a specific Bricklet port.
    ///
    /// If you want to increase the throughput of Bricklets you can increase
    /// the baudrate. If you get a high error count because of high
    /// interference (see [`get_spitfp_error_count`]) you can decrease the
    /// baudrate.
    ///
    /// If the dynamic baudrate feature is enabled, the baudrate set by this
    /// function corresponds to the maximum baudrate (see [`set_spitfp_baudrate_config`]).
    ///
    /// Regulatory testing is done with the default baudrate. If CE compatibility
    /// or similar is necessary in your applications we recommend to not change
    /// the baudrate.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn set_spitfp_baudrate(&self, bricklet_port: char, baudrate: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(baudrate));

        self.device.set(u8::from(DcBrickFunction::SetSpitfpBaudrate), payload)
    }

    /// Returns the baudrate for a given Bricklet port, see [`set_spitfp_baudrate`].
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_baudrate(&self, bricklet_port: char) -> ConvertingReceiver<u32> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(DcBrickFunction::GetSpitfpBaudrate), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Brick side. All
    /// Bricklets have a similar function that returns the errors on the Bricklet side.
    ///
    ///
    /// .. versionadded:: 2.3.3$nbsp;(Firmware)
    pub fn get_spitfp_error_count(&self, bricklet_port: char) -> ConvertingReceiver<SpitfpErrorCount> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(bricklet_port));

        self.device.get(u8::from(DcBrickFunction::GetSpitfpErrorCount), payload)
    }

    /// Enables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn enable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::EnableStatusLed), payload)
    }

    /// Disables the status LED.
    ///
    /// The status LED is the blue LED next to the USB connector. If enabled is is
    /// on and it flickers if data is transfered. If disabled it is always off.
    ///
    /// The default state is enabled.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn disable_status_led(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::DisableStatusLed), payload)
    }

    /// Returns *true* if the status LED is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.3.1$nbsp;(Firmware)
    pub fn is_status_led_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::IsStatusLedEnabled), payload)
    }

    /// Returns the firmware and protocol version and the name of the Bricklet for a
    /// given port.
    ///
    /// This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
    /// plugins.
    pub fn get_protocol1_bricklet_name(&self, port: char) -> ConvertingReceiver<Protocol1BrickletName> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));

        self.device.get(u8::from(DcBrickFunction::GetProtocol1BrickletName), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has an
    /// accuracy of ±15%. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Brick. Calling this function
    /// on a Brick inside of a stack will reset the whole stack.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(DcBrickFunction::Reset), payload)
    }

    /// Writes 32 bytes of firmware to the bricklet attached at the given port.
    /// The bytes are written to the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_bricklet_plugin(&self, port: char, offset: u8, chunk: [u8; 32]) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 34];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));
        payload[2..34].copy_from_slice(&<[u8; 32]>::to_le_byte_vec(chunk));

        self.device.set(u8::from(DcBrickFunction::WriteBrickletPlugin), payload)
    }

    /// Reads 32 bytes of firmware from the bricklet attached at the given port.
    /// The bytes are read starting at the position offset * 32.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn read_bricklet_plugin(&self, port: char, offset: u8) -> ConvertingReceiver<[u8; 32]> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(port));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(offset));

        self.device.get(u8::from(DcBrickFunction::ReadBrickletPlugin), payload)
    }

    /// Returns the UID, the UID where the Brick is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position is the position in the stack from '0' (bottom) to '8' (top).
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(DcBrickFunction::GetIdentity), payload)
    }
}
