/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Communicates with CAN bus devices.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/CAN_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum CanBrickletFunction {
    WriteFrame,
    ReadFrame,
    EnableFrameReadCallback,
    DisableFrameReadCallback,
    IsFrameReadCallbackEnabled,
    SetConfiguration,
    GetConfiguration,
    SetReadFilter,
    GetReadFilter,
    GetErrorLog,
    SetFrameReadableCallbackConfiguration,
    GetFrameReadableCallbackConfiguration,
    GetIdentity,
    CallbackFrameRead,
    CallbackFrameReadable,
}
impl From<CanBrickletFunction> for u8 {
    fn from(fun: CanBrickletFunction) -> Self {
        match fun {
            CanBrickletFunction::WriteFrame => 1,
            CanBrickletFunction::ReadFrame => 2,
            CanBrickletFunction::EnableFrameReadCallback => 3,
            CanBrickletFunction::DisableFrameReadCallback => 4,
            CanBrickletFunction::IsFrameReadCallbackEnabled => 5,
            CanBrickletFunction::SetConfiguration => 6,
            CanBrickletFunction::GetConfiguration => 7,
            CanBrickletFunction::SetReadFilter => 8,
            CanBrickletFunction::GetReadFilter => 9,
            CanBrickletFunction::GetErrorLog => 10,
            CanBrickletFunction::SetFrameReadableCallbackConfiguration => 12,
            CanBrickletFunction::GetFrameReadableCallbackConfiguration => 13,
            CanBrickletFunction::GetIdentity => 255,
            CanBrickletFunction::CallbackFrameRead => 11,
            CanBrickletFunction::CallbackFrameReadable => 14,
        }
    }
}
pub const CAN_BRICKLET_FRAME_TYPE_STANDARD_DATA: u8 = 0;
pub const CAN_BRICKLET_FRAME_TYPE_STANDARD_REMOTE: u8 = 1;
pub const CAN_BRICKLET_FRAME_TYPE_EXTENDED_DATA: u8 = 2;
pub const CAN_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE: u8 = 3;
pub const CAN_BRICKLET_BAUD_RATE_10KBPS: u8 = 0;
pub const CAN_BRICKLET_BAUD_RATE_20KBPS: u8 = 1;
pub const CAN_BRICKLET_BAUD_RATE_50KBPS: u8 = 2;
pub const CAN_BRICKLET_BAUD_RATE_125KBPS: u8 = 3;
pub const CAN_BRICKLET_BAUD_RATE_250KBPS: u8 = 4;
pub const CAN_BRICKLET_BAUD_RATE_500KBPS: u8 = 5;
pub const CAN_BRICKLET_BAUD_RATE_800KBPS: u8 = 6;
pub const CAN_BRICKLET_BAUD_RATE_1000KBPS: u8 = 7;
pub const CAN_BRICKLET_TRANSCEIVER_MODE_NORMAL: u8 = 0;
pub const CAN_BRICKLET_TRANSCEIVER_MODE_LOOPBACK: u8 = 1;
pub const CAN_BRICKLET_TRANSCEIVER_MODE_READ_ONLY: u8 = 2;
pub const CAN_BRICKLET_FILTER_MODE_DISABLED: u8 = 0;
pub const CAN_BRICKLET_FILTER_MODE_ACCEPT_ALL: u8 = 1;
pub const CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD: u8 = 2;
pub const CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_DATA: u8 = 3;
pub const CAN_BRICKLET_FILTER_MODE_MATCH_EXTENDED: u8 = 4;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFrame {
    pub success: bool,
    pub frame_type: u8,
    pub identifier: u32,
    pub data: [u8; 8],
    pub length: u8,
}
impl FromByteSlice for ReadFrame {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFrame {
        ReadFrame {
            success: <bool>::from_le_byte_slice(&bytes[0..1]),
            frame_type: <u8>::from_le_byte_slice(&bytes[1..2]),
            identifier: <u32>::from_le_byte_slice(&bytes[2..6]),
            data: <[u8; 8]>::from_le_byte_slice(&bytes[6..14]),
            length: <u8>::from_le_byte_slice(&bytes[14..15]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub baud_rate: u8,
    pub transceiver_mode: u8,
    pub write_timeout: i32,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            baud_rate: <u8>::from_le_byte_slice(&bytes[0..1]),
            transceiver_mode: <u8>::from_le_byte_slice(&bytes[1..2]),
            write_timeout: <i32>::from_le_byte_slice(&bytes[2..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ReadFilter {
    pub mode: u8,
    pub mask: u32,
    pub filter1: u32,
    pub filter2: u32,
}
impl FromByteSlice for ReadFilter {
    fn bytes_expected() -> usize { 13 }
    fn from_le_byte_slice(bytes: &[u8]) -> ReadFilter {
        ReadFilter {
            mode: <u8>::from_le_byte_slice(&bytes[0..1]),
            mask: <u32>::from_le_byte_slice(&bytes[1..5]),
            filter1: <u32>::from_le_byte_slice(&bytes[5..9]),
            filter2: <u32>::from_le_byte_slice(&bytes[9..13]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ErrorLog {
    pub write_error_level: u8,
    pub read_error_level: u8,
    pub transceiver_disabled: bool,
    pub write_timeout_count: u32,
    pub read_register_overflow_count: u32,
    pub read_buffer_overflow_count: u32,
}
impl FromByteSlice for ErrorLog {
    fn bytes_expected() -> usize { 15 }
    fn from_le_byte_slice(bytes: &[u8]) -> ErrorLog {
        ErrorLog {
            write_error_level: <u8>::from_le_byte_slice(&bytes[0..1]),
            read_error_level: <u8>::from_le_byte_slice(&bytes[1..2]),
            transceiver_disabled: <bool>::from_le_byte_slice(&bytes[2..3]),
            write_timeout_count: <u32>::from_le_byte_slice(&bytes[3..7]),
            read_register_overflow_count: <u32>::from_le_byte_slice(&bytes[7..11]),
            read_buffer_overflow_count: <u32>::from_le_byte_slice(&bytes[11..15]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FrameReadEvent {
    pub frame_type: u8,
    pub identifier: u32,
    pub data: [u8; 8],
    pub length: u8,
}
impl FromByteSlice for FrameReadEvent {
    fn bytes_expected() -> usize { 14 }
    fn from_le_byte_slice(bytes: &[u8]) -> FrameReadEvent {
        FrameReadEvent {
            frame_type: <u8>::from_le_byte_slice(&bytes[0..1]),
            identifier: <u32>::from_le_byte_slice(&bytes[1..5]),
            data: <[u8; 8]>::from_le_byte_slice(&bytes[5..13]),
            length: <u8>::from_le_byte_slice(&bytes[13..14]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Communicates with CAN bus devices
#[derive(Clone)]
pub struct CanBricklet {
    device: Device,
}
impl CanBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 270;
    pub const DEVICE_DISPLAY_NAME: &'static str = "CAN Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> CanBricklet {
        let mut result = CanBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(CanBrickletFunction::WriteFrame) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::ReadFrame) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::EnableFrameReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanBrickletFunction::DisableFrameReadCallback) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanBrickletFunction::IsFrameReadCallbackEnabled) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanBrickletFunction::GetConfiguration) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::SetReadFilter) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(CanBrickletFunction::GetReadFilter) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::GetErrorLog) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::SetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(CanBrickletFunction::GetFrameReadableCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(CanBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::can_bricklet::CanBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::can_bricklet::CanBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: CanBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(&mut self, fun: CanBrickletFunction, response_expected: bool) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered if a data or remote frame was received by the CAN
    /// transceiver.
    ///
    /// The ``identifier`` return value follows the identifier format described for
    /// [`write_frame`].
    ///
    /// For remote frames the ``data`` return value always contains invalid values.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver at all (see [`set_read_filter`]).
    ///
    /// To enable this receiver, use [`enable_frame_read_callback`].
    ///
    /// [`write_frame`]: #method.write_frame
    /// [`enable_frame_read_callback`]: #method.enable_frame_read_callback
    /// [`set_read_filter`]: #method.set_read_filter
    pub fn get_frame_read_callback_receiver(&self) -> ConvertingCallbackReceiver<FrameReadEvent> {
        self.device.get_callback_receiver(u8::from(CanBrickletFunction::CallbackFrameRead))
    }

    /// This receiver is triggered if a data or remote frame was received by the CAN
    /// transceiver. The received frame can be read with [`read_frame`].
    /// If additional frames are received, but [`read_frame`] was not called yet, the receiver
    /// will not trigger again.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read queue (see
    /// [`set_read_filter`]).
    ///
    /// To enable this receiver, use [`set_frame_readable_callback_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_frame_readable_callback_receiver(&self) -> ConvertingCallbackReceiver<()> {
        self.device.get_callback_receiver(u8::from(CanBrickletFunction::CallbackFrameReadable))
    }

    /// Writes a data or remote frame to the write buffer to be transmitted over the
    /// CAN transceiver.
    ///
    /// The Bricklet supports the standard 11-bit (CAN 2.0A) and the additional extended
    /// 18-bit (CAN 2.0B) identifiers. For standard frames the Bricklet uses bit 0 to 10
    /// from the ``identifier`` parameter as standard 11-bit identifier. For extended
    /// frames the Bricklet additionally uses bit 11 to 28 from the ``identifier``
    /// parameter as extended 18-bit identifier.
    ///
    /// For remote frames the ``data`` parameter is ignored.
    ///
    /// Returns *true* if the frame was successfully added to the write buffer. Returns
    /// *false* if the frame could not be added because write buffer is already full.
    ///
    /// The write buffer can overflow if frames are written to it at a higher rate
    /// than the Bricklet can transmitted them over the CAN transceiver. This may
    /// happen if the CAN transceiver is configured as read-only or is using a low baud
    /// rate (see [`set_configuration`]). It can also happen if the CAN bus is
    /// congested and the frame cannot be transmitted because it constantly loses
    /// arbitration or because the CAN transceiver is currently disabled due to a high
    /// write error level (see [`get_error_log`]).
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_FRAME_TYPE_STANDARD_DATA
    ///	* CAN_BRICKLET_FRAME_TYPE_STANDARD_REMOTE
    ///	* CAN_BRICKLET_FRAME_TYPE_EXTENDED_DATA
    ///	* CAN_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE
    pub fn write_frame(&self, frame_type: u8, identifier: u32, data: [u8; 8], length: u8) -> ConvertingReceiver<bool> {
        let mut payload = vec![0; 14];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(frame_type));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(identifier));
        payload[5..13].copy_from_slice(&<[u8; 8]>::to_le_byte_vec(data));
        payload[13..14].copy_from_slice(&<u8>::to_le_byte_vec(length));

        self.device.get(u8::from(CanBrickletFunction::WriteFrame), payload)
    }

    /// Tries to read the next data or remote frame from the read buffer and return it.
    /// If a frame was successfully read, then the ``success`` return value is set to
    /// *true* and the other return values contain the frame. If the read buffer is
    /// empty and no frame could be read, then the ``success`` return value is set to
    /// *false* and the other return values contain invalid data.
    ///
    /// The ``identifier`` return value follows the identifier format described for
    /// [`write_frame`].
    ///
    /// For remote frames the ``data`` return value always contains invalid data.
    ///
    /// A configurable read filter can be used to define which frames should be
    /// received by the CAN transceiver and put into the read buffer (see
    /// [`set_read_filter`]).
    ///
    /// Instead of polling with this function, you can also use receivers. See the
    /// [`enable_frame_read_callback`] function and the [`get_frame_read_callback_receiver`] receiver.
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_FRAME_TYPE_STANDARD_DATA
    ///	* CAN_BRICKLET_FRAME_TYPE_STANDARD_REMOTE
    ///	* CAN_BRICKLET_FRAME_TYPE_EXTENDED_DATA
    ///	* CAN_BRICKLET_FRAME_TYPE_EXTENDED_REMOTE
    pub fn read_frame(&self) -> ConvertingReceiver<ReadFrame> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::ReadFrame), payload)
    }

    /// Enables the [`get_frame_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled. Enabling this receiver will disable the [`get_frame_readable_callback_receiver`] receiver.
    pub fn enable_frame_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(CanBrickletFunction::EnableFrameReadCallback), payload)
    }

    /// Disables the [`get_frame_read_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled.
    pub fn disable_frame_read_callback(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(CanBrickletFunction::DisableFrameReadCallback), payload)
    }

    /// Returns *true* if the [`get_frame_read_callback_receiver`] receiver is enabled, *false* otherwise.
    pub fn is_frame_read_callback_enabled(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::IsFrameReadCallbackEnabled), payload)
    }

    /// Sets the configuration for the CAN bus communication.
    ///
    /// The baud rate can be configured in steps between 10 and 1000 kbit/s.
    ///
    /// The CAN transceiver has three different modes:
    ///
    /// * Normal: Reads from and writes to the CAN bus and performs active bus
    ///   error detection and acknowledgement.
    /// * Loopback: All reads and writes are performed internally. The transceiver
    ///   is disconnected from the actual CAN bus.
    /// * Read-Only: Only reads from the CAN bus, but does neither active bus error
    ///   detection nor acknowledgement. Only the receiving part of the transceiver
    ///   is connected to the CAN bus.
    ///
    /// The write timeout has three different modes that define how a failed frame
    /// transmission should be handled:
    ///
    /// * One-Shot (= -1): Only one transmission attempt will be made. If the
    ///   transmission fails then the frame is discarded.
    /// * Infinite (= 0): Infinite transmission attempts will be made. The frame will
    ///   never be discarded.
    /// * Milliseconds (> 0): A limited number of transmission attempts will be made.
    ///   If the frame could not be transmitted successfully after the configured
    ///   number of milliseconds then the frame is discarded.
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_BAUD_RATE_10KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_20KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_50KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_125KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_250KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_500KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_800KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_1000KBPS
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_NORMAL
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_LOOPBACK
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_READ_ONLY
    pub fn set_configuration(&self, baud_rate: u8, transceiver_mode: u8, write_timeout: i32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 6];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(baud_rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(transceiver_mode));
        payload[2..6].copy_from_slice(&<i32>::to_le_byte_vec(write_timeout));

        self.device.set(u8::from(CanBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_BAUD_RATE_10KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_20KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_50KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_125KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_250KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_500KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_800KBPS
    ///	* CAN_BRICKLET_BAUD_RATE_1000KBPS
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_NORMAL
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_LOOPBACK
    ///	* CAN_BRICKLET_TRANSCEIVER_MODE_READ_ONLY
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::GetConfiguration), payload)
    }

    /// Set the read filter configuration. This can be used to define which frames
    /// should be received by the CAN transceiver and put into the read buffer.
    ///
    /// The read filter has five different modes that define if and how the mask and
    /// the two filters are applied:
    ///
    /// * Disabled: No filtering is applied at all. All frames are received even
    ///   incomplete and defective frames. This mode should be used for debugging only.
    /// * Accept-All: All complete and error-free frames are received.
    /// * Match-Standard: Only standard frames with a matching identifier are received.
    /// * Match-Standard-and-Data: Only standard frames with matching identifier and
    ///   data bytes are received.
    /// * Match-Extended: Only extended frames with a matching identifier are received.
    ///
    /// The mask and filters are used as bit masks. Their usage depends on the mode:
    ///
    /// * Disabled: Mask and filters are ignored.
    /// * Accept-All: Mask and filters are ignored.
    /// * Match-Standard: Bit 0 to 10 (11 bits) of mask and filters are used to match
    ///   the 11-bit identifier of standard frames.
    /// * Match-Standard-and-Data: Bit 0 to 10 (11 bits) of mask and filters are used
    ///   to match the 11-bit identifier of standard frames. Bit 11 to 18 (8 bits) and
    ///   bit 19 to 26 (8 bits) of mask and filters are used to match the first and
    ///   second data byte (if present) of standard frames.
    /// * Match-Extended: Bit 0 to 10 (11 bits) of mask and filters are used
    ///   to match the standard 11-bit identifier part of extended frames. Bit 11 to 28
    ///   (18 bits) of mask and filters are used to match the extended 18-bit identifier
    ///   part of extended frames.
    ///
    /// The mask and filters are applied in this way: The mask is used to select the
    /// identifier and data bits that should be compared to the corresponding filter
    /// bits. All unselected bits are automatically accepted. All selected bits have
    /// to match one of the filters to be accepted. If all bits for the selected mode
    /// are accepted then the frame is accepted and is added to the read buffer.
    ///
    ///  Mask Bit| Filter Bit| Identifier/Data Bit| Result
    ///  --- | --- | --- | ---
    ///  0| X| X| Accept
    ///  1| 0| 0| Accept
    ///  1| 0| 1| Reject
    ///  1| 1| 0| Reject
    ///  1| 1| 1| Accept
    ///
    /// For example, to receive standard frames with identifier 0x123 only the mode can
    /// be set to Match-Standard with 0x7FF as mask and 0x123 as filter 1 and filter 2.
    /// The mask of 0x7FF selects all 11 identifier bits for matching so that the
    /// identifier has to be exactly 0x123 to be accepted.
    ///
    /// To accept identifier 0x123 and identifier 0x456 at the same time, just set
    /// filter 2 to 0x456 and keep mask and filter 1 unchanged.
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_FILTER_MODE_DISABLED
    ///	* CAN_BRICKLET_FILTER_MODE_ACCEPT_ALL
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_DATA
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_EXTENDED
    pub fn set_read_filter(&self, mode: u8, mask: u32, filter1: u32, filter2: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 13];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(mask));
        payload[5..9].copy_from_slice(&<u32>::to_le_byte_vec(filter1));
        payload[9..13].copy_from_slice(&<u32>::to_le_byte_vec(filter2));

        self.device.set(u8::from(CanBrickletFunction::SetReadFilter), payload)
    }

    /// Returns the read filter as set by [`set_read_filter`].
    ///
    /// Associated constants:
    /// * CAN_BRICKLET_FILTER_MODE_DISABLED
    ///	* CAN_BRICKLET_FILTER_MODE_ACCEPT_ALL
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_STANDARD_AND_DATA
    ///	* CAN_BRICKLET_FILTER_MODE_MATCH_EXTENDED
    pub fn get_read_filter(&self) -> ConvertingReceiver<ReadFilter> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::GetReadFilter), payload)
    }

    /// Returns information about different kinds of errors.
    ///
    /// The write and read error levels indicate the current level of checksum,
    /// acknowledgement, form, bit and stuffing errors during CAN bus write and read
    /// operations.
    ///
    /// When the write error level exceeds 255 then the CAN transceiver gets disabled
    /// and no frames can be transmitted or received anymore. The CAN transceiver will
    /// automatically be activated again after the CAN bus is idle for a while.
    ///
    /// The write and read error levels are not available in read-only transceiver mode
    /// (see [`set_configuration`]) and are reset to 0 as a side effect of changing
    /// the configuration or the read filter.
    ///
    /// The write timeout, read register and buffer overflow counts represents the
    /// number of these errors:
    ///
    /// * A write timeout occurs if a frame could not be transmitted before the
    ///   configured write timeout expired (see [`set_configuration`]).
    /// * A read register overflow occurs if the read register of the CAN transceiver
    ///   still contains the last received frame when the next frame arrives. In this
    ///   case the newly arrived frame is lost. This happens if the CAN transceiver
    ///   receives more frames than the Bricklet can handle. Using the read filter
    ///   (see [`set_read_filter`]) can help to reduce the amount of received frames.
    ///   This count is not exact, but a lower bound, because the Bricklet might not
    ///   able detect all overflows if they occur in rapid succession.
    /// * A read buffer overflow occurs if the read buffer of the Bricklet is already
    ///   full when the next frame should be read from the read register of the CAN
    ///   transceiver. In this case the frame in the read register is lost. This
    ///   happens if the CAN transceiver receives more frames to be added to the read
    ///   buffer than are removed from the read buffer using the [`read_frame`]
    ///   function. Using the [`get_frame_read_callback_receiver`] receiver ensures that the read buffer
    ///   can not overflow.
    pub fn get_error_log(&self) -> ConvertingReceiver<ErrorLog> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::GetErrorLog), payload)
    }

    /// Enables/disables the [`get_frame_readable_callback_receiver`] receiver.
    ///
    /// By default the receiver is disabled. Enabling this receiver will disable the [`get_frame_read_callback_receiver`] receiver.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn set_frame_readable_callback_configuration(&self, enabled: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enabled));

        self.device.set(u8::from(CanBrickletFunction::SetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns *true* if the [`get_frame_readable_callback_receiver`] receiver is enabled, *false* otherwise.
    ///
    ///
    /// .. versionadded:: 2.0.1$nbsp;(Plugin)
    pub fn get_frame_readable_callback_configuration(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::GetFrameReadableCallbackConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(CanBrickletFunction::GetIdentity), payload)
    }
}
