/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Generates configurable DC voltage between 0V and 5V.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AnalogOut_Bricklet_Rust.html).
use crate::{byte_converter::*, converting_receiver::ConvertingReceiver, device::*, ip_connection::GetRequestSender};
pub enum AnalogOutBrickletFunction {
    SetVoltage,
    GetVoltage,
    SetMode,
    GetMode,
    GetIdentity,
}
impl From<AnalogOutBrickletFunction> for u8 {
    fn from(fun: AnalogOutBrickletFunction) -> Self {
        match fun {
            AnalogOutBrickletFunction::SetVoltage => 1,
            AnalogOutBrickletFunction::GetVoltage => 2,
            AnalogOutBrickletFunction::SetMode => 3,
            AnalogOutBrickletFunction::GetMode => 4,
            AnalogOutBrickletFunction::GetIdentity => 255,
        }
    }
}
pub const ANALOG_OUT_BRICKLET_MODE_ANALOG_VALUE: u8 = 0;
pub const ANALOG_OUT_BRICKLET_MODE_1K_TO_GROUND: u8 = 1;
pub const ANALOG_OUT_BRICKLET_MODE_100K_TO_GROUND: u8 = 2;
pub const ANALOG_OUT_BRICKLET_MODE_500K_TO_GROUND: u8 = 3;

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Generates configurable DC voltage between 0V and 5V
#[derive(Clone)]
pub struct AnalogOutBricklet {
    device: Device,
}
impl AnalogOutBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 220;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Analog Out Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AnalogOutBricklet {
        let mut result = AnalogOutBricklet { device: Device::new([2, 0, 0], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AnalogOutBrickletFunction::SetVoltage) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AnalogOutBrickletFunction::GetVoltage) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogOutBrickletFunction::SetMode) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AnalogOutBrickletFunction::GetMode) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AnalogOutBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::analog_out_bricklet::AnalogOutBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::analog_out_bricklet::AnalogOutBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AnalogOutBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AnalogOutBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// Sets the voltage. Calling this function will set
    /// the mode to 0 (see [`set_mode`]).
    ///
    /// [`set_mode`]: #method.set_mode
    pub fn set_voltage(&self, voltage: u16) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..2].copy_from_slice(&<u16>::to_le_byte_vec(voltage));

        self.device.set(u8::from(AnalogOutBrickletFunction::SetVoltage), payload)
    }

    /// Returns the voltage as set by [`set_voltage`].
    pub fn get_voltage(&self) -> ConvertingReceiver<u16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogOutBrickletFunction::GetVoltage), payload)
    }

    /// Sets the mode of the analog value. Possible modes:
    ///
    /// * 0: Normal Mode (Analog value as set by [`set_voltage`] is applied)
    /// * 1: 1k Ohm resistor to ground
    /// * 2: 100k Ohm resistor to ground
    /// * 3: 500k Ohm resistor to ground
    ///
    /// Setting the mode to 0 will result in an output voltage of 0 V. You can jump
    /// to a higher output voltage directly by calling [`set_voltage`].
    ///
    /// Associated constants:
    /// * ANALOG_OUT_BRICKLET_MODE_ANALOG_VALUE
    ///	* ANALOG_OUT_BRICKLET_MODE_1K_TO_GROUND
    ///	* ANALOG_OUT_BRICKLET_MODE_100K_TO_GROUND
    ///	* ANALOG_OUT_BRICKLET_MODE_500K_TO_GROUND
    pub fn set_mode(&self, mode: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.set(u8::from(AnalogOutBrickletFunction::SetMode), payload)
    }

    /// Returns the mode as set by [`set_mode`].
    ///
    /// Associated constants:
    /// * ANALOG_OUT_BRICKLET_MODE_ANALOG_VALUE
    ///	* ANALOG_OUT_BRICKLET_MODE_1K_TO_GROUND
    ///	* ANALOG_OUT_BRICKLET_MODE_100K_TO_GROUND
    ///	* ANALOG_OUT_BRICKLET_MODE_500K_TO_GROUND
    pub fn get_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogOutBrickletFunction::GetMode), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AnalogOutBrickletFunction::GetIdentity), payload)
    }
}
