/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures ambient light up to 64000lux.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AmbientLightV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AmbientLightV2BrickletFunction {
    GetIlluminance,
    SetIlluminanceCallbackPeriod,
    GetIlluminanceCallbackPeriod,
    SetIlluminanceCallbackThreshold,
    GetIlluminanceCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    SetConfiguration,
    GetConfiguration,
    GetIdentity,
    CallbackIlluminance,
    CallbackIlluminanceReached,
}
impl From<AmbientLightV2BrickletFunction> for u8 {
    fn from(fun: AmbientLightV2BrickletFunction) -> Self {
        match fun {
            AmbientLightV2BrickletFunction::GetIlluminance => 1,
            AmbientLightV2BrickletFunction::SetIlluminanceCallbackPeriod => 2,
            AmbientLightV2BrickletFunction::GetIlluminanceCallbackPeriod => 3,
            AmbientLightV2BrickletFunction::SetIlluminanceCallbackThreshold => 4,
            AmbientLightV2BrickletFunction::GetIlluminanceCallbackThreshold => 5,
            AmbientLightV2BrickletFunction::SetDebouncePeriod => 6,
            AmbientLightV2BrickletFunction::GetDebouncePeriod => 7,
            AmbientLightV2BrickletFunction::SetConfiguration => 8,
            AmbientLightV2BrickletFunction::GetConfiguration => 9,
            AmbientLightV2BrickletFunction::GetIdentity => 255,
            AmbientLightV2BrickletFunction::CallbackIlluminance => 10,
            AmbientLightV2BrickletFunction::CallbackIlluminanceReached => 11,
        }
    }
}
pub const AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED: u8 = 6;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_64000LUX: u8 = 0;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_32000LUX: u8 = 1;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_16000LUX: u8 = 2;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_8000LUX: u8 = 3;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_1300LUX: u8 = 4;
pub const AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_600LUX: u8 = 5;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_50MS: u8 = 0;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_100MS: u8 = 1;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_150MS: u8 = 2;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_200MS: u8 = 3;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_250MS: u8 = 4;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_300MS: u8 = 5;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_350MS: u8 = 6;
pub const AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_400MS: u8 = 7;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct IlluminanceCallbackThreshold {
    pub option: char,
    pub min: u32,
    pub max: u32,
}
impl FromByteSlice for IlluminanceCallbackThreshold {
    fn bytes_expected() -> usize { 9 }
    fn from_le_byte_slice(bytes: &[u8]) -> IlluminanceCallbackThreshold {
        IlluminanceCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min: <u32>::from_le_byte_slice(&bytes[1..5]),
            max: <u32>::from_le_byte_slice(&bytes[5..9]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub illuminance_range: u8,
    pub integration_time: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            illuminance_range: <u8>::from_le_byte_slice(&bytes[0..1]),
            integration_time: <u8>::from_le_byte_slice(&bytes[1..2]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures ambient light up to 64000lux
#[derive(Clone)]
pub struct AmbientLightV2Bricklet {
    device: Device,
}
impl AmbientLightV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 259;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Ambient Light Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AmbientLightV2Bricklet {
        let mut result = AmbientLightV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetIlluminance) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::SetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetIlluminanceCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::SetIlluminanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetIlluminanceCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AmbientLightV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::ambient_light_v2_bricklet::AmbientLightV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::ambient_light_v2_bricklet::AmbientLightV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AmbientLightV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AmbientLightV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_illuminance_callback_period`]. The parameter is the illuminance of the
    /// ambient light sensor.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed since the
    /// last triggering.
    ///
    /// [`set_illuminance_callback_period`]: #method.set_illuminance_callback_period
    /// [`get_illuminance_callback_receiver`]: #method.get_illuminance_callback_receiver
    pub fn get_illuminance_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(AmbientLightV2BrickletFunction::CallbackIlluminance))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_illuminance_callback_threshold`] is reached.
    /// The parameter is the illuminance of the ambient light sensor.
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_illuminance_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<u32> {
        self.device.get_callback_receiver(u8::from(AmbientLightV2BrickletFunction::CallbackIlluminanceReached))
    }

    /// Returns the illuminance of the ambient light sensor. The measurement range goes
    /// up to about 100000lux, but above 64000lux the precision starts to drop.
    ///
    /// .. versionchanged:: 2.0.2$nbsp;(Plugin)
    ///   An illuminance of 0lux indicates an error condition where the sensor cannot
    ///   perform a reasonable measurement. This can happen with very dim or very bright
    ///   light conditions. In bright light conditions this might indicate that the sensor
    ///   is saturated and the configuration should be modified ([`set_configuration`])
    ///   to better match the light conditions.
    ///
    /// If you want to get the illuminance periodically, it is recommended to use the
    /// [`get_illuminance_callback_receiver`] receiver and set the period with
    /// [`set_illuminance_callback_period`].
    pub fn get_illuminance(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetIlluminance), payload)
    }

    /// Sets the period with which the [`get_illuminance_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_illuminance_callback_receiver`] receiver is only triggered if the illuminance has changed
    /// since the last triggering.
    pub fn set_illuminance_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AmbientLightV2BrickletFunction::SetIlluminanceCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_illuminance_callback_period`].
    pub fn get_illuminance_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetIlluminanceCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_illuminance_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the illuminance is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the illuminance is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the illuminance is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the illuminance is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_illuminance_callback_threshold(&self, option: char, min: u32, max: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 9];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..5].copy_from_slice(&<u32>::to_le_byte_vec(min));
        payload[5..9].copy_from_slice(&<u32>::to_le_byte_vec(max));

        self.device.set(u8::from(AmbientLightV2BrickletFunction::SetIlluminanceCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_illuminance_callback_threshold`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* AMBIENT_LIGHT_V2_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_illuminance_callback_threshold(&self) -> ConvertingReceiver<IlluminanceCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetIlluminanceCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receivers
    ///
    /// * [`get_illuminance_reached_callback_receiver`],
    ///
    /// are triggered, if the thresholds
    ///
    /// * [`set_illuminance_callback_threshold`],
    ///
    /// keep being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(AmbientLightV2BrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetDebouncePeriod), payload)
    }

    /// Sets the configuration. It is possible to configure an illuminance range
    /// between 0-600lux and 0-64000lux and an integration time between 50ms and 400ms.
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///   The unlimited illuminance range allows to measure up to about 100000lux, but
    ///   above 64000lux the precision starts to drop.
    ///
    /// A smaller illuminance range increases the resolution of the data. A longer
    /// integration time will result in less noise on the data.
    ///
    /// .. versionchanged:: 2.0.2$nbsp;(Plugin)
    ///   If the actual measure illuminance is out-of-range then the current illuminance
    ///   range maximum +0.01lux is reported by [`get_illuminance`] and the
    ///   [`get_illuminance_callback_receiver`] receiver. For example, 800001 for the 0-8000lux range.
    ///
    /// .. versionchanged:: 2.0.2$nbsp;(Plugin)
    ///   With a long integration time the sensor might be saturated before the measured
    ///   value reaches the maximum of the selected illuminance range. In this case 0lux
    ///   is reported by [`get_illuminance`] and the [`get_illuminance_callback_receiver`] receiver.
    ///
    /// If the measurement is out-of-range or the sensor is saturated then you should
    /// configure the next higher illuminance range. If the highest range is already
    /// in use, then start to reduce the integration time.
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_64000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_32000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_16000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_8000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_1300LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_600LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_50MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_100MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_150MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_200MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_250MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_300MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_350MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_400MS
    pub fn set_configuration(&self, illuminance_range: u8, integration_time: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(illuminance_range));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(integration_time));

        self.device.set(u8::from(AmbientLightV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_UNLIMITED
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_64000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_32000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_16000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_8000LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_1300LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_ILLUMINANCE_RANGE_600LUX
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_50MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_100MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_150MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_200MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_250MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_300MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_350MS
    ///	* AMBIENT_LIGHT_V2_BRICKLET_INTEGRATION_TIME_400MS
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetConfiguration), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AmbientLightV2BrickletFunction::GetIdentity), payload)
    }
}
