/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures acceleration in three axis.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/AccelerometerV2_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AccelerometerV2BrickletFunction {
    GetAcceleration,
    SetConfiguration,
    GetConfiguration,
    SetAccelerationCallbackConfiguration,
    GetAccelerationCallbackConfiguration,
    SetInfoLedConfig,
    GetInfoLedConfig,
    SetContinuousAccelerationConfiguration,
    GetContinuousAccelerationConfiguration,
    SetFilterConfiguration,
    GetFilterConfiguration,
    GetSpitfpErrorCount,
    SetBootloaderMode,
    GetBootloaderMode,
    SetWriteFirmwarePointer,
    WriteFirmware,
    SetStatusLedConfig,
    GetStatusLedConfig,
    GetChipTemperature,
    Reset,
    WriteUid,
    ReadUid,
    GetIdentity,
    CallbackAcceleration,
    CallbackContinuousAcceleration16Bit,
    CallbackContinuousAcceleration8Bit,
}
impl From<AccelerometerV2BrickletFunction> for u8 {
    fn from(fun: AccelerometerV2BrickletFunction) -> Self {
        match fun {
            AccelerometerV2BrickletFunction::GetAcceleration => 1,
            AccelerometerV2BrickletFunction::SetConfiguration => 2,
            AccelerometerV2BrickletFunction::GetConfiguration => 3,
            AccelerometerV2BrickletFunction::SetAccelerationCallbackConfiguration => 4,
            AccelerometerV2BrickletFunction::GetAccelerationCallbackConfiguration => 5,
            AccelerometerV2BrickletFunction::SetInfoLedConfig => 6,
            AccelerometerV2BrickletFunction::GetInfoLedConfig => 7,
            AccelerometerV2BrickletFunction::SetContinuousAccelerationConfiguration => 9,
            AccelerometerV2BrickletFunction::GetContinuousAccelerationConfiguration => 10,
            AccelerometerV2BrickletFunction::SetFilterConfiguration => 13,
            AccelerometerV2BrickletFunction::GetFilterConfiguration => 14,
            AccelerometerV2BrickletFunction::GetSpitfpErrorCount => 234,
            AccelerometerV2BrickletFunction::SetBootloaderMode => 235,
            AccelerometerV2BrickletFunction::GetBootloaderMode => 236,
            AccelerometerV2BrickletFunction::SetWriteFirmwarePointer => 237,
            AccelerometerV2BrickletFunction::WriteFirmware => 238,
            AccelerometerV2BrickletFunction::SetStatusLedConfig => 239,
            AccelerometerV2BrickletFunction::GetStatusLedConfig => 240,
            AccelerometerV2BrickletFunction::GetChipTemperature => 242,
            AccelerometerV2BrickletFunction::Reset => 243,
            AccelerometerV2BrickletFunction::WriteUid => 248,
            AccelerometerV2BrickletFunction::ReadUid => 249,
            AccelerometerV2BrickletFunction::GetIdentity => 255,
            AccelerometerV2BrickletFunction::CallbackAcceleration => 8,
            AccelerometerV2BrickletFunction::CallbackContinuousAcceleration16Bit => 11,
            AccelerometerV2BrickletFunction::CallbackContinuousAcceleration8Bit => 12,
        }
    }
}
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_0_781HZ: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_1_563HZ: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_3_125HZ: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_6_2512HZ: u8 = 3;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_12_5HZ: u8 = 4;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_25HZ: u8 = 5;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_50HZ: u8 = 6;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_100HZ: u8 = 7;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_200HZ: u8 = 8;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_400HZ: u8 = 9;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_800HZ: u8 = 10;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_1600HZ: u8 = 11;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_3200HZ: u8 = 12;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_6400HZ: u8 = 13;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_12800HZ: u8 = 14;
pub const ACCELEROMETER_V2_BRICKLET_DATA_RATE_25600HZ: u8 = 15;
pub const ACCELEROMETER_V2_BRICKLET_FULL_SCALE_2G: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_FULL_SCALE_4G: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_FULL_SCALE_8G: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_OFF: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_ON: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_RESOLUTION_8BIT: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_RESOLUTION_16BIT: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_APPLIED: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_BYPASSED: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_NINTH: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_HALF: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT: u8 = 3;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT: u8 = 4;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_OK: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT: u8 = 3;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT: u8 = 4;
pub const ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH: u8 = 5;
pub const ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_OFF: u8 = 0;
pub const ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_ON: u8 = 1;
pub const ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT: u8 = 2;
pub const ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Acceleration {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl FromByteSlice for Acceleration {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> Acceleration {
        Acceleration {
            x: <i32>::from_le_byte_slice(&bytes[0..4]),
            y: <i32>::from_le_byte_slice(&bytes[4..8]),
            z: <i32>::from_le_byte_slice(&bytes[8..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub data_rate: u8,
    pub full_scale: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration { data_rate: <u8>::from_le_byte_slice(&bytes[0..1]), full_scale: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationCallbackConfiguration {
    pub period: u32,
    pub value_has_to_change: bool,
}
impl FromByteSlice for AccelerationCallbackConfiguration {
    fn bytes_expected() -> usize { 5 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationCallbackConfiguration {
        AccelerationCallbackConfiguration {
            period: <u32>::from_le_byte_slice(&bytes[0..4]),
            value_has_to_change: <bool>::from_le_byte_slice(&bytes[4..5]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationEvent {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl FromByteSlice for AccelerationEvent {
    fn bytes_expected() -> usize { 12 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationEvent {
        AccelerationEvent {
            x: <i32>::from_le_byte_slice(&bytes[0..4]),
            y: <i32>::from_le_byte_slice(&bytes[4..8]),
            z: <i32>::from_le_byte_slice(&bytes[8..12]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct ContinuousAccelerationConfiguration {
    pub enable_x: bool,
    pub enable_y: bool,
    pub enable_z: bool,
    pub resolution: u8,
}
impl FromByteSlice for ContinuousAccelerationConfiguration {
    fn bytes_expected() -> usize { 4 }
    fn from_le_byte_slice(bytes: &[u8]) -> ContinuousAccelerationConfiguration {
        ContinuousAccelerationConfiguration {
            enable_x: <bool>::from_le_byte_slice(&bytes[0..1]),
            enable_y: <bool>::from_le_byte_slice(&bytes[1..2]),
            enable_z: <bool>::from_le_byte_slice(&bytes[2..3]),
            resolution: <u8>::from_le_byte_slice(&bytes[3..4]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct FilterConfiguration {
    pub iir_bypass: u8,
    pub low_pass_filter: u8,
}
impl FromByteSlice for FilterConfiguration {
    fn bytes_expected() -> usize { 2 }
    fn from_le_byte_slice(bytes: &[u8]) -> FilterConfiguration {
        FilterConfiguration { iir_bypass: <u8>::from_le_byte_slice(&bytes[0..1]), low_pass_filter: <u8>::from_le_byte_slice(&bytes[1..2]) }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct SpitfpErrorCount {
    pub error_count_ack_checksum: u32,
    pub error_count_message_checksum: u32,
    pub error_count_frame: u32,
    pub error_count_overflow: u32,
}
impl FromByteSlice for SpitfpErrorCount {
    fn bytes_expected() -> usize { 16 }
    fn from_le_byte_slice(bytes: &[u8]) -> SpitfpErrorCount {
        SpitfpErrorCount {
            error_count_ack_checksum: <u32>::from_le_byte_slice(&bytes[0..4]),
            error_count_message_checksum: <u32>::from_le_byte_slice(&bytes[4..8]),
            error_count_frame: <u32>::from_le_byte_slice(&bytes[8..12]),
            error_count_overflow: <u32>::from_le_byte_slice(&bytes[12..16]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures acceleration in three axis
#[derive(Clone)]
pub struct AccelerometerV2Bricklet {
    device: Device,
}
impl AccelerometerV2Bricklet {
    pub const DEVICE_IDENTIFIER: u16 = 2130;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Accelerometer Bricklet 2.0";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AccelerometerV2Bricklet {
        let mut result = AccelerometerV2Bricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetAcceleration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetAccelerationCallbackConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetInfoLedConfig) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetInfoLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetContinuousAccelerationConfiguration) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetContinuousAccelerationConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetFilterConfiguration) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetFilterConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetSpitfpErrorCount) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetBootloaderMode) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetWriteFirmwarePointer) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::WriteFirmware) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::SetStatusLedConfig) as usize] =
            ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetStatusLedConfig) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetChipTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::Reset) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::WriteUid) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::ReadUid) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerV2BrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::accelerometer_v2_bricklet::AccelerometerV2Bricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::accelerometer_v2_bricklet::AccelerometerV2Bricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AccelerometerV2BrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AccelerometerV2BrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically according to the configuration set by
    /// [`set_acceleration_callback_configuration`].
    ///
    /// The parameters are the same as [`get_acceleration`].
    ///
    /// [`get_acceleration`]: #method.get_acceleration
    /// [`set_acceleration_callback_configuration`]: #method.set_acceleration_callback_configuration
    pub fn get_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationEvent> {
        self.device.get_callback_receiver(u8::from(AccelerometerV2BrickletFunction::CallbackAcceleration))
    }

    /// Returns 30 acceleration values with 16 bit resolution. The data rate can
    /// be configured with [`set_configuration`] and this receiver can be
    /// enabled with [`set_continuous_acceleration_configuration`].
    ///
    /// The returned values are raw ADC data. If you want to put this data into
    /// a FFT to determine the occurrences of specific frequencies we recommend
    /// that you use the data as is. It has all of the ADC noise in it. This noise
    /// looks like pure noise at first glance, but it might still have some frequnecy
    /// information in it that can be utilized by the FFT.
    ///
    /// Otherwise you have to use the following formulas that depend on the
    /// full scale range (see [`set_configuration`]) to calculate
    /// the data in gₙ/10000 (same unit that is returned by [`get_acceleration`]):
    ///
    /// * Full scale 2g: acceleration = value * 625 / 1024
    /// * Full scale 4g: acceleration = value * 1250 / 1024
    /// * Full scale 8g: acceleration = value * 2500 / 1024
    ///
    /// The data is formated in the sequence x, y, z, x, y, z, ... depending on
    /// the enabled axis. Examples:
    ///
    /// * x, y, z enabled: x, y, z, ... 10x repeated
    /// * x, z enabled: x, z, ... 15x repeated
    /// * y enabled: y, ... 30x repeated
    pub fn get_continuous_acceleration_16_bit_callback_receiver(&self) -> ConvertingCallbackReceiver<[i16; 30]> {
        self.device.get_callback_receiver(u8::from(AccelerometerV2BrickletFunction::CallbackContinuousAcceleration16Bit))
    }

    /// Returns 60 acceleration values with 8 bit resolution. The data rate can
    /// be configured with [`set_configuration`] and this receiver can be
    /// enabled with [`set_continuous_acceleration_configuration`].
    ///
    /// The returned values are raw ADC data. If you want to put this data into
    /// a FFT to determine the occurrences of specific frequencies we recommend
    /// that you use the data as is. It has all of the ADC noise in it. This noise
    /// looks like pure noise at first glance, but it might still have some frequnecy
    /// information in it that can be utilized by the FFT.
    ///
    /// Otherwise you have to use the following formulas that depend on the
    /// full scale range (see [`set_configuration`]) to calculate
    /// the data in gₙ/10000 (same unit that is returned by [`get_acceleration`]):
    ///
    /// * Full scale 2g: acceleration = value * 256 * 625 / 1024
    /// * Full scale 4g: acceleration = value * 256 * 1250 / 1024
    /// * Full scale 8g: acceleration = value * 256 * 2500 / 1024
    ///
    /// The data is formated in the sequence x, y, z, x, y, z, ... depending on
    /// the enabled axis. Examples:
    ///
    /// * x, y, z enabled: x, y, z, ... 20x repeated
    /// * x, z enabled: x, z, ... 30x repeated
    /// * y enabled: y, ... 60x repeated
    pub fn get_continuous_acceleration_8_bit_callback_receiver(&self) -> ConvertingCallbackReceiver<[i8; 60]> {
        self.device.get_callback_receiver(u8::from(AccelerometerV2BrickletFunction::CallbackContinuousAcceleration8Bit))
    }

    /// Returns the acceleration in x, y and z direction. The values
    /// are given in gₙ/10000 (1gₙ = 9.80665m/s²). The range is
    /// configured with [`set_configuration`].
    ///
    /// If you want to get the acceleration periodically, it is recommended
    /// to use the [`get_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_acceleration_callback_configuration`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<Acceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetAcceleration), payload)
    }

    /// Configures the data rate and full scale range.
    /// Possible values are:
    ///
    /// * Data rate of 0.781Hz to 25600Hz.
    /// * Full scale range of ±2g up to ±8g.
    ///
    /// Decreasing data rate or full scale range will also decrease the noise on
    /// the data.
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_DATA_RATE_0_781HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_1_563HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_3_125HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_6_2512HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_12_5HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_25HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_50HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_100HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_200HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_400HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_800HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_1600HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_3200HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_6400HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_12800HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_25600HZ
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_2G
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_4G
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_8G
    pub fn set_configuration(&self, data_rate: u8, full_scale: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(data_rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(full_scale));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_DATA_RATE_0_781HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_1_563HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_3_125HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_6_2512HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_12_5HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_25HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_50HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_100HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_200HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_400HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_800HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_1600HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_3200HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_6400HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_12800HZ
    ///	* ACCELEROMETER_V2_BRICKLET_DATA_RATE_25600HZ
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_2G
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_4G
    ///	* ACCELEROMETER_V2_BRICKLET_FULL_SCALE_8G
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetConfiguration), payload)
    }

    /// The period is the period with which the [`get_acceleration_callback_receiver`]
    /// receiver is triggered periodically. A value of 0 turns the receiver off.
    ///
    /// If the `value has to change`-parameter is set to true, the receiver is only
    /// triggered after the value has changed. If the value didn't change within the
    /// period, the receiver is triggered immediately on change.
    ///
    /// If it is set to false, the receiver is continuously triggered with the period,
    /// independent of the value.
    ///
    /// If this receiver is enabled, the [`get_continuous_acceleration_16_bit_callback_receiver`] receiver
    /// and [`get_continuous_acceleration_8_bit_callback_receiver`] receiver will automatically be disabled.
    pub fn set_acceleration_callback_configuration(&self, period: u32, value_has_to_change: bool) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 5];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));
        payload[4..5].copy_from_slice(&<bool>::to_le_byte_vec(value_has_to_change));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetAccelerationCallbackConfiguration), payload)
    }

    /// Returns the receiver configuration as set by
    /// [`set_acceleration_callback_configuration`].
    pub fn get_acceleration_callback_configuration(&self) -> ConvertingReceiver<AccelerationCallbackConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetAccelerationCallbackConfiguration), payload)
    }

    /// Configures the info LED (marked as Force on the Bricklet) to be either turned off,
    /// turned on, or blink in heartbeat mode.
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_OFF
    ///	* ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_ON
    ///	* ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT
    pub fn set_info_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetInfoLedConfig), payload)
    }

    /// Returns the LED configuration as set by [`set_info_led_config`]
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_OFF
    ///	* ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_ON
    ///	* ACCELEROMETER_V2_BRICKLET_INFO_LED_CONFIG_SHOW_HEARTBEAT
    pub fn get_info_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetInfoLedConfig), payload)
    }

    /// For high throughput of acceleration data (> 1000Hz) you have to use the
    /// [`get_continuous_acceleration_16_bit_callback_receiver`] or [`get_continuous_acceleration_8_bit_callback_receiver`]
    /// callbacks.
    ///
    /// You can enable the receiver for each axis (x, y, z) individually and choose a
    /// resolution of 8 bit or 16 bit.
    ///
    /// If at least one of the axis is enabled and the resolution is set to 8 bit,
    /// the [`get_continuous_acceleration_8_bit_callback_receiver`] receiver is activated. If at least
    /// one of the axis is enabled and the resolution is set to 16 bit,
    /// the [`get_continuous_acceleration_16_bit_callback_receiver`] receiver is activated.
    ///
    /// The returned values are raw ADC data. If you want to put this data into
    /// a FFT to determine the occurrences of specific frequencies we recommend
    /// that you use the data as is. It has all of the ADC noise in it. This noise
    /// looks like pure noise at first glance, but it might still have some frequnecy
    /// information in it that can be utilized by the FFT.
    ///
    /// Otherwise you have to use the following formulas that depend on the configured
    /// resolution (8/16 bit) and the full scale range (see [`set_configuration`]) to calculate
    /// the data in gₙ/10000 (same unit that is returned by [`get_acceleration`]):
    ///
    /// * 16 bit, full scale 2g: acceleration = value * 625 / 1024
    /// * 16 bit, full scale 4g: acceleration = value * 1250 / 1024
    /// * 16 bit, full scale 8g: acceleration = value * 2500 / 1024
    ///
    /// If a resolution of 8 bit is used, only the 8 most significant bits will be
    /// transferred, so you can use the following formulas:
    ///
    /// * 8 bit, full scale 2g: acceleration = value * 256 * 625 / 1024
    /// * 8 bit, full scale 4g: acceleration = value * 256 * 1250 / 1024
    /// * 8 bit, full scale 8g: acceleration = value * 256 * 2500 / 1024
    ///
    /// If no axis is enabled, both receivers are disabled. If one of the continuous
    /// callbacks is enabled, the [`get_acceleration_callback_receiver`] receiver is disabled.
    ///
    /// The maximum throughput depends on the exact configuration:
    ///
    ///  Number of axis enabled| Throughput 8 bit| Throughout 16 bit
    ///  --- | --- | ---
    ///  1| 25600Hz| 25600Hz
    ///  2| 25600Hz| 15000Hz
    ///  3| 20000Hz| 10000Hz
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_RESOLUTION_8BIT
    ///	* ACCELEROMETER_V2_BRICKLET_RESOLUTION_16BIT
    pub fn set_continuous_acceleration_configuration(
        &self,
        enable_x: bool,
        enable_y: bool,
        enable_z: bool,
        resolution: u8,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..1].copy_from_slice(&<bool>::to_le_byte_vec(enable_x));
        payload[1..2].copy_from_slice(&<bool>::to_le_byte_vec(enable_y));
        payload[2..3].copy_from_slice(&<bool>::to_le_byte_vec(enable_z));
        payload[3..4].copy_from_slice(&<u8>::to_le_byte_vec(resolution));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetContinuousAccelerationConfiguration), payload)
    }

    /// Returns the continuous acceleration configuration as set by
    /// [`set_continuous_acceleration_configuration`].
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_RESOLUTION_8BIT
    ///	* ACCELEROMETER_V2_BRICKLET_RESOLUTION_16BIT
    pub fn get_continuous_acceleration_configuration(&self) -> ConvertingReceiver<ContinuousAccelerationConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetContinuousAccelerationConfiguration), payload)
    }

    /// Configures IIR Bypass filter mode and low pass filter roll off corner frequency.
    ///
    /// The filter can be applied or bypassed and the corner frequency can be
    /// half or a ninth of the output data rate.
    ///
    /// .. image:: /Images/Bricklets/bricklet_accelerometer_v2_filter.png
    ///    :scale: 100 %
    ///    :alt: Accelerometer filter
    ///    :align: center
    ///    :target: ../../_images/Bricklets/bricklet_accelerometer_v2_filter.png
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_APPLIED
    ///	* ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_BYPASSED
    ///	* ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_NINTH
    ///	* ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_HALF
    pub fn set_filter_configuration(&self, iir_bypass: u8, low_pass_filter: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 2];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(iir_bypass));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(low_pass_filter));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetFilterConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_filter_configuration`].
    ///
    ///
    /// .. versionadded:: 2.0.2$nbsp;(Plugin)
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_APPLIED
    ///	* ACCELEROMETER_V2_BRICKLET_IIR_BYPASS_BYPASSED
    ///	* ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_NINTH
    ///	* ACCELEROMETER_V2_BRICKLET_LOW_PASS_FILTER_HALF
    pub fn get_filter_configuration(&self) -> ConvertingReceiver<FilterConfiguration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetFilterConfiguration), payload)
    }

    /// Returns the error count for the communication between Brick and Bricklet.
    ///
    /// The errors are divided into
    ///
    /// * ACK checksum errors,
    /// * message checksum errors,
    /// * framing errors and
    /// * overflow errors.
    ///
    /// The errors counts are for errors that occur on the Bricklet side. All
    /// Bricks have a similar function that returns the errors on the Brick side.
    pub fn get_spitfp_error_count(&self) -> ConvertingReceiver<SpitfpErrorCount> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetSpitfpErrorCount), payload)
    }

    /// Sets the bootloader mode and returns the status after the requested
    /// mode change was instigated.
    ///
    /// You can change from bootloader mode to firmware mode and vice versa. A change
    /// from bootloader mode to firmware mode will only take place if the entry function,
    /// device identifier and CRC are present and correct.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_OK
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_INVALID_MODE
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_NO_CHANGE
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_STATUS_CRC_MISMATCH
    pub fn set_bootloader_mode(&self, mode: u8) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(mode));

        self.device.get(u8::from(AccelerometerV2BrickletFunction::SetBootloaderMode), payload)
    }

    /// Returns the current bootloader mode, see [`set_bootloader_mode`].
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT
    ///	* ACCELEROMETER_V2_BRICKLET_BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT
    pub fn get_bootloader_mode(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetBootloaderMode), payload)
    }

    /// Sets the firmware pointer for [`write_firmware`]. The pointer has
    /// to be increased by chunks of size 64. The data is written to flash
    /// every 4 chunks (which equals to one page of size 256).
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn set_write_firmware_pointer(&self, pointer: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(pointer));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetWriteFirmwarePointer), payload)
    }

    /// Writes 64 Bytes of firmware at the position as written by
    /// [`set_write_firmware_pointer`] before. The firmware is written
    /// to flash every 4 chunks.
    ///
    /// You can only write firmware in bootloader mode.
    ///
    /// This function is used by Brick Viewer during flashing. It should not be
    /// necessary to call it in a normal user program.
    pub fn write_firmware(&self, data: [u8; 64]) -> ConvertingReceiver<u8> {
        let mut payload = vec![0; 64];
        payload[0..64].copy_from_slice(&<[u8; 64]>::to_le_byte_vec(data));

        self.device.get(u8::from(AccelerometerV2BrickletFunction::WriteFirmware), payload)
    }

    /// Sets the status LED configuration. By default the LED shows
    /// communication traffic between Brick and Bricklet, it flickers once
    /// for every 10 received data packets.
    ///
    /// You can also turn the LED permanently on/off or show a heartbeat.
    ///
    /// If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn set_status_led_config(&self, config: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 1];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(config));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::SetStatusLedConfig), payload)
    }

    /// Returns the configuration as set by [`set_status_led_config`]
    ///
    /// Associated constants:
    /// * ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_OFF
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_ON
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_HEARTBEAT
    ///	* ACCELEROMETER_V2_BRICKLET_STATUS_LED_CONFIG_SHOW_STATUS
    pub fn get_status_led_config(&self) -> ConvertingReceiver<u8> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetStatusLedConfig), payload)
    }

    /// Returns the temperature as measured inside the microcontroller. The
    /// value returned is not the ambient temperature!
    ///
    /// The temperature is only proportional to the real temperature and it has bad
    /// accuracy. Practically it is only useful as an indicator for
    /// temperature changes.
    pub fn get_chip_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetChipTemperature), payload)
    }

    /// Calling this function will reset the Bricklet. All configurations
    /// will be lost.
    ///
    /// After a reset you have to create new device objects,
    /// calling functions on the existing ones will result in
    /// undefined behavior!
    pub fn reset(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AccelerometerV2BrickletFunction::Reset), payload)
    }

    /// Writes a new UID into flash. If you want to set a new UID
    /// you have to decode the Base58 encoded UID string into an
    /// integer first.
    ///
    /// We recommend that you use Brick Viewer to change the UID.
    pub fn write_uid(&self, uid: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(uid));

        self.device.set(u8::from(AccelerometerV2BrickletFunction::WriteUid), payload)
    }

    /// Returns the current UID as an integer. Encode as
    /// Base58 to get the usual string version.
    pub fn read_uid(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::ReadUid), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerV2BrickletFunction::GetIdentity), payload)
    }
}
