/* ***********************************************************
 * This file was automatically generated on 2021-08-26.      *
 *                                                           *
 * Rust Bindings Version 2.0.19                              *
 *                                                           *
 * If you have a bugfix for this file and want to commit it, *
 * please fix the bug in the generator. You can find a link  *
 * to the generators git repository on tinkerforge.com       *
 *************************************************************/

//! Measures acceleration in three axis.
//!
//! See also the documentation [here](https://www.tinkerforge.com/en/doc/Software/Bricklets/Accelerometer_Bricklet_Rust.html).
use crate::{
    byte_converter::*, converting_callback_receiver::ConvertingCallbackReceiver, converting_receiver::ConvertingReceiver, device::*,
    ip_connection::GetRequestSender,
};
pub enum AccelerometerBrickletFunction {
    GetAcceleration,
    SetAccelerationCallbackPeriod,
    GetAccelerationCallbackPeriod,
    SetAccelerationCallbackThreshold,
    GetAccelerationCallbackThreshold,
    SetDebouncePeriod,
    GetDebouncePeriod,
    GetTemperature,
    SetConfiguration,
    GetConfiguration,
    LedOn,
    LedOff,
    IsLedOn,
    GetIdentity,
    CallbackAcceleration,
    CallbackAccelerationReached,
}
impl From<AccelerometerBrickletFunction> for u8 {
    fn from(fun: AccelerometerBrickletFunction) -> Self {
        match fun {
            AccelerometerBrickletFunction::GetAcceleration => 1,
            AccelerometerBrickletFunction::SetAccelerationCallbackPeriod => 2,
            AccelerometerBrickletFunction::GetAccelerationCallbackPeriod => 3,
            AccelerometerBrickletFunction::SetAccelerationCallbackThreshold => 4,
            AccelerometerBrickletFunction::GetAccelerationCallbackThreshold => 5,
            AccelerometerBrickletFunction::SetDebouncePeriod => 6,
            AccelerometerBrickletFunction::GetDebouncePeriod => 7,
            AccelerometerBrickletFunction::GetTemperature => 8,
            AccelerometerBrickletFunction::SetConfiguration => 9,
            AccelerometerBrickletFunction::GetConfiguration => 10,
            AccelerometerBrickletFunction::LedOn => 11,
            AccelerometerBrickletFunction::LedOff => 12,
            AccelerometerBrickletFunction::IsLedOn => 13,
            AccelerometerBrickletFunction::GetIdentity => 255,
            AccelerometerBrickletFunction::CallbackAcceleration => 14,
            AccelerometerBrickletFunction::CallbackAccelerationReached => 15,
        }
    }
}
pub const ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OFF: char = 'x';
pub const ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE: char = 'o';
pub const ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE: char = 'i';
pub const ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER: char = '<';
pub const ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_GREATER: char = '>';
pub const ACCELEROMETER_BRICKLET_DATA_RATE_OFF: u8 = 0;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_3HZ: u8 = 1;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_6HZ: u8 = 2;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_12HZ: u8 = 3;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_25HZ: u8 = 4;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_50HZ: u8 = 5;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_100HZ: u8 = 6;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_400HZ: u8 = 7;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_800HZ: u8 = 8;
pub const ACCELEROMETER_BRICKLET_DATA_RATE_1600HZ: u8 = 9;
pub const ACCELEROMETER_BRICKLET_FULL_SCALE_2G: u8 = 0;
pub const ACCELEROMETER_BRICKLET_FULL_SCALE_4G: u8 = 1;
pub const ACCELEROMETER_BRICKLET_FULL_SCALE_6G: u8 = 2;
pub const ACCELEROMETER_BRICKLET_FULL_SCALE_8G: u8 = 3;
pub const ACCELEROMETER_BRICKLET_FULL_SCALE_16G: u8 = 4;
pub const ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_800HZ: u8 = 0;
pub const ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_400HZ: u8 = 1;
pub const ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_200HZ: u8 = 2;
pub const ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_50HZ: u8 = 3;

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Acceleration {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for Acceleration {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> Acceleration {
        Acceleration {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationCallbackThreshold {
    pub option: char,
    pub min_x: i16,
    pub max_x: i16,
    pub min_y: i16,
    pub max_y: i16,
    pub min_z: i16,
    pub max_z: i16,
}
impl FromByteSlice for AccelerationCallbackThreshold {
    fn bytes_expected() -> usize { 13 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationCallbackThreshold {
        AccelerationCallbackThreshold {
            option: <char>::from_le_byte_slice(&bytes[0..1]),
            min_x: <i16>::from_le_byte_slice(&bytes[1..3]),
            max_x: <i16>::from_le_byte_slice(&bytes[3..5]),
            min_y: <i16>::from_le_byte_slice(&bytes[5..7]),
            max_y: <i16>::from_le_byte_slice(&bytes[7..9]),
            min_z: <i16>::from_le_byte_slice(&bytes[9..11]),
            max_z: <i16>::from_le_byte_slice(&bytes[11..13]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct Configuration {
    pub data_rate: u8,
    pub full_scale: u8,
    pub filter_bandwidth: u8,
}
impl FromByteSlice for Configuration {
    fn bytes_expected() -> usize { 3 }
    fn from_le_byte_slice(bytes: &[u8]) -> Configuration {
        Configuration {
            data_rate: <u8>::from_le_byte_slice(&bytes[0..1]),
            full_scale: <u8>::from_le_byte_slice(&bytes[1..2]),
            filter_bandwidth: <u8>::from_le_byte_slice(&bytes[2..3]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AccelerationEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationEvent {
        AccelerationEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Copy, Debug, Default, PartialEq, Eq, Hash)]
pub struct AccelerationReachedEvent {
    pub x: i16,
    pub y: i16,
    pub z: i16,
}
impl FromByteSlice for AccelerationReachedEvent {
    fn bytes_expected() -> usize { 6 }
    fn from_le_byte_slice(bytes: &[u8]) -> AccelerationReachedEvent {
        AccelerationReachedEvent {
            x: <i16>::from_le_byte_slice(&bytes[0..2]),
            y: <i16>::from_le_byte_slice(&bytes[2..4]),
            z: <i16>::from_le_byte_slice(&bytes[4..6]),
        }
    }
}

#[derive(Clone, Debug, Default, PartialEq, Eq, Hash)]
pub struct Identity {
    pub uid: String,
    pub connected_uid: String,
    pub position: char,
    pub hardware_version: [u8; 3],
    pub firmware_version: [u8; 3],
    pub device_identifier: u16,
}
impl FromByteSlice for Identity {
    fn bytes_expected() -> usize { 25 }
    fn from_le_byte_slice(bytes: &[u8]) -> Identity {
        Identity {
            uid: <String>::from_le_byte_slice(&bytes[0..8]),
            connected_uid: <String>::from_le_byte_slice(&bytes[8..16]),
            position: <char>::from_le_byte_slice(&bytes[16..17]),
            hardware_version: <[u8; 3]>::from_le_byte_slice(&bytes[17..20]),
            firmware_version: <[u8; 3]>::from_le_byte_slice(&bytes[20..23]),
            device_identifier: <u16>::from_le_byte_slice(&bytes[23..25]),
        }
    }
}

/// Measures acceleration in three axis
#[derive(Clone)]
pub struct AccelerometerBricklet {
    device: Device,
}
impl AccelerometerBricklet {
    pub const DEVICE_IDENTIFIER: u16 = 250;
    pub const DEVICE_DISPLAY_NAME: &'static str = "Accelerometer Bricklet";
    /// Creates an object with the unique device ID `uid`. This object can then be used after the IP Connection `ip_connection` is connected.
    pub fn new<T: GetRequestSender>(uid: &str, req_sender: T) -> AccelerometerBricklet {
        let mut result = AccelerometerBricklet { device: Device::new([2, 0, 1], uid, req_sender, 0) };
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetAcceleration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::SetAccelerationCallbackPeriod) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetAccelerationCallbackPeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::SetAccelerationCallbackThreshold) as usize] =
            ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetAccelerationCallbackThreshold) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::SetDebouncePeriod) as usize] = ResponseExpectedFlag::True;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetDebouncePeriod) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetTemperature) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::SetConfiguration) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetConfiguration) as usize] =
            ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::LedOn) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::LedOff) as usize] = ResponseExpectedFlag::False;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::IsLedOn) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result.device.response_expected[u8::from(AccelerometerBrickletFunction::GetIdentity) as usize] = ResponseExpectedFlag::AlwaysTrue;
        result
    }

    /// Returns the response expected flag for the function specified by the function ID parameter.
    /// It is true if the function is expected to send a response, false otherwise.
    ///
    /// For getter functions this is enabled by default and cannot be disabled, because those
    /// functions will always send a response. For callback configuration functions it is enabled
    /// by default too, but can be disabled by [`set_response_expected`](crate::accelerometer_bricklet::AccelerometerBricklet::set_response_expected).
    /// For setter functions it is disabled by default and can be enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts
    /// and other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    ///
    /// See [`set_response_expected`](crate::accelerometer_bricklet::AccelerometerBricklet::set_response_expected) for the list of function ID constants available for this function.
    pub fn get_response_expected(&mut self, fun: AccelerometerBrickletFunction) -> Result<bool, GetResponseExpectedError> {
        self.device.get_response_expected(u8::from(fun))
    }

    /// Changes the response expected flag of the function specified by the function ID parameter.
    /// This flag can only be changed for setter (default value: false) and callback configuration
    /// functions (default value: true). For getter functions it is always enabled.
    ///
    /// Enabling the response expected flag for a setter function allows to detect timeouts and
    /// other error conditions calls of this setter as well. The device will then send a response
    /// for this purpose. If this flag is disabled for a setter function then no response is sent
    /// and errors are silently ignored, because they cannot be detected.
    pub fn set_response_expected(
        &mut self,
        fun: AccelerometerBrickletFunction,
        response_expected: bool,
    ) -> Result<(), SetResponseExpectedError> {
        self.device.set_response_expected(u8::from(fun), response_expected)
    }

    /// Changes the response expected flag for all setter and callback configuration functions of this device at once.
    pub fn set_response_expected_all(&mut self, response_expected: bool) { self.device.set_response_expected_all(response_expected) }

    /// Returns the version of the API definition (major, minor, revision) implemented by this API bindings.
    /// This is neither the release version of this API bindings nor does it tell you anything about the represented Brick or Bricklet.
    pub fn get_api_version(&self) -> [u8; 3] { self.device.api_version }

    /// This receiver is triggered periodically with the period that is set by
    /// [`set_acceleration_callback_period`]. The parameters are the
    /// X, Y and Z acceleration. The range is
    /// configured with [`set_configuration`].
    ///
    /// The [`get_acceleration_callback_receiver`] receiver is only triggered if the acceleration has
    /// changed since the last triggering.
    ///
    /// [`set_acceleration_callback_period`]: #method.set_acceleration_callback_period
    /// [`set_configuration`]: #method.set_configuration
    /// [`get_acceleration_callback_receiver`]: #method.get_acceleration_callback_receiver
    pub fn get_acceleration_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationEvent> {
        self.device.get_callback_receiver(u8::from(AccelerometerBrickletFunction::CallbackAcceleration))
    }

    /// This receiver is triggered when the threshold as set by
    /// [`set_acceleration_callback_threshold`] is reached.
    /// The parameters are the X, Y and Z acceleration. The range is
    /// configured with [`set_configuration`].
    ///
    /// If the threshold keeps being reached, the receiver is triggered periodically
    /// with the period as set by [`set_debounce_period`].
    pub fn get_acceleration_reached_callback_receiver(&self) -> ConvertingCallbackReceiver<AccelerationReachedEvent> {
        self.device.get_callback_receiver(u8::from(AccelerometerBrickletFunction::CallbackAccelerationReached))
    }

    /// Returns the acceleration in x, y and z direction. The values
    /// are given in gₙ/1000 (1gₙ = 9.80665m/s²). The range is
    /// configured with [`set_configuration`].
    ///
    /// If you want to get the acceleration periodically, it is recommended
    /// to use the [`get_acceleration_callback_receiver`] receiver and set the period with
    /// [`set_acceleration_callback_period`].
    pub fn get_acceleration(&self) -> ConvertingReceiver<Acceleration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetAcceleration), payload)
    }

    /// Sets the period with which the [`get_acceleration_callback_receiver`] receiver is triggered
    /// periodically. A value of 0 turns the receiver off.
    ///
    /// The [`get_acceleration_callback_receiver`] receiver is only triggered if the acceleration has
    /// changed since the last triggering.
    pub fn set_acceleration_callback_period(&self, period: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(period));

        self.device.set(u8::from(AccelerometerBrickletFunction::SetAccelerationCallbackPeriod), payload)
    }

    /// Returns the period as set by [`set_acceleration_callback_period`].
    pub fn get_acceleration_callback_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetAccelerationCallbackPeriod), payload)
    }

    /// Sets the thresholds for the [`get_acceleration_reached_callback_receiver`] receiver.
    ///
    /// The following options are possible:
    ///
    ///  Option| Description
    ///  --- | ---
    ///  'x'|    Receiver is turned off
    ///  'o'|    Receiver is triggered when the acceleration is *outside* the min and max values
    ///  'i'|    Receiver is triggered when the acceleration is *inside* the min and max values
    ///  '<'|    Receiver is triggered when the acceleration is smaller than the min value (max is ignored)
    ///  '>'|    Receiver is triggered when the acceleration is greater than the min value (max is ignored)
    ///
    /// Associated constants:
    /// * ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn set_acceleration_callback_threshold(
        &self,
        option: char,
        min_x: i16,
        max_x: i16,
        min_y: i16,
        max_y: i16,
        min_z: i16,
        max_z: i16,
    ) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 13];
        payload[0..1].copy_from_slice(&<char>::to_le_byte_vec(option));
        payload[1..3].copy_from_slice(&<i16>::to_le_byte_vec(min_x));
        payload[3..5].copy_from_slice(&<i16>::to_le_byte_vec(max_x));
        payload[5..7].copy_from_slice(&<i16>::to_le_byte_vec(min_y));
        payload[7..9].copy_from_slice(&<i16>::to_le_byte_vec(max_y));
        payload[9..11].copy_from_slice(&<i16>::to_le_byte_vec(min_z));
        payload[11..13].copy_from_slice(&<i16>::to_le_byte_vec(max_z));

        self.device.set(u8::from(AccelerometerBrickletFunction::SetAccelerationCallbackThreshold), payload)
    }

    /// Returns the threshold as set by [`set_acceleration_callback_threshold`].
    ///
    /// Associated constants:
    /// * ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OFF
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_OUTSIDE
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_INSIDE
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_SMALLER
    ///	* ACCELEROMETER_BRICKLET_THRESHOLD_OPTION_GREATER
    pub fn get_acceleration_callback_threshold(&self) -> ConvertingReceiver<AccelerationCallbackThreshold> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetAccelerationCallbackThreshold), payload)
    }

    /// Sets the period with which the threshold receiver
    ///
    /// * [`get_acceleration_reached_callback_receiver`]
    ///
    /// is triggered, if the threshold
    ///
    /// * [`set_acceleration_callback_threshold`]
    ///
    /// keeps being reached.
    pub fn set_debounce_period(&self, debounce: u32) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 4];
        payload[0..4].copy_from_slice(&<u32>::to_le_byte_vec(debounce));

        self.device.set(u8::from(AccelerometerBrickletFunction::SetDebouncePeriod), payload)
    }

    /// Returns the debounce period as set by [`set_debounce_period`].
    pub fn get_debounce_period(&self) -> ConvertingReceiver<u32> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetDebouncePeriod), payload)
    }

    /// Returns the temperature of the accelerometer.
    pub fn get_temperature(&self) -> ConvertingReceiver<i16> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetTemperature), payload)
    }

    /// Configures the data rate, full scale range and filter bandwidth.
    /// Possible values are:
    ///
    /// * Data rate of 0Hz to 1600Hz.
    /// * Full scale range of ±2gₙ up to ±16gₙ.
    /// * Filter bandwidth between 50Hz and 800Hz.
    ///
    /// Decreasing data rate or full scale range will also decrease the noise on
    /// the data.
    ///
    /// Associated constants:
    /// * ACCELEROMETER_BRICKLET_DATA_RATE_OFF
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_3HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_6HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_12HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_25HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_50HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_100HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_400HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_800HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_1600HZ
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_2G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_4G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_6G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_8G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_16G
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_800HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_400HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_200HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_50HZ
    pub fn set_configuration(&self, data_rate: u8, full_scale: u8, filter_bandwidth: u8) -> ConvertingReceiver<()> {
        let mut payload = vec![0; 3];
        payload[0..1].copy_from_slice(&<u8>::to_le_byte_vec(data_rate));
        payload[1..2].copy_from_slice(&<u8>::to_le_byte_vec(full_scale));
        payload[2..3].copy_from_slice(&<u8>::to_le_byte_vec(filter_bandwidth));

        self.device.set(u8::from(AccelerometerBrickletFunction::SetConfiguration), payload)
    }

    /// Returns the configuration as set by [`set_configuration`].
    ///
    /// Associated constants:
    /// * ACCELEROMETER_BRICKLET_DATA_RATE_OFF
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_3HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_6HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_12HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_25HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_50HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_100HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_400HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_800HZ
    ///	* ACCELEROMETER_BRICKLET_DATA_RATE_1600HZ
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_2G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_4G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_6G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_8G
    ///	* ACCELEROMETER_BRICKLET_FULL_SCALE_16G
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_800HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_400HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_200HZ
    ///	* ACCELEROMETER_BRICKLET_FILTER_BANDWIDTH_50HZ
    pub fn get_configuration(&self) -> ConvertingReceiver<Configuration> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetConfiguration), payload)
    }

    /// Enables the LED on the Bricklet.
    pub fn led_on(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AccelerometerBrickletFunction::LedOn), payload)
    }

    /// Disables the LED on the Bricklet.
    pub fn led_off(&self) -> ConvertingReceiver<()> {
        let payload = vec![0; 0];

        self.device.set(u8::from(AccelerometerBrickletFunction::LedOff), payload)
    }

    /// Returns *true* if the LED is enabled, *false* otherwise.
    pub fn is_led_on(&self) -> ConvertingReceiver<bool> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::IsLedOn), payload)
    }

    /// Returns the UID, the UID where the Bricklet is connected to,
    /// the position, the hardware and firmware version as well as the
    /// device identifier.
    ///
    /// The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
    /// A Bricklet connected to an [Isolator Bricklet](isolator_bricklet) is always at
    /// position 'z'.
    ///
    /// The device identifier numbers can be found [here](device_identifier).
    /// |device_identifier_constant|
    pub fn get_identity(&self) -> ConvertingReceiver<Identity> {
        let payload = vec![0; 0];

        self.device.get(u8::from(AccelerometerBrickletFunction::GetIdentity), payload)
    }
}
