use timestudy::{Activity, StartActivityError};

fn main() {
    let activity1 = match Activity::start() {
        Ok(v) => v,
        Err(StartActivityError::AlreadyExistingCurrentActivity) => {
            return println!("Error: Another activity is already being tracked.")
        }
        Err(StartActivityError::CannotCreateFile) => {
            return println!("Error: Cannot create activity.")
        }
    };
    println!("Activity started at {:?}.", activity1.start);

    // this one should fail
    let activity1 = match Activity::start() {
        Ok(v) => v,
        Err(StartActivityError::AlreadyExistingCurrentActivity) => {
            return println!("Error: Another activity is already being tracked.")
        }
        Err(StartActivityError::CannotCreateFile) => {
            return println!("Error: Cannot create activity.")
        }
    };

    // match Activity::stop() {
    //     Ok(v) => println!("ok"),
    //     Err(_) => println!("No activity is currently being tracked.".to_string()),
    // }
}
