use chrono::{TimeZone, Utc};
use std::io::{self, BufRead};

use regex::Regex;

fn main() {
    let stdin = io::stdin();
    for line in stdin.lock().lines() {
        println!("{}", timestampify_text(&line.unwrap()));
    }
}

fn timestampify_text(input: &String) -> String {
    let timestamp_re = Regex::new(r"(^|[^0-9])(?P<t>1[0-9]{9}([0-9]{3})?)([^0-9]|$)").unwrap();
    let captures = timestamp_re.captures_iter(input);
    let mut result = "".to_string();
    let mut prev_end = 0;
    for capture in captures {
        let ts_match = capture.name("t").unwrap();
        let timestamp = ts_match.as_str().parse::<i64>().unwrap();
        let date_time = Utc.timestamp(timestamp, 0);
        result.push_str(&input[prev_end..ts_match.start()]);
        result.push_str(&date_time.to_rfc3339());
        prev_end = ts_match.end();
    }
    result.push_str(&input[prev_end..input.len()]);
    result
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn test_dev() {
        let input = "lksfdj> 1234567890 <slkfj slfj ' 1234567890 ' sfljk";
        println!("{}", input);
        println!("{}", timestampify_text(&input.to_string()));
    }
}
