SELECT
  e.aggregate_id,
  n.name,
  e.payload,
  e.time,
  e.sequence
FROM event e
  INNER JOIN aggregate_subscription s
    ON
      e.aggregate_type_id = s.aggregate_type_id AND
      e.sequence > coalesce(s."offset", -9223372036854775808)
LEFT JOIN event_name n
  ON e.name_id = n.id
WHERE e.aggregate_type_id = $1
ORDER BY e.sequence;