pub mod aggregate;

use crate::error::Result;
use crate::TimescaleEventPayload;
use futures::stream::BoxStream;
use serde::Deserialize;
use timesource_core::event::Persisted;

pub type StoreData<Event> = Result<Persisted<Event>>;

#[async_trait]
pub trait ReaderStore<'de> {
    type Event: Clone + Deserialize<'de> + TimescaleEventPayload + Send + Sync;

    fn events_after_offset(&self) -> BoxStream<'_, StoreData<Self::Event>>;

    fn events_after(&self, offset: i64, limit: usize) -> BoxStream<'_, StoreData<Self::Event>>;

    fn events_range(&self, later_than: i64, until: i64) -> BoxStream<'_, StoreData<Self::Event>>;

    async fn save_offset(&self, offset: i64) -> Result<()>;

    async fn try_save_offset(&self, offset: i64) -> Result<()>;
}
