use std::io::{self, Write};

fn read_line() -> io::Result<String> {
    let mut pre_n = String::new();
    io::stdin().read_line(&mut pre_n)?;
    Ok(pre_n)
}

pub fn ask<W: Write>(out: &mut W, question: &str) -> io::Result<bool> {
    write!(out, "{} [y/N] ", question)?;
    out.flush()?;

    Ok(read_line()?.to_lowercase().starts_with('y'))
}
