use std::convert::TryFrom;
use std::io::Write;

use clap::ArgMatches;
use chrono::{DateTime, Utc};

use crate::error::Result;
use crate::database::Database;
use crate::config::Config;

pub mod r#in;
pub mod display;
pub mod today;
pub mod yesterday;
pub mod sheet;
pub mod week;
pub mod month;
pub mod list;
pub mod out;
pub mod resume;
pub mod backend;
pub mod kill;
pub mod now;
pub mod edit;
pub mod archive;
pub mod configure;

pub trait Command<'a> {
    type Args: TryFrom<&'a ArgMatches<'a>>;

    fn handle<D: Database, O: Write, E: Write>(args: Self::Args, db: &mut D, out: &mut O, err: &mut E, config: &Config, now: DateTime<Utc>) -> Result<()>;
}
