use std::path::PathBuf;
use structopt::StructOpt;

#[derive(Debug, Clone, StructOpt)]
#[structopt(name = "tidyVCF", about = "generates tidy tables from VCF files")]
pub struct Opt {
    /// Input file, stdin if not present
    #[structopt(short, long, parse(from_os_str))]
    pub input: Option<PathBuf>,

    /// Output file, stdout if not present
    #[structopt(short, long, parse(from_os_str))]
    pub output: Option<PathBuf>,

    /// Stack samples in rows
    #[structopt(short, long)]
    pub stack: bool,

    /// Split VEP's CSQ string into fields
    #[structopt(short, long)]
    pub vep_fields: bool,

    /// comma separated output (default is tab)
    #[structopt(short, long)]
    pub csv: bool,

    ///input is BGZF compressed (unnecessary if `-i` has suffix `.gz`)
    #[structopt(short, long)]
    pub bgzip: bool,

    /// Delimiting character to join sample names to fmt fields (default is "_")
    #[structopt(short = "j", long = "sample-delim")]
    pub sample_delim: Option<String>,

    /// Prefix string for INFO fields to avoid name collisions (default is "info_")
    #[structopt(short = "p", long)]
    pub info_prefix: Option<String>,
}
