use std::path::PathBuf;
use structopt::StructOpt;

#[derive(Debug, StructOpt)]
#[structopt(name = "tidyVCF", about = "generates tidy tables from VCF files")]
pub struct Opt {
    /// Input file, stdin if not present
    #[structopt(short, long, parse(from_os_str))]
    pub input: Option<PathBuf>,

    /// Output file, stdout if not present
    #[structopt(short, long, parse(from_os_str))]
    pub output: Option<PathBuf>,

    /// Stack samples in rows
    #[structopt(short, long)]
    pub stack: bool,

    /// Delimiting character to join sample names to fmt fields
    #[structopt(short = "j")]
    pub inner_delim: Option<String>,
}
