use async_trait::async_trait;
use http_types::headers::{HeaderName, HeaderValue};

use crate::Result;

#[async_trait]
pub trait Scheme {
    fn header_name() -> HeaderName;

    async fn parse(&self, header_value: &HeaderValue) -> Result<AuthValue>;
}

#[derive(Debug)]
pub enum AuthValue {
    Bearer(String),
    Basic(User),
}

#[derive(Debug)]
pub struct User {
    pub username: String,
    pub password: String,
}
