use tide::{self, Body, Request, Response, StatusCode};
use tide_auth::{Auth, AuthValue, Bearer};

#[async_std::main]
async fn main() -> Result<(), std::io::Error> {
    tide::log::start();

    let mut app = tide::new();
    let auth: Auth<Bearer> = Bearer::new("Hello").into();

    app.with(auth);

    app.at("/").get(|r: Request<()>| async move {
        let user = r.ext::<AuthValue>();
        Ok(format!("{:?}", user))
    });
    app.listen("127.0.0.1:8080").await?;

    Ok(())
}
