#[allow(non_camel_case_types, missing_docs)]
#[derive(Debug, Copy, Clone, PartialEq)]
/// Standard pseudo-terminal codes.
pub enum Pty {
    TTY_OP_END = 0,
    VINTR = 1,
    VQUIT = 2,
    VERASE = 3,
    VKILL = 4,
    VEOF = 5,
    VEOL = 6,
    VEOL2 = 7,
    VSTART = 8,
    VSTOP = 9,
    VSUSP = 10,
    VDSUSP = 11,

    VREPRINT = 12,
    VWERASE = 13,
    VLNEXT = 14,
    VFLUSH = 15,
    VSWTCH = 16,
    VSTATUS = 17,
    VDISCARD = 18,
    IGNPAR = 30,
    PARMRK = 31,
    INPCK = 32,
    ISTRIP = 33,
    INLCR = 34,
    IGNCR = 35,
    ICRNL = 36,
    IUCLC = 37,
    IXON = 38,
    IXANY = 39,
    IXOFF = 40,
    IMAXBEL = 41,
    ISIG = 50,
    ICANON = 51,
    XCASE = 52,
    ECHO = 53,
    ECHOE = 54,
    ECHOK = 55,
    ECHONL = 56,
    NOFLSH = 57,
    TOSTOP = 58,
    IEXTEN = 59,
    ECHOCTL = 60,
    ECHOKE = 61,
    PENDIN = 62,
    OPOST = 70,
    OLCUC = 71,
    ONLCR = 72,
    OCRNL = 73,
    ONOCR = 74,
    ONLRET = 75,

    CS7 = 90,
    CS8 = 91,
    PARENB = 92,
    PARODD = 93,

    TTY_OP_ISPEED = 128,
    TTY_OP_OSPEED = 129,
}

impl Pty {
    #[doc(hidden)]
    pub fn from_u8(x: u8) -> Option<Pty> {
        match x {
            0 => None,
            1 => Some(Pty::VINTR),
            2 => Some(Pty::VQUIT),
            3 => Some(Pty::VERASE),
            4 => Some(Pty::VKILL),
            5 => Some(Pty::VEOF),
            6 => Some(Pty::VEOL),
            7 => Some(Pty::VEOL2),
            8 => Some(Pty::VSTART),
            9 => Some(Pty::VSTOP),
            10 => Some(Pty::VSUSP),
            11 => Some(Pty::VDSUSP),

            12 => Some(Pty::VREPRINT),
            13 => Some(Pty::VWERASE),
            14 => Some(Pty::VLNEXT),
            15 => Some(Pty::VFLUSH),
            16 => Some(Pty::VSWTCH),
            17 => Some(Pty::VSTATUS),
            18 => Some(Pty::VDISCARD),
            30 => Some(Pty::IGNPAR),
            31 => Some(Pty::PARMRK),
            32 => Some(Pty::INPCK),
            33 => Some(Pty::ISTRIP),
            34 => Some(Pty::INLCR),
            35 => Some(Pty::IGNCR),
            36 => Some(Pty::ICRNL),
            37 => Some(Pty::IUCLC),
            38 => Some(Pty::IXON),
            39 => Some(Pty::IXANY),
            40 => Some(Pty::IXOFF),
            41 => Some(Pty::IMAXBEL),
            50 => Some(Pty::ISIG),
            51 => Some(Pty::ICANON),
            52 => Some(Pty::XCASE),
            53 => Some(Pty::ECHO),
            54 => Some(Pty::ECHOE),
            55 => Some(Pty::ECHOK),
            56 => Some(Pty::ECHONL),
            57 => Some(Pty::NOFLSH),
            58 => Some(Pty::TOSTOP),
            59 => Some(Pty::IEXTEN),
            60 => Some(Pty::ECHOCTL),
            61 => Some(Pty::ECHOKE),
            62 => Some(Pty::PENDIN),
            70 => Some(Pty::OPOST),
            71 => Some(Pty::OLCUC),
            72 => Some(Pty::ONLCR),
            73 => Some(Pty::OCRNL),
            74 => Some(Pty::ONOCR),
            75 => Some(Pty::ONLRET),

            90 => Some(Pty::CS7),
            91 => Some(Pty::CS8),
            92 => Some(Pty::PARENB),
            93 => Some(Pty::PARODD),

            128 => Some(Pty::TTY_OP_ISPEED),
            129 => Some(Pty::TTY_OP_OSPEED),
            _ => None,
        }
    }
}
