#![allow(clippy::unreadable_literal)]

// Magic constant for key schedule
pub const C240: u64 = 0x1BD11BDAA9FC1A22;

// Rotation constants for the different key lengths
pub const R256: [[u8; 2]; 8] = [
    [14, 16],
    [52, 57],
    [23, 40],
    [5, 37],
    [25, 33],
    [46, 12],
    [58, 22],
    [32, 32],
];

pub const R512: [[u8; 4]; 8] = [
    [46, 36, 19, 37],
    [33, 27, 14, 42],
    [17, 49, 36, 39],
    [44, 9, 54, 56],
    [39, 30, 34, 24],
    [13, 50, 10, 17],
    [25, 29, 39, 43],
    [8, 35, 56, 22],
];

pub const R1024: [[u8; 8]; 8] = [
    [24, 13, 8, 47, 8, 17, 22, 37],
    [38, 19, 10, 55, 49, 18, 23, 52],
    [33, 4, 51, 13, 34, 41, 59, 17],
    [5, 20, 48, 41, 47, 28, 16, 25],
    [41, 9, 37, 31, 12, 47, 44, 30],
    [16, 34, 56, 51, 4, 53, 42, 41],
    [31, 44, 47, 46, 19, 42, 44, 25],
    [9, 48, 35, 52, 23, 31, 37, 20],
];

// Permutation tables for the different key lengths
pub const P256: [u8; 4] = [0, 3, 2, 1];
pub const P512: [u8; 8] = [6, 1, 0, 7, 2, 5, 4, 3];
pub const P1024: [u8; 16] = [0, 15, 2, 11, 6, 13, 4, 9, 14, 1, 8, 5, 10, 3, 12, 7];
