## How to contribute to Threaty

#### **Did you find a bug?**

* **Do not open up a GitHub issue if the bug is a security vulnerability
  in Threaty**, and instead to refer to our [security policy](#). 

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/MrrRaph/threaty-rs/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/MrrRaph/threaty-rs/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

* If possible, use the relevant bug report templates to create the issue. Simply copy the content of the appropriate template into a .rb file, make the necessary changes to demonstrate the issue, and **paste the content into the issue description**:
  * [**Generic template**](https://github.com/MrrRaph/threaty-rs/blob/master/.github/ISSUE_TEMPLATE/bug_report.md)

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Before submitting, please read the [Contributing to Threaty](#) guide to know more about coding conventions and benchmarks.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Threaty will generally not be accepted.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [threaty-core mailing list](#) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* Ask any question about how to use Threaty in the [threaty-talk mailing list](#).

#### **Do you want to contribute to the Threaty documentation?**

* Please read [Contributing to the Threaty Documentation](#).

Threaty is a volunteer effort. We encourage you to pitch in and join [the team](#)!

Thanks! :heart: :heart: :heart:

Threaty Team.
