# Code of Conduct

## When something happens

If you see a violation of our community's standards of [Conduct](#conduct), follow these steps:

1. Let the person know that what they did is not appropriate and ask them to stop and/or edit their messages.
2. That person should immediately stop the behavior and correct the issue.
3. If this doesn’t happen, or if you're uncomfortable speaking up, contact the moderation team.
4. As soon as available, a moderator will look into the issue, and take further action, starting with a warning, then temporary block, then long-term repo or organization ban.

When reporting, please include any relevant details, links, screenshots, context, or other information that may be used to better understand and resolve the situation. See [Moderation](#moderation) for more information about the moderation process.

## Community Commitment
We as a community are committed to providing a friendly, inclusive, safe and harassment-free environment for all, regardless of level of experience, gender identity and expression, sexual orientation, disability, personal appearance, body size, race, ethnicity, age, religion, nationality, or other similar characteristics.

## Conduct

In this community we strive to go the extra step to look out for each other. Don’t just aim to be technically unimpeachable, try to be your best self. In particular, avoid flirting with offensive or sensitive issues, particularly if they’re off-topic; this all too often leads to unnecessary fights, hurt feelings, and damaged trust; worse, it can drive people away from the community entirely.

And if someone takes issue with something you said or did, resist the urge to be defensive. Just stop doing what it was they complained about and apologize. Even if you feel you were misinterpreted or unfairly accused, chances are good there was something you could’ve communicated better — remember that it’s your responsibility to make your fellow community memebers comfortable. Everyone wants to get along and we are all here first and foremost because we want to talk about cool technology. You will find that people will be eager to assume good intent and forgive as long as you earn their trust.

* Please avoid using overtly sexual aliases or other nicknames that might detract from a friendly, safe and welcoming environment for all.
* Please be kind and courteous. There’s no need to be mean or rude.
* Respect that people have differences of opinion and that every design or implementation choice carries a trade-off and numerous costs. There is seldom a right answer.
* Please keep unstructured critique to a minimum. If you have solid ideas you want to experiment with, make a fork and see how it works.
* We will exclude you from interaction if you insult, demean or harass anyone. That is not welcome behavior. We interpret the term “harassment” as including the definition in the [Citizen Code of Conduct](https://github.com/stumpsyn/policies/blob/master/citizen_code_of_conduct.md); if you have any lack of clarity about what might be included in that concept, please read their definition. In particular, we don’t tolerate behavior that excludes people in socially marginalized groups.
* Private harassment is also unacceptable. No matter who you are, if you feel you have been or are being harassed or made uncomfortable by a community member, please contact the moderation team immediately. Whether you’re a regular contributor or a newcomer, we care about making this community a safe place for you and we’ve got your back.
* Please do not try to present "reverse-ism" versions of the conduct violations that apply specifically to underrepresented groups. Examples of reverse-isms are "reverse racism", "reverse sexism", "heterophobia", and "cisphobia".
* Do not make casual mention of slavery or indentured servitude and/or false comparisons of one's occupation or situation to slavery. Please consider using or asking about alternate terminology when referring to such metaphors in technology.
* Likewise any spamming, trolling, flaming, baiting or other attention-stealing behavior is not welcome.

These standards of conduct apply to all official venues, including Discord channels, GitHub repositories, the Twitter community and all other forums.

## Moderation

These are the policies for upholding our community’s standards of [Conduct](#conduct). If you feel that a thread needs moderation, please contact the moderation team.

1. Remarks that violate the community standards of conduct, including hateful, hurtful, oppressive, or exclusionary remarks, are not allowed. (Cursing is allowed, but never targeting another user, and never in a hateful manner).
2. Remarks that moderators find inappropriate, whether listed in the code of conduct or not, are also not allowed.
3. Moderators will first respond to such remarks with a warning.
4. If the warning is unheeded, the user will be “kicked,” i.e., kicked out of the communication channel to cool off.
5. If the user comes back and continues to make trouble, they will be banned, i.e., indefinitely excluded.
6. Moderators may choose at their discretion to un-ban the user if it was a first offense and they offer the offended party a genuine apology.
7. If a moderator bans someone and you think it was unjustified, please take it up with that moderator, or with a different moderator, in private. Complaints about bans in-channel are not allowed.
8. Moderators are held to a higher standard than other community members. If a moderator creates an inappropriate situation, they should expect less leeway than others.

The moderators will prioritize the well-being and comfort of the recipients of the violation over the comfort of the violator.

Please note that the intent of this Code of Conduct is to create the environment envisioned in our Community Commitment. As such, recurring individual behavior that does not run afoul of any specific policy here but which creates a harmfully toxic or notably unwelcome environment will be considered in overall violation: our policy is to give a single formal warning. It is not this community's responsibility to educate people on how to change their behavior going from there, but specific events might be pointed to. Note however, there will only be _one_ warning. As a community we are committed to avoiding issues like "[missing stairs](https://en.wikipedia.org/wiki/Missing_stair)" in regards to this.

## Attribution

This Code of Conduct is based on the [Rust Code of Conduct](https://www.rust-lang.org/policies/code-of-conduct), which is adapted from the [Node.js Policy on Trolling](http://blog.izs.me/post/30036893703/policy-on-trolling) as well as the [Contributor Covenant version 1.3](https://www.contributor-covenant.org/version/1/3/0/code-of-conduct/); and also the [WeAllJS Code of Conduct](https://wealljs.org/code-of-conduct), which is itself based on [Contributor Covenant version 1.4](https://www.contributor-covenant.org/version/1/4/code-of-conduct/), and the [LGBTQ in Technology Slack Code of Conduct](http://lgbtq.technology/coc.html).
