//! The `thfmr-util` crate provides several utility functions and traits used by the
//! TouHou.FM Radio project.

/// A trait to define the ability to drop a result.
///
/// This can be used when the return type of a [core::result::Result] is not interesting. In
/// particular, this can be used with [try_join!] which returns a [core::result::Result] with
/// a tuple of all original [core::result::Result] values. When the original [core::result::Result]s
/// were all `()`, this trait can be used to simplify the return value by calling
/// [DropResult::drop_result]
pub trait DropResult<T, E> {
    /// Drops the result from a [core::result::Result], turning it into `()`
    fn drop_result(self) -> core::result::Result<(), E>;
}

/// Implementation of DropResult for all [core::result::Result] types
impl<T, E> DropResult<T, E> for core::result::Result<T, E> {
    /// Drops the result from a [core::result::Result], turning it into `()`
    #[inline]
    fn drop_result(self) -> core::result::Result<(), E> {
        self.map(|_| ())
    }
}
