#[cfg(test)]
mod tests;

use serde::{Deserialize, Serialize};
use std::collections::HashMap;

#[derive(Serialize, Deserialize, Debug, PartialEq, Clone)]
pub struct Song {
    pub file: String,
    pub start: Timestamp,
    pub stop: Timestamp,
}

pub type Deck = u8;
pub type Timestamp = u64;

#[derive(Serialize, Deserialize, Debug, PartialEq, Clone)]
pub struct Loaded {
    pub deck: Deck,
    #[serde(flatten)]
    pub song: Song,
}

#[derive(Serialize, Deserialize, Debug, PartialEq, Clone)]
pub struct Transport {
    pub deck: Deck,
    pub position: Timestamp,
    pub length: Timestamp,
}

#[derive(Serialize, Deserialize, Debug, PartialEq, Clone)]
pub struct Meta {
    pub meta: HashMap<String, String>,
}

#[derive(Serialize, Deserialize, Debug, PartialEq, Clone)]
#[serde(tag = "type")]
pub enum Message {
    Want,
    Skip,
    Status,
    Quit,
    Next(Song),
    Loaded(Loaded),
    Playing(Transport),
    Stopped(Transport),
    MetaInfo(Meta),
}
