use crate::message;
use core::result;
use thiserror::Error;
use tokio::{io, sync::mpsc};

#[derive(Error, Debug)]
pub enum ProtocolError {
    #[error("io error")]
    Io(#[from] io::Error),
    #[error("message send error")]
    SendError(#[from] mpsc::error::SendError<message::Message>),
    #[error("serialization/deserialization error")]
    SerdeJson(#[from] serde_json::Error),
    #[error("connection send error")]
    ConnectionSendError(#[from] mpsc::error::SendError<mpsc::Sender<message::Message>>),
}

pub type Result<T> = result::Result<T, ProtocolError>;
