use crate::message::{Loaded, Message, Meta, Song, Transport};
use std::collections::HashMap;

#[test]
fn want() {
    let msg: Message = serde_json::from_str(&r#"{"type":"Want"}"#).unwrap();

    assert_eq!(msg, Message::Want);
}

#[test]
fn skip() {
    let msg: Message = serde_json::from_str(&r#"{"type":"Skip"}"#).unwrap();

    assert_eq!(msg, Message::Skip);
}

#[test]
fn status() {
    let msg: Message = serde_json::from_str(&r#"{"type":"Status"}"#).unwrap();

    assert_eq!(msg, Message::Status);
}

#[test]
fn quit() {
    let msg: Message = serde_json::from_str(&r#"{"type":"Quit"}"#).unwrap();

    assert_eq!(msg, Message::Quit);
}

#[test]
fn next() {
    let msg: Message =
        serde_json::from_str(&r#"{"type":"Next","file":"Test","start":1,"stop":2}"#).unwrap();

    assert_eq!(
        msg,
        Message::Next(Song {
            file: String::from("Test"),
            start: 1,
            stop: 2
        })
    )
}

#[test]
fn loaded() {
    let msg: Message =
        serde_json::from_str(&r#"{"type":"Loaded","deck":1,"file":"Test","start":1,"stop":2}"#)
            .unwrap();

    assert_eq!(
        msg,
        Message::Loaded(Loaded {
            deck: 1,
            song: Song {
                file: String::from("Test"),
                start: 1,
                stop: 2,
            }
        })
    )
}

#[test]
fn playing() {
    let msg: Message =
        serde_json::from_str(&r#"{"type":"Playing","deck":1,"length":2,"position":0}"#).unwrap();

    assert_eq!(
        msg,
        Message::Playing(Transport {
            deck: 1,
            length: 2,
            position: 0,
        })
    )
}

#[test]
fn stopped() {
    let msg: Message =
        serde_json::from_str(&r#"{"type":"Stopped","deck":1,"length":2,"position":2}"#).unwrap();

    assert_eq!(
        msg,
        Message::Stopped(Transport {
            deck: 1,
            length: 2,
            position: 2,
        })
    )
}

#[test]
fn meta_info() {
    let msg: Message =
        serde_json::from_str(&r#"{"type":"MetaInfo","meta":{"artist":"test"}}"#).unwrap();

    assert_eq!(
        msg,
        Message::MetaInfo(Meta {
            meta: {
                let mut map = HashMap::new();

                map.insert("artist".to_string(), "test".to_string());

                map
            }
        })
    )
}
