use tokio::sync::mpsc::{channel, Receiver, Sender};

pub struct ChanPair<T> {
    send: Sender<T>,
    recv: Receiver<T>,
}

impl<T> ChanPair<T> {
    pub fn new(buffer: usize) -> (ChanPair<T>, ChanPair<T>) {
        let (send_a, recv_a) = channel(buffer);
        let (send_b, recv_b) = channel(buffer);

        (
            ChanPair {
                send: send_a,
                recv: recv_b,
            },
            ChanPair {
                send: send_b,
                recv: recv_a,
            },
        )
    }

    pub fn from(send: Sender<T>, recv: Receiver<T>) -> ChanPair<T> {
        ChanPair { send, recv }
    }

    pub fn split(&mut self) -> (&Sender<T>, &mut Receiver<T>) {
        (&self.send, &mut self.recv)
    }

    pub fn send(&self) -> &Sender<T> {
        &self.send
    }

    pub fn recv(&mut self) -> &mut Receiver<T> {
        &mut self.recv
    }
}
