use ndarray::Array2;

/// A trait for thermal cameras
pub trait ThermalCamera {
    type Error;

    /// Get the temperature of the camera.
    ///
    /// Many cameras have a built-in temperature sensor separate from the camera itself. If a
    /// device does not have a temperature sensor distinct from the camera, it should return `None`
    /// (which is what the default implementation does).
    fn temperature(&mut self) -> Option<f32> {
        None
    }

    /// Return a two-dimensional array representing an image from the thermal camera.
    /// Currently the order of the pixels in the image is camera-dependent, but that's probably
    /// going to change at some point.
    fn image(&mut self) -> Result<Array2<f32>, Self::Error>;
}
