//use std::env;
use std::path::Path;

use linux_embedded_hal::I2cdev;
use thermal_camera::grideye;
use thermal_camera::ThermalCamera;

pub fn main() {
    let addr = grideye::Address::High;
    let bus_path = Path::new("/dev/i2c-1");
    let bus = I2cdev::new(bus_path).unwrap();
    let mut camera = grideye::GridEye::new(bus, addr);
    println!("Power Mode: {:?}", camera.power_mode().unwrap());
    println!("Frame Rate: {:?}", camera.frame_rate().unwrap());
    println!(
        "Interrupts enabled: {:?}",
        camera.interrupts_enabled().unwrap()
    );
    println!("Interrupt mode: {:?}", camera.interrupt_mode().unwrap());
    println!("Status Flags: {:?}", camera.flags().unwrap());
    println!(
        "Moving average: {:?}",
        camera.moving_average_enabled().unwrap()
    );
    println!(
        "Interrupt levels: {:^6.2} - {:^6.2} - {:^6.2}",
        camera.lower_interrupt_level().unwrap(),
        camera.hysteresis_interrupt_level().unwrap(),
        camera.upper_interrupt_level().unwrap(),
    );
    println!("Sensor Temperature: {:?}", camera.temperature().unwrap());
    println!("Pixel Temperatures:");
    let image = camera.image().unwrap();
    for row in image.outer_iter().rev() {
        for pixel in row.iter() {
            print!("{:>6.2} ", pixel);
        }
        println!();
    }
}
