# Contributing to The Force

Thank you for helping out with the The Force!

Following these guidelines helps us keep good project workflow. We appreciate you working with us on it. 

Please read our [CODE_OF_CONDUCT.md](CODE_OF_CONDUCT.md) to understand our community expectations.

## How to help?

Please check the [Issues][Issues] for current task. If you see something that you would like to help with, ask about helping in a comment and we'll assign it too you.

Checkout the [introduction.md](docs/introduction.md) file for a high level explanation of the project.

### Report Bug 

Check to see if someone already reported this [bug][Bug Issues] already exists. If so then leave a comment on that issue. If not, please provide a detailed description of the bug. Include what was happening before the error, all settings, and test results. This helps us more quickly identify and solve any problems. Create an [Issue][Issues] with the description and add a bug label. We will do our best to respond quickly to it. 

### Request a Feature

Check to see if the feature is already listed in our [feature requests][Feature Issues]. If it's not, describe the feature and why it would be beneficial. Create an [Issue][Issues] with this description and add a feature enhancement label. We will do our best to respond quickly to it. 

### Submit Example Code

If you have a program written in The Force that you'd like to share, please do! Make a Pull Request to add it to the Examples folder.

### Work on The Force

If you'd like to fix bugs or add features to The Force, please submit an issue or comment on a relevant issue to share your intentions and ask any questions. 

Once you are ready to make the Pull Request, consult the [Pull Request Checklist](#Pull-Request-Checklist)

## Pull Request Checklist

Please do these things before you make your Pull Request

- [ ] Add any relevant unit tests
- [ ] Make sure all unit tests pass with `cargo test`
- [ ] Use our [.editorconfig](.editorconfig) to help automatically style all files
- [ ] Format the code with `cargo fmt`
- [ ] Link the relevant issue the Pull Request addresses

[Issues]: https://github.com/mirdaki/theforce/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc
[Bug Issues]: https://github.com/mirdaki/theforce/labels/bug
[Feature Issues]: https://github.com/mirdaki/theforce/labels/enhancement
