use std::{fs, env};
use chrono::{Datelike, Timelike, Local};

fn main() {
    println!("cargo:rerun-if-changed=build.rs");
    let icon_dir = match fs::read_dir("/storage/emulated/0") {
        Ok(_) => format!("{}/lib/the_rock/icon.png", env::var("PREFIX").unwrap()),
        Err(_) => "/usr/lib/the_rock/icon.png".to_string()
    };
    let months = ["January","February","March","April","May","June","July","August","September","October","November","December"];
    let date = Local::now().date();
    let month = months[date.month() as usize - 1];
    let day = date.day();
    let year = date.year();

    let date_str = format!("{} {} {}",day, month, year);

    let time = Local::now().time();
    let hour = time.hour();
    let minute = time.minute();
    let second = time.second(); 

    let time_str = format!("{:02}:{:02}:{:02}",hour,minute,second);

    let desktop_file = format!("[Desktop Entry]
Version={}
Type=Application
Name=The Rock
Comment=Command line King James bible viewer
Exec=the_rock
Icon={}
Terminal=true
StartupNotify=false
Categories=Utility;",env!("CARGO_PKG_VERSION"), icon_dir);

    let the_rock_manpage = format!(".\\\" Manpage for The Rock.
.\\\" Created on {} {}, {} at {}
.TH the_rock 1 \"{}\" \"{}\" \"the_rock man page\"
.SH NAME
The Rock \\- Command line King James bible viewer
.SH DESCRIPTION
the_rock [chapter]
.br
The Rock is a command line program to view the King James version of the bible
.SH OPTIONS
If you specify a specific chapter as an argument, or if none are specified, The Rock will open the last chapter it closed on, or it will open Genesis 1
.SH SEE ALSO
bible(1)
.SH AUTHOR
Noah Jelen (noahtjelen@gmail.com)",month,day,year,time_str,date_str,env!("CARGO_PKG_VERSION"));

    let bible_manpage = format!(".\\\" Manpage for bible (part of The Rock).
.\\\" Created on {} {}, {} at {}
.TH bible 1 \"{}\" \"{}\" \"bible man page\"
.SH NAME
bible \\- King James bible verse reference utility
.SH SYNOPSIS
bible <verse>
.br
bible -p <verse>
.br
bible -c <chapter>
.br
bible -s <search term>
.br
bible <passage>
.br
biblr -t <topic>
.br
bible [verse or passage][,verse or passage,verse or passage...]
.SH DESCRIPTION
bible is the command line interface of The Rock.
.SH OPTIONS
If no options are specifed, bible will just show Genesis 1:1
Use -v to show current version
.br
Use -h to show the help message
.br
Use -p <passage> to show the passage as a paragraph instead of verse list
.br
Use -c <book number><chapter number> to show an entire chapter
.br
Use -s <word> to find all instances of a specific word
.SH EXAMPLES
bible Mark9:23
.br
bible matt24:4-14
.br
bible isa40:31,matt6:9-13,Genesis1
.br
bible -p matt24:4-14
.br
bible -c genesis1
.br
bible -cp exodus20
.SH SEE ALSO
the_rock(1)
.SH AUTHOR
Noah Jelen (noahtjelen@gmail.com)",month,day,year,time_str,date_str,env!("CARGO_PKG_VERSION"));

    let aur_pkgbuild = format!("# Maintainer: Noah Jelen <noahtjelen@gmail.com>
# Generated by cargo on {} {}, {} at {}
pkgname=the-rock
pkgver={}
pkgrel=1
pkgdesc=\"A command line King James bible viewer\"
arch=('i686' 'x86_64')
url=\"https://gitlab.com/NoahJelen/the-rock\"
license=('GPL')
depends=('ncurses' 'gcc-libs' 'glibc')
makedepends=('cargo' 'gzip')
source=(\"https://gitlab.com/NoahJelen/the-rock/-/archive/$pkgver/the-rock-$pkgver.zip\")
conflicts=('the-rock-git' 'bible-kjv')
md5sums=('SKIP')

build() {{
    cd \"the-rock-$pkgver\"
    cargo build --release
    cd target/release
    ln -sf the_rock bible
}}

package() {{
    cd \"the-rock-$pkgver\"
    mkdir -p \"$pkgdir/usr/lib/the_rock\"
    mkdir -p \"$pkgdir/usr/share/man/man1/\"
    install -Dt \"$pkgdir/usr/bin\" -m755 target/release/the_rock
    install -Dt \"$pkgdir/usr/bin\" -m755 target/release/bible
    install -Dt \"$pkgdir/usr/lib/the_rock/\" bible.rawtext
    install -Dt \"$pkgdir/usr/share/applications/\" the_rock.desktop
    install -Dt \"$pkgdir/usr/lib/the_rock/\" icon.png
    install -Dt \"$pkgdir/usr/share/man/man1\" man/the_rock.1
    install -Dt \"$pkgdir/usr/share/man/man1\" man/bible.1
    gzip \"$pkgdir/usr/share/man/man1/bible.1\"
    gzip \"$pkgdir/usr/share/man/man1/the_rock.1\"
}}",month,day,year,time_str,env!("CARGO_PKG_VERSION"));

    fs::remove_file("aur/PKGBUILD").unwrap_or(());
    fs::remove_file("man/bible.1").unwrap_or(());
    fs::remove_file("man/the_rock.1").unwrap_or(());
    fs::remove_file("the_rock.desktop").unwrap_or(());
    fs::remove_dir("man/").unwrap_or(());
    
    fs::write("aur/PKGBUILD", aur_pkgbuild).unwrap_or(());
    fs::create_dir("man/").unwrap();
    fs::write("man/bible.1", bible_manpage).unwrap();
    fs::write("man/the_rock.1", the_rock_manpage).unwrap();
    fs::write("the_rock.desktop", desktop_file).unwrap();
}