use std::{env, fs};
use rust_utils::utils;
mod tui;
mod cli;
mod bible;
mod config;

fn main() {
    // get the command line arguments of the program
    let mut args: Vec<String> = env::args().collect();
    let arg: String;
    if args.len() == 1 {
        arg =  String::from("DEF")
    }
    else {
        arg = args[1].to_string();
    }
    if utils::get_execname()=="bible"{
        args.remove(0);
        cli::parse_args(args);
    }

    // start the TUI
    else if utils::get_execname()=="the_rock"{
        tui::show_ui(arg);
    }

    // file cleanup
    fs::remove_file("/tmp/bookmark_to_delete").unwrap_or(());
    fs::remove_file("/tmp/title").unwrap_or(());
    fs::remove_file("/tmp/book").unwrap_or(());
    fs::remove_file("/tmp/chapter_num").unwrap_or(());
    fs::remove_file("/tmp/verse_num").unwrap_or(());
    fs::remove_file("/tmp/last_verse_num").unwrap_or(());
}