use crate::bible::*;

pub fn parse_args(args: Vec<String>) {
    if args.len() == 0 {
        parse_refs("Ge1:1", false, false);
        return;
    }

    match args[0].as_str() {
        "-v" => println!("The Rock: A King James Bible Viewer\nVersion {}",env!("CARGO_PKG_VERSION")),
        "-h" => show_help(),
        "-c" => parse_refs(&args[1], false, true),
        "-p" => parse_refs(&args[1], true, false),
        "-pc" => parse_refs(&args[1], true, true),
        "-cp" => parse_refs(&args[1], true, true),
        _=> parse_refs(&args[0], false, false)
    }
}

// parse verse and passage references and output them
fn parse_refs(args: &str, isparagraph: bool, entire_chapter: bool) {
    let mut ispassage: bool;
    let verse_list = args.split(",");
    let mut passage: Vec<String>;
    let mut book: String;
    let mut chapter_num: usize;
    let mut verse_num;
    let mut last_verse_num:usize;
    let mut verse_ref:(String,usize,usize,usize,bool);
    for verse in verse_list{
        verse_ref = parse_verse_ref(verse);
        book = verse_ref.0;
        chapter_num = verse_ref.1;
        verse_num = verse_ref.2;
        last_verse_num = verse_ref.3;
        ispassage = verse_ref.4;
        if entire_chapter {
            ispassage=true;
        }

        // output the text
        if ispassage {
            if isparagraph{
                if entire_chapter{
                    print!("{} {}: ", books::BOOKS[get_book_num(&book)], chapter_num);
                }
                else
                {
                    print!("{} {}:{}-{}: ", books::BOOKS[get_book_num(&book)], chapter_num,verse_num,last_verse_num);
                }
            }
            else {
                println!("{} {}\n", books::BOOKS[get_book_num(&book)], chapter_num);
            }
            
            if entire_chapter {
                
                passage = chapter::get_chapter(&book, chapter_num);
            }
            else {
                passage = chapter::get_passage(&book, chapter_num, verse_num, last_verse_num);
            }

            for (i,verse_text) in passage.iter().enumerate() {
                if isparagraph{
                    print!("{} ",verse_text);
                }
                else {
                    println!("{} {}", verse_num+i, verse_text);
                }
            }
        }
        else {
            println!("{} {}:{}: {}", books::BOOKS[get_book_num(&book)],chapter_num,verse_num,chapter::get_verse(&book, chapter_num, verse_num))
        }
    }
    print!("\n");
}

// show the help for the program
fn show_help() {
    println!("Usage:\nbible <verse>\nbible <passage>\nbible <verse or passage>[,verse or passage,verse or passage...]\n");
    println!("Examples:\nbible Mark9:23\nbible matt24:4-14\nbible isa40:31,matt6:9-13,Genesis1\n");
    println!("Use -v to show current version.\nUse -h to show this help message again.\nUse -p <passage> to show the passage as a paragraph instead of verse list");
    println!("\nPassage and verse syntax: <book name><chapter>:<verse>[-<ending verse if passage>]");
}