that
====

[![crates.io](https://img.shields.io/crates/v/that.svg)](https://crates.io/crates/that)
[![Documentation](https://docs.rs/that/badge.svg)](https://docs.rs/that)
[![Build Status](https://travis-ci.org/btwiuse/that.svg?branch=master)](https://travis-ci.org/btwiuse/that)

`that` is yet another clone of `which`, as the result of my attempt to accomplish something out of [nothing](https://docs.rs/nothing).

The main function contains only a single line of code.

```
fn main() -> nothing::Probably<()> {
    println!("{}", that::Args::parse().locate()?.display()).into()
}
```

Besides that, there is nothing appropriate.

```
$ whatis that
that: nothing appropriate
```

## Install

```
$ cargo install that
```

## Usage

```
that 0.1.3
locate the binary for a command

USAGE:
    that <COMMAND>

ARGS:
    <COMMAND>    command name

OPTIONS:
    -h, --help       Print help information
    -V, --version    Print version information
```

## Examples

if the command is found in PATH, print the path and exit with `0`

```
$ that cat
/usr/sbin/cat
$ echo $?
0
```

otherwise do nothing, exit with `1`

```
$ that dog
$ echo $?
1
```
