use clap::Parser;
use nothing::Probably;
use std::env;
use std::path::{Path, PathBuf};

/// find binary for command
///
/// credits to <https://stackoverflow.com/questions/37498864/finding-executable-in-path-with-rust>
pub fn locate<P>(exe_name: P) -> Option<PathBuf>
where
    P: AsRef<Path>,
{
    env::var_os("PATH").and_then(|paths| {
        env::split_paths(&paths)
            .filter_map(|dir| {
                let full_path = dir.join(&exe_name);
                if full_path.is_file() {
                    Some(full_path)
                } else {
                    None
                }
            })
            .next()
    })
}

/// clap::Parser struct
#[derive(Parser)]
#[clap(author, version, about, long_about = None)]
pub struct Args {
    /// command name
    pub command: String,
}

impl Args {
    /// find command path
    pub fn locate(self) -> Probably<PathBuf> {
        locate(self.command).into()
    }
}
