#![no_std]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(non_snake_case)]

macro_rules! glconst {
    ($($i:ident),*) => {
	paste::paste! {
	    $(
		pub const $i: crate::types::GLenum = crate::sys::[<GL_ $i>] as crate::types::GLenum;
	    )*
	}
    };
}

macro_rules! glconst_rename {
    ($($i:ident $j:ident),*) => {
	paste::paste! {
	    $(
		pub const $j: crate::types::GLenum = crate::sys::[<GL_ $i>] as crate::types::GLenum;
	    )*
	}
    };
}

#[cfg(feature = "text")]
macro_rules! gltextconst {
    ($($i:ident),*) => {
	paste::paste! {
	    $(
		pub const $i: crate::types::GLTEXTSIZE = crate::sys::[<GLTEXTSIZE_GL_ $i>] as crate::types::GLTEXTSIZE;
	    )*
	}
    };
}

macro_rules! glfn {
    ($($i:ident ($($arg:ident $t:ty),*)),*) => {
	paste::paste! {
	    $(
		pub unsafe fn $i($(
		    $arg: $t,
		)*) {
		    crate::sys::[<gl $i>]($($arg as _, )*)
		}
	    )*
	}
    };
}

pub const _2D: crate::types::GLenum = crate::sys::GL_2D as crate::types::GLenum;
pub const _2_BYTES: crate::types::GLenum = crate::sys::GL_2_BYTES as crate::types::GLenum;
pub const _3D: crate::types::GLenum = crate::sys::GL_3D as crate::types::GLenum;
pub const _3D_COLOR: crate::types::GLenum = crate::sys::GL_3D_COLOR as crate::types::GLenum;
pub const _3D_COLOR_TEXTURE: crate::types::GLenum =
    crate::sys::GL_3D_COLOR_TEXTURE as crate::types::GLenum;
pub const _3_BYTES: crate::types::GLenum = crate::sys::GL_3_BYTES as crate::types::GLenum;
pub const _4D_COLOR_TEXTURE: crate::types::GLenum =
    crate::sys::GL_4D_COLOR_TEXTURE as crate::types::GLenum;
pub const _4_BYTES: crate::types::GLenum = crate::sys::GL_4_BYTES as crate::types::GLenum;

glconst![
    ACCUM,
    ACCUM_ALPHA_BITS,
    ACCUM_BLUE_BITS,
    ACCUM_BUFFER_BIT,
    ACCUM_CLEAR_VALUE,
    ACCUM_GREEN_BITS,
    ACCUM_RED_BITS,
    ADD,
    ALL_ATTRIB_BITS,
    ALPHA,
    ALPHA4,
    ALPHA8,
    ALPHA12,
    ALPHA16,
    ALPHA_BIAS,
    ALPHA_BITS,
    ALPHA_SCALE,
    ALPHA_TEST,
    ALPHA_TEST_FUNC,
    ALPHA_TEST_REF,
    ALWAYS,
    AMBIENT,
    AMBIENT_AND_DIFFUSE,
    AND,
    AND_INVERTED,
    AND_REVERSE,
    ARRAY_BUFFER,
    ATTRIB_STACK_DEPTH,
    AUTO_NORMAL,
    AUX0,
    AUX1,
    AUX2,
    AUX3,
    AUX_BUFFERS,
    BACK,
    BACK_LEFT,
    BACK_RIGHT,
    BITMAP,
    BITMAP_TOKEN,
    BLEND,
    BLEND_DST,
    BLEND_EQUATION,
    BLEND_SRC,
    BLUE,
    BLUE_BIAS,
    BLUE_BITS,
    BLUE_SCALE,
    BYTE,
    C3F_V3F,
    C4F_N3F_V3F,
    C4UB_V2F,
    C4UB_V3F,
    CCW,
    CLAMP,
    CLEAR,
    CLIP_PLANE0,
    CLIP_PLANE1,
    CLIP_PLANE2,
    CLIP_PLANE3,
    CLIP_PLANE4,
    CLIP_PLANE5,
    COEFF,
    COLOR,
    COLOR_ARRAY,
    COLOR_ARRAY_COUNT,
    COLOR_ARRAY_POINTER,
    COLOR_ARRAY_SIZE,
    COLOR_ARRAY_STRIDE,
    COLOR_ARRAY_TYPE,
    COLOR_BUFFER,
    COLOR_BUFFER_BIT,
    COLOR_CLEAR_VALUE,
    COLOR_INDEX,
    COLOR_INDEXES,
    COLOR_MATERIAL,
    COLOR_MATERIAL_FACE,
    COLOR_MATERIAL_PARAMETER,
    COLOR_WRITEMASK,
    COMPILE,
    COMPILE_AND_EXECUTE,
    CONSTANT_ALPHA,
    CONSTANT_ATTENUATION,
    CONSTANT_COLOR,
    COPY,
    COPY_INVERTED,
    COPY_PIXEL_TOKEN,
    CULL_FACE,
    CULL_FACE_MODE,
    CURRENT_BIT,
    CURRENT_COLOR,
    CURRENT_INDEX,
    CURRENT_NORMAL,
    CURRENT_RASTER_COLOR,
    CURRENT_RASTER_DISTANCE,
    CURRENT_RASTER_INDEX,
    CURRENT_RASTER_POSITION,
    CURRENT_RASTER_POSITION_VALID,
    CURRENT_RASTER_TEXTURE_COORDS,
    CURRENT_TEXTURE_COORDS,
    CW,
    DECAL,
    DECR,
    DEPTH,
    DEPTH_BIAS,
    DEPTH_BITS,
    DEPTH_BUFFER_BIT,
    DEPTH_CLEAR_VALUE,
    DEPTH_COMPONENT,
    DEPTH_FUNC,
    DEPTH_RANGE,
    DEPTH_SCALE,
    DEPTH_TEST,
    DEPTH_WRITEMASK,
    DIFFUSE,
    DITHER,
    DOMAIN,
    DONT_CARE,
    DOUBLE,
    DOUBLEBUFFER,
    DRAW_BUFFER,
    DRAW_PIXEL_TOKEN,
    DST_ALPHA,
    DST_COLOR,
    EDGE_FLAG,
    EDGE_FLAG_ARRAY,
    EDGE_FLAG_ARRAY_COUNT,
    EDGE_FLAG_ARRAY_POINTER,
    EDGE_FLAG_ARRAY_STRIDE,
    EMISSION,
    ENABLE_BIT,
    EQUAL,
    EQUIV,
    ERROR_CHECK_LEVEL,
    EVAL_BIT,
    EXP,
    EXP2,
    EXTENSIONS,
    EYE_LINEAR,
    EYE_PLANE,
    FALSE,
    FASTEST,
    FEEDBACK,
    FILL,
    FLAT,
    FLOAT,
    FOG,
    FOG_BIT,
    FOG_COLOR,
    FOG_DENSITY,
    FOG_END,
    FOG_HINT,
    FOG_INDEX,
    FOG_MODE,
    FOG_START,
    FRONT,
    FRONT_AND_BACK,
    FRONT_FACE,
    FRONT_LEFT,
    FRONT_RIGHT,
    FUNC_ADD,
    FUNC_REVERSE_SUBTRACT,
    FUNC_SUBTRACT,
    GEQUAL,
    GREATER,
    GREEN,
    GREEN_BIAS,
    GREEN_BITS,
    GREEN_SCALE,
    HINT_BIT,
    INCR,
    INDEX_ARRAY,
    INDEX_ARRAY_COUNT,
    INDEX_ARRAY_POINTER,
    INDEX_ARRAY_STRIDE,
    INDEX_ARRAY_TYPE,
    INDEX_BITS,
    INDEX_CLEAR_VALUE,
    INDEX_MODE,
    INDEX_OFFSET,
    INDEX_SHIFT,
    INDEX_WRITEMASK,
    INT,
    INTENSITY,
    INTENSITY4,
    INTENSITY8,
    INTENSITY12,
    INTENSITY16,
    INVALID_ENUM,
    INVALID_OPERATION,
    INVALID_VALUE,
    INVERT,
    IS_SPECULAR_ENABLED,
    KEEP,
    LEFT,
    LEQUAL,
    LESS,
    LICENSE,
    LIGHT0,
    LIGHT1,
    LIGHT2,
    LIGHT3,
    LIGHT4,
    LIGHT5,
    LIGHT6,
    LIGHT7,
    LIGHT8,
    LIGHT9,
    LIGHT10,
    LIGHT11,
    LIGHT12,
    LIGHT13,
    LIGHT14,
    LIGHT15,
    LIGHTING,
    LIGHTING_BIT,
    LIGHT_MODEL_AMBIENT,
    LIGHT_MODEL_LOCAL_VIEWER,
    LIGHT_MODEL_TWO_SIDE,
    LINE,
    LINEAR,
    LINEAR_ATTENUATION,
    LINEAR_MIPMAP_LINEAR,
    LINEAR_MIPMAP_NEAREST,
    LINES,
    LINE_BIT,
    LINE_LOOP,
    LINE_RESET_TOKEN,
    LINE_SMOOTH,
    LINE_SMOOTH_HINT,
    LINE_STIPPLE,
    LINE_STIPPLE_PATTERN,
    LINE_STIPPLE_REPEAT,
    LINE_STRIP,
    LINE_TOKEN,
    LINE_WIDTH,
    LINE_WIDTH_GRANULARITY,
    LINE_WIDTH_RANGE,
    LIST_BASE,
    LIST_BIT,
    LIST_INDEX,
    LIST_MODE,
    LOAD,
    LOGIC_OP,
    LOGIC_OP_MODE,
    LUMINANCE,
    LUMINANCE4,
    LUMINANCE4_ALPHA4,
    LUMINANCE6_ALPHA2,
    LUMINANCE8,
    LUMINANCE8_ALPHA8,
    LUMINANCE12,
    LUMINANCE12_ALPHA4,
    LUMINANCE12_ALPHA12,
    LUMINANCE16,
    LUMINANCE16_ALPHA16,
    LUMINANCE_ALPHA,
    MAP1_COLOR_4,
    MAP1_GRID_DOMAIN,
    MAP1_GRID_SEGMENTS,
    MAP1_INDEX,
    MAP1_NORMAL,
    MAP1_TEXTURE_COORD_1,
    MAP1_TEXTURE_COORD_2,
    MAP1_TEXTURE_COORD_3,
    MAP1_TEXTURE_COORD_4,
    MAP1_VERTEX_3,
    MAP1_VERTEX_4,
    MAP2_COLOR_4,
    MAP2_GRID_DOMAIN,
    MAP2_GRID_SEGMENTS,
    MAP2_INDEX,
    MAP2_NORMAL,
    MAP2_TEXTURE_COORD_1,
    MAP2_TEXTURE_COORD_2,
    MAP2_TEXTURE_COORD_3,
    MAP2_TEXTURE_COORD_4,
    MAP2_VERTEX_3,
    MAP2_VERTEX_4,
    MAP_COLOR,
    MAP_STENCIL,
    MATRIX_MODE,
    MAX_ATTRIB_STACK_DEPTH,
    MAX_BUFFERS,
    MAX_CLIENT_ATTRIB_STACK_DEPTH,
    MAX_CLIP_PLANES,
    MAX_DISPLAY_LISTS,
    MAX_EVAL_ORDER,
    MAX_LIGHTS,
    MAX_LIST_NESTING,
    MAX_MODELVIEW_STACK_DEPTH,
    MAX_NAME_STACK_DEPTH,
    MAX_PIXEL_MAP_TABLE,
    MAX_PROJECTION_STACK_DEPTH,
    MAX_SPECULAR_BUFFERS,
    MAX_TEXTURE_LEVELS,
    MAX_TEXTURE_SIZE,
    MAX_TEXTURE_STACK_DEPTH,
    MAX_VIEWPORT_DIMS,
    MODELVIEW,
    MODELVIEW_MATRIX,
    MODELVIEW_STACK_DEPTH,
    MODULATE,
    MULT,
    N3F_V3F,
    NAME_STACK_DEPTH,
    NAND,
    NEAREST,
    NEAREST_MIPMAP_LINEAR,
    NEAREST_MIPMAP_NEAREST,
    NEVER,
    NICEST,
    NONE,
    NOOP,
    NOR,
    NORMALIZE,
    NORMAL_ARRAY,
    NORMAL_ARRAY_COUNT,
    NORMAL_ARRAY_COUNT_EXT,
    NORMAL_ARRAY_EXT,
    NORMAL_ARRAY_POINTER,
    NORMAL_ARRAY_POINTER_EXT,
    NORMAL_ARRAY_STRIDE,
    NORMAL_ARRAY_STRIDE_EXT,
    NORMAL_ARRAY_TYPE,
    NORMAL_ARRAY_TYPE_EXT,
    NORMAL_BUFFER,
    NOTEQUAL,
    NO_ERROR,
    OBJECT_LINEAR,
    OBJECT_PLANE,
    ONE,
    ONE_MINUS_CONSTANT_ALPHA,
    ONE_MINUS_CONSTANT_ALPHA_EXT,
    ONE_MINUS_CONSTANT_COLOR,
    ONE_MINUS_CONSTANT_COLOR_EXT,
    ONE_MINUS_DST_ALPHA,
    ONE_MINUS_DST_COLOR,
    ONE_MINUS_SRC_ALPHA,
    ONE_MINUS_SRC_COLOR,
    OR,
    ORDER,
    OR_INVERTED,
    OR_REVERSE,
    OUT_OF_MEMORY,
    PACK_ALIGNMENT,
    PACK_LSB_FIRST,
    PACK_ROW_LENGTH,
    PACK_SKIP_PIXELS,
    PACK_SKIP_ROWS,
    PACK_SWAP_BYTES,
    PASS_THROUGH_TOKEN,
    PERSPECTIVE_CORRECTION_HINT,
    PIXEL_MAP_A_TO_A,
    PIXEL_MAP_A_TO_A_SIZE,
    PIXEL_MAP_B_TO_B,
    PIXEL_MAP_B_TO_B_SIZE,
    PIXEL_MAP_G_TO_G,
    PIXEL_MAP_G_TO_G_SIZE,
    PIXEL_MAP_I_TO_A,
    PIXEL_MAP_I_TO_A_SIZE,
    PIXEL_MAP_I_TO_B,
    PIXEL_MAP_I_TO_B_SIZE,
    PIXEL_MAP_I_TO_G,
    PIXEL_MAP_I_TO_G_SIZE,
    PIXEL_MAP_I_TO_I,
    PIXEL_MAP_I_TO_I_SIZE,
    PIXEL_MAP_I_TO_R,
    PIXEL_MAP_I_TO_R_SIZE,
    PIXEL_MAP_R_TO_R,
    PIXEL_MAP_R_TO_R_SIZE,
    PIXEL_MAP_S_TO_S,
    PIXEL_MAP_S_TO_S_SIZE,
    PIXEL_MODE_BIT,
    POINT,
    POINTS,
    POINT_BIT,
    POINT_SIZE,
    POINT_SIZE_GRANULARITY,
    POINT_SIZE_RANGE,
    POINT_SMOOTH,
    POINT_SMOOTH_HINT,
    POINT_TOKEN,
    POLYGON,
    POLYGON_BIT,
    POLYGON_MAX_VERTEX,
    POLYGON_MODE,
    POLYGON_OFFSET_BIAS_EXT,
    POLYGON_OFFSET_EXT,
    POLYGON_OFFSET_FILL,
    POLYGON_OFFSET_LINE,
    POLYGON_OFFSET_POINT,
    POLYGON_OFFSET_UNITS,
    POLYGON_SMOOTH,
    POLYGON_SMOOTH_HINT,
    POLYGON_STIPPLE,
    POLYGON_STIPPLE_BIT,
    POLYGON_TOKEN,
    POSITION,
    PROJECTION,
    PROJECTION_MATRIX,
    PROJECTION_STACK_DEPTH,
    PROXY_TEXTURE_1D,
    PROXY_TEXTURE_2D,
    Q,
    QUADRATIC_ATTENUATION,
    QUADS,
    QUAD_STRIP,
    R,
    R3_G3_B2,
    READ_BUFFER,
    RED,
    RED_BIAS,
    RED_BITS,
    RED_SCALE,
    RENDER,
    RENDERER,
    RENDER_MODE,
    REPEAT,
    REPLACE,
    RETURN,
    RGB,
    RGB4,
    RGB5,
    RGB5_A1,
    RGB8,
    RGB10,
    RGB10_A2,
    RGB12,
    RGB16,
    RGBA,
    RGBA2,
    RGBA4,
    RGBA8,
    RGBA12,
    RGBA16,
    RGBA_MODE,
    RIGHT,
    S,
    SCISSOR_BIT,
    SCISSOR_BOX,
    SCISSOR_TEST,
    SELECT,
    SET,
    SHADE_MODEL,
    SHININESS,
    SHORT,
    SMOOTH,
    SPECULAR,
    SPHERE_MAP,
    SPOT_CUTOFF,
    SPOT_DIRECTION,
    SPOT_EXPONENT,
    SRC_ALPHA,
    SRC_ALPHA_SATURATE,
    SRC_COLOR,
    STACK_OVERFLOW,
    STACK_UNDERFLOW,
    STATIC_DRAW,
    STENCIL,
    STENCIL_BITS,
    STENCIL_BUFFER_BIT,
    STENCIL_CLEAR_VALUE,
    STENCIL_FAIL,
    STENCIL_FUNC,
    STENCIL_INDEX,
    STENCIL_PASS_DEPTH_FAIL,
    STENCIL_PASS_DEPTH_PASS,
    STENCIL_REF,
    STENCIL_TEST,
    STENCIL_VALUE_MASK,
    STENCIL_WRITEMASK,
    STEREO,
    SUBPIXEL_BITS,
    T,
    T2F_C3F_V3F,
    T2F_C4F_N3F_V3F,
    T2F_C4UB_V3F,
    T2F_N3F_V3F,
    T2F_V3F,
    T4F_C4F_N3F_V4F,
    T4F_V4F,
    TEXTURE,
    TEXTURE_1D,
    TEXTURE_1D_BINDING,
    TEXTURE_2D,
    TEXTURE_2D_BINDING,
    TEXTURE_BIT,
    TEXTURE_BORDER,
    TEXTURE_BORDER_COLOR,
    TEXTURE_COMPONENTS,
    TEXTURE_COORD_ARRAY,
    TEXTURE_COORD_ARRAY_COUNT,
    TEXTURE_COORD_ARRAY_COUNT_EXT,
    TEXTURE_COORD_ARRAY_EXT,
    TEXTURE_COORD_ARRAY_POINTER,
    TEXTURE_COORD_ARRAY_POINTER_EXT,
    TEXTURE_COORD_ARRAY_SIZE,
    TEXTURE_COORD_ARRAY_SIZE_EXT,
    TEXTURE_COORD_ARRAY_STRIDE,
    TEXTURE_COORD_ARRAY_STRIDE_EXT,
    TEXTURE_COORD_ARRAY_TYPE,
    TEXTURE_COORD_ARRAY_TYPE_EXT,
    TEXTURE_COORD_BUFFER,
    TEXTURE_ENV,
    TEXTURE_ENV_COLOR,
    TEXTURE_ENV_MODE,
    TEXTURE_GEN_MODE,
    TEXTURE_GEN_Q,
    TEXTURE_GEN_R,
    TEXTURE_GEN_S,
    TEXTURE_GEN_T,
    TEXTURE_HEIGHT,
    TEXTURE_HASH_TABLE_SIZE,
    TEXTURE_MAG_FILTER,
    TEXTURE_MATRIX,
    TEXTURE_MIN_FILTER,
    TEXTURE_PRIORITY,
    TEXTURE_RESIDENT,
    TEXTURE_STACK_DEPTH,
    TEXTURE_WIDTH,
    TEXTURE_WRAP_S,
    TEXTURE_WRAP_T,
    TRANSFORM_BIT,
    TRIANGLES,
    TRIANGLE_FAN,
    TRIANGLE_STRIP,
    TRUE,
    UNPACK_ALIGNMENT,
    UNPACK_LSB_FIRST,
    UNPACK_ROW_LENGTH,
    UNPACK_SKIP_PIXELS,
    UNPACK_SKIP_ROWS,
    UNPACK_SWAP_BYTES,
    UNSIGNED_BYTE,
    UNSIGNED_INT,
    UNSIGNED_INT_8_8_8_8,
    UNSIGNED_SHORT,
    UNSIGNED_SHORT_5_6_5,
    V2F,
    V3F,
    VENDOR,
    VERSION,
    VERSION_1_1,
    VERTEX_ARRAY,
    VERTEX_ARRAY_COUNT,
    VERTEX_ARRAY_POINTER,
    VERTEX_ARRAY_SIZE,
    VERTEX_ARRAY_STRIDE,
    VERTEX_ARRAY_TYPE,
    VERTEX_BUFFER,
    VIEWPORT,
    VIEWPORT_BIT,
    XOR,
    ZERO,
    ZOOM_X,
    ZOOM_Y
];

glconst_rename![
    CLIP_PLANE0 CLIP_DISTANCE0,
    CLIP_PLANE1 CLIP_DISTANCE1,
    CLIP_PLANE2 CLIP_DISTANCE2,
    CLIP_PLANE3 CLIP_DISTANCE3,
    CLIP_PLANE4 CLIP_DISTANCE4,
    CLIP_PLANE5 CLIP_DISTANCE5,
    BLEND_COLOR_EXT BLEND_COLOR,
    MAX_EXT MAX,
    MAX_CLIP_PLANES MAX_CLIP_DISTANCES,
    MIN_EXT MIN,
    POLYGON_OFFSET_FACTOR_EXT POLYGON_OFFSET_FACTOR,
    TEXTURE_1D_BINDING TEXTURE_BINDING_1D,
    TEXTURE_2D_BINDING TEXTURE_BINDING_2D
];

pub unsafe fn AreTexturesResident(
    n: GLsizei,
    textures: *const GLuint,
    residences: *mut GLboolean,
) -> GLboolean {
    sys::glAreTexturesResident(n, textures, residences)
}

pub unsafe fn CallLists(n: GLsizei, type_: GLenum, lists: *const cty::c_void) {
    sys::glCallLists(n, type_, lists as *const GLuint)
}

pub unsafe fn GenLists(range: GLsizei) -> GLuint {
    sys::glGenLists(range)
}

pub unsafe fn GetError() -> GLenum {
    sys::glGetError()
}

pub unsafe fn GetString(name: GLenum) -> *const GLubyte {
    sys::glGetString(name)
}

#[cfg(feature = "text")]
pub unsafe fn GetTexturePixmap(
    text: GLint,
    level: GLint,
    xsize: *mut GLint,
    ysize: *mut GLint,
) -> *mut GLvoid {
    sys::glGetTexturePixmap(text, level, xsize, ysize)
}

pub unsafe fn IsBuffer(buffer: GLuint) -> GLboolean {
    sys::glIsBuffer(buffer)
}

pub unsafe fn IsList(list: GLuint) -> GLboolean {
    (sys::glIsList(list) != 0) as GLboolean
}

pub unsafe fn IsTexture(buffer: GLuint) -> GLboolean {
    sys::glIsTexture(buffer)
}

pub unsafe fn MapBuffer(target: GLenum, access: GLenum) -> *mut GLvoid {
    sys::glMapBuffer(target, access)
}

pub unsafe fn RenderMode(mode: GLenum) -> GLint {
    sys::glRenderMode(mode)
}

use types::*;

glfn![
    ArrayElement (i GLint),
    Begin (mode GLenum),
    BindBuffer (target GLenum, buffer GLuint),
    BindBufferAsArray (target GLenum, buffer GLuint, type_ GLenum, size GLint, stride GLsizei),
    BindTexture (target GLenum, texture GLuint),
    BlendEquation (mode GLenum),
    BlendFunc (sfactor GLenum, dfactor GLenum),
    BufferData (target GLenum, size isize, data *const cty::c_void, usage GLenum),
    CallList (list GLuint),
    Clear (mask GLint),
    ClearColor (red GLfloat, green GLfloat, blue GLfloat, alpha GLfloat),
    ClearDepth (depth GLdouble),
    Close (),
    Color3f(red GLfloat, green GLfloat, blue GLfloat),
    Color3d(red GLdouble, green GLdouble, blue GLdouble),
    Color3fv(v *mut GLfloat),
    Color3dv(v *mut GLdouble),
    Color4f(red GLfloat, green GLfloat, blue GLfloat, alpha GLfloat),
    Color4d(red GLdouble, green GLdouble, blue GLdouble, alpha GLdouble),
    Color4fv(v *mut GLfloat),
    Color4dv(v *mut GLdouble),
    ColorMaterial (face GLenum, mode GLenum),
    ColorPointer (size GLint, type_ GLenum, stride GLsizei, pointer *const cty::c_void),
    CopyTexImage2D (target GLenum, level GLint, internalformat GLenum, x GLint, y GLint, width GLsizei, height GLsizei, border GLint),
    CullFace (mode GLenum),
    Debug (mode GLint),
    DeleteBuffers (n GLsizei, buffers *const GLuint),
    DeleteList (list GLuint),
    DeleteLists (list GLuint, range GLsizei),
    DeleteTextures (n GLsizei, textures *const GLuint),
    DepthMask (flag GLboolean),
    Disable (cap GLenum),
    DisableClientState (cap GLenum),
    DrawArrays (mode GLenum, first GLint, count GLsizei),
    DrawBuffer (buf GLenum),
    DrawPixels (width GLsizei, height GLsizei, format GLenum, type_ GLenum, data *mut cty::c_void),
    EdgeFlag (flag GLboolean),
    Enable (cap GLenum),
    EnableClientState (cap GLenum),
    End (),
    EndList (),
    FeedbackBuffer (size GLsizei, type_ GLenum, buffer *mut GLfloat),
    Finish (),
    Flush (),
    FrontFace (mode GLenum),
    Frustum (left GLdouble, right GLdouble, bottom GLdouble, top GLdouble, nearVal GLdouble, farVal GLdouble),
    GenBuffers (n GLsizei, buffers *mut GLuint),
    GenTextures (n GLsizei, textures *mut GLuint),
    GetFloatv (pname GLenum, data *mut GLfloat),
    GetIntegerv (pname GLenum, data *mut GLint),
    Hint (target GLenum, mode GLenum),
    Init (buffer *mut cty::c_void),
    InitNames (),
    ListBase (base GLuint),
    Lightf (light GLenum, pname GLenum, param GLfloat),
    Lightfv (light GLenum, pname GLenum, params *mut GLfloat),
    LightModeli (pname GLenum, param GLint),
    LightModelfv (pname GLenum, param *mut GLfloat),
    LoadIdentity (),
    LoadMatrixf (m *const GLfloat),
    LoadName (name GLuint),
    Materialf (face GLenum, pname GLenum, param GLfloat),
    Materialfv (face GLenum, pname GLenum, param *mut GLfloat),
    MatrixMode (mode GLenum),
    MultMatrixf (m *const GLfloat),
    NewList (list GLuint, mode GLenum),
    Normal3f(nx GLfloat, ny GLfloat, nz GLfloat),
    Normal3d(nx GLdouble, ny GLdouble, nz GLdouble),
    Normal3fv(v *mut GLfloat),
    Normal3dv (v *mut GLdouble),
    NormalPointer (type_ GLenum, stride GLsizei, pointer *const cty::c_void),
    PassThrough (token GLfloat),
    PixelZoom (xfactor GLfloat, yfactor GLfloat),
    PlotPixel (x GLint, y GLint, pixel GLuint),
    PointSize (size GLfloat),
    PolygonMode (face GLenum, mode GLenum),
    PolygonOffset (factor GLfloat, units GLfloat),
    PolygonStipple (pattern *mut cty::c_void),
    PopMatrix (),
    PopName (),
    PostProcess (postprocess Option<postProcessFunc>),
    PushMatrix (),
    PushName (name GLuint),
    RasterPos2f (x GLfloat, y GLfloat),
    RasterPos2fv (v *mut GLfloat),
    RasterPos3f (x GLfloat, y GLfloat, z GLfloat),
    RasterPos3fv (v *mut GLfloat),
    RasterPos4f (x GLfloat, y GLfloat, z GLfloat, w GLfloat),
    RasterPos4fv (v *mut GLfloat),
    ReadBuffer (src GLenum),
    ReadPixels (x GLint, y GLint, width GLsizei, height GLsizei, format GLenum, type_ GLenum, pixels *mut cty::c_void),
    Rectf (x1 GLfloat, y1 GLfloat, x2 GLfloat, y2 GLfloat),
    Rotatef (angle GLfloat, x GLfloat, y GLfloat, z GLfloat),
    Scalef (x GLfloat, y GLfloat, z GLfloat),
    SelectBuffer (size GLsizei, buffer *mut GLuint),
    SetEnableSpecular (s GLint),
    ShadeModel (mode GLenum),
    TexCoord1f(s GLfloat),
    TexCoord1d(s GLdouble),
    TexCoord1fv(v *mut GLfloat),
    TexCoord1dv(v *mut GLdouble),
    TexCoord2f(s GLfloat, t GLfloat),
    TexCoord2d(s GLdouble, t GLdouble),
    TexCoord2fv(v *mut GLfloat),
    TexCoord2dv(v *mut GLdouble),
    TexCoord3f(s GLfloat, t GLfloat, r GLfloat),
    TexCoord3d(s GLdouble, t GLdouble, r GLdouble),
    TexCoord3fv(v *mut GLfloat),
    TexCoord3dv(v *mut GLdouble),
    TexCoord4f(s GLfloat, t GLfloat, r GLfloat, q GLfloat),
    TexCoord4d(s GLdouble, t GLdouble, r GLdouble, q GLdouble),
    TexCoord4fv(v *mut GLfloat),
    TexCoord4dv(v *mut GLdouble),
    TexCoordPointer (size GLint, type_ GLenum, stride GLsizei, pointer *const cty::c_void),
    TexEnvi (target GLenum, pname GLenum, param GLint),
    TexImage1D (target GLenum, level GLint, internalformat GLint, width GLsizei, border GLint, format GLenum, type_ GLenum, pixels *mut cty::c_void),
    TexImage2D (target GLenum, level GLint, internalformat GLint, width GLsizei, height GLsizei, border GLint, format GLenum, type_ GLenum, pixels *mut cty::c_void),
    TexParameteri (target GLenum, pname GLenum, param GLint),
    Translatef (x GLfloat, y GLfloat, z GLfloat),
    Vertex2f(x GLfloat, y GLfloat),
    Vertex2d(x GLdouble, y GLdouble),
    Vertex2fv(v *mut GLfloat),
    Vertex2dv(v *mut GLdouble),
    Vertex3f(x GLfloat, y GLfloat, z GLfloat),
    Vertex3d(x GLdouble, y GLdouble, z GLdouble),
    Vertex3fv(v *mut GLfloat),
    Vertex3dv(v *mut GLdouble),
    Vertex4f(x GLfloat, y GLfloat, z GLfloat, w GLfloat),
    Vertex4d(x GLdouble, y GLdouble, z GLdouble, w GLdouble),
    Vertex4fv(v *mut GLfloat),
    Vertex4dv(v *mut GLdouble),
    VertexPointer (size GLint, type_ GLenum, stride GLsizei, pointer *const cty::c_void),
    Viewport (x GLint, y GLint, width GLsizei, height GLsizei)
];

#[cfg(feature = "text")]
gltextconst![
    TEXT_SIZE8x8,
    TEXT_SIZE16x16,
    TEXT_SIZE24x24,
    TEXT_SIZE32x32,
    TEXT_SIZE40x40,
    TEXT_SIZE48x48,
    TEXT_SIZE56x56,
    TEXT_SIZE64x64,
    TEXT_SIZE72x72,
    TEXT_SIZE80x80,
    TEXT_SIZE88x88,
    TEXT_SIZE96x96,
    TEXT_SIZE104x104,
    TEXT_SIZE112x112,
    TEXT_SIZE120x120,
    TEXT_SIZE128x128,
    MAX_TEXT_SIZE
];

#[cfg(feature = "text")]
glfn![
    DrawText (text *const GLubyte, x GLint, y GLint, pixel GLuint),
    TextSize (mode GLTEXTSIZE)
];

pub type postProcessFunc =
    unsafe extern "C" fn(x: GLint, y: GLint, pixel: GLuint, z: GLushort) -> GLuint;

pub mod types {
    pub use crate::sys::{
        GLboolean, GLbyte, GLdouble, GLenum, GLfloat, GLint, GLshort, GLsizei, GLubyte, GLuint,
        GLushort, GLvoid,
    };

    #[cfg(feature = "text")]
    pub use crate::sys::GLTEXTSIZE;
}

pub mod zbuffer {
    pub use crate::sys::{ZBuffer, ZBufferPoint};

    macro_rules! zbconst {
	($($i:ident),*) => {
	    paste::paste! {
		$(
		    pub const $i: crate::types::GLenum = crate::sys::[<ZB_ $i>] as crate::types::GLenum;
		)*
	    }
	};
    }

    macro_rules! zbfn {
	($($i:ident),*) => {
	    paste::paste! {
		$(
		    pub use crate::sys::[<ZB_ $i>] as $i;
		)*
	    }
	};
    }

    zbconst![
        MODE_5R6G5B,
        MODE_INDEX,
        MODE_RGB24,
        MODE_RGBA,
        NB_COLORS,
        POINT_S_FRAC_BITS,
        POINT_S_MAX,
        POINT_S_MIN,
        POINT_S_VALUE,
        POINT_T_FRAC_BITS,
        POINT_T_MAX,
        POINT_T_MIN,
        POINT_T_VALUE,
        POINT_Z_FRAC_BITS,
        S_MASK,
        T_MASK,
        Z_BITS
    ];

    zbfn![
        clear,
        close,
        copyFrameBuffer,
        fillTriangleFlat,
        fillTriangleFlatNOBLEND,
        fillTriangleMappingPerspective,
        fillTriangleMappingPerspectiveNOBLEND,
        fillTriangleSmooth,
        fillTriangleSmoothNOBLEND,
        line,
        line_z,
        open,
        plot,
        resize,
        setTexture
    ];

    pub type fillTriangleFunc = crate::sys::ZB_fillTriangleFunc;
}

#[allow(dead_code)]
mod sys {
    include!(concat!(env!("OUT_DIR"), "/bindings.rs"));
}
