use winit::event::{VirtualKeyCode, ScanCode};

#[derive(Debug, Copy, Clone, Hash, Eq, PartialEq)]
pub enum KeyCode {
    Esc,
    Num1,
    Num2,
    Num3,
    Num4,
    Num5,
    Num6,
    Num7,
    Num8,
    Num9,
    Num0,
    A,
    B,
    C,
    D,
    E,
    F,
    G,
    H,
    I,
    J,
    K,
    L,
    M,
    N,
    O,
    P,
    Q,
    R,
    S,
    T,
    U,
    V,
    W,
    X,
    Y,
    Z,
    F1,
    F2,
    F3,
    F4,
    F5,
    F6,
    F7,
    F8,
    F9,
    F10,
    F11,
    F12,
    F13,
    F14,
    F15,
    F16,
    F17,
    F18,
    F19,
    F20,
    F21,
    F22,
    F23,
    F24,
    PrintScreen,
    ScrollLock,
    /// Pause or Break
    Pause,
    /// ` or ~
    Grave,
    /// - or _
    Minus,
    /// = or +
    Equals,
    /// [ or {
    LBracket,
    /// ] or }
    RBracket,
    /// \ or |
    Backslash,
    /// ; or :
    Semicolon,
    /// ' or "
    Apostrophe,
    /// , or <
    Comma,
    /// . or >
    Period,
    /// / or ?
    Slash,
    Tab,
    CapsLock,
    LShift,
    RShift,
    LCtrl,
    RCtrl,
    /// or left option on macOS
    LAlt,
    /// or right option on macOs
    RAlt,
    /// or left command on macOS
    LWin,
    /// or right command on macOS
    RWin,
    /// or delete on macOS
    Backspace,
    /// or return on macOS
    Enter,
    Space,
    Menu,
    Insert,
    Delete,
    Home,
    End,
    PageUp,
    PageDown,
    Up,
    Down,
    Left,
    Right,
    NumLock,
    Numpad0,
    Numpad1,
    Numpad2,
    Numpad3,
    Numpad4,
    Numpad5,
    Numpad6,
    Numpad7,
    Numpad8,
    Numpad9,
    NumpadAdd,
    NumpadSubtract,
    NumpadMultiply,
    NumpadDivide,
    NumpadDecimal,
    NumpadEnter,
    Other(u32),
}

impl From<(Option<VirtualKeyCode>, ScanCode)> for KeyCode {
    fn from((key_code, scan_code): (Option<VirtualKeyCode>, ScanCode)) -> Self {
        match key_code {
            Some(key_code) => {
                match key_code {
                    VirtualKeyCode::Key1 => Self::Num1,
                    VirtualKeyCode::Key2 => Self::Num2,
                    VirtualKeyCode::Key3 => Self::Num3,
                    VirtualKeyCode::Key4 => Self::Num4,
                    VirtualKeyCode::Key5 => Self::Num5,
                    VirtualKeyCode::Key6 => Self::Num6,
                    VirtualKeyCode::Key7 => Self::Num7,
                    VirtualKeyCode::Key8 => Self::Num8,
                    VirtualKeyCode::Key9 => Self::Num9,
                    VirtualKeyCode::Key0 => Self::Num0,
                    VirtualKeyCode::A => Self::A,
                    VirtualKeyCode::B => Self::B,
                    VirtualKeyCode::C => Self::C,
                    VirtualKeyCode::D => Self::D,
                    VirtualKeyCode::E => Self::E,
                    VirtualKeyCode::F => Self::F,
                    VirtualKeyCode::G => Self::G,
                    VirtualKeyCode::H => Self::H,
                    VirtualKeyCode::I => Self::I,
                    VirtualKeyCode::J => Self::J,
                    VirtualKeyCode::K => Self::K,
                    VirtualKeyCode::L => Self::L,
                    VirtualKeyCode::M => Self::M,
                    VirtualKeyCode::N => Self::N,
                    VirtualKeyCode::O => Self::O,
                    VirtualKeyCode::P => Self::P,
                    VirtualKeyCode::Q => Self::Q,
                    VirtualKeyCode::R => Self::R,
                    VirtualKeyCode::S => Self::S,
                    VirtualKeyCode::T => Self::T,
                    VirtualKeyCode::U => Self::U,
                    VirtualKeyCode::V => Self::V,
                    VirtualKeyCode::W => Self::W,
                    VirtualKeyCode::X => Self::X,
                    VirtualKeyCode::Y => Self::Y,
                    VirtualKeyCode::Z => Self::Z,
                    VirtualKeyCode::Escape => Self::Esc,
                    VirtualKeyCode::F1 => Self::F1,
                    VirtualKeyCode::F2 => Self::F2,
                    VirtualKeyCode::F3 => Self::F3,
                    VirtualKeyCode::F4 => Self::F4,
                    VirtualKeyCode::F5 => Self::F5,
                    VirtualKeyCode::F6 => Self::F6,
                    VirtualKeyCode::F7 => Self::F7,
                    VirtualKeyCode::F8 => Self::F8,
                    VirtualKeyCode::F9 => Self::F9,
                    VirtualKeyCode::F10 => Self::F10,
                    VirtualKeyCode::F11 => Self::F11,
                    VirtualKeyCode::F12 => Self::F12,
                    VirtualKeyCode::F13 => Self::F13,
                    VirtualKeyCode::F14 => Self::F14,
                    VirtualKeyCode::F15 => Self::F15,
                    VirtualKeyCode::F16 => Self::F16,
                    VirtualKeyCode::F17 => Self::F17,
                    VirtualKeyCode::F18 => Self::F18,
                    VirtualKeyCode::F19 => Self::F19,
                    VirtualKeyCode::F20 => Self::F20,
                    VirtualKeyCode::F21 => Self::F21,
                    VirtualKeyCode::F22 => Self::F22,
                    VirtualKeyCode::F23 => Self::F23,
                    VirtualKeyCode::F24 => Self::F24,
                    VirtualKeyCode::Snapshot => Self::PrintScreen,
                    VirtualKeyCode::Scroll => Self::ScrollLock,
                    VirtualKeyCode::Pause => Self::Pause,
                    VirtualKeyCode::Insert => Self::Insert,
                    VirtualKeyCode::Home => Self::Home,
                    VirtualKeyCode::Delete => Self::Delete,
                    VirtualKeyCode::End => Self::End,
                    VirtualKeyCode::PageDown => Self::PageDown,
                    VirtualKeyCode::PageUp => Self::PageUp,
                    VirtualKeyCode::Left => Self::Left,
                    VirtualKeyCode::Up => Self::Up,
                    VirtualKeyCode::Right => Self::Right,
                    VirtualKeyCode::Down => Self::Down,
                    VirtualKeyCode::Back => Self::Backspace,
                    VirtualKeyCode::Return => Self::Enter,
                    VirtualKeyCode::Space => Self::Space,
                    VirtualKeyCode::Compose => Self::Other(scan_code),
                    VirtualKeyCode::Caret => Self::Other(scan_code),
                    VirtualKeyCode::Numlock => Self::NumLock,
                    VirtualKeyCode::Numpad0 => Self::Numpad0,
                    VirtualKeyCode::Numpad1 => Self::Numpad1,
                    VirtualKeyCode::Numpad2 => Self::Numpad2,
                    VirtualKeyCode::Numpad3 => Self::Numpad3,
                    VirtualKeyCode::Numpad4 => Self::Numpad4,
                    VirtualKeyCode::Numpad5 => Self::Numpad5,
                    VirtualKeyCode::Numpad6 => Self::Numpad6,
                    VirtualKeyCode::Numpad7 => Self::Numpad7,
                    VirtualKeyCode::Numpad8 => Self::Numpad8,
                    VirtualKeyCode::Numpad9 => Self::Numpad9,
                    VirtualKeyCode::NumpadAdd => Self::NumpadAdd,
                    VirtualKeyCode::NumpadDivide => Self::NumpadDivide,
                    VirtualKeyCode::NumpadDecimal => Self::NumpadDecimal,
                    VirtualKeyCode::NumpadComma => Self::Other(scan_code),
                    VirtualKeyCode::NumpadEnter => Self::NumpadEnter,
                    VirtualKeyCode::NumpadEquals => Self::Other(scan_code),
                    VirtualKeyCode::NumpadMultiply => Self::NumpadMultiply,
                    VirtualKeyCode::NumpadSubtract => Self::NumpadSubtract,
                    VirtualKeyCode::AbntC1 => Self::Other(scan_code),
                    VirtualKeyCode::AbntC2 => Self::Other(scan_code),
                    VirtualKeyCode::Apostrophe => Self::Apostrophe,
                    VirtualKeyCode::Apps => Self::Menu,
                    VirtualKeyCode::Asterisk => Self::Other(scan_code),
                    VirtualKeyCode::At => Self::Other(scan_code),
                    VirtualKeyCode::Ax => Self::Other(scan_code),
                    VirtualKeyCode::Backslash => Self::Backslash,
                    VirtualKeyCode::Calculator => Self::Other(scan_code),
                    VirtualKeyCode::Capital => Self::CapsLock,
                    VirtualKeyCode::Colon => Self::Other(scan_code),
                    VirtualKeyCode::Comma => Self::Comma,
                    VirtualKeyCode::Convert => Self::Other(scan_code),
                    VirtualKeyCode::Equals => Self::Equals,
                    VirtualKeyCode::Grave => Self::Grave,
                    VirtualKeyCode::Kana => Self::Other(scan_code),
                    VirtualKeyCode::Kanji => Self::Other(scan_code),
                    VirtualKeyCode::LAlt => Self::LAlt,
                    VirtualKeyCode::LBracket => Self::LBracket,
                    VirtualKeyCode::LControl => Self::LCtrl,
                    VirtualKeyCode::LShift => Self::LShift,
                    VirtualKeyCode::LWin => Self::LWin,
                    VirtualKeyCode::Mail => Self::Other(scan_code),
                    VirtualKeyCode::MediaSelect => Self::Other(scan_code),
                    VirtualKeyCode::MediaStop => Self::Other(scan_code),
                    VirtualKeyCode::Minus => Self::Minus,
                    VirtualKeyCode::Mute => Self::Other(scan_code),
                    VirtualKeyCode::MyComputer => Self::Other(scan_code),
                    VirtualKeyCode::NavigateForward => Self::Other(scan_code),
                    VirtualKeyCode::NavigateBackward => Self::Other(scan_code),
                    VirtualKeyCode::NextTrack => Self::Other(scan_code),
                    VirtualKeyCode::NoConvert => Self::Other(scan_code),
                    VirtualKeyCode::OEM102 => Self::Other(scan_code),
                    VirtualKeyCode::Period => Self::Period,
                    VirtualKeyCode::PlayPause => Self::Other(scan_code),
                    VirtualKeyCode::Plus => Self::Other(scan_code),
                    VirtualKeyCode::Power => Self::Other(scan_code),
                    VirtualKeyCode::PrevTrack => Self::Other(scan_code),
                    VirtualKeyCode::RAlt => Self::RAlt,
                    VirtualKeyCode::RBracket => Self::RBracket,
                    VirtualKeyCode::RControl => Self::RCtrl,
                    VirtualKeyCode::RShift => Self::RShift,
                    VirtualKeyCode::RWin => Self::RWin,
                    VirtualKeyCode::Semicolon => Self::Semicolon,
                    VirtualKeyCode::Slash => Self::Slash,
                    VirtualKeyCode::Sleep => Self::Other(scan_code),
                    VirtualKeyCode::Stop => Self::Other(scan_code),
                    VirtualKeyCode::Sysrq => Self::Other(scan_code),
                    VirtualKeyCode::Tab => Self::Tab,
                    VirtualKeyCode::Underline => Self::Other(scan_code),
                    VirtualKeyCode::Unlabeled => Self::Other(scan_code),
                    VirtualKeyCode::VolumeDown => Self::Other(scan_code),
                    VirtualKeyCode::VolumeUp => Self::Other(scan_code),
                    VirtualKeyCode::Wake => Self::Other(scan_code),
                    VirtualKeyCode::WebBack => Self::Other(scan_code),
                    VirtualKeyCode::WebFavorites => Self::Other(scan_code),
                    VirtualKeyCode::WebForward => Self::Other(scan_code),
                    VirtualKeyCode::WebHome => Self::Other(scan_code),
                    VirtualKeyCode::WebRefresh => Self::Other(scan_code),
                    VirtualKeyCode::WebSearch => Self::Other(scan_code),
                    VirtualKeyCode::WebStop => Self::Other(scan_code),
                    VirtualKeyCode::Yen => Self::Other(scan_code),
                    VirtualKeyCode::Copy => Self::Other(scan_code),
                    VirtualKeyCode::Paste => Self::Other(scan_code),
                    VirtualKeyCode::Cut => Self::Other(scan_code),
                }
            }
            None => Self::Other(scan_code),
        }
    }
}
