enumeration!(Key, "A keyboard key used by the [`KeyboardContext`](crate::KeyboardContext) trait.", [
    // Modifier keys
    (CapsLock, "Caps Lock"),
    (Shift, "Shift"),
    (Control, "Control"),
    (Alt, "Alt"),
    (Meta, "Meta"), // Command on macOS. Windows key on Windows.
    (ControlOrMeta, "Control or Meta"), // Command on macOS. Control on Windows.
    (RightShift, "Right Shift"),
    (RightControl, "Right Control"),
    (RightAlt, "Right Alt"),
    (RightMeta, "Right Meta"), // Command on macOS. Windows key on Windows.
    (RightControlOrMeta, "Right Control or Meta"), // Command on macOS. Control on Windows.
    (Fn, "Fn"),

    // Controls and symbols
    (ReturnOrEnter, "Return or Enter"),
    (Escape, "Escape"),
    (DeleteOrBackspace, "Delete or Backspace"),
    (ForwardDelete, "Forward Delete"),
    (Tab, "Tab"),
    (Space, "Space"),
    (Minus, "Minus"),
    (Equal, "Equal"),
    (LeftBracket, "Left Bracket"),
    (RightBracket, "Right Bracket"),
    (Backslash, "Backslash"),
    (Semicolon, "Semicolon"),
    (Quote, "Quote"),
    (Grave, "Grave"),
    (Comma, "Comma"),
    (Period, "Period"),
    (Slash, "Slash"),

    // Arrow keys
    (UpArrow, "Up Arrow"),
    (RightArrow, "Right Arrow"),
    (DownArrow, "Down Arrow"),
    (LeftArrow, "Left Arrow"),
    (PageUp, "Page Up"),
    (PageDown, "Page Down"),
    (Home, "Home"),
    (End, "End"),

    // Letter keys
    (A, "A"),
    (B, "B"),
    (C, "C"),
    (D, "D"),
    (E, "E"),
    (F, "F"),
    (G, "G"),
    (H, "H"),
    (I, "I"),
    (J, "J"),
    (K, "K"),
    (L, "L"),
    (M, "M"),
    (N, "N"),
    (O, "O"),
    (P, "P"),
    (Q, "Q"),
    (R, "R"),
    (S, "S"),
    (T, "T"),
    (U, "U"),
    (V, "V"),
    (W, "W"),
    (X, "X"),
    (Y, "Y"),
    (Z, "Z"),

    // Number keys
    (N0, "0"),
    (N1, "1"),
    (N2, "2"),
    (N3, "3"),
    (N4, "4"),
    (N5, "5"),
    (N6, "6"),
    (N7, "7"),
    (N8, "8"),
    (N9, "9"),

    // Number pad numbers
    (Numpad0, "Numpad 0"),
    (Numpad1, "Numpad 1"),
    (Numpad2, "Numpad 2"),
    (Numpad3, "Numpad 3"),
    (Numpad4, "Numpad 4"),
    (Numpad5, "Numpad 5"),
    (Numpad6, "Numpad 6"),
    (Numpad7, "Numpad 7"),
    (Numpad8, "Numpad 8"),
    (Numpad9, "Numpad 9"),

    // Number pad keys
    (NumpadClear, "Numpad Clear"),
    (NumpadEquals, "Numpad Equals"),
    (NumpadDivide, "Numpad Divide"),
    (NumpadMultiply, "Numpad Multiply"),
    (NumpadMinus, "Numpad Minus"),
    (NumpadPlus, "Numpad Plus"),
    (NumpadEnter, "Numpad Enter"),
    (NumpadDecimal, "Numpad Decimal"),

    // Function keys
    (F1, "F1"),
    (F2, "F2"),
    (F3, "F3"),
    (F4, "F4"),
    (F5, "F5"),
    (F6, "F6"),
    (F7, "F7"),
    (F8, "F8"),
    (F9, "F9"),
    (F10, "F10"),
    (F11, "F11"),
    (F12, "F12"),

    // Media controls
    (FastForward, "Fast-Forward"),
    (Rewind, "Rewind"),
    (PlayPause, "Play/Pause"),
    (VolumeUp, "Volume Up"),
    (VolumeDown, "Volume Down"),
    (Mute, "Mute"),
]);
