use std::convert::{TryFrom, Into};

#[derive(Debug)]
pub enum TimeInterval{
    Min1,
    Min2,
    Min3,
    Min5,
    Min10,
    Min15,
    Min30,
    Hour1,
    Hour2,
    Hour4,
    Day,
    Week,
    Month,
}

impl Into<u8> for TimeInterval{
    fn into(self) -> u8 {
        match self{
            TimeInterval::Min1 => {0}
            TimeInterval::Min2 => {1}
            TimeInterval::Min3 => {2}
            TimeInterval::Min5 => {3}
            TimeInterval::Min10 => {4}
            TimeInterval::Min15 => {5}
            TimeInterval::Min30 => {6}
            TimeInterval::Hour1 => {7}
            TimeInterval::Hour2 => {8}
            TimeInterval::Hour4 => {9}
            TimeInterval::Day => {10}
            TimeInterval::Week => {11}
            TimeInterval::Month => {12}
        }
    }
}

impl TryFrom<u8> for TimeInterval{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::Min1) }
            1 => { Ok(Self::Min2) }
            2 => { Ok(Self::Min3) }
            3 => { Ok(Self::Min5) }
            4 => { Ok(Self::Min10) }
            5 => { Ok(Self::Min15) }
            6 => { Ok(Self::Min30) }
            7 => { Ok(Self::Hour1) }
            8 => { Ok(Self::Hour2) }
            9 => { Ok(Self::Hour4) }
            10 => { Ok(Self::Day) }
            11 => { Ok(Self::Week) }
            12 => { Ok(Self::Month) }
            _ => { Err(()) }
        }
    }
}

pub enum TradeStatus{
    BreakInTrading,
    NormalTrading,
    NotAvailable,
    ClosingAuction,
    ClosingPeriod,
    DiscreteAuction,
    OpeningPeriod,
    TradingAtClosingAuctionPrice,
    DisableForTrading,
}

impl Into<u8> for TradeStatus{
    fn into(self) -> u8 {
        match self{
            TradeStatus::BreakInTrading => {0}
            TradeStatus::NormalTrading => {1}
            TradeStatus::NotAvailable => {2}
            TradeStatus::ClosingAuction => {3}
            TradeStatus::ClosingPeriod => {4}
            TradeStatus::DiscreteAuction => {5}
            TradeStatus::OpeningPeriod => {6}
            TradeStatus::TradingAtClosingAuctionPrice => {7}
            TradeStatus::DisableForTrading => {8}
        }
    }
}

impl TryFrom<u8> for TradeStatus{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::BreakInTrading) }
            1 => { Ok(Self::NormalTrading) }
            2 => { Ok(Self::NotAvailable) }
            3 => { Ok(Self::ClosingAuction) }
            4 => { Ok(Self::ClosingPeriod) }
            5 => { Ok(Self::DiscreteAuction) }
            6 => { Ok(Self::OpeningPeriod) }
            7 => { Ok(Self::TradingAtClosingAuctionPrice) }
            8 => { Ok(Self::DisableForTrading) }
            _ => { Err(()) }
        }
    }
}

pub enum TransactionStatus{
    Done,
    Decline,
    Progress,
}

impl Into<u8> for TransactionStatus{
    fn into(self) -> u8 {
        match self{
            TransactionStatus::Done => {0}
            TransactionStatus::Decline => {1}
            TransactionStatus::Progress => {2}
        }
    }
}

impl TryFrom<u8> for TransactionStatus{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::Done) }
            1 => { Ok(Self::Decline) }
            2 => { Ok(Self::Progress) }
            _ => { Err(()) }
        }
    }
}
