use serde::Deserialize;

#[derive(Deserialize, Debug)]
pub struct Path{
    pub ws_base: Option<String>,
    pub rest_base: Option<String>,
    pub keys_service: Option<String>,
    pub messages_bus: Option<String>,
}

impl Path{
    pub fn get_streaming_base(&self) -> Option<String>{
        self.ws_base.clone()
    }
    pub fn get_rest_base(&self) -> Option<String>{
        self.rest_base.clone()
    }
    pub fn get_keys_service(&self) -> Option<String>{
        match &self.keys_service{
            None => {
                match self.rest_base.clone(){
                    None => { None }
                    Some(rest_base) => {
                        Some(format!("{}/keys", rest_base).to_string())
                    }
                }
            }
            Some(s) => {
                Some(s.clone())
            }
        }
    }
    pub fn get_messages_bus(&self) -> Option<String>{
        match &self.messages_bus{
            None => {
                match self.ws_base.clone(){
                    None => { None }
                    Some(ws_base) => {
                        Some(format!("{}/rotor", ws_base).to_string())
                    }
                }
            }
            Some(s) => {
                Some(s.clone())
            }
        }
    }
}
