use std::string::ToString;
use std::str::FromStr;
use std::convert::{TryFrom, Into};

#[derive(Debug)]
pub enum TimeInterval{
    Min1,
    Min2,
    Min3,
    Min5,
    Min10,
    Min15,
    Min30,
    Hour1,
    Hour2,
    Hour4,
    Day,
    Week,
    Month,
}

impl ToString for TimeInterval{
    fn to_string(&self) -> String {
        match self{
            TimeInterval::Min1 => {"m"}
            TimeInterval::Min2 => {"m2"}
            TimeInterval::Min3 => {"m3"}
            TimeInterval::Min5 => {"m5"}
            TimeInterval::Min10 => {"m10"}
            TimeInterval::Min15 => {"m15"}
            TimeInterval::Min30 => {"m30"}
            TimeInterval::Hour1 => {"h"}
            TimeInterval::Hour2 => {"h2"}
            TimeInterval::Hour4 => {"h3"}
            TimeInterval::Day => {"d"}
            TimeInterval::Week => {"w"}
            TimeInterval::Month => {"mo"}
        }.to_string()
    }
}

impl FromStr for TimeInterval{
    type Err = ();

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s{
            "m" => { Ok(Self::Min1) }
            "m2" => { Ok(Self::Min2) }
            "m3" => { Ok(Self::Min3) }
            "m5" => { Ok(Self::Min5) }
            "m10" => { Ok(Self::Min10) }
            "m15" => { Ok(Self::Min15) }
            "m30" => { Ok(Self::Min30) }
            "h" => { Ok(Self::Hour1) }
            "h2" => { Ok(Self::Hour2) }
            "h4" => { Ok(Self::Hour4) }
            "d" => { Ok(Self::Day) }
            "w" => { Ok(Self::Week) }
            "mo" => { Ok(Self::Month) }
            &_ => { Err(()) }
        }
    }
}

impl Into<u8> for TimeInterval{
    fn into(self) -> u8 {
        match self{
            TimeInterval::Min1 => {0}
            TimeInterval::Min2 => {1}
            TimeInterval::Min3 => {2}
            TimeInterval::Min5 => {3}
            TimeInterval::Min10 => {4}
            TimeInterval::Min15 => {5}
            TimeInterval::Min30 => {6}
            TimeInterval::Hour1 => {7}
            TimeInterval::Hour2 => {8}
            TimeInterval::Hour4 => {9}
            TimeInterval::Day => {10}
            TimeInterval::Week => {11}
            TimeInterval::Month => {12}
        }
    }
}

impl TryFrom<u8> for TimeInterval{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::Min1) }
            1 => { Ok(Self::Min2) }
            2 => { Ok(Self::Min3) }
            3 => { Ok(Self::Min5) }
            4 => { Ok(Self::Min10) }
            5 => { Ok(Self::Min15) }
            6 => { Ok(Self::Min30) }
            7 => { Ok(Self::Hour1) }
            8 => { Ok(Self::Hour2) }
            9 => { Ok(Self::Hour4) }
            10 => { Ok(Self::Day) }
            11 => { Ok(Self::Week) }
            12 => { Ok(Self::Month) }
            _ => { Err(()) }
        }
    }
}

pub enum TradeStatus{
    BreakInTrading,
    NormalTrading,
    NotAvailable,
    ClosingAuction,
    ClosingPeriod,
    DiscreteAuction,
    OpeningPeriod,
    TradingAtClosingAuctionPrice,
    DisableForTrading,
}

impl ToString for TradeStatus{
    fn to_string(&self) -> String {
        match self{
            TradeStatus::BreakInTrading => {"break_in_trading"}
            TradeStatus::NormalTrading => {"normal_trading"}
            TradeStatus::NotAvailable => {"not_available_for_trading"}
            TradeStatus::ClosingAuction => {"closing_auction"}
            TradeStatus::ClosingPeriod => {"closing_period"}
            TradeStatus::DiscreteAuction => {"discrete_auction"}
            TradeStatus::OpeningPeriod => {"opening_period"}
            TradeStatus::TradingAtClosingAuctionPrice => {"trading_at_closing_auction_price"}
            TradeStatus::DisableForTrading => {"disable_for_trading"}
        }.to_string()
    }
}

impl FromStr for TradeStatus{
    type Err = ();

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s{
            "break_in_trading" => { Ok(Self::BreakInTrading) }
            "normal_trading" => { Ok(Self::NormalTrading) }
            "not_available_for_trading" => { Ok(Self::NotAvailable) }
            "closing_auction" => { Ok(Self::ClosingAuction) }
            "closing_period" => { Ok(Self::ClosingPeriod) }
            "discrete_auction" => { Ok(Self::DiscreteAuction) }
            "opening_period" => { Ok(Self::OpeningPeriod) }
            "trading_at_closing_auction_price" => { Ok(Self::TradingAtClosingAuctionPrice) }
            "disable_for_trading" => { Ok(Self::DisableForTrading) }
            &_ => { Err(()) }
        }
    }
}

impl Into<u8> for TradeStatus{
    fn into(self) -> u8 {
        match self{
            TradeStatus::BreakInTrading => {0}
            TradeStatus::NormalTrading => {1}
            TradeStatus::NotAvailable => {2}
            TradeStatus::ClosingAuction => {3}
            TradeStatus::ClosingPeriod => {4}
            TradeStatus::DiscreteAuction => {5}
            TradeStatus::OpeningPeriod => {6}
            TradeStatus::TradingAtClosingAuctionPrice => {7}
            TradeStatus::DisableForTrading => {8}
        }
    }
}

impl TryFrom<u8> for TradeStatus{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::BreakInTrading) }
            1 => { Ok(Self::NormalTrading) }
            2 => { Ok(Self::NotAvailable) }
            3 => { Ok(Self::ClosingAuction) }
            4 => { Ok(Self::ClosingPeriod) }
            5 => { Ok(Self::DiscreteAuction) }
            6 => { Ok(Self::OpeningPeriod) }
            7 => { Ok(Self::TradingAtClosingAuctionPrice) }
            8 => { Ok(Self::DisableForTrading) }
            _ => { Err(()) }
        }
    }
}

pub enum TransactionStatus{
    Done,
    Decline,
    Progress,
}

impl ToString for TransactionStatus{
    fn to_string(&self) -> String {
        match self{
            TransactionStatus::Done => {"Done"}
            TransactionStatus::Decline => {"Decline"}
            TransactionStatus::Progress => {"Progress"}
        }.to_string()
    }
}

impl FromStr for TransactionStatus{
    type Err = ();

    fn from_str(s: &str) -> Result<Self, Self::Err> {
        match s{
            "Done" => { Ok(Self::Done) }
            "Decline" => { Ok(Self::Decline) }
            "Progress" => { Ok(Self::Progress) }
            &_ => { Err(()) }
        }
    }
}

impl Into<u8> for TransactionStatus{
    fn into(self) -> u8 {
        match self{
            TransactionStatus::Done => {0}
            TransactionStatus::Decline => {1}
            TransactionStatus::Progress => {2}
        }
    }
}

impl TryFrom<u8> for TransactionStatus{
    type Error = ();

    fn try_from(value: u8) -> Result<Self, Self::Error> {
        match value{
            0 => { Ok(Self::Done) }
            1 => { Ok(Self::Decline) }
            2 => { Ok(Self::Progress) }
            _ => { Err(()) }
        }
    }
}
