use serde::Deserialize;

#[derive(Deserialize, Debug)]
pub struct Path{
    pub streaming_base: Option<String>,
    pub rest_base: Option<String>,
    pub keys_service: Option<String>,
}

impl Path{
    pub fn get_streaming_base(&self) -> Option<String>{
        self.streaming_base.clone()
    }
    pub fn get_rest_base(&self) -> Option<String>{
        self.rest_base.clone()
    }
    pub fn get_keys_service(&self) -> Option<String>{
        match &self.keys_service{
            None => {
                Some(format!("{:?}/keys", self.rest_base.clone()).to_string())
            }
            Some(s) => {
                Some(s.clone())
            }
        }
    }
}
