use crate::setup::Path;
use crate::structs;
use hyper_tls::HttpsConnector;
use hyper::body;
use hyper::{Client, Error, Body, Response};
use hyper::client::connect::HttpConnector;
use http::uri::Uri;
use serde_json;
use std::fs::read_to_string;

pub struct Api{
    keys_service_path: String,
    client: Client<HttpsConnector<HttpConnector>>,
}

impl Api{
    pub fn from_path(path: &Path) -> Option<Self> {
        let https = HttpsConnector::new();
        let client = Client::builder().build::<_, hyper::Body>(https);
        if let Some(keys_service_path) = path.get_keys_service(){
            return Some(Self{keys_service_path, client})
        }
        None
    }
    pub async fn get_key(&self, name: String) -> Result<structs::TinkoffApiKey, ()>{
        let uri = format!("{:?}/get?name={:?}", self.keys_service_path.clone(), name).parse();
        if let Ok(uri) = uri{
            if let Ok(resp) = self.client.get(uri).await{
                if resp.status() != 200{ return Err(())}
                if let Ok(b) = body::to_bytes(resp.into_body()).await{
                    if let Ok(s) = String::from_utf8(b.to_vec()){
                        if let Ok(key) = serde_json::from_str(&s){
                            return Ok(key)
                        }
                    }
                }
            }
        }
        Err(())
    }
}
