use textcode::*;


#[test]
fn test_iso6937() {
    let u = "\
iso6937\n\
€♪\n\
ÀÈÌÒÙàèìòù\n\
ÁĆÉÍĹŃÓŔŚÚÝŹáćéģíĺńóŕśúýź\n\
ÂĈÊĜĤÎĴÔŜÛŴŶâĉêĝĥîĵôŝûŵŷ\n\
ÃĨÑÕŨãĩñõũ\n\
ĀĒĪŌŪāēīōū\n\
ĂĞŬăğŭ\n\
ĊĖĠİŻċėġż\n\
ÄËÏÖÜŸäëïöüÿ\n\
ÅŮåů\n\
ÇĢĶĻŅŖŞŢçķļņŗşţ\n\
ŐŰőű\n\
ĄĘĮŲąęįų\n\
ČĎĚĽŇŘŠŤŽčďěľňřšťž\n\
";
    let c: &[u8] = &[
        0x69, 0x73, 0x6f, 0x36, 0x39, 0x33, 0x37, 0x0a, 0xa4, 0xd5, 0x0a,
        0xc1, 0x41, 0xc1, 0x45, 0xc1, 0x49, 0xc1, 0x4f, 0xc1, 0x55, 0xc1, 0x61,
        0xc1, 0x65, 0xc1, 0x69, 0xc1, 0x6f, 0xc1, 0x75, 0x0a, 0xc2, 0x41, 0xc2,
        0x43, 0xc2, 0x45, 0xc2, 0x49, 0xc2, 0x4c, 0xc2, 0x4e, 0xc2, 0x4f, 0xc2,
        0x52, 0xc2, 0x53, 0xc2, 0x55, 0xc2, 0x59, 0xc2, 0x5a, 0xc2, 0x61, 0xc2,
        0x63, 0xc2, 0x65, 0xc2, 0x67, 0xc2, 0x69, 0xc2, 0x6c, 0xc2, 0x6e, 0xc2,
        0x6f, 0xc2, 0x72, 0xc2, 0x73, 0xc2, 0x75, 0xc2, 0x79, 0xc2, 0x7a, 0x0a,
        0xc3, 0x41, 0xc3, 0x43, 0xc3, 0x45, 0xc3, 0x47, 0xc3, 0x48, 0xc3, 0x49,
        0xc3, 0x4a, 0xc3, 0x4f, 0xc3, 0x53, 0xc3, 0x55, 0xc3, 0x57, 0xc3, 0x59,
        0xc3, 0x61, 0xc3, 0x63, 0xc3, 0x65, 0xc3, 0x67, 0xc3, 0x68, 0xc3, 0x69,
        0xc3, 0x6a, 0xc3, 0x6f, 0xc3, 0x73, 0xc3, 0x75, 0xc3, 0x77, 0xc3, 0x79,
        0x0a, 0xc4, 0x41, 0xc4, 0x49, 0xc4, 0x4e, 0xc4, 0x4f, 0xc4, 0x55, 0xc4,
        0x61, 0xc4, 0x69, 0xc4, 0x6e, 0xc4, 0x6f, 0xc4, 0x75, 0x0a, 0xc5, 0x41,
        0xc5, 0x45, 0xc5, 0x49, 0xc5, 0x4f, 0xc5, 0x55, 0xc5, 0x61, 0xc5, 0x65,
        0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x75, 0x0a, 0xc6, 0x41, 0xc6, 0x47, 0xc6,
        0x55, 0xc6, 0x61, 0xc6, 0x67, 0xc6, 0x75, 0x0a, 0xc7, 0x43, 0xc7, 0x45,
        0xc7, 0x47, 0xc7, 0x49, 0xc7, 0x5a, 0xc7, 0x63, 0xc7, 0x65, 0xc7, 0x67,
        0xc7, 0x7a, 0x0a, 0xc8, 0x41, 0xc8, 0x45, 0xc8, 0x49, 0xc8, 0x4f, 0xc8,
        0x55, 0xc8, 0x59, 0xc8, 0x61, 0xc8, 0x65, 0xc8, 0x69, 0xc8, 0x6f, 0xc8,
        0x75, 0xc8, 0x79, 0x0a, 0xca, 0x41, 0xca, 0x55, 0xca, 0x61, 0xca, 0x75,
        0x0a, 0xcb, 0x43, 0xcb, 0x47, 0xcb, 0x4b, 0xcb, 0x4c, 0xcb, 0x4e, 0xcb,
        0x52, 0xcb, 0x53, 0xcb, 0x54, 0xcb, 0x63, 0xcb, 0x6b, 0xcb, 0x6c, 0xcb,
        0x6e, 0xcb, 0x72, 0xcb, 0x73, 0xcb, 0x74, 0x0a, 0xcd, 0x4f, 0xcd, 0x55,
        0xcd, 0x6f, 0xcd, 0x75, 0x0a, 0xce, 0x41, 0xce, 0x45, 0xce, 0x49, 0xce,
        0x55, 0xce, 0x61, 0xce, 0x65, 0xce, 0x69, 0xce, 0x75, 0x0a, 0xcf, 0x43,
        0xcf, 0x44, 0xcf, 0x45, 0xcf, 0x4c, 0xcf, 0x4e, 0xcf, 0x52, 0xcf, 0x53,
        0xcf, 0x54, 0xcf, 0x5a, 0xcf, 0x63, 0xcf, 0x64, 0xcf, 0x65, 0xcf, 0x6c,
        0xcf, 0x6e, 0xcf, 0x72, 0xcf, 0x73, 0xcf, 0x74, 0xcf, 0x7a, 0x0a
    ];

    let mut dst: Vec<u8> = Vec::new();
    iso6937::encode(u, &mut dst);
    assert_eq!(dst.as_slice(), c);

    let enc = iso6937::encode_to_vec(u);
    assert_eq!(enc, dst);

    let mut dst = String::new();
    iso6937::decode(c, &mut dst);
    assert_eq!(u, dst.as_str());

    let dec = iso6937::decode_to_string(c);
    assert_eq!(dst, dec);
}
