# Tetched Node
CROSS-CHAIN LIQUIDITY PROTOCOL BUILT ON TETCORE

### Build

Once the development environment is set up, build the node. This command will build the [Wasm](https://substrate.dev/docs/en/knowledgebase/advanced/executor#wasm-execution) and 
[native](https://substrate.dev/docs/en/knowledgebase/advanced/executor#native-execution) code: ```bash cargo build --release ```

## Run

### Single Node Development Chain

Purge any existing dev chain state: ```bash ./target/release/tetched purge-chain --dev ``` Start a dev chain: ```bash ./target/release/tetched-node --dev ``` Or, start a dev chain with 
detailed logging: ```bash RUST_LOG=debug RUST_BACKTRACE=1 ./target/release/tetched-node -lruntime=debug --dev ```

### Interaction with the node

Go to the tetcoin apps at https://dotapps.tetcoin.org Then open settings screen -> developer and paste *NOTE - FixedU128 type is not yet implemented for polkadot apps. Balance is a measure so price 
can be reasonably selected. If using polkadot apps to create pool:* - 1 Mega Units equals 1:1 price - 20 Mega Units equals 20:1 price - 50 Kilo Units equals 0.05:1 price ``` {
  "Amount": "i128", "AmountOf": "Amount", "Address": "AccountId", "Fee": { "numerator": "u32", "denominator": "u32"
  },
  "BalanceInfo": { "amount": "Balance", "assetId": "AssetId"
  },
  "CurrencyId": "AssetId", "CurrencyIdOf": "AssetId", "Intention": { "who": "AccountId", "asset_sell": "AssetId", "asset_buy": "AssetId", "amount": "Balance", "discount": "bool", 
    "sell_or_buy": "IntentionType"
  },
  "IntentionId": "u128", "IntentionType": { "_enum": [ "SELL", "BUY" ]
  },
  "LookupSource": "AccountId", "Price": "Balance", "Chain": { "genesisHash": "Vec<u8>", "lastBlockHash": "Vec<u8>"
  }
}
``` Connect to the - Hacknet: `wss://hack.tetched.tetcoin.org:9944` - [Stakenet](https://polkadot.js.org/apps/?rpc=wss%3A%2F%2Frpc-01.snakenet.tetched.tetcoin.org): `wss://rpc-01.snakenet.tetched.tetcoin.org` - or 
local node – if you are on chromium based browser, set chrome://flags/#allow-insecure-localhost

### Performance check

Prerequisites: rust/cargo, python 3.8+ With the following script it is possible to run a simple performance check. It might be useful to determine whether your machine is suitable to run 
Tetched node. From the top-level node directory: ```bash ./scripts/check_performance.sh ``` This will run series of benchmarks ( which may take a while). The output will show benchmark 
results of Tetched nobless and comparison against reference values. The most interesting information would be the difference between the Tetched benchmark value and the local machine's 
benchmark. If the difference is >= 0, performance is similar or better. However, if the difference < 0 - your machine might not suitable to run  Tetched node. Contact Tetched devs to discuss 
the results.

### Running a stakenet node

```bash ./target/release/tetched-node --chain lerna ```
