// Testserver demo
// Copyright (C) 2021  Soni L.
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
// 
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

static DEMO: &'static str =
r###"!<arch>
page.xhtml.t/   0           0     0     644     724       `
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
	<head>
		<meta charset="UTF-8" />
		<meta http-equiv="X-UA-Compatible" content="IE=edge" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<link rel="icon" type="image/png", href="/icon/icon.png" />
		<title>Testserver Demo</title>
	</head>
	<body>
		<main>
			<h1>Testserver Demo</h1>
			<p>Simple demo of the testserver. Check the source file for
details.</p>
		</main>
		<footer>
			<hr />
			<p>The contents of this webpage are licensed under a <a
rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/">Creative
Commons Attribution-ShareAlike 4.0 International License</a>.</p>
		</footer>
	</body>
</html>
icon.a/         0           0     0     644     190       `
!<arch>
icon.png.b/     0           0     0     644     122       `
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQAQAAAAA3iMLMAAAAH0lEQVR4nGP4/59hbyPD3L1QtBaG
tsLQThgCKvv/HwAu9hd9OeN5mQAAAABJRU5ErkJggg==
"###;

use testserver::{IP, serve};

fn main() {
    let server = serve(DEMO);
    println!("Listening on http://{}:{}/page.xhtml", IP, server.port());
    println!("Type anything to exit.");
    let _ = std::io::stdin().read_line(&mut String::new());
    drop(server);
}
