use std::{collections::BTreeSet, iter::FromIterator};
use std::path::Path;

pub mod m1 {
    pub fn f1() -> i32 {
        println!("edderocks1111111111111111");
        111
    }

    pub fn f2() -> i32 {
        println!("edderocks222222222222222222222222");
        222
    }
}

pub fn f3() -> i32 {
    println!("fffffffffffffffffff333333333333333333333333");
    333
}



pub trait MyTraitForStringSlice<'a> {
    fn equals_to_one_of_2(self, a: &str, b: &str) -> bool;
    fn equals_to_one_of_3(self, a: &str, b: &str, c: &str) -> bool;
    fn get_regex_matched_group_n(self, regex: &str, n: usize) -> Option<String>;
    fn name_increase_width_2(self) -> String;
    fn to_path(self) -> &'a Path;
    fn to_vec_char(self) -> Vec<char>;
    fn to_vec_u8(self) -> Vec<u8>;
    fn ends_with_vec(self, v: Vec<&str>) -> bool;
    fn get_file_name(self) -> &'a str;
    fn get_folder_name(self) -> &'a str;
}

impl<'a> MyTraitForStringSlice<'a> for &'a str {
    fn equals_to_one_of_2(self, a: &str, b: &str) -> bool {
        if self == a || self == b {
            return true;
        }
        false
    }

    fn equals_to_one_of_3(self, a: &str, b: &str, c: &str) -> bool {
        if self == a || self == b || self == c {
            return true;
        }
        false
    }

    fn get_regex_matched_group_n(self, regex: &str, n: usize) -> Option<String> {
        let re = regex::Regex::new(regex).unwrap();
        let result = re.captures(self)?;
        Some(result[n].to_string())
    }

    fn name_increase_width_2(self) -> String {
        fn inc(s: &str) -> String {
            let mut i = s.parse::<i32>().unwrap();
            i = i + 1;
            let width = s.chars().count();
            format!("[{:0>w$}]", i, w = width)
        }

        fn get_default(w: usize) -> String {
            format!("[{}]", "0".repeat(w))
        }

        let width: usize = 2;
        let file = Path::new(self);
        let re = regex::Regex::new(&format!(r"(?i)^(.+?)(\[({})\])?(\.\w+)?$", r"\d".repeat(width))).unwrap();
        let result = re.captures(file.to_str().unwrap()).unwrap();

        let mut t;
        if result.get(2).is_none() {
            t = format!("{}{}{}", &result.get(1).map_or("", |e| e.as_str()), get_default(width), &result.get(4).map_or("", |e| e.as_str()));
        } else {
            t = format!("{}{}{}", &result.get(1).map_or("", |e| e.as_str()), inc(&result.get(3).map(|e| e.as_str()).unwrap()), &result.get(4).map_or("", |e| e.as_str()));
        }

        while t.as_str().to_path().is_file() || t.as_str().to_path().is_dir() {
            t = t.name_increase_width_2();
        }
        t
    }

    fn to_path(self) -> &'a Path {
        Path::new(self)
    }

    fn to_vec_char(self) -> Vec<char> {
        self.chars().collect::<Vec<_>>()
    }

    fn to_vec_u8(self) -> Vec<u8> {
        self.as_bytes().to_vec()
    }

    fn ends_with_vec(self, v: Vec<&str>) -> bool {
        for e in v {
            if self.ends_with(e) {
                return true;
            }
        }
        false
    }

    fn get_file_name(self) -> &'a str {
        let x = Path::new(self);
        x.file_name().unwrap().to_str().unwrap()
    }

    fn get_folder_name(self) -> &'a str {
        let x = Path::new(self);
        x.parent().map_or("", |e| e.to_str().unwrap())
    }
}


