// DO NOT EDIT. Generated by tensorflow-op-codegen/src/main.rs.
#![allow(non_snake_case, trivial_casts, unused_parens, unused_qualifications)]

/// Builder for the `Abort` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Abort {
    error_msg: ::std::option::Option<::std::string::String>,
    exit_without_error: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Abort {
    /// Creates a new `Abort`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `error_msg` attribute.
    pub fn error_msg<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.error_msg = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `exit_without_error` attribute.
    pub fn exit_without_error<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.exit_without_error = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Abort` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("Abort", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.error_msg {
                nd.set_attr_string("error_msg", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.exit_without_error {
                nd.set_attr_bool("exit_without_error", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Abort::new().build(scope)`.
pub fn abort(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    Abort::new().build(scope)
}
/// Builder for the `Abs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Abs {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Abs {
    /// Creates a new `Abs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Abs` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Abs", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Abs::new().build(x, scope)`.
pub fn abs<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Abs::new().build(x, scope)
}
/// Builder for the `AccumulateNV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AccumulateNV2 {
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    shape: ::std::option::Option<crate::Shape>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AccumulateNV2 {
    /// Creates a new `AccumulateNV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AccumulateNV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        inputs: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(inputs.into(), scope)
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AccumulateNV2", |nd| {
            nd.add_input(inputs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shape {
                nd.set_attr_shape("shape", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AccumulateNV2::new().build(inputs, scope)`.
pub fn accumulate_nv2<O0: ::std::convert::Into<crate::Output>>(
    inputs: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AccumulateNV2::new().build(inputs, scope)
}
/// Builder for the `AccumulatorApplyGradient` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AccumulatorApplyGradient {
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AccumulatorApplyGradient {
    /// Creates a new `AccumulatorApplyGradient`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AccumulatorApplyGradient` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        local_step: O1,
        gradient: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), local_step.into(), gradient.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        local_step: crate::Output,
        gradient: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AccumulatorApplyGradient", |nd| {
            nd.add_input(handle);
            nd.add_input(local_step);
            nd.add_input(gradient);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AccumulatorApplyGradient::new().build(handle, local_step, gradient, scope)`.
pub fn accumulator_apply_gradient<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    local_step: O1,
    gradient: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AccumulatorApplyGradient::new().build(handle, local_step, gradient, scope)
}
/// Builder for the `AccumulatorNumAccumulated` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AccumulatorNumAccumulated {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AccumulatorNumAccumulated {
    /// Creates a new `AccumulatorNumAccumulated`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AccumulatorNumAccumulated` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AccumulatorNumAccumulated", |nd| {
            nd.add_input(handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AccumulatorNumAccumulated::new().build(handle, scope)`.
pub fn accumulator_num_accumulated<O0: ::std::convert::Into<crate::Output>>(
    handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AccumulatorNumAccumulated::new().build(handle, scope)
}
/// Builder for the `AccumulatorSetGlobalStep` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AccumulatorSetGlobalStep {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AccumulatorSetGlobalStep {
    /// Creates a new `AccumulatorSetGlobalStep`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AccumulatorSetGlobalStep` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        new_global_step: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), new_global_step.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        new_global_step: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AccumulatorSetGlobalStep", |nd| {
            nd.add_input(handle);
            nd.add_input(new_global_step);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AccumulatorSetGlobalStep::new().build(handle, new_global_step, scope)`.
pub fn accumulator_set_global_step<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    new_global_step: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AccumulatorSetGlobalStep::new().build(handle, new_global_step, scope)
}
/// Builder for the `AccumulatorTakeGradient` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AccumulatorTakeGradient {
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AccumulatorTakeGradient {
    /// Creates a new `AccumulatorTakeGradient`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AccumulatorTakeGradient` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        num_required: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), num_required.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        num_required: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AccumulatorTakeGradient", |nd| {
            nd.add_input(handle);
            nd.add_input(num_required);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AccumulatorTakeGradient::new().build(handle, num_required, scope)`.
pub fn accumulator_take_gradient<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    num_required: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AccumulatorTakeGradient::new().build(handle, num_required, scope)
}
/// Builder for the `Acos` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Acos {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Acos {
    /// Creates a new `Acos`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Acos` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Acos", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Acos::new().build(x, scope)`.
pub fn acos<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Acos::new().build(x, scope)
}
/// Builder for the `Acosh` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Acosh {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Acosh {
    /// Creates a new `Acosh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Acosh` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Acosh", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Acosh::new().build(x, scope)`.
pub fn acosh<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Acosh::new().build(x, scope)
}
/// Builder for the `Add` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Add {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Add {
    /// Creates a new `Add`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Add` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Add", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Add::new().build(x, y, scope)`.
pub fn add<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Add::new().build(x, y, scope)
}
/// Builder for the `AddManySparseToTensorsMap` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AddManySparseToTensorsMap {
    T: ::std::option::Option<crate::DataType>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AddManySparseToTensorsMap {
    /// Creates a new `AddManySparseToTensorsMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AddManySparseToTensorsMap` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        sparse_indices: O0,
        sparse_values: O1,
        sparse_shape: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            sparse_indices.into(),
            sparse_values.into(),
            sparse_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        sparse_indices: crate::Output,
        sparse_values: crate::Output,
        sparse_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AddManySparseToTensorsMap", |nd| {
            nd.add_input(sparse_indices);
            nd.add_input(sparse_values);
            nd.add_input(sparse_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AddManySparseToTensorsMap::new().build(sparse_indices, sparse_values, sparse_shape, scope)`.
pub fn add_many_sparse_to_tensors_map<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    sparse_indices: O0,
    sparse_values: O1,
    sparse_shape: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AddManySparseToTensorsMap::new().build(sparse_indices, sparse_values, sparse_shape, scope)
}
/// Builder for the `AddN` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AddN {
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AddN {
    /// Creates a new `AddN`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AddN` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        inputs: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(inputs.into(), scope)
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AddN", |nd| {
            nd.add_input(inputs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AddN::new().build(inputs, scope)`.
pub fn add_n<O0: ::std::convert::Into<crate::Output>>(
    inputs: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AddN::new().build(inputs, scope)
}
/// Builder for the `AddSparseToTensorsMap` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AddSparseToTensorsMap {
    T: ::std::option::Option<crate::DataType>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AddSparseToTensorsMap {
    /// Creates a new `AddSparseToTensorsMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AddSparseToTensorsMap` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        sparse_indices: O0,
        sparse_values: O1,
        sparse_shape: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            sparse_indices.into(),
            sparse_values.into(),
            sparse_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        sparse_indices: crate::Output,
        sparse_values: crate::Output,
        sparse_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AddSparseToTensorsMap", |nd| {
            nd.add_input(sparse_indices);
            nd.add_input(sparse_values);
            nd.add_input(sparse_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AddSparseToTensorsMap::new().build(sparse_indices, sparse_values, sparse_shape, scope)`.
pub fn add_sparse_to_tensors_map<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    sparse_indices: O0,
    sparse_values: O1,
    sparse_shape: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AddSparseToTensorsMap::new().build(sparse_indices, sparse_values, sparse_shape, scope)
}
/// Builder for the `AddV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AddV2 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AddV2 {
    /// Creates a new `AddV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AddV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AddV2", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AddV2::new().build(x, y, scope)`.
pub fn add_v2<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AddV2::new().build(x, y, scope)
}
/// Builder for the `AdjustContrast` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AdjustContrast {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AdjustContrast {
    /// Creates a new `AdjustContrast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AdjustContrast` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        contrast_factor: O1,
        min_value: O2,
        max_value: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            images.into(),
            contrast_factor.into(),
            min_value.into(),
            max_value.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        images: crate::Output,
        contrast_factor: crate::Output,
        min_value: crate::Output,
        max_value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AdjustContrast", |nd| {
            nd.add_input(images);
            nd.add_input(contrast_factor);
            nd.add_input(min_value);
            nd.add_input(max_value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AdjustContrast::new().build(images, contrast_factor, min_value, max_value, scope)`.
pub fn adjust_contrast<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    contrast_factor: O1,
    min_value: O2,
    max_value: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AdjustContrast::new().build(images, contrast_factor, min_value, max_value, scope)
}
/// Builder for the `AdjustContrastv2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AdjustContrastv2 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AdjustContrastv2 {
    /// Creates a new `AdjustContrastv2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AdjustContrastv2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        contrast_factor: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(images.into(), contrast_factor.into(), scope)
    }

    fn build_impl(
        &self,
        images: crate::Output,
        contrast_factor: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AdjustContrastv2", |nd| {
            nd.add_input(images);
            nd.add_input(contrast_factor);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AdjustContrastv2::new().build(images, contrast_factor, scope)`.
pub fn adjust_contrastv2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    contrast_factor: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AdjustContrastv2::new().build(images, contrast_factor, scope)
}
/// Builder for the `AdjustHue` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AdjustHue {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AdjustHue {
    /// Creates a new `AdjustHue`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AdjustHue` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        delta: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(images.into(), delta.into(), scope)
    }

    fn build_impl(
        &self,
        images: crate::Output,
        delta: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AdjustHue", |nd| {
            nd.add_input(images);
            nd.add_input(delta);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AdjustHue::new().build(images, delta, scope)`.
pub fn adjust_hue<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    delta: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AdjustHue::new().build(images, delta, scope)
}
/// Builder for the `AdjustSaturation` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AdjustSaturation {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AdjustSaturation {
    /// Creates a new `AdjustSaturation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AdjustSaturation` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        scale: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(images.into(), scale.into(), scope)
    }

    fn build_impl(
        &self,
        images: crate::Output,
        scale: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AdjustSaturation", |nd| {
            nd.add_input(images);
            nd.add_input(scale);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AdjustSaturation::new().build(images, scale, scope)`.
pub fn adjust_saturation<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    scale: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AdjustSaturation::new().build(images, scale, scope)
}
/// Builder for the `All` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct All {
    keep_dims: ::std::option::Option<bool>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl All {
    /// Creates a new `All`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `keep_dims` attribute.
    pub fn keep_dims<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.keep_dims = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `All` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        reduction_indices: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), reduction_indices.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        reduction_indices: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("All", |nd| {
            nd.add_input(input);
            nd.add_input(reduction_indices);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.keep_dims {
                nd.set_attr_bool("keep_dims", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `All::new().build(input, reduction_indices, scope)`.
pub fn all<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    reduction_indices: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    All::new().build(input, reduction_indices, scope)
}
/// Builder for the `AllCandidateSampler` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AllCandidateSampler {
    num_true: ::std::option::Option<i64>,
    num_sampled: ::std::option::Option<i64>,
    unique: ::std::option::Option<bool>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AllCandidateSampler {
    /// Creates a new `AllCandidateSampler`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_true` attribute.
    pub fn num_true<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_true = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_sampled` attribute.
    pub fn num_sampled<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_sampled = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `unique` attribute.
    pub fn unique<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.unique = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AllCandidateSampler` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        true_classes: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(true_classes.into(), scope)
    }

    fn build_impl(
        &self,
        true_classes: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AllCandidateSampler", |nd| {
            nd.add_input(true_classes);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_true {
                nd.set_attr_int("num_true", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_sampled {
                nd.set_attr_int("num_sampled", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.unique {
                nd.set_attr_bool("unique", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AllCandidateSampler::new().build(true_classes, scope)`.
pub fn all_candidate_sampler<O0: ::std::convert::Into<crate::Output>>(
    true_classes: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AllCandidateSampler::new().build(true_classes, scope)
}
/// Builder for the `AllToAll` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AllToAll {
    T: ::std::option::Option<crate::DataType>,
    concat_dimension: ::std::option::Option<i64>,
    split_dimension: ::std::option::Option<i64>,
    split_count: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AllToAll {
    /// Creates a new `AllToAll`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `concat_dimension` attribute.
    pub fn concat_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.concat_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_dimension` attribute.
    pub fn split_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.split_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_count` attribute.
    pub fn split_count<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.split_count = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AllToAll` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        group_assignment: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), group_assignment.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        group_assignment: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AllToAll", |nd| {
            nd.add_input(input);
            nd.add_input(group_assignment);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.concat_dimension {
                nd.set_attr_int("concat_dimension", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.split_dimension {
                nd.set_attr_int("split_dimension", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.split_count {
                nd.set_attr_int("split_count", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AllToAll::new().build(input, group_assignment, scope)`.
pub fn all_to_all<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    group_assignment: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AllToAll::new().build(input, group_assignment, scope)
}
/// Builder for the `Angle` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Angle {
    T: ::std::option::Option<crate::DataType>,
    Tout: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Angle {
    /// Creates a new `Angle`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Angle` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Angle", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type("Tout", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Angle::new().build(input, scope)`.
pub fn angle<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Angle::new().build(input, scope)
}
/// Builder for the `AnonymousHashTable` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousHashTable {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousHashTable {
    /// Creates a new `AnonymousHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousHashTable` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousHashTable", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.key_dtype {
                nd.set_attr_type("key_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_dtype {
                nd.set_attr_type("value_dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousHashTable::new().build(scope)`.
pub fn anonymous_hash_table(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousHashTable::new().build(scope)
}
/// Builder for the `AnonymousIterator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousIterator {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousIterator {
    /// Creates a new `AnonymousIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousIterator` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousIterator", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousIterator::new().build(scope)`.
pub fn anonymous_iterator(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousIterator::new().build(scope)
}
/// Builder for the `AnonymousIteratorV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousIteratorV2 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousIteratorV2 {
    /// Creates a new `AnonymousIteratorV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousIteratorV2` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousIteratorV2", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousIteratorV2::new().build(scope)`.
pub fn anonymous_iterator_v2(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousIteratorV2::new().build(scope)
}
/// Builder for the `AnonymousIteratorV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousIteratorV3 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousIteratorV3 {
    /// Creates a new `AnonymousIteratorV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousIteratorV3` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousIteratorV3", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousIteratorV3::new().build(scope)`.
pub fn anonymous_iterator_v3(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousIteratorV3::new().build(scope)
}
/// Builder for the `AnonymousMemoryCache` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousMemoryCache {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousMemoryCache {
    /// Creates a new `AnonymousMemoryCache`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousMemoryCache` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousMemoryCache", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousMemoryCache::new().build(scope)`.
pub fn anonymous_memory_cache(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousMemoryCache::new().build(scope)
}
/// Builder for the `AnonymousMultiDeviceIterator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousMultiDeviceIterator {
    devices: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousMultiDeviceIterator {
    /// Creates a new `AnonymousMultiDeviceIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `devices` attribute.
    pub fn devices<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.devices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousMultiDeviceIterator` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousMultiDeviceIterator", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.devices {
                nd.set_attr_string_list("devices", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousMultiDeviceIterator::new().build(scope)`.
pub fn anonymous_multi_device_iterator(
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AnonymousMultiDeviceIterator::new().build(scope)
}
/// Builder for the `AnonymousMutableDenseHashTable` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousMutableDenseHashTable {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    value_shape: ::std::option::Option<crate::Shape>,
    initial_num_buckets: ::std::option::Option<i64>,
    max_load_factor: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousMutableDenseHashTable {
    /// Creates a new `AnonymousMutableDenseHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_shape` attribute.
    pub fn value_shape<ArgType: ::std::convert::Into<crate::Shape>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `initial_num_buckets` attribute.
    pub fn initial_num_buckets<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.initial_num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_load_factor` attribute.
    pub fn max_load_factor<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.max_load_factor = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousMutableDenseHashTable` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        empty_key: O0,
        deleted_key: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(empty_key.into(), deleted_key.into(), scope)
    }

    fn build_impl(
        &self,
        empty_key: crate::Output,
        deleted_key: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousMutableDenseHashTable", |nd| {
            nd.add_input(empty_key);
            nd.add_input(deleted_key);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.key_dtype {
                nd.set_attr_type("key_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_dtype {
                nd.set_attr_type("value_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_shape {
                nd.set_attr_shape("value_shape", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.initial_num_buckets {
                nd.set_attr_int("initial_num_buckets", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_load_factor {
                nd.set_attr_float("max_load_factor", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousMutableDenseHashTable::new().build(empty_key, deleted_key, scope)`.
pub fn anonymous_mutable_dense_hash_table<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    empty_key: O0,
    deleted_key: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AnonymousMutableDenseHashTable::new().build(empty_key, deleted_key, scope)
}
/// Builder for the `AnonymousMutableHashTable` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousMutableHashTable {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousMutableHashTable {
    /// Creates a new `AnonymousMutableHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousMutableHashTable` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousMutableHashTable", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.key_dtype {
                nd.set_attr_type("key_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_dtype {
                nd.set_attr_type("value_dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousMutableHashTable::new().build(scope)`.
pub fn anonymous_mutable_hash_table(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    AnonymousMutableHashTable::new().build(scope)
}
/// Builder for the `AnonymousMutableHashTableOfTensors` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousMutableHashTableOfTensors {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    value_shape: ::std::option::Option<crate::Shape>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousMutableHashTableOfTensors {
    /// Creates a new `AnonymousMutableHashTableOfTensors`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_shape` attribute.
    pub fn value_shape<ArgType: ::std::convert::Into<crate::Shape>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousMutableHashTableOfTensors` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousMutableHashTableOfTensors", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.key_dtype {
                nd.set_attr_type("key_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_dtype {
                nd.set_attr_type("value_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.value_shape {
                nd.set_attr_shape("value_shape", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousMutableHashTableOfTensors::new().build(scope)`.
pub fn anonymous_mutable_hash_table_of_tensors(
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AnonymousMutableHashTableOfTensors::new().build(scope)
}
/// Builder for the `AnonymousRandomSeedGenerator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousRandomSeedGenerator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousRandomSeedGenerator {
    /// Creates a new `AnonymousRandomSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousRandomSeedGenerator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seed: O0,
        seed2: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(seed.into(), seed2.into(), scope)
    }

    fn build_impl(
        &self,
        seed: crate::Output,
        seed2: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousRandomSeedGenerator", |nd| {
            nd.add_input(seed);
            nd.add_input(seed2);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousRandomSeedGenerator::new().build(seed, seed2, scope)`.
pub fn anonymous_random_seed_generator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    seed: O0,
    seed2: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AnonymousRandomSeedGenerator::new().build(seed, seed2, scope)
}
/// Builder for the `AnonymousSeedGenerator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AnonymousSeedGenerator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AnonymousSeedGenerator {
    /// Creates a new `AnonymousSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AnonymousSeedGenerator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seed: O0,
        seed2: O1,
        reshuffle: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(seed.into(), seed2.into(), reshuffle.into(), scope)
    }

    fn build_impl(
        &self,
        seed: crate::Output,
        seed2: crate::Output,
        reshuffle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AnonymousSeedGenerator", |nd| {
            nd.add_input(seed);
            nd.add_input(seed2);
            nd.add_input(reshuffle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AnonymousSeedGenerator::new().build(seed, seed2, reshuffle, scope)`.
pub fn anonymous_seed_generator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    seed: O0,
    seed2: O1,
    reshuffle: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AnonymousSeedGenerator::new().build(seed, seed2, reshuffle, scope)
}
/// Builder for the `Any` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Any {
    keep_dims: ::std::option::Option<bool>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Any {
    /// Creates a new `Any`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `keep_dims` attribute.
    pub fn keep_dims<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.keep_dims = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Any` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        reduction_indices: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), reduction_indices.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        reduction_indices: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Any", |nd| {
            nd.add_input(input);
            nd.add_input(reduction_indices);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.keep_dims {
                nd.set_attr_bool("keep_dims", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Any::new().build(input, reduction_indices, scope)`.
pub fn any<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    reduction_indices: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Any::new().build(input, reduction_indices, scope)
}
/// Builder for the `ApplyAdaMax` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdaMax {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdaMax {
    /// Creates a new `ApplyAdaMax`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdaMax` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        m: O1,
        v: O2,
        beta1_power: O3,
        lr: O4,
        beta1: O5,
        beta2: O6,
        epsilon: O7,
        grad: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            m.into(),
            v.into(),
            beta1_power.into(),
            lr.into(),
            beta1.into(),
            beta2.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        m: crate::Output,
        v: crate::Output,
        beta1_power: crate::Output,
        lr: crate::Output,
        beta1: crate::Output,
        beta2: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdaMax", |nd| {
            nd.add_input(var);
            nd.add_input(m);
            nd.add_input(v);
            nd.add_input(beta1_power);
            nd.add_input(lr);
            nd.add_input(beta1);
            nd.add_input(beta2);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdaMax::new().build(var, m, v, beta1_power, lr, beta1, beta2, epsilon, grad, scope)`.
pub fn apply_ada_max<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    m: O1,
    v: O2,
    beta1_power: O3,
    lr: O4,
    beta1: O5,
    beta2: O6,
    epsilon: O7,
    grad: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdaMax::new().build(
        var,
        m,
        v,
        beta1_power,
        lr,
        beta1,
        beta2,
        epsilon,
        grad,
        scope,
    )
}
/// Builder for the `ApplyAdadelta` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdadelta {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdadelta {
    /// Creates a new `ApplyAdadelta`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdadelta` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        accum_update: O2,
        lr: O3,
        rho: O4,
        epsilon: O5,
        grad: O6,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            accum_update.into(),
            lr.into(),
            rho.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        accum_update: crate::Output,
        lr: crate::Output,
        rho: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdadelta", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(accum_update);
            nd.add_input(lr);
            nd.add_input(rho);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdadelta::new().build(var, accum, accum_update, lr, rho, epsilon, grad, scope)`.
pub fn apply_adadelta<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    accum_update: O2,
    lr: O3,
    rho: O4,
    epsilon: O5,
    grad: O6,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdadelta::new().build(var, accum, accum_update, lr, rho, epsilon, grad, scope)
}
/// Builder for the `ApplyAdagrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdagrad {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    update_slots: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdagrad {
    /// Creates a new `ApplyAdagrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `update_slots` attribute.
    pub fn update_slots<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.update_slots = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdagrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        lr: O2,
        grad: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(var.into(), accum.into(), lr.into(), grad.into(), scope)
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        lr: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdagrad", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(lr);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.update_slots {
                nd.set_attr_bool("update_slots", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdagrad::new().build(var, accum, lr, grad, scope)`.
pub fn apply_adagrad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    lr: O2,
    grad: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdagrad::new().build(var, accum, lr, grad, scope)
}
/// Builder for the `ApplyAdagradDA` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdagradDA {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdagradDA {
    /// Creates a new `ApplyAdagradDA`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdagradDA` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        gradient_accumulator: O1,
        gradient_squared_accumulator: O2,
        grad: O3,
        lr: O4,
        l1: O5,
        l2: O6,
        global_step: O7,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            gradient_accumulator.into(),
            gradient_squared_accumulator.into(),
            grad.into(),
            lr.into(),
            l1.into(),
            l2.into(),
            global_step.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        gradient_accumulator: crate::Output,
        gradient_squared_accumulator: crate::Output,
        grad: crate::Output,
        lr: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        global_step: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdagradDA", |nd| {
            nd.add_input(var);
            nd.add_input(gradient_accumulator);
            nd.add_input(gradient_squared_accumulator);
            nd.add_input(grad);
            nd.add_input(lr);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(global_step);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdagradDA::new().build(var, gradient_accumulator, gradient_squared_accumulator, grad, lr, l1, l2, global_step, scope)`.
pub fn apply_adagrad_da<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    gradient_accumulator: O1,
    gradient_squared_accumulator: O2,
    grad: O3,
    lr: O4,
    l1: O5,
    l2: O6,
    global_step: O7,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdagradDA::new().build(
        var,
        gradient_accumulator,
        gradient_squared_accumulator,
        grad,
        lr,
        l1,
        l2,
        global_step,
        scope,
    )
}
/// Builder for the `ApplyAdagradV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdagradV2 {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    update_slots: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdagradV2 {
    /// Creates a new `ApplyAdagradV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `update_slots` attribute.
    pub fn update_slots<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.update_slots = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdagradV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        lr: O2,
        epsilon: O3,
        grad: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            lr.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        lr: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdagradV2", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(lr);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.update_slots {
                nd.set_attr_bool("update_slots", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdagradV2::new().build(var, accum, lr, epsilon, grad, scope)`.
pub fn apply_adagrad_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    lr: O2,
    epsilon: O3,
    grad: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdagradV2::new().build(var, accum, lr, epsilon, grad, scope)
}
/// Builder for the `ApplyAdam` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAdam {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    use_nesterov: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAdam {
    /// Creates a new `ApplyAdam`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_nesterov` attribute.
    pub fn use_nesterov<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_nesterov = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAdam` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        m: O1,
        v: O2,
        beta1_power: O3,
        beta2_power: O4,
        lr: O5,
        beta1: O6,
        beta2: O7,
        epsilon: O8,
        grad: O9,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            m.into(),
            v.into(),
            beta1_power.into(),
            beta2_power.into(),
            lr.into(),
            beta1.into(),
            beta2.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        m: crate::Output,
        v: crate::Output,
        beta1_power: crate::Output,
        beta2_power: crate::Output,
        lr: crate::Output,
        beta1: crate::Output,
        beta2: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAdam", |nd| {
            nd.add_input(var);
            nd.add_input(m);
            nd.add_input(v);
            nd.add_input(beta1_power);
            nd.add_input(beta2_power);
            nd.add_input(lr);
            nd.add_input(beta1);
            nd.add_input(beta2);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_nesterov {
                nd.set_attr_bool("use_nesterov", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAdam::new().build(var, m, v, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad, scope)`.
pub fn apply_adam<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    m: O1,
    v: O2,
    beta1_power: O3,
    beta2_power: O4,
    lr: O5,
    beta1: O6,
    beta2: O7,
    epsilon: O8,
    grad: O9,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAdam::new().build(
        var,
        m,
        v,
        beta1_power,
        beta2_power,
        lr,
        beta1,
        beta2,
        epsilon,
        grad,
        scope,
    )
}
/// Builder for the `ApplyAddSign` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyAddSign {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyAddSign {
    /// Creates a new `ApplyAddSign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyAddSign` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        m: O1,
        lr: O2,
        alpha: O3,
        sign_decay: O4,
        beta: O5,
        grad: O6,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            m.into(),
            lr.into(),
            alpha.into(),
            sign_decay.into(),
            beta.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        m: crate::Output,
        lr: crate::Output,
        alpha: crate::Output,
        sign_decay: crate::Output,
        beta: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyAddSign", |nd| {
            nd.add_input(var);
            nd.add_input(m);
            nd.add_input(lr);
            nd.add_input(alpha);
            nd.add_input(sign_decay);
            nd.add_input(beta);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyAddSign::new().build(var, m, lr, alpha, sign_decay, beta, grad, scope)`.
pub fn apply_add_sign<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    m: O1,
    lr: O2,
    alpha: O3,
    sign_decay: O4,
    beta: O5,
    grad: O6,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyAddSign::new().build(var, m, lr, alpha, sign_decay, beta, grad, scope)
}
/// Builder for the `ApplyCenteredRMSProp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyCenteredRMSProp {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyCenteredRMSProp {
    /// Creates a new `ApplyCenteredRMSProp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyCenteredRMSProp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        mg: O1,
        ms: O2,
        mom: O3,
        lr: O4,
        rho: O5,
        momentum: O6,
        epsilon: O7,
        grad: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            mg.into(),
            ms.into(),
            mom.into(),
            lr.into(),
            rho.into(),
            momentum.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        mg: crate::Output,
        ms: crate::Output,
        mom: crate::Output,
        lr: crate::Output,
        rho: crate::Output,
        momentum: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyCenteredRMSProp", |nd| {
            nd.add_input(var);
            nd.add_input(mg);
            nd.add_input(ms);
            nd.add_input(mom);
            nd.add_input(lr);
            nd.add_input(rho);
            nd.add_input(momentum);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyCenteredRMSProp::new().build(var, mg, ms, mom, lr, rho, momentum, epsilon, grad, scope)`.
pub fn apply_centered_rmsprop<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    mg: O1,
    ms: O2,
    mom: O3,
    lr: O4,
    rho: O5,
    momentum: O6,
    epsilon: O7,
    grad: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyCenteredRMSProp::new().build(var, mg, ms, mom, lr, rho, momentum, epsilon, grad, scope)
}
/// Builder for the `ApplyFtrl` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyFtrl {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    multiply_linear_by_lr: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyFtrl {
    /// Creates a new `ApplyFtrl`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `multiply_linear_by_lr` attribute.
    pub fn multiply_linear_by_lr<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.multiply_linear_by_lr = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyFtrl` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        linear: O2,
        grad: O3,
        lr: O4,
        l1: O5,
        l2: O6,
        lr_power: O7,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            linear.into(),
            grad.into(),
            lr.into(),
            l1.into(),
            l2.into(),
            lr_power.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        linear: crate::Output,
        grad: crate::Output,
        lr: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        lr_power: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyFtrl", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(linear);
            nd.add_input(grad);
            nd.add_input(lr);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(lr_power);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.multiply_linear_by_lr {
                nd.set_attr_bool("multiply_linear_by_lr", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyFtrl::new().build(var, accum, linear, grad, lr, l1, l2, lr_power, scope)`.
pub fn apply_ftrl<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    linear: O2,
    grad: O3,
    lr: O4,
    l1: O5,
    l2: O6,
    lr_power: O7,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyFtrl::new().build(var, accum, linear, grad, lr, l1, l2, lr_power, scope)
}
/// Builder for the `ApplyFtrlV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyFtrlV2 {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    multiply_linear_by_lr: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyFtrlV2 {
    /// Creates a new `ApplyFtrlV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `multiply_linear_by_lr` attribute.
    pub fn multiply_linear_by_lr<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.multiply_linear_by_lr = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyFtrlV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        linear: O2,
        grad: O3,
        lr: O4,
        l1: O5,
        l2: O6,
        l2_shrinkage: O7,
        lr_power: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            linear.into(),
            grad.into(),
            lr.into(),
            l1.into(),
            l2.into(),
            l2_shrinkage.into(),
            lr_power.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        linear: crate::Output,
        grad: crate::Output,
        lr: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        l2_shrinkage: crate::Output,
        lr_power: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyFtrlV2", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(linear);
            nd.add_input(grad);
            nd.add_input(lr);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(l2_shrinkage);
            nd.add_input(lr_power);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.multiply_linear_by_lr {
                nd.set_attr_bool("multiply_linear_by_lr", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyFtrlV2::new().build(var, accum, linear, grad, lr, l1, l2, l2_shrinkage, lr_power, scope)`.
pub fn apply_ftrl_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    linear: O2,
    grad: O3,
    lr: O4,
    l1: O5,
    l2: O6,
    l2_shrinkage: O7,
    lr_power: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyFtrlV2::new().build(
        var,
        accum,
        linear,
        grad,
        lr,
        l1,
        l2,
        l2_shrinkage,
        lr_power,
        scope,
    )
}
/// Builder for the `ApplyGradientDescent` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyGradientDescent {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyGradientDescent {
    /// Creates a new `ApplyGradientDescent`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyGradientDescent` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        alpha: O1,
        delta: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(var.into(), alpha.into(), delta.into(), scope)
    }

    fn build_impl(
        &self,
        var: crate::Output,
        alpha: crate::Output,
        delta: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyGradientDescent", |nd| {
            nd.add_input(var);
            nd.add_input(alpha);
            nd.add_input(delta);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyGradientDescent::new().build(var, alpha, delta, scope)`.
pub fn apply_gradient_descent<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    alpha: O1,
    delta: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyGradientDescent::new().build(var, alpha, delta, scope)
}
/// Builder for the `ApplyMomentum` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyMomentum {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    use_nesterov: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyMomentum {
    /// Creates a new `ApplyMomentum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_nesterov` attribute.
    pub fn use_nesterov<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_nesterov = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyMomentum` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        lr: O2,
        grad: O3,
        momentum: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            lr.into(),
            grad.into(),
            momentum.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        lr: crate::Output,
        grad: crate::Output,
        momentum: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyMomentum", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(lr);
            nd.add_input(grad);
            nd.add_input(momentum);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_nesterov {
                nd.set_attr_bool("use_nesterov", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyMomentum::new().build(var, accum, lr, grad, momentum, scope)`.
pub fn apply_momentum<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    lr: O2,
    grad: O3,
    momentum: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyMomentum::new().build(var, accum, lr, grad, momentum, scope)
}
/// Builder for the `ApplyPowerSign` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyPowerSign {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyPowerSign {
    /// Creates a new `ApplyPowerSign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyPowerSign` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        m: O1,
        lr: O2,
        logbase: O3,
        sign_decay: O4,
        beta: O5,
        grad: O6,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            m.into(),
            lr.into(),
            logbase.into(),
            sign_decay.into(),
            beta.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        m: crate::Output,
        lr: crate::Output,
        logbase: crate::Output,
        sign_decay: crate::Output,
        beta: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyPowerSign", |nd| {
            nd.add_input(var);
            nd.add_input(m);
            nd.add_input(lr);
            nd.add_input(logbase);
            nd.add_input(sign_decay);
            nd.add_input(beta);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyPowerSign::new().build(var, m, lr, logbase, sign_decay, beta, grad, scope)`.
pub fn apply_power_sign<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    m: O1,
    lr: O2,
    logbase: O3,
    sign_decay: O4,
    beta: O5,
    grad: O6,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyPowerSign::new().build(var, m, lr, logbase, sign_decay, beta, grad, scope)
}
/// Builder for the `ApplyProximalAdagrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyProximalAdagrad {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyProximalAdagrad {
    /// Creates a new `ApplyProximalAdagrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyProximalAdagrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        accum: O1,
        lr: O2,
        l1: O3,
        l2: O4,
        grad: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            accum.into(),
            lr.into(),
            l1.into(),
            l2.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        accum: crate::Output,
        lr: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyProximalAdagrad", |nd| {
            nd.add_input(var);
            nd.add_input(accum);
            nd.add_input(lr);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyProximalAdagrad::new().build(var, accum, lr, l1, l2, grad, scope)`.
pub fn apply_proximal_adagrad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    accum: O1,
    lr: O2,
    l1: O3,
    l2: O4,
    grad: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyProximalAdagrad::new().build(var, accum, lr, l1, l2, grad, scope)
}
/// Builder for the `ApplyProximalGradientDescent` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyProximalGradientDescent {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyProximalGradientDescent {
    /// Creates a new `ApplyProximalGradientDescent`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyProximalGradientDescent` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        alpha: O1,
        l1: O2,
        l2: O3,
        delta: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            alpha.into(),
            l1.into(),
            l2.into(),
            delta.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        alpha: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        delta: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyProximalGradientDescent", |nd| {
            nd.add_input(var);
            nd.add_input(alpha);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(delta);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyProximalGradientDescent::new().build(var, alpha, l1, l2, delta, scope)`.
pub fn apply_proximal_gradient_descent<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    alpha: O1,
    l1: O2,
    l2: O3,
    delta: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyProximalGradientDescent::new().build(var, alpha, l1, l2, delta, scope)
}
/// Builder for the `ApplyRMSProp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApplyRMSProp {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApplyRMSProp {
    /// Creates a new `ApplyRMSProp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApplyRMSProp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
    >(
        &self,
        var: O0,
        ms: O1,
        mom: O2,
        lr: O3,
        rho: O4,
        momentum: O5,
        epsilon: O6,
        grad: O7,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            var.into(),
            ms.into(),
            mom.into(),
            lr.into(),
            rho.into(),
            momentum.into(),
            epsilon.into(),
            grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        var: crate::Output,
        ms: crate::Output,
        mom: crate::Output,
        lr: crate::Output,
        rho: crate::Output,
        momentum: crate::Output,
        epsilon: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApplyRMSProp", |nd| {
            nd.add_input(var);
            nd.add_input(ms);
            nd.add_input(mom);
            nd.add_input(lr);
            nd.add_input(rho);
            nd.add_input(momentum);
            nd.add_input(epsilon);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApplyRMSProp::new().build(var, ms, mom, lr, rho, momentum, epsilon, grad, scope)`.
pub fn apply_rmsprop<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
>(
    var: O0,
    ms: O1,
    mom: O2,
    lr: O3,
    rho: O4,
    momentum: O5,
    epsilon: O6,
    grad: O7,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApplyRMSProp::new().build(var, ms, mom, lr, rho, momentum, epsilon, grad, scope)
}
/// Builder for the `ApproximateEqual` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ApproximateEqual {
    T: ::std::option::Option<crate::DataType>,
    tolerance: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ApproximateEqual {
    /// Creates a new `ApproximateEqual`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tolerance` attribute.
    pub fn tolerance<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.tolerance = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ApproximateEqual` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ApproximateEqual", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tolerance {
                nd.set_attr_float("tolerance", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ApproximateEqual::new().build(x, y, scope)`.
pub fn approximate_equal<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ApproximateEqual::new().build(x, y, scope)
}
/// Builder for the `ArgMax` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ArgMax {
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    output_type: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ArgMax {
    /// Creates a new `ArgMax`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_type` attribute.
    pub fn output_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ArgMax` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        dimension: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), dimension.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        dimension: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ArgMax", |nd| {
            nd.add_input(input);
            nd.add_input(dimension);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_type {
                nd.set_attr_type("output_type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ArgMax::new().build(input, dimension, scope)`.
pub fn arg_max<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    dimension: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ArgMax::new().build(input, dimension, scope)
}
/// Builder for the `ArgMin` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ArgMin {
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    output_type: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ArgMin {
    /// Creates a new `ArgMin`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_type` attribute.
    pub fn output_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ArgMin` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        dimension: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), dimension.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        dimension: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ArgMin", |nd| {
            nd.add_input(input);
            nd.add_input(dimension);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_type {
                nd.set_attr_type("output_type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ArgMin::new().build(input, dimension, scope)`.
pub fn arg_min<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    dimension: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ArgMin::new().build(input, dimension, scope)
}
/// Builder for the `AsString` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AsString {
    T: ::std::option::Option<crate::DataType>,
    precision: ::std::option::Option<i64>,
    scientific: ::std::option::Option<bool>,
    shortest: ::std::option::Option<bool>,
    width: ::std::option::Option<i64>,
    fill: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AsString {
    /// Creates a new `AsString`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `precision` attribute.
    pub fn precision<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.precision = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scientific` attribute.
    pub fn scientific<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.scientific = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shortest` attribute.
    pub fn shortest<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.shortest = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `width` attribute.
    pub fn width<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.width = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fill` attribute.
    pub fn fill<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.fill = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AsString` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AsString", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.precision {
                nd.set_attr_int("precision", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.scientific {
                nd.set_attr_bool("scientific", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shortest {
                nd.set_attr_bool("shortest", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.width {
                nd.set_attr_int("width", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.fill {
                nd.set_attr_string("fill", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AsString::new().build(input, scope)`.
pub fn as_string<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AsString::new().build(input, scope)
}
/// Builder for the `Asin` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Asin {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Asin {
    /// Creates a new `Asin`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Asin` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Asin", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Asin::new().build(x, scope)`.
pub fn asin<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Asin::new().build(x, scope)
}
/// Builder for the `Asinh` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Asinh {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Asinh {
    /// Creates a new `Asinh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Asinh` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Asinh", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Asinh::new().build(x, scope)`.
pub fn asinh<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Asinh::new().build(x, scope)
}
/// Builder for the `Assert` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Assert {
    T: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    summarize: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Assert {
    /// Creates a new `Assert`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `summarize` attribute.
    pub fn summarize<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.summarize = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Assert` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        condition: O0,
        data: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(condition.into(), data.into(), scope)
    }

    fn build_impl(
        &self,
        condition: crate::Output,
        data: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Assert", |nd| {
            nd.add_input(condition);
            nd.add_input(data);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type_list("T", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.summarize {
                nd.set_attr_int("summarize", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Assert::new().build(condition, data, scope)`.
pub fn assert<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    condition: O0,
    data: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Assert::new().build(condition, data, scope)
}
/// Builder for the `AssertCardinalityDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssertCardinalityDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssertCardinalityDataset {
    /// Creates a new `AssertCardinalityDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssertCardinalityDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        cardinality: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), cardinality.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        cardinality: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssertCardinalityDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(cardinality);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssertCardinalityDataset::new().build(input_dataset, cardinality, scope)`.
pub fn assert_cardinality_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    cardinality: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssertCardinalityDataset::new().build(input_dataset, cardinality, scope)
}
/// Builder for the `AssertNextDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssertNextDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssertNextDataset {
    /// Creates a new `AssertNextDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssertNextDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        transformations: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), transformations.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        transformations: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssertNextDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(transformations);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssertNextDataset::new().build(input_dataset, transformations, scope)`.
pub fn assert_next_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    transformations: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssertNextDataset::new().build(input_dataset, transformations, scope)
}
/// Builder for the `Assign` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Assign {
    T: ::std::option::Option<crate::DataType>,
    validate_shape: ::std::option::Option<bool>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Assign {
    /// Creates a new `Assign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_shape` attribute.
    pub fn validate_shape<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Assign` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        ref_: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(ref_.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        ref_: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Assign", |nd| {
            nd.add_input(ref_);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.validate_shape {
                nd.set_attr_bool("validate_shape", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Assign::new().build(ref_, value, scope)`.
pub fn assign<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    ref_: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Assign::new().build(ref_, value, scope)
}
/// Builder for the `AssignAdd` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignAdd {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignAdd {
    /// Creates a new `AssignAdd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignAdd` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        ref_: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(ref_.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        ref_: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignAdd", |nd| {
            nd.add_input(ref_);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignAdd::new().build(ref_, value, scope)`.
pub fn assign_add<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    ref_: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignAdd::new().build(ref_, value, scope)
}
/// Builder for the `AssignAddVariableOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignAddVariableOp {
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignAddVariableOp {
    /// Creates a new `AssignAddVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignAddVariableOp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        resource: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        resource: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignAddVariableOp", |nd| {
            nd.add_input(resource);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignAddVariableOp::new().build(resource, value, scope)`.
pub fn assign_add_variable_op<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    resource: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignAddVariableOp::new().build(resource, value, scope)
}
/// Builder for the `AssignSub` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignSub {
    T: ::std::option::Option<crate::DataType>,
    use_locking: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignSub {
    /// Creates a new `AssignSub`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignSub` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        ref_: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(ref_.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        ref_: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignSub", |nd| {
            nd.add_input(ref_);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_locking {
                nd.set_attr_bool("use_locking", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignSub::new().build(ref_, value, scope)`.
pub fn assign_sub<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    ref_: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignSub::new().build(ref_, value, scope)
}
/// Builder for the `AssignSubVariableOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignSubVariableOp {
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignSubVariableOp {
    /// Creates a new `AssignSubVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignSubVariableOp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        resource: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        resource: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignSubVariableOp", |nd| {
            nd.add_input(resource);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignSubVariableOp::new().build(resource, value, scope)`.
pub fn assign_sub_variable_op<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    resource: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignSubVariableOp::new().build(resource, value, scope)
}
/// Builder for the `AssignVariableOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignVariableOp {
    dtype: ::std::option::Option<crate::DataType>,
    validate_shape: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignVariableOp {
    /// Creates a new `AssignVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_shape` attribute.
    pub fn validate_shape<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignVariableOp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        resource: O0,
        value: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource.into(), value.into(), scope)
    }

    fn build_impl(
        &self,
        resource: crate::Output,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignVariableOp", |nd| {
            nd.add_input(resource);
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.validate_shape {
                nd.set_attr_bool("validate_shape", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignVariableOp::new().build(resource, value, scope)`.
pub fn assign_variable_op<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    resource: O0,
    value: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignVariableOp::new().build(resource, value, scope)
}
/// Builder for the `AssignVariableXlaConcatND` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AssignVariableXlaConcatND {
    T: ::std::option::Option<crate::DataType>,
    N: ::std::option::Option<i64>,
    num_concats: ::std::option::Option<::std::vec::Vec<i64>>,
    paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AssignVariableXlaConcatND {
    /// Creates a new `AssignVariableXlaConcatND`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_concats` attribute.
    pub fn num_concats<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_concats = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `paddings` attribute.
    pub fn paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AssignVariableXlaConcatND` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        resource: O0,
        inputs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource.into(), inputs.into(), scope)
    }

    fn build_impl(
        &self,
        resource: crate::Output,
        inputs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AssignVariableXlaConcatND", |nd| {
            nd.add_input(resource);
            nd.add_input(inputs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_concats {
                nd.set_attr_int_list("num_concats", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.paddings {
                nd.set_attr_int_list("paddings", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AssignVariableXlaConcatND::new().build(resource, inputs, scope)`.
pub fn assign_variable_xla_concat_nd<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    resource: O0,
    inputs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AssignVariableXlaConcatND::new().build(resource, inputs, scope)
}
/// Builder for the `Atan` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Atan {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Atan {
    /// Creates a new `Atan`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Atan` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Atan", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Atan::new().build(x, scope)`.
pub fn atan<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Atan::new().build(x, scope)
}
/// Builder for the `Atan2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Atan2 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Atan2 {
    /// Creates a new `Atan2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Atan2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        y: O0,
        x: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(y.into(), x.into(), scope)
    }

    fn build_impl(
        &self,
        y: crate::Output,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Atan2", |nd| {
            nd.add_input(y);
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Atan2::new().build(y, x, scope)`.
pub fn atan2<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    y: O0,
    x: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Atan2::new().build(y, x, scope)
}
/// Builder for the `Atanh` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Atanh {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Atanh {
    /// Creates a new `Atanh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Atanh` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Atanh", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Atanh::new().build(x, scope)`.
pub fn atanh<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Atanh::new().build(x, scope)
}
/// Builder for the `AudioSpectrogram` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AudioSpectrogram {
    window_size: ::std::option::Option<i64>,
    stride: ::std::option::Option<i64>,
    magnitude_squared: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AudioSpectrogram {
    /// Creates a new `AudioSpectrogram`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `window_size` attribute.
    pub fn window_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.window_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `stride` attribute.
    pub fn stride<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.stride = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `magnitude_squared` attribute.
    pub fn magnitude_squared<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.magnitude_squared = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AudioSpectrogram` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AudioSpectrogram", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.window_size {
                nd.set_attr_int("window_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.stride {
                nd.set_attr_int("stride", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.magnitude_squared {
                nd.set_attr_bool("magnitude_squared", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AudioSpectrogram::new().build(input, scope)`.
pub fn audio_spectrogram<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AudioSpectrogram::new().build(input, scope)
}
/// Builder for the `AudioSummary` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AudioSummary {
    sample_rate: ::std::option::Option<f32>,
    max_outputs: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AudioSummary {
    /// Creates a new `AudioSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `sample_rate` attribute.
    pub fn sample_rate<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.sample_rate = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_outputs` attribute.
    pub fn max_outputs<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_outputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AudioSummary` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tag: O0,
        tensor: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tag.into(), tensor.into(), scope)
    }

    fn build_impl(
        &self,
        tag: crate::Output,
        tensor: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AudioSummary", |nd| {
            nd.add_input(tag);
            nd.add_input(tensor);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.sample_rate {
                nd.set_attr_float("sample_rate", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_outputs {
                nd.set_attr_int("max_outputs", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AudioSummary::new().build(tag, tensor, scope)`.
pub fn audio_summary<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    tag: O0,
    tensor: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AudioSummary::new().build(tag, tensor, scope)
}
/// Builder for the `AudioSummaryV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AudioSummaryV2 {
    max_outputs: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AudioSummaryV2 {
    /// Creates a new `AudioSummaryV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_outputs` attribute.
    pub fn max_outputs<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_outputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AudioSummaryV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tag: O0,
        tensor: O1,
        sample_rate: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tag.into(), tensor.into(), sample_rate.into(), scope)
    }

    fn build_impl(
        &self,
        tag: crate::Output,
        tensor: crate::Output,
        sample_rate: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AudioSummaryV2", |nd| {
            nd.add_input(tag);
            nd.add_input(tensor);
            nd.add_input(sample_rate);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_outputs {
                nd.set_attr_int("max_outputs", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AudioSummaryV2::new().build(tag, tensor, sample_rate, scope)`.
pub fn audio_summary_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    tag: O0,
    tensor: O1,
    sample_rate: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AudioSummaryV2::new().build(tag, tensor, sample_rate, scope)
}
/// Builder for the `AutoShardDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AutoShardDataset {
    auto_shard_policy: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    num_replicas: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AutoShardDataset {
    /// Creates a new `AutoShardDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `auto_shard_policy` attribute.
    pub fn auto_shard_policy<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.auto_shard_policy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_replicas` attribute.
    pub fn num_replicas<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_replicas = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AutoShardDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        num_workers: O1,
        index: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_dataset.into(),
            num_workers.into(),
            index.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        num_workers: crate::Output,
        index: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AutoShardDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(num_workers);
            nd.add_input(index);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.auto_shard_policy {
                nd.set_attr_int("auto_shard_policy", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_replicas {
                nd.set_attr_int("num_replicas", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AutoShardDataset::new().build(input_dataset, num_workers, index, scope)`.
pub fn auto_shard_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    num_workers: O1,
    index: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AutoShardDataset::new().build(input_dataset, num_workers, index, scope)
}
/// Builder for the `AvgPool` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AvgPool {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AvgPool {
    /// Creates a new `AvgPool`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AvgPool` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        value: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(value.into(), scope)
    }

    fn build_impl(
        &self,
        value: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AvgPool", |nd| {
            nd.add_input(value);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.ksize {
                nd.set_attr_int_list("ksize", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AvgPool::new().build(value, scope)`.
pub fn avg_pool<O0: ::std::convert::Into<crate::Output>>(
    value: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AvgPool::new().build(value, scope)
}
/// Builder for the `AvgPool3D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AvgPool3D {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AvgPool3D {
    /// Creates a new `AvgPool3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AvgPool3D` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AvgPool3D", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.ksize {
                nd.set_attr_int_list("ksize", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AvgPool3D::new().build(input, scope)`.
pub fn avg_pool3_d<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AvgPool3D::new().build(input, scope)
}
/// Builder for the `AvgPool3DGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AvgPool3DGrad {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AvgPool3DGrad {
    /// Creates a new `AvgPool3DGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AvgPool3DGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        orig_input_shape: O0,
        grad: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(orig_input_shape.into(), grad.into(), scope)
    }

    fn build_impl(
        &self,
        orig_input_shape: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AvgPool3DGrad", |nd| {
            nd.add_input(orig_input_shape);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.ksize {
                nd.set_attr_int_list("ksize", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AvgPool3DGrad::new().build(orig_input_shape, grad, scope)`.
pub fn avg_pool3_dgrad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    orig_input_shape: O0,
    grad: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AvgPool3DGrad::new().build(orig_input_shape, grad, scope)
}
/// Builder for the `AvgPoolGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct AvgPoolGrad {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl AvgPoolGrad {
    /// Creates a new `AvgPoolGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `AvgPoolGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        orig_input_shape: O0,
        grad: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(orig_input_shape.into(), grad.into(), scope)
    }

    fn build_impl(
        &self,
        orig_input_shape: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("AvgPoolGrad", |nd| {
            nd.add_input(orig_input_shape);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.ksize {
                nd.set_attr_int_list("ksize", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `AvgPoolGrad::new().build(orig_input_shape, grad, scope)`.
pub fn avg_pool_grad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    orig_input_shape: O0,
    grad: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    AvgPoolGrad::new().build(orig_input_shape, grad, scope)
}
/// Builder for the `BandedTriangularSolve` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BandedTriangularSolve {
    lower: ::std::option::Option<bool>,
    adjoint: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BandedTriangularSolve {
    /// Creates a new `BandedTriangularSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `lower` attribute.
    pub fn lower<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.lower = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BandedTriangularSolve` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        matrix: O0,
        rhs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(matrix.into(), rhs.into(), scope)
    }

    fn build_impl(
        &self,
        matrix: crate::Output,
        rhs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BandedTriangularSolve", |nd| {
            nd.add_input(matrix);
            nd.add_input(rhs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.lower {
                nd.set_attr_bool("lower", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adjoint {
                nd.set_attr_bool("adjoint", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BandedTriangularSolve::new().build(matrix, rhs, scope)`.
pub fn banded_triangular_solve<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    matrix: O0,
    rhs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BandedTriangularSolve::new().build(matrix, rhs, scope)
}
/// Builder for the `Barrier` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Barrier {
    component_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    capacity: ::std::option::Option<i64>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Barrier {
    /// Creates a new `Barrier`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `component_types` attribute.
    pub fn component_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.component_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shapes` attribute.
    pub fn shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `capacity` attribute.
    pub fn capacity<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.capacity = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Barrier` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("Barrier", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.component_types {
                nd.set_attr_type_list("component_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shapes {
                nd.set_attr_shape_list("shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.capacity {
                nd.set_attr_int("capacity", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Barrier::new().build(scope)`.
pub fn barrier(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    Barrier::new().build(scope)
}
/// Builder for the `BarrierClose` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BarrierClose {
    cancel_pending_enqueues: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BarrierClose {
    /// Creates a new `BarrierClose`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `cancel_pending_enqueues` attribute.
    pub fn cancel_pending_enqueues<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.cancel_pending_enqueues = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BarrierClose` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BarrierClose", |nd| {
            nd.add_input(handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.cancel_pending_enqueues {
                nd.set_attr_bool("cancel_pending_enqueues", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BarrierClose::new().build(handle, scope)`.
pub fn barrier_close<O0: ::std::convert::Into<crate::Output>>(
    handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BarrierClose::new().build(handle, scope)
}
/// Builder for the `BarrierIncompleteSize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BarrierIncompleteSize {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BarrierIncompleteSize {
    /// Creates a new `BarrierIncompleteSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BarrierIncompleteSize` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BarrierIncompleteSize", |nd| {
            nd.add_input(handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BarrierIncompleteSize::new().build(handle, scope)`.
pub fn barrier_incomplete_size<O0: ::std::convert::Into<crate::Output>>(
    handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BarrierIncompleteSize::new().build(handle, scope)
}
/// Builder for the `BarrierInsertMany` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BarrierInsertMany {
    T: ::std::option::Option<crate::DataType>,
    component_index: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BarrierInsertMany {
    /// Creates a new `BarrierInsertMany`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `component_index` attribute.
    pub fn component_index<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.component_index = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BarrierInsertMany` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        keys: O1,
        values: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), keys.into(), values.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        keys: crate::Output,
        values: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BarrierInsertMany", |nd| {
            nd.add_input(handle);
            nd.add_input(keys);
            nd.add_input(values);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.component_index {
                nd.set_attr_int("component_index", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BarrierInsertMany::new().build(handle, keys, values, scope)`.
pub fn barrier_insert_many<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    keys: O1,
    values: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BarrierInsertMany::new().build(handle, keys, values, scope)
}
/// Builder for the `BarrierReadySize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BarrierReadySize {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BarrierReadySize {
    /// Creates a new `BarrierReadySize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BarrierReadySize` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BarrierReadySize", |nd| {
            nd.add_input(handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BarrierReadySize::new().build(handle, scope)`.
pub fn barrier_ready_size<O0: ::std::convert::Into<crate::Output>>(
    handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BarrierReadySize::new().build(handle, scope)
}
/// Builder for the `BarrierTakeMany` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BarrierTakeMany {
    component_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    allow_small_batch: ::std::option::Option<bool>,
    wait_for_incomplete: ::std::option::Option<bool>,
    timeout_ms: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BarrierTakeMany {
    /// Creates a new `BarrierTakeMany`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `component_types` attribute.
    pub fn component_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.component_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allow_small_batch` attribute.
    pub fn allow_small_batch<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allow_small_batch = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `wait_for_incomplete` attribute.
    pub fn wait_for_incomplete<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.wait_for_incomplete = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_ms` attribute.
    pub fn timeout_ms<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.timeout_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BarrierTakeMany` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        num_elements: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), num_elements.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        num_elements: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BarrierTakeMany", |nd| {
            nd.add_input(handle);
            nd.add_input(num_elements);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.component_types {
                nd.set_attr_type_list("component_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.allow_small_batch {
                nd.set_attr_bool("allow_small_batch", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.wait_for_incomplete {
                nd.set_attr_bool("wait_for_incomplete", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_ms {
                nd.set_attr_int("timeout_ms", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BarrierTakeMany::new().build(handle, num_elements, scope)`.
pub fn barrier_take_many<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    num_elements: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BarrierTakeMany::new().build(handle, num_elements, scope)
}
/// Builder for the `Batch` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Batch {
    num_batch_threads: ::std::option::Option<i64>,
    max_batch_size: ::std::option::Option<i64>,
    max_enqueued_batches: ::std::option::Option<i64>,
    batch_timeout_micros: ::std::option::Option<i64>,
    allowed_batch_sizes: ::std::option::Option<::std::vec::Vec<i64>>,
    grad_timeout_micros: ::std::option::Option<i64>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    batching_queue: ::std::option::Option<::std::string::String>,
    T: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Batch {
    /// Creates a new `Batch`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_batch_threads` attribute.
    pub fn num_batch_threads<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_batch_threads = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_batch_size` attribute.
    pub fn max_batch_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_batch_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_enqueued_batches` attribute.
    pub fn max_enqueued_batches<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_enqueued_batches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batch_timeout_micros` attribute.
    pub fn batch_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batch_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allowed_batch_sizes` attribute.
    pub fn allowed_batch_sizes<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allowed_batch_sizes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `grad_timeout_micros` attribute.
    pub fn grad_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.grad_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batching_queue` attribute.
    pub fn batching_queue<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batching_queue = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Batch` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        in_tensors: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(in_tensors.into(), scope)
    }

    fn build_impl(
        &self,
        in_tensors: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Batch", |nd| {
            nd.add_input(in_tensors);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_batch_threads {
                nd.set_attr_int("num_batch_threads", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_batch_size {
                nd.set_attr_int("max_batch_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_enqueued_batches {
                nd.set_attr_int("max_enqueued_batches", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.batch_timeout_micros {
                nd.set_attr_int("batch_timeout_micros", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.allowed_batch_sizes {
                nd.set_attr_int_list("allowed_batch_sizes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.grad_timeout_micros {
                nd.set_attr_int("grad_timeout_micros", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.batching_queue {
                nd.set_attr_string("batching_queue", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type_list("T", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Batch::new().build(in_tensors, scope)`.
pub fn batch<O0: ::std::convert::Into<crate::Output>>(
    in_tensors: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Batch::new().build(in_tensors, scope)
}
/// Builder for the `BatchCholesky` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchCholesky {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchCholesky {
    /// Creates a new `BatchCholesky`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchCholesky` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchCholesky", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchCholesky::new().build(input, scope)`.
pub fn batch_cholesky<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchCholesky::new().build(input, scope)
}
/// Builder for the `BatchCholeskyGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchCholeskyGrad {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchCholeskyGrad {
    /// Creates a new `BatchCholeskyGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchCholeskyGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        l: O0,
        grad: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(l.into(), grad.into(), scope)
    }

    fn build_impl(
        &self,
        l: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchCholeskyGrad", |nd| {
            nd.add_input(l);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchCholeskyGrad::new().build(l, grad, scope)`.
pub fn batch_cholesky_grad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    l: O0,
    grad: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchCholeskyGrad::new().build(l, grad, scope)
}
/// Builder for the `BatchDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchDataset {
    /// Creates a new `BatchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        batch_size: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), batch_size.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        batch_size: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(batch_size);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchDataset::new().build(input_dataset, batch_size, scope)`.
pub fn batch_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    batch_size: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchDataset::new().build(input_dataset, batch_size, scope)
}
/// Builder for the `BatchDatasetV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchDatasetV2 {
    parallel_copy: ::std::option::Option<bool>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchDatasetV2 {
    /// Creates a new `BatchDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `parallel_copy` attribute.
    pub fn parallel_copy<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.parallel_copy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchDatasetV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        batch_size: O1,
        drop_remainder: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_dataset.into(),
            batch_size.into(),
            drop_remainder.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        batch_size: crate::Output,
        drop_remainder: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchDatasetV2", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(batch_size);
            nd.add_input(drop_remainder);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.parallel_copy {
                nd.set_attr_bool("parallel_copy", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchDatasetV2::new().build(input_dataset, batch_size, drop_remainder, scope)`.
pub fn batch_dataset_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    batch_size: O1,
    drop_remainder: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchDatasetV2::new().build(input_dataset, batch_size, drop_remainder, scope)
}
/// Builder for the `BatchFFT` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchFFT {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchFFT {
    /// Creates a new `BatchFFT`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchFFT` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchFFT", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchFFT::new().build(input, scope)`.
pub fn batch_fft<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchFFT::new().build(input, scope)
}
/// Builder for the `BatchFFT2D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchFFT2D {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchFFT2D {
    /// Creates a new `BatchFFT2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchFFT2D` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchFFT2D", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchFFT2D::new().build(input, scope)`.
pub fn batch_fft2_d<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchFFT2D::new().build(input, scope)
}
/// Builder for the `BatchFFT3D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchFFT3D {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchFFT3D {
    /// Creates a new `BatchFFT3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchFFT3D` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchFFT3D", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchFFT3D::new().build(input, scope)`.
pub fn batch_fft3_d<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchFFT3D::new().build(input, scope)
}
/// Builder for the `BatchFunction` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchFunction {
    f: ::std::option::Option<::std::string::String>,
    num_batch_threads: ::std::option::Option<i64>,
    max_batch_size: ::std::option::Option<i64>,
    batch_timeout_micros: ::std::option::Option<i64>,
    max_enqueued_batches: ::std::option::Option<i64>,
    allowed_batch_sizes: ::std::option::Option<::std::vec::Vec<i64>>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    batching_queue: ::std::option::Option<::std::string::String>,
    Tin: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    Tcaptured: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    Tout: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    enable_large_batch_splitting: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchFunction {
    /// Creates a new `BatchFunction`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `f` attribute.
    pub fn f<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.f = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_batch_threads` attribute.
    pub fn num_batch_threads<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_batch_threads = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_batch_size` attribute.
    pub fn max_batch_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_batch_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batch_timeout_micros` attribute.
    pub fn batch_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batch_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_enqueued_batches` attribute.
    pub fn max_enqueued_batches<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_enqueued_batches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allowed_batch_sizes` attribute.
    pub fn allowed_batch_sizes<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allowed_batch_sizes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batching_queue` attribute.
    pub fn batching_queue<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batching_queue = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tin` attribute.
    pub fn Tin<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tin = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tcaptured` attribute.
    pub fn Tcaptured<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tcaptured = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `enable_large_batch_splitting` attribute.
    pub fn enable_large_batch_splitting<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.enable_large_batch_splitting = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchFunction` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        in_tensors: O0,
        captured_tensors: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(in_tensors.into(), captured_tensors.into(), scope)
    }

    fn build_impl(
        &self,
        in_tensors: crate::Output,
        captured_tensors: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchFunction", |nd| {
            nd.add_input(in_tensors);
            nd.add_input(captured_tensors);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.f {
                nd.set_attr_string("f", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_batch_threads {
                nd.set_attr_int("num_batch_threads", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_batch_size {
                nd.set_attr_int("max_batch_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.batch_timeout_micros {
                nd.set_attr_int("batch_timeout_micros", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_enqueued_batches {
                nd.set_attr_int("max_enqueued_batches", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.allowed_batch_sizes {
                nd.set_attr_int_list("allowed_batch_sizes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.batching_queue {
                nd.set_attr_string("batching_queue", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tin {
                nd.set_attr_type_list("Tin", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tcaptured {
                nd.set_attr_type_list("Tcaptured", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type_list("Tout", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.enable_large_batch_splitting {
                nd.set_attr_bool("enable_large_batch_splitting", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchFunction::new().build(in_tensors, captured_tensors, scope)`.
pub fn batch_function<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    in_tensors: O0,
    captured_tensors: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchFunction::new().build(in_tensors, captured_tensors, scope)
}
/// Builder for the `BatchIFFT` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchIFFT {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchIFFT {
    /// Creates a new `BatchIFFT`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchIFFT` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchIFFT", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchIFFT::new().build(input, scope)`.
pub fn batch_ifft<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchIFFT::new().build(input, scope)
}
/// Builder for the `BatchIFFT2D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchIFFT2D {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchIFFT2D {
    /// Creates a new `BatchIFFT2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchIFFT2D` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchIFFT2D", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchIFFT2D::new().build(input, scope)`.
pub fn batch_ifft2_d<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchIFFT2D::new().build(input, scope)
}
/// Builder for the `BatchIFFT3D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchIFFT3D {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchIFFT3D {
    /// Creates a new `BatchIFFT3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchIFFT3D` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchIFFT3D", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchIFFT3D::new().build(input, scope)`.
pub fn batch_ifft3_d<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchIFFT3D::new().build(input, scope)
}
/// Builder for the `BatchMatMul` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatMul {
    T: ::std::option::Option<crate::DataType>,
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatMul {
    /// Creates a new `BatchMatMul`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatMul` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatMul", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_x {
                nd.set_attr_bool("adj_x", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_y {
                nd.set_attr_bool("adj_y", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatMul::new().build(x, y, scope)`.
pub fn batch_mat_mul<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatMul::new().build(x, y, scope)
}
/// Builder for the `BatchMatMulV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatMulV2 {
    T: ::std::option::Option<crate::DataType>,
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatMulV2 {
    /// Creates a new `BatchMatMulV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatMulV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatMulV2", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_x {
                nd.set_attr_bool("adj_x", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_y {
                nd.set_attr_bool("adj_y", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatMulV2::new().build(x, y, scope)`.
pub fn batch_mat_mul_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatMulV2::new().build(x, y, scope)
}
/// Builder for the `BatchMatMulV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatMulV3 {
    Ta: ::std::option::Option<crate::DataType>,
    Tb: ::std::option::Option<crate::DataType>,
    Tout: ::std::option::Option<crate::DataType>,
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatMulV3 {
    /// Creates a new `BatchMatMulV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Ta` attribute.
    pub fn Ta<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Ta = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tb` attribute.
    pub fn Tb<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tb = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatMulV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatMulV3", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.Ta {
                nd.set_attr_type("Ta", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tb {
                nd.set_attr_type("Tb", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type("Tout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_x {
                nd.set_attr_bool("adj_x", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adj_y {
                nd.set_attr_bool("adj_y", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatMulV3::new().build(x, y, scope)`.
pub fn batch_mat_mul_v3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatMulV3::new().build(x, y, scope)
}
/// Builder for the `BatchMatrixBandPart` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixBandPart {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixBandPart {
    /// Creates a new `BatchMatrixBandPart`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixBandPart` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        num_lower: O1,
        num_upper: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), num_lower.into(), num_upper.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        num_lower: crate::Output,
        num_upper: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixBandPart", |nd| {
            nd.add_input(input);
            nd.add_input(num_lower);
            nd.add_input(num_upper);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixBandPart::new().build(input, num_lower, num_upper, scope)`.
pub fn batch_matrix_band_part<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    num_lower: O1,
    num_upper: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixBandPart::new().build(input, num_lower, num_upper, scope)
}
/// Builder for the `BatchMatrixDeterminant` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixDeterminant {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixDeterminant {
    /// Creates a new `BatchMatrixDeterminant`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixDeterminant` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixDeterminant", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixDeterminant::new().build(input, scope)`.
pub fn batch_matrix_determinant<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixDeterminant::new().build(input, scope)
}
/// Builder for the `BatchMatrixDiag` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixDiag {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixDiag {
    /// Creates a new `BatchMatrixDiag`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixDiag` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        diagonal: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(diagonal.into(), scope)
    }

    fn build_impl(
        &self,
        diagonal: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixDiag", |nd| {
            nd.add_input(diagonal);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixDiag::new().build(diagonal, scope)`.
pub fn batch_matrix_diag<O0: ::std::convert::Into<crate::Output>>(
    diagonal: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixDiag::new().build(diagonal, scope)
}
/// Builder for the `BatchMatrixDiagPart` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixDiagPart {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixDiagPart {
    /// Creates a new `BatchMatrixDiagPart`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixDiagPart` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixDiagPart", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixDiagPart::new().build(input, scope)`.
pub fn batch_matrix_diag_part<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixDiagPart::new().build(input, scope)
}
/// Builder for the `BatchMatrixInverse` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixInverse {
    adjoint: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixInverse {
    /// Creates a new `BatchMatrixInverse`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixInverse` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixInverse", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.adjoint {
                nd.set_attr_bool("adjoint", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixInverse::new().build(input, scope)`.
pub fn batch_matrix_inverse<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixInverse::new().build(input, scope)
}
/// Builder for the `BatchMatrixSetDiag` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixSetDiag {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixSetDiag {
    /// Creates a new `BatchMatrixSetDiag`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixSetDiag` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        diagonal: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), diagonal.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        diagonal: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixSetDiag", |nd| {
            nd.add_input(input);
            nd.add_input(diagonal);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixSetDiag::new().build(input, diagonal, scope)`.
pub fn batch_matrix_set_diag<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    diagonal: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixSetDiag::new().build(input, diagonal, scope)
}
/// Builder for the `BatchMatrixSolve` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixSolve {
    adjoint: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixSolve {
    /// Creates a new `BatchMatrixSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixSolve` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        matrix: O0,
        rhs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(matrix.into(), rhs.into(), scope)
    }

    fn build_impl(
        &self,
        matrix: crate::Output,
        rhs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixSolve", |nd| {
            nd.add_input(matrix);
            nd.add_input(rhs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.adjoint {
                nd.set_attr_bool("adjoint", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixSolve::new().build(matrix, rhs, scope)`.
pub fn batch_matrix_solve<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    matrix: O0,
    rhs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixSolve::new().build(matrix, rhs, scope)
}
/// Builder for the `BatchMatrixSolveLs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixSolveLs {
    T: ::std::option::Option<crate::DataType>,
    fast: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixSolveLs {
    /// Creates a new `BatchMatrixSolveLs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fast` attribute.
    pub fn fast<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fast = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixSolveLs` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        matrix: O0,
        rhs: O1,
        l2_regularizer: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(matrix.into(), rhs.into(), l2_regularizer.into(), scope)
    }

    fn build_impl(
        &self,
        matrix: crate::Output,
        rhs: crate::Output,
        l2_regularizer: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixSolveLs", |nd| {
            nd.add_input(matrix);
            nd.add_input(rhs);
            nd.add_input(l2_regularizer);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.fast {
                nd.set_attr_bool("fast", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixSolveLs::new().build(matrix, rhs, l2_regularizer, scope)`.
pub fn batch_matrix_solve_ls<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    matrix: O0,
    rhs: O1,
    l2_regularizer: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixSolveLs::new().build(matrix, rhs, l2_regularizer, scope)
}
/// Builder for the `BatchMatrixTriangularSolve` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchMatrixTriangularSolve {
    lower: ::std::option::Option<bool>,
    adjoint: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchMatrixTriangularSolve {
    /// Creates a new `BatchMatrixTriangularSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `lower` attribute.
    pub fn lower<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.lower = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchMatrixTriangularSolve` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        matrix: O0,
        rhs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(matrix.into(), rhs.into(), scope)
    }

    fn build_impl(
        &self,
        matrix: crate::Output,
        rhs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchMatrixTriangularSolve", |nd| {
            nd.add_input(matrix);
            nd.add_input(rhs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.lower {
                nd.set_attr_bool("lower", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.adjoint {
                nd.set_attr_bool("adjoint", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchMatrixTriangularSolve::new().build(matrix, rhs, scope)`.
pub fn batch_matrix_triangular_solve<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    matrix: O0,
    rhs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchMatrixTriangularSolve::new().build(matrix, rhs, scope)
}
/// Builder for the `BatchNormWithGlobalNormalization` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchNormWithGlobalNormalization {
    T: ::std::option::Option<crate::DataType>,
    variance_epsilon: ::std::option::Option<f32>,
    scale_after_normalization: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchNormWithGlobalNormalization {
    /// Creates a new `BatchNormWithGlobalNormalization`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `variance_epsilon` attribute.
    pub fn variance_epsilon<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.variance_epsilon = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scale_after_normalization` attribute.
    pub fn scale_after_normalization<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.scale_after_normalization = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchNormWithGlobalNormalization` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        t: O0,
        m: O1,
        v: O2,
        beta: O3,
        gamma: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            t.into(),
            m.into(),
            v.into(),
            beta.into(),
            gamma.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        t: crate::Output,
        m: crate::Output,
        v: crate::Output,
        beta: crate::Output,
        gamma: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchNormWithGlobalNormalization", |nd| {
            nd.add_input(t);
            nd.add_input(m);
            nd.add_input(v);
            nd.add_input(beta);
            nd.add_input(gamma);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.variance_epsilon {
                nd.set_attr_float("variance_epsilon", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.scale_after_normalization {
                nd.set_attr_bool("scale_after_normalization", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchNormWithGlobalNormalization::new().build(t, m, v, beta, gamma, scope)`.
pub fn batch_norm_with_global_normalization<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    t: O0,
    m: O1,
    v: O2,
    beta: O3,
    gamma: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchNormWithGlobalNormalization::new().build(t, m, v, beta, gamma, scope)
}
/// Builder for the `BatchNormWithGlobalNormalizationGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchNormWithGlobalNormalizationGrad {
    T: ::std::option::Option<crate::DataType>,
    variance_epsilon: ::std::option::Option<f32>,
    scale_after_normalization: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchNormWithGlobalNormalizationGrad {
    /// Creates a new `BatchNormWithGlobalNormalizationGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `variance_epsilon` attribute.
    pub fn variance_epsilon<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.variance_epsilon = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scale_after_normalization` attribute.
    pub fn scale_after_normalization<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.scale_after_normalization = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchNormWithGlobalNormalizationGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        t: O0,
        m: O1,
        v: O2,
        gamma: O3,
        backprop: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            t.into(),
            m.into(),
            v.into(),
            gamma.into(),
            backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        t: crate::Output,
        m: crate::Output,
        v: crate::Output,
        gamma: crate::Output,
        backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchNormWithGlobalNormalizationGrad", |nd| {
            nd.add_input(t);
            nd.add_input(m);
            nd.add_input(v);
            nd.add_input(gamma);
            nd.add_input(backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.variance_epsilon {
                nd.set_attr_float("variance_epsilon", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.scale_after_normalization {
                nd.set_attr_bool("scale_after_normalization", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchNormWithGlobalNormalizationGrad::new().build(t, m, v, gamma, backprop, scope)`.
pub fn batch_norm_with_global_normalization_grad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    t: O0,
    m: O1,
    v: O2,
    gamma: O3,
    backprop: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchNormWithGlobalNormalizationGrad::new().build(t, m, v, gamma, backprop, scope)
}
/// Builder for the `BatchSelfAdjointEig` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchSelfAdjointEig {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchSelfAdjointEig {
    /// Creates a new `BatchSelfAdjointEig`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchSelfAdjointEig` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchSelfAdjointEig", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchSelfAdjointEig::new().build(input, scope)`.
pub fn batch_self_adjoint_eig<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchSelfAdjointEig::new().build(input, scope)
}
/// Builder for the `BatchSelfAdjointEigV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchSelfAdjointEigV2 {
    compute_v: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchSelfAdjointEigV2 {
    /// Creates a new `BatchSelfAdjointEigV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compute_v` attribute.
    pub fn compute_v<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.compute_v = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchSelfAdjointEigV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchSelfAdjointEigV2", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.compute_v {
                nd.set_attr_bool("compute_v", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchSelfAdjointEigV2::new().build(input, scope)`.
pub fn batch_self_adjoint_eig_v2<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchSelfAdjointEigV2::new().build(input, scope)
}
/// Builder for the `BatchSvd` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchSvd {
    compute_uv: ::std::option::Option<bool>,
    full_matrices: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchSvd {
    /// Creates a new `BatchSvd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compute_uv` attribute.
    pub fn compute_uv<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.compute_uv = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `full_matrices` attribute.
    pub fn full_matrices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.full_matrices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchSvd` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchSvd", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.compute_uv {
                nd.set_attr_bool("compute_uv", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.full_matrices {
                nd.set_attr_bool("full_matrices", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchSvd::new().build(input, scope)`.
pub fn batch_svd<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchSvd::new().build(input, scope)
}
/// Builder for the `BatchToSpace` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchToSpace {
    T: ::std::option::Option<crate::DataType>,
    block_size: ::std::option::Option<i64>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchToSpace {
    /// Creates a new `BatchToSpace`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `block_size` attribute.
    pub fn block_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.block_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchToSpace` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        crops: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), crops.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        crops: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchToSpace", |nd| {
            nd.add_input(input);
            nd.add_input(crops);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.block_size {
                nd.set_attr_int("block_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchToSpace::new().build(input, crops, scope)`.
pub fn batch_to_space<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    crops: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchToSpace::new().build(input, crops, scope)
}
/// Builder for the `BatchToSpaceND` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BatchToSpaceND {
    T: ::std::option::Option<crate::DataType>,
    Tblock_shape: ::std::option::Option<crate::DataType>,
    Tcrops: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BatchToSpaceND {
    /// Creates a new `BatchToSpaceND`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tblock_shape` attribute.
    pub fn Tblock_shape<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tblock_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tcrops` attribute.
    pub fn Tcrops<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tcrops = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BatchToSpaceND` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        block_shape: O1,
        crops: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), block_shape.into(), crops.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        block_shape: crate::Output,
        crops: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BatchToSpaceND", |nd| {
            nd.add_input(input);
            nd.add_input(block_shape);
            nd.add_input(crops);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tblock_shape {
                nd.set_attr_type("Tblock_shape", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tcrops {
                nd.set_attr_type("Tcrops", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BatchToSpaceND::new().build(input, block_shape, crops, scope)`.
pub fn batch_to_space_nd<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    block_shape: O1,
    crops: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BatchToSpaceND::new().build(input, block_shape, crops, scope)
}
/// Builder for the `BesselI0` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselI0 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselI0 {
    /// Creates a new `BesselI0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselI0` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselI0", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselI0::new().build(x, scope)`.
pub fn bessel_i0<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselI0::new().build(x, scope)
}
/// Builder for the `BesselI0e` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselI0e {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselI0e {
    /// Creates a new `BesselI0e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselI0e` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselI0e", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselI0e::new().build(x, scope)`.
pub fn bessel_i0e<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselI0e::new().build(x, scope)
}
/// Builder for the `BesselI1` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselI1 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselI1 {
    /// Creates a new `BesselI1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselI1` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselI1", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselI1::new().build(x, scope)`.
pub fn bessel_i1<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselI1::new().build(x, scope)
}
/// Builder for the `BesselI1e` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselI1e {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselI1e {
    /// Creates a new `BesselI1e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselI1e` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselI1e", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselI1e::new().build(x, scope)`.
pub fn bessel_i1e<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselI1e::new().build(x, scope)
}
/// Builder for the `BesselJ0` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselJ0 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselJ0 {
    /// Creates a new `BesselJ0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselJ0` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselJ0", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselJ0::new().build(x, scope)`.
pub fn bessel_j0<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselJ0::new().build(x, scope)
}
/// Builder for the `BesselJ1` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselJ1 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselJ1 {
    /// Creates a new `BesselJ1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselJ1` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselJ1", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselJ1::new().build(x, scope)`.
pub fn bessel_j1<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselJ1::new().build(x, scope)
}
/// Builder for the `BesselK0` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselK0 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselK0 {
    /// Creates a new `BesselK0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselK0` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselK0", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselK0::new().build(x, scope)`.
pub fn bessel_k0<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselK0::new().build(x, scope)
}
/// Builder for the `BesselK0e` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselK0e {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselK0e {
    /// Creates a new `BesselK0e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselK0e` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselK0e", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselK0e::new().build(x, scope)`.
pub fn bessel_k0e<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselK0e::new().build(x, scope)
}
/// Builder for the `BesselK1` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselK1 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselK1 {
    /// Creates a new `BesselK1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselK1` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselK1", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselK1::new().build(x, scope)`.
pub fn bessel_k1<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselK1::new().build(x, scope)
}
/// Builder for the `BesselK1e` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselK1e {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselK1e {
    /// Creates a new `BesselK1e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselK1e` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselK1e", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselK1e::new().build(x, scope)`.
pub fn bessel_k1e<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselK1e::new().build(x, scope)
}
/// Builder for the `BesselY0` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselY0 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselY0 {
    /// Creates a new `BesselY0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselY0` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselY0", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselY0::new().build(x, scope)`.
pub fn bessel_y0<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselY0::new().build(x, scope)
}
/// Builder for the `BesselY1` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BesselY1 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BesselY1 {
    /// Creates a new `BesselY1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BesselY1` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BesselY1", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BesselY1::new().build(x, scope)`.
pub fn bessel_y1<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BesselY1::new().build(x, scope)
}
/// Builder for the `Betainc` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Betainc {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Betainc {
    /// Creates a new `Betainc`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Betainc` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        a: O0,
        b: O1,
        x: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(a.into(), b.into(), x.into(), scope)
    }

    fn build_impl(
        &self,
        a: crate::Output,
        b: crate::Output,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Betainc", |nd| {
            nd.add_input(a);
            nd.add_input(b);
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Betainc::new().build(a, b, x, scope)`.
pub fn betainc<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    a: O0,
    b: O1,
    x: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Betainc::new().build(a, b, x, scope)
}
/// Builder for the `BiasAdd` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BiasAdd {
    T: ::std::option::Option<crate::DataType>,
    data_format: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BiasAdd {
    /// Creates a new `BiasAdd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BiasAdd` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        value: O0,
        bias: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(value.into(), bias.into(), scope)
    }

    fn build_impl(
        &self,
        value: crate::Output,
        bias: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BiasAdd", |nd| {
            nd.add_input(value);
            nd.add_input(bias);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BiasAdd::new().build(value, bias, scope)`.
pub fn bias_add<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    value: O0,
    bias: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BiasAdd::new().build(value, bias, scope)
}
/// Builder for the `BiasAddGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BiasAddGrad {
    T: ::std::option::Option<crate::DataType>,
    data_format: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BiasAddGrad {
    /// Creates a new `BiasAddGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BiasAddGrad` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        out_backprop: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(out_backprop.into(), scope)
    }

    fn build_impl(
        &self,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BiasAddGrad", |nd| {
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BiasAddGrad::new().build(out_backprop, scope)`.
pub fn bias_add_grad<O0: ::std::convert::Into<crate::Output>>(
    out_backprop: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BiasAddGrad::new().build(out_backprop, scope)
}
/// Builder for the `BiasAddV1` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BiasAddV1 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BiasAddV1 {
    /// Creates a new `BiasAddV1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BiasAddV1` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        value: O0,
        bias: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(value.into(), bias.into(), scope)
    }

    fn build_impl(
        &self,
        value: crate::Output,
        bias: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BiasAddV1", |nd| {
            nd.add_input(value);
            nd.add_input(bias);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BiasAddV1::new().build(value, bias, scope)`.
pub fn bias_add_v1<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    value: O0,
    bias: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BiasAddV1::new().build(value, bias, scope)
}
/// Builder for the `Bincount` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Bincount {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Bincount {
    /// Creates a new `Bincount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Bincount` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        arr: O0,
        size: O1,
        weights: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(arr.into(), size.into(), weights.into(), scope)
    }

    fn build_impl(
        &self,
        arr: crate::Output,
        size: crate::Output,
        weights: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Bincount", |nd| {
            nd.add_input(arr);
            nd.add_input(size);
            nd.add_input(weights);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Bincount::new().build(arr, size, weights, scope)`.
pub fn bincount<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    arr: O0,
    size: O1,
    weights: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Bincount::new().build(arr, size, weights, scope)
}
/// Builder for the `Bitcast` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Bitcast {
    T: ::std::option::Option<crate::DataType>,
    type_: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Bitcast {
    /// Creates a new `Bitcast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Bitcast` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Bitcast", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.type_ {
                nd.set_attr_type("type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Bitcast::new().build(input, scope)`.
pub fn bitcast<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Bitcast::new().build(input, scope)
}
/// Builder for the `BitwiseAnd` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BitwiseAnd {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BitwiseAnd {
    /// Creates a new `BitwiseAnd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BitwiseAnd` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BitwiseAnd", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BitwiseAnd::new().build(x, y, scope)`.
pub fn bitwise_and<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BitwiseAnd::new().build(x, y, scope)
}
/// Builder for the `BitwiseOr` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BitwiseOr {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BitwiseOr {
    /// Creates a new `BitwiseOr`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BitwiseOr` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BitwiseOr", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BitwiseOr::new().build(x, y, scope)`.
pub fn bitwise_or<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BitwiseOr::new().build(x, y, scope)
}
/// Builder for the `BitwiseXor` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BitwiseXor {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BitwiseXor {
    /// Creates a new `BitwiseXor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BitwiseXor` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BitwiseXor", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BitwiseXor::new().build(x, y, scope)`.
pub fn bitwise_xor<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BitwiseXor::new().build(x, y, scope)
}
/// Builder for the `BlockLSTM` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BlockLSTM {
    forget_bias: ::std::option::Option<f32>,
    cell_clip: ::std::option::Option<f32>,
    use_peephole: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BlockLSTM {
    /// Creates a new `BlockLSTM`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `forget_bias` attribute.
    pub fn forget_bias<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.forget_bias = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `cell_clip` attribute.
    pub fn cell_clip<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.cell_clip = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BlockLSTM` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seq_len_max: O0,
        x: O1,
        cs_prev: O2,
        h_prev: O3,
        w: O4,
        wci: O5,
        wcf: O6,
        wco: O7,
        b: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            seq_len_max.into(),
            x.into(),
            cs_prev.into(),
            h_prev.into(),
            w.into(),
            wci.into(),
            wcf.into(),
            wco.into(),
            b.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        seq_len_max: crate::Output,
        x: crate::Output,
        cs_prev: crate::Output,
        h_prev: crate::Output,
        w: crate::Output,
        wci: crate::Output,
        wcf: crate::Output,
        wco: crate::Output,
        b: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BlockLSTM", |nd| {
            nd.add_input(seq_len_max);
            nd.add_input(x);
            nd.add_input(cs_prev);
            nd.add_input(h_prev);
            nd.add_input(w);
            nd.add_input(wci);
            nd.add_input(wcf);
            nd.add_input(wco);
            nd.add_input(b);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.forget_bias {
                nd.set_attr_float("forget_bias", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.cell_clip {
                nd.set_attr_float("cell_clip", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_peephole {
                nd.set_attr_bool("use_peephole", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BlockLSTM::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, scope)`.
pub fn block_lstm<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    seq_len_max: O0,
    x: O1,
    cs_prev: O2,
    h_prev: O3,
    w: O4,
    wci: O5,
    wcf: O6,
    wco: O7,
    b: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BlockLSTM::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, scope)
}
/// Builder for the `BlockLSTMGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BlockLSTMGrad {
    use_peephole: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BlockLSTMGrad {
    /// Creates a new `BlockLSTMGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BlockLSTMGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
        O11: ::std::convert::Into<crate::Output>,
        O12: ::std::convert::Into<crate::Output>,
        O13: ::std::convert::Into<crate::Output>,
        O14: ::std::convert::Into<crate::Output>,
        O15: ::std::convert::Into<crate::Output>,
        O16: ::std::convert::Into<crate::Output>,
        O17: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seq_len_max: O0,
        x: O1,
        cs_prev: O2,
        h_prev: O3,
        w: O4,
        wci: O5,
        wcf: O6,
        wco: O7,
        b: O8,
        i: O9,
        cs: O10,
        f: O11,
        o: O12,
        ci: O13,
        co: O14,
        h: O15,
        cs_grad: O16,
        h_grad: O17,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            seq_len_max.into(),
            x.into(),
            cs_prev.into(),
            h_prev.into(),
            w.into(),
            wci.into(),
            wcf.into(),
            wco.into(),
            b.into(),
            i.into(),
            cs.into(),
            f.into(),
            o.into(),
            ci.into(),
            co.into(),
            h.into(),
            cs_grad.into(),
            h_grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        seq_len_max: crate::Output,
        x: crate::Output,
        cs_prev: crate::Output,
        h_prev: crate::Output,
        w: crate::Output,
        wci: crate::Output,
        wcf: crate::Output,
        wco: crate::Output,
        b: crate::Output,
        i: crate::Output,
        cs: crate::Output,
        f: crate::Output,
        o: crate::Output,
        ci: crate::Output,
        co: crate::Output,
        h: crate::Output,
        cs_grad: crate::Output,
        h_grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BlockLSTMGrad", |nd| {
            nd.add_input(seq_len_max);
            nd.add_input(x);
            nd.add_input(cs_prev);
            nd.add_input(h_prev);
            nd.add_input(w);
            nd.add_input(wci);
            nd.add_input(wcf);
            nd.add_input(wco);
            nd.add_input(b);
            nd.add_input(i);
            nd.add_input(cs);
            nd.add_input(f);
            nd.add_input(o);
            nd.add_input(ci);
            nd.add_input(co);
            nd.add_input(h);
            nd.add_input(cs_grad);
            nd.add_input(h_grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.use_peephole {
                nd.set_attr_bool("use_peephole", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BlockLSTMGrad::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad, scope)`.
pub fn block_lstmgrad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
    O11: ::std::convert::Into<crate::Output>,
    O12: ::std::convert::Into<crate::Output>,
    O13: ::std::convert::Into<crate::Output>,
    O14: ::std::convert::Into<crate::Output>,
    O15: ::std::convert::Into<crate::Output>,
    O16: ::std::convert::Into<crate::Output>,
    O17: ::std::convert::Into<crate::Output>,
>(
    seq_len_max: O0,
    x: O1,
    cs_prev: O2,
    h_prev: O3,
    w: O4,
    wci: O5,
    wcf: O6,
    wco: O7,
    b: O8,
    i: O9,
    cs: O10,
    f: O11,
    o: O12,
    ci: O13,
    co: O14,
    h: O15,
    cs_grad: O16,
    h_grad: O17,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BlockLSTMGrad::new().build(
        seq_len_max,
        x,
        cs_prev,
        h_prev,
        w,
        wci,
        wcf,
        wco,
        b,
        i,
        cs,
        f,
        o,
        ci,
        co,
        h,
        cs_grad,
        h_grad,
        scope,
    )
}
/// Builder for the `BlockLSTMGradV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BlockLSTMGradV2 {
    use_peephole: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BlockLSTMGradV2 {
    /// Creates a new `BlockLSTMGradV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BlockLSTMGradV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
        O11: ::std::convert::Into<crate::Output>,
        O12: ::std::convert::Into<crate::Output>,
        O13: ::std::convert::Into<crate::Output>,
        O14: ::std::convert::Into<crate::Output>,
        O15: ::std::convert::Into<crate::Output>,
        O16: ::std::convert::Into<crate::Output>,
        O17: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seq_len_max: O0,
        x: O1,
        cs_prev: O2,
        h_prev: O3,
        w: O4,
        wci: O5,
        wcf: O6,
        wco: O7,
        b: O8,
        i: O9,
        cs: O10,
        f: O11,
        o: O12,
        ci: O13,
        co: O14,
        h: O15,
        cs_grad: O16,
        h_grad: O17,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            seq_len_max.into(),
            x.into(),
            cs_prev.into(),
            h_prev.into(),
            w.into(),
            wci.into(),
            wcf.into(),
            wco.into(),
            b.into(),
            i.into(),
            cs.into(),
            f.into(),
            o.into(),
            ci.into(),
            co.into(),
            h.into(),
            cs_grad.into(),
            h_grad.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        seq_len_max: crate::Output,
        x: crate::Output,
        cs_prev: crate::Output,
        h_prev: crate::Output,
        w: crate::Output,
        wci: crate::Output,
        wcf: crate::Output,
        wco: crate::Output,
        b: crate::Output,
        i: crate::Output,
        cs: crate::Output,
        f: crate::Output,
        o: crate::Output,
        ci: crate::Output,
        co: crate::Output,
        h: crate::Output,
        cs_grad: crate::Output,
        h_grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BlockLSTMGradV2", |nd| {
            nd.add_input(seq_len_max);
            nd.add_input(x);
            nd.add_input(cs_prev);
            nd.add_input(h_prev);
            nd.add_input(w);
            nd.add_input(wci);
            nd.add_input(wcf);
            nd.add_input(wco);
            nd.add_input(b);
            nd.add_input(i);
            nd.add_input(cs);
            nd.add_input(f);
            nd.add_input(o);
            nd.add_input(ci);
            nd.add_input(co);
            nd.add_input(h);
            nd.add_input(cs_grad);
            nd.add_input(h_grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.use_peephole {
                nd.set_attr_bool("use_peephole", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BlockLSTMGradV2::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, i, cs, f, o, ci, co, h, cs_grad, h_grad, scope)`.
pub fn block_lstmgrad_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
    O11: ::std::convert::Into<crate::Output>,
    O12: ::std::convert::Into<crate::Output>,
    O13: ::std::convert::Into<crate::Output>,
    O14: ::std::convert::Into<crate::Output>,
    O15: ::std::convert::Into<crate::Output>,
    O16: ::std::convert::Into<crate::Output>,
    O17: ::std::convert::Into<crate::Output>,
>(
    seq_len_max: O0,
    x: O1,
    cs_prev: O2,
    h_prev: O3,
    w: O4,
    wci: O5,
    wcf: O6,
    wco: O7,
    b: O8,
    i: O9,
    cs: O10,
    f: O11,
    o: O12,
    ci: O13,
    co: O14,
    h: O15,
    cs_grad: O16,
    h_grad: O17,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BlockLSTMGradV2::new().build(
        seq_len_max,
        x,
        cs_prev,
        h_prev,
        w,
        wci,
        wcf,
        wco,
        b,
        i,
        cs,
        f,
        o,
        ci,
        co,
        h,
        cs_grad,
        h_grad,
        scope,
    )
}
/// Builder for the `BlockLSTMV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BlockLSTMV2 {
    cell_clip: ::std::option::Option<f32>,
    use_peephole: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BlockLSTMV2 {
    /// Creates a new `BlockLSTMV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `cell_clip` attribute.
    pub fn cell_clip<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.cell_clip = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BlockLSTMV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        seq_len_max: O0,
        x: O1,
        cs_prev: O2,
        h_prev: O3,
        w: O4,
        wci: O5,
        wcf: O6,
        wco: O7,
        b: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            seq_len_max.into(),
            x.into(),
            cs_prev.into(),
            h_prev.into(),
            w.into(),
            wci.into(),
            wcf.into(),
            wco.into(),
            b.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        seq_len_max: crate::Output,
        x: crate::Output,
        cs_prev: crate::Output,
        h_prev: crate::Output,
        w: crate::Output,
        wci: crate::Output,
        wcf: crate::Output,
        wco: crate::Output,
        b: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BlockLSTMV2", |nd| {
            nd.add_input(seq_len_max);
            nd.add_input(x);
            nd.add_input(cs_prev);
            nd.add_input(h_prev);
            nd.add_input(w);
            nd.add_input(wci);
            nd.add_input(wcf);
            nd.add_input(wco);
            nd.add_input(b);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.cell_clip {
                nd.set_attr_float("cell_clip", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_peephole {
                nd.set_attr_bool("use_peephole", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BlockLSTMV2::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, scope)`.
pub fn block_lstmv2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    seq_len_max: O0,
    x: O1,
    cs_prev: O2,
    h_prev: O3,
    w: O4,
    wci: O5,
    wcf: O6,
    wco: O7,
    b: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BlockLSTMV2::new().build(seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b, scope)
}
/// Builder for the `BoostedTreesAggregateStats` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesAggregateStats {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesAggregateStats {
    /// Creates a new `BoostedTreesAggregateStats`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesAggregateStats` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_ids: O0,
        gradients: O1,
        hessians: O2,
        feature: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_ids.into(),
            gradients.into(),
            hessians.into(),
            feature.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_ids: crate::Output,
        gradients: crate::Output,
        hessians: crate::Output,
        feature: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesAggregateStats", |nd| {
            nd.add_input(node_ids);
            nd.add_input(gradients);
            nd.add_input(hessians);
            nd.add_input(feature);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_splits {
                nd.set_attr_int("max_splits", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_buckets {
                nd.set_attr_int("num_buckets", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesAggregateStats::new().build(node_ids, gradients, hessians, feature, scope)`.
pub fn boosted_trees_aggregate_stats<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    node_ids: O0,
    gradients: O1,
    hessians: O2,
    feature: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesAggregateStats::new().build(node_ids, gradients, hessians, feature, scope)
}
/// Builder for the `BoostedTreesBucketize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesBucketize {
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesBucketize {
    /// Creates a new `BoostedTreesBucketize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesBucketize` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        float_values: O0,
        bucket_boundaries: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(float_values.into(), bucket_boundaries.into(), scope)
    }

    fn build_impl(
        &self,
        float_values: crate::Output,
        bucket_boundaries: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesBucketize", |nd| {
            nd.add_input(float_values);
            nd.add_input(bucket_boundaries);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesBucketize::new().build(float_values, bucket_boundaries, scope)`.
pub fn boosted_trees_bucketize<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    float_values: O0,
    bucket_boundaries: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesBucketize::new().build(float_values, bucket_boundaries, scope)
}
/// Builder for the `BoostedTreesCalculateBestFeatureSplit` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCalculateBestFeatureSplit {
    logits_dimension: ::std::option::Option<i64>,
    split_type: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCalculateBestFeatureSplit {
    /// Creates a new `BoostedTreesCalculateBestFeatureSplit`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_type` attribute.
    pub fn split_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.split_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCalculateBestFeatureSplit` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_id_range: O0,
        stats_summary: O1,
        l1: O2,
        l2: O3,
        tree_complexity: O4,
        min_node_weight: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_id_range.into(),
            stats_summary.into(),
            l1.into(),
            l2.into(),
            tree_complexity.into(),
            min_node_weight.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_id_range: crate::Output,
        stats_summary: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        tree_complexity: crate::Output,
        min_node_weight: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCalculateBestFeatureSplit", |nd| {
            nd.add_input(node_id_range);
            nd.add_input(stats_summary);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(tree_complexity);
            nd.add_input(min_node_weight);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.split_type {
                nd.set_attr_string("split_type", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCalculateBestFeatureSplit::new().build(node_id_range, stats_summary, l1, l2, tree_complexity, min_node_weight, scope)`.
pub fn boosted_trees_calculate_best_feature_split<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    node_id_range: O0,
    stats_summary: O1,
    l1: O2,
    l2: O3,
    tree_complexity: O4,
    min_node_weight: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCalculateBestFeatureSplit::new().build(
        node_id_range,
        stats_summary,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
        scope,
    )
}
/// Builder for the `BoostedTreesCalculateBestFeatureSplitV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCalculateBestFeatureSplitV2 {
    num_features: ::std::option::Option<i64>,
    logits_dimension: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCalculateBestFeatureSplitV2 {
    /// Creates a new `BoostedTreesCalculateBestFeatureSplitV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCalculateBestFeatureSplitV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_id_range: O0,
        stats_summaries_list: O1,
        split_types: O2,
        candidate_feature_ids: O3,
        l1: O4,
        l2: O5,
        tree_complexity: O6,
        min_node_weight: O7,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_id_range.into(),
            stats_summaries_list.into(),
            split_types.into(),
            candidate_feature_ids.into(),
            l1.into(),
            l2.into(),
            tree_complexity.into(),
            min_node_weight.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_id_range: crate::Output,
        stats_summaries_list: crate::Output,
        split_types: crate::Output,
        candidate_feature_ids: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        tree_complexity: crate::Output,
        min_node_weight: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCalculateBestFeatureSplitV2", |nd| {
            nd.add_input(node_id_range);
            nd.add_input(stats_summaries_list);
            nd.add_input(split_types);
            nd.add_input(candidate_feature_ids);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(tree_complexity);
            nd.add_input(min_node_weight);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCalculateBestFeatureSplitV2::new().build(node_id_range, stats_summaries_list, split_types, candidate_feature_ids, l1, l2, tree_complexity, min_node_weight, scope)`.
pub fn boosted_trees_calculate_best_feature_split_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
>(
    node_id_range: O0,
    stats_summaries_list: O1,
    split_types: O2,
    candidate_feature_ids: O3,
    l1: O4,
    l2: O5,
    tree_complexity: O6,
    min_node_weight: O7,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCalculateBestFeatureSplitV2::new().build(
        node_id_range,
        stats_summaries_list,
        split_types,
        candidate_feature_ids,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
        scope,
    )
}
/// Builder for the `BoostedTreesCalculateBestGainsPerFeature` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCalculateBestGainsPerFeature {
    max_splits: ::std::option::Option<i64>,
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCalculateBestGainsPerFeature {
    /// Creates a new `BoostedTreesCalculateBestGainsPerFeature`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCalculateBestGainsPerFeature` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_id_range: O0,
        stats_summary_list: O1,
        l1: O2,
        l2: O3,
        tree_complexity: O4,
        min_node_weight: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_id_range.into(),
            stats_summary_list.into(),
            l1.into(),
            l2.into(),
            tree_complexity.into(),
            min_node_weight.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_id_range: crate::Output,
        stats_summary_list: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        tree_complexity: crate::Output,
        min_node_weight: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCalculateBestGainsPerFeature", |nd| {
            nd.add_input(node_id_range);
            nd.add_input(stats_summary_list);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(tree_complexity);
            nd.add_input(min_node_weight);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_splits {
                nd.set_attr_int("max_splits", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCalculateBestGainsPerFeature::new().build(node_id_range, stats_summary_list, l1, l2, tree_complexity, min_node_weight, scope)`.
pub fn boosted_trees_calculate_best_gains_per_feature<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    node_id_range: O0,
    stats_summary_list: O1,
    l1: O2,
    l2: O3,
    tree_complexity: O4,
    min_node_weight: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCalculateBestGainsPerFeature::new().build(
        node_id_range,
        stats_summary_list,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
        scope,
    )
}
/// Builder for the `BoostedTreesCenterBias` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCenterBias {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCenterBias {
    /// Creates a new `BoostedTreesCenterBias`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCenterBias` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        mean_gradients: O1,
        mean_hessians: O2,
        l1: O3,
        l2: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            mean_gradients.into(),
            mean_hessians.into(),
            l1.into(),
            l2.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        mean_gradients: crate::Output,
        mean_hessians: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCenterBias", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(mean_gradients);
            nd.add_input(mean_hessians);
            nd.add_input(l1);
            nd.add_input(l2);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCenterBias::new().build(tree_ensemble_handle, mean_gradients, mean_hessians, l1, l2, scope)`.
pub fn boosted_trees_center_bias<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    mean_gradients: O1,
    mean_hessians: O2,
    l1: O3,
    l2: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCenterBias::new().build(
        tree_ensemble_handle,
        mean_gradients,
        mean_hessians,
        l1,
        l2,
        scope,
    )
}
/// Builder for the `BoostedTreesCreateEnsemble` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCreateEnsemble {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCreateEnsemble {
    /// Creates a new `BoostedTreesCreateEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCreateEnsemble` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        stamp_token: O1,
        tree_ensemble_serialized: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            stamp_token.into(),
            tree_ensemble_serialized.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        stamp_token: crate::Output,
        tree_ensemble_serialized: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCreateEnsemble", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(stamp_token);
            nd.add_input(tree_ensemble_serialized);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCreateEnsemble::new().build(tree_ensemble_handle, stamp_token, tree_ensemble_serialized, scope)`.
pub fn boosted_trees_create_ensemble<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    stamp_token: O1,
    tree_ensemble_serialized: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCreateEnsemble::new().build(
        tree_ensemble_handle,
        stamp_token,
        tree_ensemble_serialized,
        scope,
    )
}
/// Builder for the `BoostedTreesCreateQuantileStreamResource` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesCreateQuantileStreamResource {
    max_elements: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesCreateQuantileStreamResource {
    /// Creates a new `BoostedTreesCreateQuantileStreamResource`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_elements` attribute.
    pub fn max_elements<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_elements = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesCreateQuantileStreamResource` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        quantile_stream_resource_handle: O0,
        epsilon: O1,
        num_streams: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            quantile_stream_resource_handle.into(),
            epsilon.into(),
            num_streams.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        epsilon: crate::Output,
        num_streams: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesCreateQuantileStreamResource", |nd| {
            nd.add_input(quantile_stream_resource_handle);
            nd.add_input(epsilon);
            nd.add_input(num_streams);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_elements {
                nd.set_attr_int("max_elements", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesCreateQuantileStreamResource::new().build(quantile_stream_resource_handle, epsilon, num_streams, scope)`.
pub fn boosted_trees_create_quantile_stream_resource<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    quantile_stream_resource_handle: O0,
    epsilon: O1,
    num_streams: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesCreateQuantileStreamResource::new().build(
        quantile_stream_resource_handle,
        epsilon,
        num_streams,
        scope,
    )
}
/// Builder for the `BoostedTreesDeserializeEnsemble` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesDeserializeEnsemble {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesDeserializeEnsemble {
    /// Creates a new `BoostedTreesDeserializeEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesDeserializeEnsemble` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        stamp_token: O1,
        tree_ensemble_serialized: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            stamp_token.into(),
            tree_ensemble_serialized.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        stamp_token: crate::Output,
        tree_ensemble_serialized: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesDeserializeEnsemble", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(stamp_token);
            nd.add_input(tree_ensemble_serialized);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesDeserializeEnsemble::new().build(tree_ensemble_handle, stamp_token, tree_ensemble_serialized, scope)`.
pub fn boosted_trees_deserialize_ensemble<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    stamp_token: O1,
    tree_ensemble_serialized: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesDeserializeEnsemble::new().build(
        tree_ensemble_handle,
        stamp_token,
        tree_ensemble_serialized,
        scope,
    )
}
/// Builder for the `BoostedTreesEnsembleResourceHandleOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesEnsembleResourceHandleOp {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesEnsembleResourceHandleOp {
    /// Creates a new `BoostedTreesEnsembleResourceHandleOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesEnsembleResourceHandleOp` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesEnsembleResourceHandleOp", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesEnsembleResourceHandleOp::new().build(scope)`.
pub fn boosted_trees_ensemble_resource_handle_op(
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesEnsembleResourceHandleOp::new().build(scope)
}
/// Builder for the `BoostedTreesExampleDebugOutputs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesExampleDebugOutputs {
    num_bucketized_features: ::std::option::Option<i64>,
    logits_dimension: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesExampleDebugOutputs {
    /// Creates a new `BoostedTreesExampleDebugOutputs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_bucketized_features` attribute.
    pub fn num_bucketized_features<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_bucketized_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesExampleDebugOutputs` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        bucketized_features: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            bucketized_features.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        bucketized_features: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesExampleDebugOutputs", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(bucketized_features);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_bucketized_features {
                nd.set_attr_int("num_bucketized_features", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesExampleDebugOutputs::new().build(tree_ensemble_handle, bucketized_features, scope)`.
pub fn boosted_trees_example_debug_outputs<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    bucketized_features: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesExampleDebugOutputs::new().build(tree_ensemble_handle, bucketized_features, scope)
}
/// Builder for the `BoostedTreesFlushQuantileSummaries` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesFlushQuantileSummaries {
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesFlushQuantileSummaries {
    /// Creates a new `BoostedTreesFlushQuantileSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesFlushQuantileSummaries` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        quantile_stream_resource_handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(quantile_stream_resource_handle.into(), scope)
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesFlushQuantileSummaries", |nd| {
            nd.add_input(quantile_stream_resource_handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesFlushQuantileSummaries::new().build(quantile_stream_resource_handle, scope)`.
pub fn boosted_trees_flush_quantile_summaries<O0: ::std::convert::Into<crate::Output>>(
    quantile_stream_resource_handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesFlushQuantileSummaries::new().build(quantile_stream_resource_handle, scope)
}
/// Builder for the `BoostedTreesGetEnsembleStates` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesGetEnsembleStates {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesGetEnsembleStates {
    /// Creates a new `BoostedTreesGetEnsembleStates`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesGetEnsembleStates` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        tree_ensemble_handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tree_ensemble_handle.into(), scope)
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesGetEnsembleStates", |nd| {
            nd.add_input(tree_ensemble_handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesGetEnsembleStates::new().build(tree_ensemble_handle, scope)`.
pub fn boosted_trees_get_ensemble_states<O0: ::std::convert::Into<crate::Output>>(
    tree_ensemble_handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesGetEnsembleStates::new().build(tree_ensemble_handle, scope)
}
/// Builder for the `BoostedTreesMakeQuantileSummaries` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesMakeQuantileSummaries {
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesMakeQuantileSummaries {
    /// Creates a new `BoostedTreesMakeQuantileSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesMakeQuantileSummaries` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        float_values: O0,
        example_weights: O1,
        epsilon: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            float_values.into(),
            example_weights.into(),
            epsilon.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        float_values: crate::Output,
        example_weights: crate::Output,
        epsilon: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesMakeQuantileSummaries", |nd| {
            nd.add_input(float_values);
            nd.add_input(example_weights);
            nd.add_input(epsilon);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesMakeQuantileSummaries::new().build(float_values, example_weights, epsilon, scope)`.
pub fn boosted_trees_make_quantile_summaries<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    float_values: O0,
    example_weights: O1,
    epsilon: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesMakeQuantileSummaries::new().build(float_values, example_weights, epsilon, scope)
}
/// Builder for the `BoostedTreesMakeStatsSummary` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesMakeStatsSummary {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesMakeStatsSummary {
    /// Creates a new `BoostedTreesMakeStatsSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesMakeStatsSummary` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_ids: O0,
        gradients: O1,
        hessians: O2,
        bucketized_features_list: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_ids.into(),
            gradients.into(),
            hessians.into(),
            bucketized_features_list.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_ids: crate::Output,
        gradients: crate::Output,
        hessians: crate::Output,
        bucketized_features_list: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesMakeStatsSummary", |nd| {
            nd.add_input(node_ids);
            nd.add_input(gradients);
            nd.add_input(hessians);
            nd.add_input(bucketized_features_list);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_splits {
                nd.set_attr_int("max_splits", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_buckets {
                nd.set_attr_int("num_buckets", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesMakeStatsSummary::new().build(node_ids, gradients, hessians, bucketized_features_list, scope)`.
pub fn boosted_trees_make_stats_summary<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    node_ids: O0,
    gradients: O1,
    hessians: O2,
    bucketized_features_list: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesMakeStatsSummary::new().build(
        node_ids,
        gradients,
        hessians,
        bucketized_features_list,
        scope,
    )
}
/// Builder for the `BoostedTreesPredict` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesPredict {
    num_bucketized_features: ::std::option::Option<i64>,
    logits_dimension: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesPredict {
    /// Creates a new `BoostedTreesPredict`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_bucketized_features` attribute.
    pub fn num_bucketized_features<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_bucketized_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesPredict` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        bucketized_features: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            bucketized_features.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        bucketized_features: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesPredict", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(bucketized_features);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_bucketized_features {
                nd.set_attr_int("num_bucketized_features", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesPredict::new().build(tree_ensemble_handle, bucketized_features, scope)`.
pub fn boosted_trees_predict<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    bucketized_features: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesPredict::new().build(tree_ensemble_handle, bucketized_features, scope)
}
/// Builder for the `BoostedTreesQuantileStreamResourceAddSummaries` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesQuantileStreamResourceAddSummaries {
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesQuantileStreamResourceAddSummaries {
    /// Creates a new `BoostedTreesQuantileStreamResourceAddSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesQuantileStreamResourceAddSummaries` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        quantile_stream_resource_handle: O0,
        summaries: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            quantile_stream_resource_handle.into(),
            summaries.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        summaries: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesQuantileStreamResourceAddSummaries", |nd| {
            nd.add_input(quantile_stream_resource_handle);
            nd.add_input(summaries);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceAddSummaries::new().build(quantile_stream_resource_handle, summaries, scope)`.
pub fn boosted_trees_quantile_stream_resource_add_summaries<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    quantile_stream_resource_handle: O0,
    summaries: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesQuantileStreamResourceAddSummaries::new().build(
        quantile_stream_resource_handle,
        summaries,
        scope,
    )
}
/// Builder for the `BoostedTreesQuantileStreamResourceDeserialize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesQuantileStreamResourceDeserialize {
    num_streams: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesQuantileStreamResourceDeserialize {
    /// Creates a new `BoostedTreesQuantileStreamResourceDeserialize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_streams` attribute.
    pub fn num_streams<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_streams = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesQuantileStreamResourceDeserialize` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        quantile_stream_resource_handle: O0,
        bucket_boundaries: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            quantile_stream_resource_handle.into(),
            bucket_boundaries.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        bucket_boundaries: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesQuantileStreamResourceDeserialize", |nd| {
            nd.add_input(quantile_stream_resource_handle);
            nd.add_input(bucket_boundaries);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_streams {
                nd.set_attr_int("num_streams", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceDeserialize::new().build(quantile_stream_resource_handle, bucket_boundaries, scope)`.
pub fn boosted_trees_quantile_stream_resource_deserialize<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    quantile_stream_resource_handle: O0,
    bucket_boundaries: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesQuantileStreamResourceDeserialize::new().build(
        quantile_stream_resource_handle,
        bucket_boundaries,
        scope,
    )
}
/// Builder for the `BoostedTreesQuantileStreamResourceFlush` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesQuantileStreamResourceFlush {
    generate_quantiles: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesQuantileStreamResourceFlush {
    /// Creates a new `BoostedTreesQuantileStreamResourceFlush`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `generate_quantiles` attribute.
    pub fn generate_quantiles<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.generate_quantiles = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesQuantileStreamResourceFlush` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        quantile_stream_resource_handle: O0,
        num_buckets: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            quantile_stream_resource_handle.into(),
            num_buckets.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        num_buckets: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesQuantileStreamResourceFlush", |nd| {
            nd.add_input(quantile_stream_resource_handle);
            nd.add_input(num_buckets);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.generate_quantiles {
                nd.set_attr_bool("generate_quantiles", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceFlush::new().build(quantile_stream_resource_handle, num_buckets, scope)`.
pub fn boosted_trees_quantile_stream_resource_flush<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    quantile_stream_resource_handle: O0,
    num_buckets: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesQuantileStreamResourceFlush::new().build(
        quantile_stream_resource_handle,
        num_buckets,
        scope,
    )
}
/// Builder for the `BoostedTreesQuantileStreamResourceGetBucketBoundaries` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesQuantileStreamResourceGetBucketBoundaries {
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesQuantileStreamResourceGetBucketBoundaries {
    /// Creates a new `BoostedTreesQuantileStreamResourceGetBucketBoundaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesQuantileStreamResourceGetBucketBoundaries` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        quantile_stream_resource_handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(quantile_stream_resource_handle.into(), scope)
    }

    fn build_impl(
        &self,
        quantile_stream_resource_handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation(
            "BoostedTreesQuantileStreamResourceGetBucketBoundaries",
            |nd| {
                nd.add_input(quantile_stream_resource_handle);
                for op in &self.control_inputs {
                    nd.add_control_input(op);
                }
                if let ::std::option::Option::Some(value) = &self.num_features {
                    nd.set_attr_int("num_features", *value)?;
                }
                ::std::result::Result::Ok(())
            },
        )
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceGetBucketBoundaries::new().build(quantile_stream_resource_handle, scope)`.
pub fn boosted_trees_quantile_stream_resource_get_bucket_boundaries<
    O0: ::std::convert::Into<crate::Output>,
>(
    quantile_stream_resource_handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesQuantileStreamResourceGetBucketBoundaries::new()
        .build(quantile_stream_resource_handle, scope)
}
/// Builder for the `BoostedTreesQuantileStreamResourceHandleOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesQuantileStreamResourceHandleOp {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesQuantileStreamResourceHandleOp {
    /// Creates a new `BoostedTreesQuantileStreamResourceHandleOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesQuantileStreamResourceHandleOp` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesQuantileStreamResourceHandleOp", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceHandleOp::new().build(scope)`.
pub fn boosted_trees_quantile_stream_resource_handle_op(
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesQuantileStreamResourceHandleOp::new().build(scope)
}
/// Builder for the `BoostedTreesSerializeEnsemble` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesSerializeEnsemble {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesSerializeEnsemble {
    /// Creates a new `BoostedTreesSerializeEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesSerializeEnsemble` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        tree_ensemble_handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tree_ensemble_handle.into(), scope)
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesSerializeEnsemble", |nd| {
            nd.add_input(tree_ensemble_handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesSerializeEnsemble::new().build(tree_ensemble_handle, scope)`.
pub fn boosted_trees_serialize_ensemble<O0: ::std::convert::Into<crate::Output>>(
    tree_ensemble_handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesSerializeEnsemble::new().build(tree_ensemble_handle, scope)
}
/// Builder for the `BoostedTreesSparseAggregateStats` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesSparseAggregateStats {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesSparseAggregateStats {
    /// Creates a new `BoostedTreesSparseAggregateStats`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesSparseAggregateStats` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_ids: O0,
        gradients: O1,
        hessians: O2,
        feature_indices: O3,
        feature_values: O4,
        feature_shape: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_ids.into(),
            gradients.into(),
            hessians.into(),
            feature_indices.into(),
            feature_values.into(),
            feature_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_ids: crate::Output,
        gradients: crate::Output,
        hessians: crate::Output,
        feature_indices: crate::Output,
        feature_values: crate::Output,
        feature_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesSparseAggregateStats", |nd| {
            nd.add_input(node_ids);
            nd.add_input(gradients);
            nd.add_input(hessians);
            nd.add_input(feature_indices);
            nd.add_input(feature_values);
            nd.add_input(feature_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.max_splits {
                nd.set_attr_int("max_splits", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_buckets {
                nd.set_attr_int("num_buckets", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesSparseAggregateStats::new().build(node_ids, gradients, hessians, feature_indices, feature_values, feature_shape, scope)`.
pub fn boosted_trees_sparse_aggregate_stats<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    node_ids: O0,
    gradients: O1,
    hessians: O2,
    feature_indices: O3,
    feature_values: O4,
    feature_shape: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesSparseAggregateStats::new().build(
        node_ids,
        gradients,
        hessians,
        feature_indices,
        feature_values,
        feature_shape,
        scope,
    )
}
/// Builder for the `BoostedTreesSparseCalculateBestFeatureSplit` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesSparseCalculateBestFeatureSplit {
    logits_dimension: ::std::option::Option<i64>,
    split_type: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesSparseCalculateBestFeatureSplit {
    /// Creates a new `BoostedTreesSparseCalculateBestFeatureSplit`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_type` attribute.
    pub fn split_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.split_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesSparseCalculateBestFeatureSplit` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
    >(
        &self,
        node_id_range: O0,
        stats_summary_indices: O1,
        stats_summary_values: O2,
        stats_summary_shape: O3,
        l1: O4,
        l2: O5,
        tree_complexity: O6,
        min_node_weight: O7,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            node_id_range.into(),
            stats_summary_indices.into(),
            stats_summary_values.into(),
            stats_summary_shape.into(),
            l1.into(),
            l2.into(),
            tree_complexity.into(),
            min_node_weight.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        node_id_range: crate::Output,
        stats_summary_indices: crate::Output,
        stats_summary_values: crate::Output,
        stats_summary_shape: crate::Output,
        l1: crate::Output,
        l2: crate::Output,
        tree_complexity: crate::Output,
        min_node_weight: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesSparseCalculateBestFeatureSplit", |nd| {
            nd.add_input(node_id_range);
            nd.add_input(stats_summary_indices);
            nd.add_input(stats_summary_values);
            nd.add_input(stats_summary_shape);
            nd.add_input(l1);
            nd.add_input(l2);
            nd.add_input(tree_complexity);
            nd.add_input(min_node_weight);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.split_type {
                nd.set_attr_string("split_type", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesSparseCalculateBestFeatureSplit::new().build(node_id_range, stats_summary_indices, stats_summary_values, stats_summary_shape, l1, l2, tree_complexity, min_node_weight, scope)`.
pub fn boosted_trees_sparse_calculate_best_feature_split<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
>(
    node_id_range: O0,
    stats_summary_indices: O1,
    stats_summary_values: O2,
    stats_summary_shape: O3,
    l1: O4,
    l2: O5,
    tree_complexity: O6,
    min_node_weight: O7,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesSparseCalculateBestFeatureSplit::new().build(
        node_id_range,
        stats_summary_indices,
        stats_summary_values,
        stats_summary_shape,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
        scope,
    )
}
/// Builder for the `BoostedTreesTrainingPredict` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesTrainingPredict {
    num_bucketized_features: ::std::option::Option<i64>,
    logits_dimension: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesTrainingPredict {
    /// Creates a new `BoostedTreesTrainingPredict`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_bucketized_features` attribute.
    pub fn num_bucketized_features<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_bucketized_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesTrainingPredict` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        cached_tree_ids: O1,
        cached_node_ids: O2,
        bucketized_features: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            cached_tree_ids.into(),
            cached_node_ids.into(),
            bucketized_features.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        cached_tree_ids: crate::Output,
        cached_node_ids: crate::Output,
        bucketized_features: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesTrainingPredict", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(cached_tree_ids);
            nd.add_input(cached_node_ids);
            nd.add_input(bucketized_features);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_bucketized_features {
                nd.set_attr_int("num_bucketized_features", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesTrainingPredict::new().build(tree_ensemble_handle, cached_tree_ids, cached_node_ids, bucketized_features, scope)`.
pub fn boosted_trees_training_predict<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    cached_tree_ids: O1,
    cached_node_ids: O2,
    bucketized_features: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesTrainingPredict::new().build(
        tree_ensemble_handle,
        cached_tree_ids,
        cached_node_ids,
        bucketized_features,
        scope,
    )
}
/// Builder for the `BoostedTreesUpdateEnsemble` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesUpdateEnsemble {
    pruning_mode: ::std::option::Option<i64>,
    num_features: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesUpdateEnsemble {
    /// Creates a new `BoostedTreesUpdateEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `pruning_mode` attribute.
    pub fn pruning_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.pruning_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesUpdateEnsemble` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        feature_ids: O1,
        node_ids: O2,
        gains: O3,
        thresholds: O4,
        left_node_contribs: O5,
        right_node_contribs: O6,
        max_depth: O7,
        learning_rate: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            feature_ids.into(),
            node_ids.into(),
            gains.into(),
            thresholds.into(),
            left_node_contribs.into(),
            right_node_contribs.into(),
            max_depth.into(),
            learning_rate.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        feature_ids: crate::Output,
        node_ids: crate::Output,
        gains: crate::Output,
        thresholds: crate::Output,
        left_node_contribs: crate::Output,
        right_node_contribs: crate::Output,
        max_depth: crate::Output,
        learning_rate: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesUpdateEnsemble", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(feature_ids);
            nd.add_input(node_ids);
            nd.add_input(gains);
            nd.add_input(thresholds);
            nd.add_input(left_node_contribs);
            nd.add_input(right_node_contribs);
            nd.add_input(max_depth);
            nd.add_input(learning_rate);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.pruning_mode {
                nd.set_attr_int("pruning_mode", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesUpdateEnsemble::new().build(tree_ensemble_handle, feature_ids, node_ids, gains, thresholds, left_node_contribs, right_node_contribs, max_depth, learning_rate, scope)`.
pub fn boosted_trees_update_ensemble<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    feature_ids: O1,
    node_ids: O2,
    gains: O3,
    thresholds: O4,
    left_node_contribs: O5,
    right_node_contribs: O6,
    max_depth: O7,
    learning_rate: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesUpdateEnsemble::new().build(
        tree_ensemble_handle,
        feature_ids,
        node_ids,
        gains,
        thresholds,
        left_node_contribs,
        right_node_contribs,
        max_depth,
        learning_rate,
        scope,
    )
}
/// Builder for the `BoostedTreesUpdateEnsembleV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BoostedTreesUpdateEnsembleV2 {
    num_features: ::std::option::Option<i64>,
    logits_dimension: ::std::option::Option<i64>,
    num_groups: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BoostedTreesUpdateEnsembleV2 {
    /// Creates a new `BoostedTreesUpdateEnsembleV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_groups` attribute.
    pub fn num_groups<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_groups = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BoostedTreesUpdateEnsembleV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
        O11: ::std::convert::Into<crate::Output>,
    >(
        &self,
        tree_ensemble_handle: O0,
        feature_ids: O1,
        dimension_ids: O2,
        node_ids: O3,
        gains: O4,
        thresholds: O5,
        left_node_contribs: O6,
        right_node_contribs: O7,
        split_types: O8,
        max_depth: O9,
        learning_rate: O10,
        pruning_mode: O11,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            tree_ensemble_handle.into(),
            feature_ids.into(),
            dimension_ids.into(),
            node_ids.into(),
            gains.into(),
            thresholds.into(),
            left_node_contribs.into(),
            right_node_contribs.into(),
            split_types.into(),
            max_depth.into(),
            learning_rate.into(),
            pruning_mode.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        tree_ensemble_handle: crate::Output,
        feature_ids: crate::Output,
        dimension_ids: crate::Output,
        node_ids: crate::Output,
        gains: crate::Output,
        thresholds: crate::Output,
        left_node_contribs: crate::Output,
        right_node_contribs: crate::Output,
        split_types: crate::Output,
        max_depth: crate::Output,
        learning_rate: crate::Output,
        pruning_mode: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BoostedTreesUpdateEnsembleV2", |nd| {
            nd.add_input(tree_ensemble_handle);
            nd.add_input(feature_ids);
            nd.add_input(dimension_ids);
            nd.add_input(node_ids);
            nd.add_input(gains);
            nd.add_input(thresholds);
            nd.add_input(left_node_contribs);
            nd.add_input(right_node_contribs);
            nd.add_input(split_types);
            nd.add_input(max_depth);
            nd.add_input(learning_rate);
            nd.add_input(pruning_mode);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_features {
                nd.set_attr_int("num_features", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.logits_dimension {
                nd.set_attr_int("logits_dimension", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_groups {
                nd.set_attr_int("num_groups", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BoostedTreesUpdateEnsembleV2::new().build(tree_ensemble_handle, feature_ids, dimension_ids, node_ids, gains, thresholds, left_node_contribs, right_node_contribs, split_types, max_depth, learning_rate, pruning_mode, scope)`.
pub fn boosted_trees_update_ensemble_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
    O11: ::std::convert::Into<crate::Output>,
>(
    tree_ensemble_handle: O0,
    feature_ids: O1,
    dimension_ids: O2,
    node_ids: O3,
    gains: O4,
    thresholds: O5,
    left_node_contribs: O6,
    right_node_contribs: O7,
    split_types: O8,
    max_depth: O9,
    learning_rate: O10,
    pruning_mode: O11,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BoostedTreesUpdateEnsembleV2::new().build(
        tree_ensemble_handle,
        feature_ids,
        dimension_ids,
        node_ids,
        gains,
        thresholds,
        left_node_contribs,
        right_node_contribs,
        split_types,
        max_depth,
        learning_rate,
        pruning_mode,
        scope,
    )
}
/// Builder for the `BroadcastArgs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BroadcastArgs {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BroadcastArgs {
    /// Creates a new `BroadcastArgs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BroadcastArgs` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        s0: O0,
        s1: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(s0.into(), s1.into(), scope)
    }

    fn build_impl(
        &self,
        s0: crate::Output,
        s1: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BroadcastArgs", |nd| {
            nd.add_input(s0);
            nd.add_input(s1);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BroadcastArgs::new().build(s0, s1, scope)`.
pub fn broadcast_args<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    s0: O0,
    s1: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BroadcastArgs::new().build(s0, s1, scope)
}
/// Builder for the `BroadcastGradientArgs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BroadcastGradientArgs {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BroadcastGradientArgs {
    /// Creates a new `BroadcastGradientArgs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BroadcastGradientArgs` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        s0: O0,
        s1: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(s0.into(), s1.into(), scope)
    }

    fn build_impl(
        &self,
        s0: crate::Output,
        s1: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BroadcastGradientArgs", |nd| {
            nd.add_input(s0);
            nd.add_input(s1);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BroadcastGradientArgs::new().build(s0, s1, scope)`.
pub fn broadcast_gradient_args<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    s0: O0,
    s1: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BroadcastGradientArgs::new().build(s0, s1, scope)
}
/// Builder for the `BroadcastTo` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BroadcastTo {
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BroadcastTo {
    /// Creates a new `BroadcastTo`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BroadcastTo` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        shape: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), shape.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BroadcastTo", |nd| {
            nd.add_input(input);
            nd.add_input(shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BroadcastTo::new().build(input, shape, scope)`.
pub fn broadcast_to<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    shape: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BroadcastTo::new().build(input, shape, scope)
}
/// Builder for the `Bucketize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Bucketize {
    T: ::std::option::Option<crate::DataType>,
    boundaries: ::std::option::Option<::std::vec::Vec<f32>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Bucketize {
    /// Creates a new `Bucketize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `boundaries` attribute.
    pub fn boundaries<ArgType: ::std::convert::Into<::std::vec::Vec<f32>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.boundaries = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Bucketize` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Bucketize", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.boundaries {
                nd.set_attr_float_list("boundaries", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Bucketize::new().build(input, scope)`.
pub fn bucketize<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Bucketize::new().build(input, scope)
}
/// Builder for the `BytesProducedStatsDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct BytesProducedStatsDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl BytesProducedStatsDataset {
    /// Creates a new `BytesProducedStatsDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `BytesProducedStatsDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        tag: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), tag.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        tag: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("BytesProducedStatsDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(tag);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `BytesProducedStatsDataset::new().build(input_dataset, tag, scope)`.
pub fn bytes_produced_stats_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    tag: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    BytesProducedStatsDataset::new().build(input_dataset, tag, scope)
}
/// Builder for the `CSRSparseMatrixComponents` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CSRSparseMatrixComponents {
    type_: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CSRSparseMatrixComponents {
    /// Creates a new `CSRSparseMatrixComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CSRSparseMatrixComponents` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        csr_sparse_matrix: O0,
        index: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(csr_sparse_matrix.into(), index.into(), scope)
    }

    fn build_impl(
        &self,
        csr_sparse_matrix: crate::Output,
        index: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CSRSparseMatrixComponents", |nd| {
            nd.add_input(csr_sparse_matrix);
            nd.add_input(index);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.type_ {
                nd.set_attr_type("type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CSRSparseMatrixComponents::new().build(csr_sparse_matrix, index, scope)`.
pub fn csrsparse_matrix_components<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    csr_sparse_matrix: O0,
    index: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CSRSparseMatrixComponents::new().build(csr_sparse_matrix, index, scope)
}
/// Builder for the `CSRSparseMatrixToDense` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CSRSparseMatrixToDense {
    type_: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CSRSparseMatrixToDense {
    /// Creates a new `CSRSparseMatrixToDense`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CSRSparseMatrixToDense` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        sparse_input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(sparse_input.into(), scope)
    }

    fn build_impl(
        &self,
        sparse_input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CSRSparseMatrixToDense", |nd| {
            nd.add_input(sparse_input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.type_ {
                nd.set_attr_type("type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CSRSparseMatrixToDense::new().build(sparse_input, scope)`.
pub fn csrsparse_matrix_to_dense<O0: ::std::convert::Into<crate::Output>>(
    sparse_input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CSRSparseMatrixToDense::new().build(sparse_input, scope)
}
/// Builder for the `CSRSparseMatrixToSparseTensor` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CSRSparseMatrixToSparseTensor {
    type_: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CSRSparseMatrixToSparseTensor {
    /// Creates a new `CSRSparseMatrixToSparseTensor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CSRSparseMatrixToSparseTensor` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        sparse_matrix: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(sparse_matrix.into(), scope)
    }

    fn build_impl(
        &self,
        sparse_matrix: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CSRSparseMatrixToSparseTensor", |nd| {
            nd.add_input(sparse_matrix);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.type_ {
                nd.set_attr_type("type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CSRSparseMatrixToSparseTensor::new().build(sparse_matrix, scope)`.
pub fn csrsparse_matrix_to_sparse_tensor<O0: ::std::convert::Into<crate::Output>>(
    sparse_matrix: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CSRSparseMatrixToSparseTensor::new().build(sparse_matrix, scope)
}
/// Builder for the `CSVDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CSVDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CSVDataset {
    /// Creates a new `CSVDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CSVDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        filenames: O0,
        compression_type: O1,
        buffer_size: O2,
        header: O3,
        field_delim: O4,
        use_quote_delim: O5,
        na_value: O6,
        select_cols: O7,
        record_defaults: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            filenames.into(),
            compression_type.into(),
            buffer_size.into(),
            header.into(),
            field_delim.into(),
            use_quote_delim.into(),
            na_value.into(),
            select_cols.into(),
            record_defaults.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        filenames: crate::Output,
        compression_type: crate::Output,
        buffer_size: crate::Output,
        header: crate::Output,
        field_delim: crate::Output,
        use_quote_delim: crate::Output,
        na_value: crate::Output,
        select_cols: crate::Output,
        record_defaults: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CSVDataset", |nd| {
            nd.add_input(filenames);
            nd.add_input(compression_type);
            nd.add_input(buffer_size);
            nd.add_input(header);
            nd.add_input(field_delim);
            nd.add_input(use_quote_delim);
            nd.add_input(na_value);
            nd.add_input(select_cols);
            nd.add_input(record_defaults);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CSVDataset::new().build(filenames, compression_type, buffer_size, header, field_delim, use_quote_delim, na_value, select_cols, record_defaults, scope)`.
pub fn csvdataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    filenames: O0,
    compression_type: O1,
    buffer_size: O2,
    header: O3,
    field_delim: O4,
    use_quote_delim: O5,
    na_value: O6,
    select_cols: O7,
    record_defaults: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CSVDataset::new().build(
        filenames,
        compression_type,
        buffer_size,
        header,
        field_delim,
        use_quote_delim,
        na_value,
        select_cols,
        record_defaults,
        scope,
    )
}
/// Builder for the `CSVDatasetV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CSVDatasetV2 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CSVDatasetV2 {
    /// Creates a new `CSVDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CSVDatasetV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
    >(
        &self,
        filenames: O0,
        compression_type: O1,
        buffer_size: O2,
        header: O3,
        field_delim: O4,
        use_quote_delim: O5,
        na_value: O6,
        select_cols: O7,
        record_defaults: O8,
        exclude_cols: O9,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            filenames.into(),
            compression_type.into(),
            buffer_size.into(),
            header.into(),
            field_delim.into(),
            use_quote_delim.into(),
            na_value.into(),
            select_cols.into(),
            record_defaults.into(),
            exclude_cols.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        filenames: crate::Output,
        compression_type: crate::Output,
        buffer_size: crate::Output,
        header: crate::Output,
        field_delim: crate::Output,
        use_quote_delim: crate::Output,
        na_value: crate::Output,
        select_cols: crate::Output,
        record_defaults: crate::Output,
        exclude_cols: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CSVDatasetV2", |nd| {
            nd.add_input(filenames);
            nd.add_input(compression_type);
            nd.add_input(buffer_size);
            nd.add_input(header);
            nd.add_input(field_delim);
            nd.add_input(use_quote_delim);
            nd.add_input(na_value);
            nd.add_input(select_cols);
            nd.add_input(record_defaults);
            nd.add_input(exclude_cols);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CSVDatasetV2::new().build(filenames, compression_type, buffer_size, header, field_delim, use_quote_delim, na_value, select_cols, record_defaults, exclude_cols, scope)`.
pub fn csvdataset_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
>(
    filenames: O0,
    compression_type: O1,
    buffer_size: O2,
    header: O3,
    field_delim: O4,
    use_quote_delim: O5,
    na_value: O6,
    select_cols: O7,
    record_defaults: O8,
    exclude_cols: O9,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CSVDatasetV2::new().build(
        filenames,
        compression_type,
        buffer_size,
        header,
        field_delim,
        use_quote_delim,
        na_value,
        select_cols,
        record_defaults,
        exclude_cols,
        scope,
    )
}
/// Builder for the `CTCBeamSearchDecoder` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CTCBeamSearchDecoder {
    beam_width: ::std::option::Option<i64>,
    top_paths: ::std::option::Option<i64>,
    merge_repeated: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CTCBeamSearchDecoder {
    /// Creates a new `CTCBeamSearchDecoder`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `beam_width` attribute.
    pub fn beam_width<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.beam_width = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `top_paths` attribute.
    pub fn top_paths<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.top_paths = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `merge_repeated` attribute.
    pub fn merge_repeated<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CTCBeamSearchDecoder` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        inputs: O0,
        sequence_length: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(inputs.into(), sequence_length.into(), scope)
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        sequence_length: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CTCBeamSearchDecoder", |nd| {
            nd.add_input(inputs);
            nd.add_input(sequence_length);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.beam_width {
                nd.set_attr_int("beam_width", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.top_paths {
                nd.set_attr_int("top_paths", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.merge_repeated {
                nd.set_attr_bool("merge_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CTCBeamSearchDecoder::new().build(inputs, sequence_length, scope)`.
pub fn ctcbeam_search_decoder<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    inputs: O0,
    sequence_length: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CTCBeamSearchDecoder::new().build(inputs, sequence_length, scope)
}
/// Builder for the `CTCGreedyDecoder` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CTCGreedyDecoder {
    merge_repeated: ::std::option::Option<bool>,
    blank_index: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CTCGreedyDecoder {
    /// Creates a new `CTCGreedyDecoder`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `merge_repeated` attribute.
    pub fn merge_repeated<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `blank_index` attribute.
    pub fn blank_index<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.blank_index = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CTCGreedyDecoder` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        inputs: O0,
        sequence_length: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(inputs.into(), sequence_length.into(), scope)
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        sequence_length: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CTCGreedyDecoder", |nd| {
            nd.add_input(inputs);
            nd.add_input(sequence_length);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.merge_repeated {
                nd.set_attr_bool("merge_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.blank_index {
                nd.set_attr_int("blank_index", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CTCGreedyDecoder::new().build(inputs, sequence_length, scope)`.
pub fn ctcgreedy_decoder<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    inputs: O0,
    sequence_length: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CTCGreedyDecoder::new().build(inputs, sequence_length, scope)
}
/// Builder for the `CTCLoss` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CTCLoss {
    preprocess_collapse_repeated: ::std::option::Option<bool>,
    ctc_merge_repeated: ::std::option::Option<bool>,
    ignore_longer_outputs_than_inputs: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CTCLoss {
    /// Creates a new `CTCLoss`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `preprocess_collapse_repeated` attribute.
    pub fn preprocess_collapse_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.preprocess_collapse_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ctc_merge_repeated` attribute.
    pub fn ctc_merge_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ctc_merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ignore_longer_outputs_than_inputs` attribute.
    pub fn ignore_longer_outputs_than_inputs<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ignore_longer_outputs_than_inputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CTCLoss` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        inputs: O0,
        labels_indices: O1,
        labels_values: O2,
        sequence_length: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            inputs.into(),
            labels_indices.into(),
            labels_values.into(),
            sequence_length.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        labels_indices: crate::Output,
        labels_values: crate::Output,
        sequence_length: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CTCLoss", |nd| {
            nd.add_input(inputs);
            nd.add_input(labels_indices);
            nd.add_input(labels_values);
            nd.add_input(sequence_length);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.preprocess_collapse_repeated {
                nd.set_attr_bool("preprocess_collapse_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ctc_merge_repeated {
                nd.set_attr_bool("ctc_merge_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ignore_longer_outputs_than_inputs {
                nd.set_attr_bool("ignore_longer_outputs_than_inputs", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CTCLoss::new().build(inputs, labels_indices, labels_values, sequence_length, scope)`.
pub fn ctcloss<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    inputs: O0,
    labels_indices: O1,
    labels_values: O2,
    sequence_length: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CTCLoss::new().build(
        inputs,
        labels_indices,
        labels_values,
        sequence_length,
        scope,
    )
}
/// Builder for the `CTCLossV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CTCLossV2 {
    preprocess_collapse_repeated: ::std::option::Option<bool>,
    ctc_merge_repeated: ::std::option::Option<bool>,
    ignore_longer_outputs_than_inputs: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CTCLossV2 {
    /// Creates a new `CTCLossV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `preprocess_collapse_repeated` attribute.
    pub fn preprocess_collapse_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.preprocess_collapse_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ctc_merge_repeated` attribute.
    pub fn ctc_merge_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ctc_merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ignore_longer_outputs_than_inputs` attribute.
    pub fn ignore_longer_outputs_than_inputs<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ignore_longer_outputs_than_inputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CTCLossV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        inputs: O0,
        labels_indices: O1,
        labels_values: O2,
        sequence_length: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            inputs.into(),
            labels_indices.into(),
            labels_values.into(),
            sequence_length.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        labels_indices: crate::Output,
        labels_values: crate::Output,
        sequence_length: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CTCLossV2", |nd| {
            nd.add_input(inputs);
            nd.add_input(labels_indices);
            nd.add_input(labels_values);
            nd.add_input(sequence_length);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.preprocess_collapse_repeated {
                nd.set_attr_bool("preprocess_collapse_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ctc_merge_repeated {
                nd.set_attr_bool("ctc_merge_repeated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ignore_longer_outputs_than_inputs {
                nd.set_attr_bool("ignore_longer_outputs_than_inputs", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CTCLossV2::new().build(inputs, labels_indices, labels_values, sequence_length, scope)`.
pub fn ctcloss_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    inputs: O0,
    labels_indices: O1,
    labels_values: O2,
    sequence_length: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CTCLossV2::new().build(
        inputs,
        labels_indices,
        labels_values,
        sequence_length,
        scope,
    )
}
/// Builder for the `CacheDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CacheDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CacheDataset {
    /// Creates a new `CacheDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CacheDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        filename: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), filename.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        filename: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CacheDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(filename);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CacheDataset::new().build(input_dataset, filename, scope)`.
pub fn cache_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    filename: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CacheDataset::new().build(input_dataset, filename, scope)
}
/// Builder for the `CacheDatasetV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CacheDatasetV2 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CacheDatasetV2 {
    /// Creates a new `CacheDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CacheDatasetV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        filename: O1,
        cache: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), filename.into(), cache.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        filename: crate::Output,
        cache: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CacheDatasetV2", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(filename);
            nd.add_input(cache);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CacheDatasetV2::new().build(input_dataset, filename, cache, scope)`.
pub fn cache_dataset_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    filename: O1,
    cache: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CacheDatasetV2::new().build(input_dataset, filename, cache, scope)
}
/// Builder for the `Case` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Case {
    Tin: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    Tout: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    branches: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Case {
    /// Creates a new `Case`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tin` attribute.
    pub fn Tin<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tin = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `branches` attribute.
    pub fn branches<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.branches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Case` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        branch_index: O0,
        input: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(branch_index.into(), input.into(), scope)
    }

    fn build_impl(
        &self,
        branch_index: crate::Output,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Case", |nd| {
            nd.add_input(branch_index);
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.Tin {
                nd.set_attr_type_list("Tin", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type_list("Tout", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.branches {
                nd.set_attr_string_list("branches", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Case::new().build(branch_index, input, scope)`.
pub fn case<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    branch_index: O0,
    input: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Case::new().build(branch_index, input, scope)
}
/// Builder for the `Cast` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cast {
    SrcT: ::std::option::Option<crate::DataType>,
    DstT: ::std::option::Option<crate::DataType>,
    Truncate: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cast {
    /// Creates a new `Cast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `SrcT` attribute.
    pub fn SrcT<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.SrcT = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `DstT` attribute.
    pub fn DstT<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.DstT = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Truncate` attribute.
    pub fn Truncate<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.Truncate = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cast` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cast", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.SrcT {
                nd.set_attr_type("SrcT", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.DstT {
                nd.set_attr_type("DstT", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Truncate {
                nd.set_attr_bool("Truncate", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cast::new().build(x, scope)`.
pub fn cast<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cast::new().build(x, scope)
}
/// Builder for the `Ceil` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Ceil {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Ceil {
    /// Creates a new `Ceil`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Ceil` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Ceil", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Ceil::new().build(x, scope)`.
pub fn ceil<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Ceil::new().build(x, scope)
}
/// Builder for the `CheckNumerics` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CheckNumerics {
    T: ::std::option::Option<crate::DataType>,
    message: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CheckNumerics {
    /// Creates a new `CheckNumerics`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `message` attribute.
    pub fn message<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CheckNumerics` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        tensor: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tensor.into(), scope)
    }

    fn build_impl(
        &self,
        tensor: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CheckNumerics", |nd| {
            nd.add_input(tensor);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.message {
                nd.set_attr_string("message", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CheckNumerics::new().build(tensor, scope)`.
pub fn check_numerics<O0: ::std::convert::Into<crate::Output>>(
    tensor: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CheckNumerics::new().build(tensor, scope)
}
/// Builder for the `CheckNumericsV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CheckNumericsV2 {
    T: ::std::option::Option<crate::DataType>,
    message: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CheckNumericsV2 {
    /// Creates a new `CheckNumericsV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `message` attribute.
    pub fn message<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CheckNumericsV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        tensor: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(tensor.into(), scope)
    }

    fn build_impl(
        &self,
        tensor: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CheckNumericsV2", |nd| {
            nd.add_input(tensor);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.message {
                nd.set_attr_string("message", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CheckNumericsV2::new().build(tensor, scope)`.
pub fn check_numerics_v2<O0: ::std::convert::Into<crate::Output>>(
    tensor: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CheckNumericsV2::new().build(tensor, scope)
}
/// Builder for the `Cholesky` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cholesky {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cholesky {
    /// Creates a new `Cholesky`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cholesky` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cholesky", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cholesky::new().build(input, scope)`.
pub fn cholesky<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cholesky::new().build(input, scope)
}
/// Builder for the `CholeskyGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CholeskyGrad {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CholeskyGrad {
    /// Creates a new `CholeskyGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CholeskyGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        l: O0,
        grad: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(l.into(), grad.into(), scope)
    }

    fn build_impl(
        &self,
        l: crate::Output,
        grad: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CholeskyGrad", |nd| {
            nd.add_input(l);
            nd.add_input(grad);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CholeskyGrad::new().build(l, grad, scope)`.
pub fn cholesky_grad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    l: O0,
    grad: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CholeskyGrad::new().build(l, grad, scope)
}
/// Builder for the `ChooseFastestBranchDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ChooseFastestBranchDataset {
    Targuments: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    num_elements_per_branch: ::std::option::Option<i64>,
    branches: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    other_arguments_lengths: ::std::option::Option<::std::vec::Vec<i64>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ChooseFastestBranchDataset {
    /// Creates a new `ChooseFastestBranchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Targuments` attribute.
    pub fn Targuments<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Targuments = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_elements_per_branch` attribute.
    pub fn num_elements_per_branch<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_elements_per_branch = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `branches` attribute.
    pub fn branches<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.branches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `other_arguments_lengths` attribute.
    pub fn other_arguments_lengths<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.other_arguments_lengths = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ChooseFastestBranchDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        ratio_numerator: O1,
        ratio_denominator: O2,
        other_arguments: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_dataset.into(),
            ratio_numerator.into(),
            ratio_denominator.into(),
            other_arguments.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        ratio_numerator: crate::Output,
        ratio_denominator: crate::Output,
        other_arguments: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ChooseFastestBranchDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(ratio_numerator);
            nd.add_input(ratio_denominator);
            nd.add_input(other_arguments);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.Targuments {
                nd.set_attr_type_list("Targuments", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_elements_per_branch {
                nd.set_attr_int("num_elements_per_branch", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.branches {
                nd.set_attr_string_list("branches", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.other_arguments_lengths {
                nd.set_attr_int_list("other_arguments_lengths", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ChooseFastestBranchDataset::new().build(input_dataset, ratio_numerator, ratio_denominator, other_arguments, scope)`.
pub fn choose_fastest_branch_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    ratio_numerator: O1,
    ratio_denominator: O2,
    other_arguments: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ChooseFastestBranchDataset::new().build(
        input_dataset,
        ratio_numerator,
        ratio_denominator,
        other_arguments,
        scope,
    )
}
/// Builder for the `ChooseFastestDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ChooseFastestDataset {
    N: ::std::option::Option<i64>,
    num_experiments: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ChooseFastestDataset {
    /// Creates a new `ChooseFastestDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_experiments` attribute.
    pub fn num_experiments<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_experiments = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ChooseFastestDataset` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input_datasets: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_datasets.into(), scope)
    }

    fn build_impl(
        &self,
        input_datasets: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ChooseFastestDataset", |nd| {
            nd.add_input(input_datasets);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_experiments {
                nd.set_attr_int("num_experiments", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ChooseFastestDataset::new().build(input_datasets, scope)`.
pub fn choose_fastest_dataset<O0: ::std::convert::Into<crate::Output>>(
    input_datasets: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ChooseFastestDataset::new().build(input_datasets, scope)
}
/// Builder for the `ClipByValue` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ClipByValue {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ClipByValue {
    /// Creates a new `ClipByValue`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ClipByValue` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        t: O0,
        clip_value_min: O1,
        clip_value_max: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            t.into(),
            clip_value_min.into(),
            clip_value_max.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        t: crate::Output,
        clip_value_min: crate::Output,
        clip_value_max: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ClipByValue", |nd| {
            nd.add_input(t);
            nd.add_input(clip_value_min);
            nd.add_input(clip_value_max);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ClipByValue::new().build(t, clip_value_min, clip_value_max, scope)`.
pub fn clip_by_value<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    t: O0,
    clip_value_min: O1,
    clip_value_max: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ClipByValue::new().build(t, clip_value_min, clip_value_max, scope)
}
/// Builder for the `CloseSummaryWriter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CloseSummaryWriter {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CloseSummaryWriter {
    /// Creates a new `CloseSummaryWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CloseSummaryWriter` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        writer: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(writer.into(), scope)
    }

    fn build_impl(
        &self,
        writer: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CloseSummaryWriter", |nd| {
            nd.add_input(writer);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CloseSummaryWriter::new().build(writer, scope)`.
pub fn close_summary_writer<O0: ::std::convert::Into<crate::Output>>(
    writer: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CloseSummaryWriter::new().build(writer, scope)
}
/// Builder for the `CollectiveAllToAllV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveAllToAllV3 {
    T: ::std::option::Option<crate::DataType>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveAllToAllV3 {
    /// Creates a new `CollectiveAllToAllV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveAllToAllV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        communicator: O1,
        group_assignment: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            communicator.into(),
            group_assignment.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        communicator: crate::Output,
        group_assignment: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveAllToAllV3", |nd| {
            nd.add_input(input);
            nd.add_input(communicator);
            nd.add_input(group_assignment);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveAllToAllV3::new().build(input, communicator, group_assignment, scope)`.
pub fn collective_all_to_all_v3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    communicator: O1,
    group_assignment: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveAllToAllV3::new().build(input, communicator, group_assignment, scope)
}
/// Builder for the `CollectiveBcastRecv` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveBcastRecv {
    T: ::std::option::Option<crate::DataType>,
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveBcastRecv {
    /// Creates a new `CollectiveBcastRecv`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveBcastRecv` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveBcastRecv", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_size {
                nd.set_attr_int("group_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_key {
                nd.set_attr_int("group_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.instance_key {
                nd.set_attr_int("instance_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shape {
                nd.set_attr_shape("shape", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveBcastRecv::new().build(scope)`.
pub fn collective_bcast_recv(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    CollectiveBcastRecv::new().build(scope)
}
/// Builder for the `CollectiveBcastRecvV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveBcastRecvV2 {
    T: ::std::option::Option<crate::DataType>,
    Tshape: ::std::option::Option<crate::DataType>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveBcastRecvV2 {
    /// Creates a new `CollectiveBcastRecvV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tshape` attribute.
    pub fn Tshape<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tshape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveBcastRecvV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        group_size: O0,
        group_key: O1,
        instance_key: O2,
        shape: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            group_size.into(),
            group_key.into(),
            instance_key.into(),
            shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        group_size: crate::Output,
        group_key: crate::Output,
        instance_key: crate::Output,
        shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveBcastRecvV2", |nd| {
            nd.add_input(group_size);
            nd.add_input(group_key);
            nd.add_input(instance_key);
            nd.add_input(shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tshape {
                nd.set_attr_type("Tshape", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveBcastRecvV2::new().build(group_size, group_key, instance_key, shape, scope)`.
pub fn collective_bcast_recv_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    group_size: O0,
    group_key: O1,
    instance_key: O2,
    shape: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveBcastRecvV2::new().build(group_size, group_key, instance_key, shape, scope)
}
/// Builder for the `CollectiveBcastSend` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveBcastSend {
    T: ::std::option::Option<crate::DataType>,
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveBcastSend {
    /// Creates a new `CollectiveBcastSend`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveBcastSend` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveBcastSend", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_size {
                nd.set_attr_int("group_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_key {
                nd.set_attr_int("group_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.instance_key {
                nd.set_attr_int("instance_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shape {
                nd.set_attr_shape("shape", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveBcastSend::new().build(input, scope)`.
pub fn collective_bcast_send<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveBcastSend::new().build(input, scope)
}
/// Builder for the `CollectiveBcastSendV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveBcastSendV2 {
    T: ::std::option::Option<crate::DataType>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveBcastSendV2 {
    /// Creates a new `CollectiveBcastSendV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveBcastSendV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        group_size: O1,
        group_key: O2,
        instance_key: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            group_size.into(),
            group_key.into(),
            instance_key.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        group_size: crate::Output,
        group_key: crate::Output,
        instance_key: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveBcastSendV2", |nd| {
            nd.add_input(input);
            nd.add_input(group_size);
            nd.add_input(group_key);
            nd.add_input(instance_key);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveBcastSendV2::new().build(input, group_size, group_key, instance_key, scope)`.
pub fn collective_bcast_send_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    group_size: O1,
    group_key: O2,
    instance_key: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveBcastSendV2::new().build(input, group_size, group_key, instance_key, scope)
}
/// Builder for the `CollectiveGather` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveGather {
    T: ::std::option::Option<crate::DataType>,
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveGather {
    /// Creates a new `CollectiveGather`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveGather` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveGather", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_size {
                nd.set_attr_int("group_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_key {
                nd.set_attr_int("group_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.instance_key {
                nd.set_attr_int("instance_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shape {
                nd.set_attr_shape("shape", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveGather::new().build(input, scope)`.
pub fn collective_gather<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveGather::new().build(input, scope)
}
/// Builder for the `CollectiveGatherV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveGatherV2 {
    T: ::std::option::Option<crate::DataType>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    Nordering_token: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveGatherV2 {
    /// Creates a new `CollectiveGatherV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Nordering_token` attribute.
    pub fn Nordering_token<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.Nordering_token = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveGatherV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        group_size: O1,
        group_key: O2,
        instance_key: O3,
        ordering_token: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            group_size.into(),
            group_key.into(),
            instance_key.into(),
            ordering_token.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        group_size: crate::Output,
        group_key: crate::Output,
        instance_key: crate::Output,
        ordering_token: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveGatherV2", |nd| {
            nd.add_input(input);
            nd.add_input(group_size);
            nd.add_input(group_key);
            nd.add_input(instance_key);
            nd.add_input(ordering_token);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Nordering_token {
                nd.set_attr_int("Nordering_token", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveGatherV2::new().build(input, group_size, group_key, instance_key, ordering_token, scope)`.
pub fn collective_gather_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    group_size: O1,
    group_key: O2,
    instance_key: O3,
    ordering_token: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveGatherV2::new().build(
        input,
        group_size,
        group_key,
        instance_key,
        ordering_token,
        scope,
    )
}
/// Builder for the `CollectiveInitializeCommunicator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveInitializeCommunicator {
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveInitializeCommunicator {
    /// Creates a new `CollectiveInitializeCommunicator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveInitializeCommunicator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        group_key: O0,
        rank: O1,
        group_size: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(group_key.into(), rank.into(), group_size.into(), scope)
    }

    fn build_impl(
        &self,
        group_key: crate::Output,
        rank: crate::Output,
        group_size: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveInitializeCommunicator", |nd| {
            nd.add_input(group_key);
            nd.add_input(rank);
            nd.add_input(group_size);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveInitializeCommunicator::new().build(group_key, rank, group_size, scope)`.
pub fn collective_initialize_communicator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    group_key: O0,
    rank: O1,
    group_size: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveInitializeCommunicator::new().build(group_key, rank, group_size, scope)
}
/// Builder for the `CollectivePermute` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectivePermute {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectivePermute {
    /// Creates a new `CollectivePermute`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectivePermute` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        source_target_pairs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), source_target_pairs.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        source_target_pairs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectivePermute", |nd| {
            nd.add_input(input);
            nd.add_input(source_target_pairs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectivePermute::new().build(input, source_target_pairs, scope)`.
pub fn collective_permute<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    source_target_pairs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectivePermute::new().build(input, source_target_pairs, scope)
}
/// Builder for the `CollectiveReduce` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveReduce {
    T: ::std::option::Option<crate::DataType>,
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    merge_op: ::std::option::Option<::std::string::String>,
    final_op: ::std::option::Option<::std::string::String>,
    subdiv_offsets: ::std::option::Option<::std::vec::Vec<i64>>,
    wait_for: ::std::option::Option<::std::vec::Vec<i64>>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveReduce {
    /// Creates a new `CollectiveReduce`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `merge_op` attribute.
    pub fn merge_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.merge_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `final_op` attribute.
    pub fn final_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.final_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `subdiv_offsets` attribute.
    pub fn subdiv_offsets<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.subdiv_offsets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `wait_for` attribute.
    pub fn wait_for<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.wait_for = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveReduce` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveReduce", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_size {
                nd.set_attr_int("group_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.group_key {
                nd.set_attr_int("group_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.instance_key {
                nd.set_attr_int("instance_key", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.merge_op {
                nd.set_attr_string("merge_op", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.final_op {
                nd.set_attr_string("final_op", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.subdiv_offsets {
                nd.set_attr_int_list("subdiv_offsets", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.wait_for {
                nd.set_attr_int_list("wait_for", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveReduce::new().build(input, scope)`.
pub fn collective_reduce<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveReduce::new().build(input, scope)
}
/// Builder for the `CollectiveReduceV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveReduceV2 {
    T: ::std::option::Option<crate::DataType>,
    merge_op: ::std::option::Option<::std::string::String>,
    final_op: ::std::option::Option<::std::string::String>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    Nordering_token: ::std::option::Option<i64>,
    max_subdivs_per_device: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveReduceV2 {
    /// Creates a new `CollectiveReduceV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `merge_op` attribute.
    pub fn merge_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.merge_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `final_op` attribute.
    pub fn final_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.final_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Nordering_token` attribute.
    pub fn Nordering_token<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.Nordering_token = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_subdivs_per_device` attribute.
    pub fn max_subdivs_per_device<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_subdivs_per_device = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveReduceV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        group_size: O1,
        group_key: O2,
        instance_key: O3,
        ordering_token: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            group_size.into(),
            group_key.into(),
            instance_key.into(),
            ordering_token.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        group_size: crate::Output,
        group_key: crate::Output,
        instance_key: crate::Output,
        ordering_token: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveReduceV2", |nd| {
            nd.add_input(input);
            nd.add_input(group_size);
            nd.add_input(group_key);
            nd.add_input(instance_key);
            nd.add_input(ordering_token);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.merge_op {
                nd.set_attr_string("merge_op", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.final_op {
                nd.set_attr_string("final_op", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.communication_hint {
                nd.set_attr_string("communication_hint", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Nordering_token {
                nd.set_attr_int("Nordering_token", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.max_subdivs_per_device {
                nd.set_attr_int("max_subdivs_per_device", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveReduceV2::new().build(input, group_size, group_key, instance_key, ordering_token, scope)`.
pub fn collective_reduce_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    group_size: O1,
    group_key: O2,
    instance_key: O3,
    ordering_token: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveReduceV2::new().build(
        input,
        group_size,
        group_key,
        instance_key,
        ordering_token,
        scope,
    )
}
/// Builder for the `CollectiveReduceV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CollectiveReduceV3 {
    T: ::std::option::Option<crate::DataType>,
    reduction: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CollectiveReduceV3 {
    /// Creates a new `CollectiveReduceV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reduction` attribute.
    pub fn reduction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.reduction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CollectiveReduceV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        communicator: O1,
        group_assignment: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            communicator.into(),
            group_assignment.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        communicator: crate::Output,
        group_assignment: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CollectiveReduceV3", |nd| {
            nd.add_input(input);
            nd.add_input(communicator);
            nd.add_input(group_assignment);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.reduction {
                nd.set_attr_string("reduction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.timeout_seconds {
                nd.set_attr_float("timeout_seconds", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CollectiveReduceV3::new().build(input, communicator, group_assignment, scope)`.
pub fn collective_reduce_v3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    communicator: O1,
    group_assignment: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CollectiveReduceV3::new().build(input, communicator, group_assignment, scope)
}
/// Builder for the `CombinedNonMaxSuppression` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CombinedNonMaxSuppression {
    pad_per_class: ::std::option::Option<bool>,
    clip_boxes: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CombinedNonMaxSuppression {
    /// Creates a new `CombinedNonMaxSuppression`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `pad_per_class` attribute.
    pub fn pad_per_class<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.pad_per_class = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `clip_boxes` attribute.
    pub fn clip_boxes<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.clip_boxes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CombinedNonMaxSuppression` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        boxes: O0,
        scores: O1,
        max_output_size_per_class: O2,
        max_total_size: O3,
        iou_threshold: O4,
        score_threshold: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            boxes.into(),
            scores.into(),
            max_output_size_per_class.into(),
            max_total_size.into(),
            iou_threshold.into(),
            score_threshold.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        boxes: crate::Output,
        scores: crate::Output,
        max_output_size_per_class: crate::Output,
        max_total_size: crate::Output,
        iou_threshold: crate::Output,
        score_threshold: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CombinedNonMaxSuppression", |nd| {
            nd.add_input(boxes);
            nd.add_input(scores);
            nd.add_input(max_output_size_per_class);
            nd.add_input(max_total_size);
            nd.add_input(iou_threshold);
            nd.add_input(score_threshold);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.pad_per_class {
                nd.set_attr_bool("pad_per_class", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.clip_boxes {
                nd.set_attr_bool("clip_boxes", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CombinedNonMaxSuppression::new().build(boxes, scores, max_output_size_per_class, max_total_size, iou_threshold, score_threshold, scope)`.
pub fn combined_non_max_suppression<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    boxes: O0,
    scores: O1,
    max_output_size_per_class: O2,
    max_total_size: O3,
    iou_threshold: O4,
    score_threshold: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CombinedNonMaxSuppression::new().build(
        boxes,
        scores,
        max_output_size_per_class,
        max_total_size,
        iou_threshold,
        score_threshold,
        scope,
    )
}
/// Builder for the `Complex` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Complex {
    T: ::std::option::Option<crate::DataType>,
    Tout: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Complex {
    /// Creates a new `Complex`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Complex` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        real: O0,
        imag: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(real.into(), imag.into(), scope)
    }

    fn build_impl(
        &self,
        real: crate::Output,
        imag: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Complex", |nd| {
            nd.add_input(real);
            nd.add_input(imag);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type("Tout", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Complex::new().build(real, imag, scope)`.
pub fn complex<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    real: O0,
    imag: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Complex::new().build(real, imag, scope)
}
/// Builder for the `ComplexAbs` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ComplexAbs {
    T: ::std::option::Option<crate::DataType>,
    Tout: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ComplexAbs {
    /// Creates a new `ComplexAbs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ComplexAbs` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ComplexAbs", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type("Tout", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ComplexAbs::new().build(x, scope)`.
pub fn complex_abs<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ComplexAbs::new().build(x, scope)
}
/// Builder for the `CompositeTensorVariantFromComponents` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CompositeTensorVariantFromComponents {
    metadata: ::std::option::Option<::std::string::String>,
    Tcomponents: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CompositeTensorVariantFromComponents {
    /// Creates a new `CompositeTensorVariantFromComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tcomponents` attribute.
    pub fn Tcomponents<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tcomponents = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CompositeTensorVariantFromComponents` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        components: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(components.into(), scope)
    }

    fn build_impl(
        &self,
        components: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CompositeTensorVariantFromComponents", |nd| {
            nd.add_input(components);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tcomponents {
                nd.set_attr_type_list("Tcomponents", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CompositeTensorVariantFromComponents::new().build(components, scope)`.
pub fn composite_tensor_variant_from_components<O0: ::std::convert::Into<crate::Output>>(
    components: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CompositeTensorVariantFromComponents::new().build(components, scope)
}
/// Builder for the `CompositeTensorVariantToComponents` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CompositeTensorVariantToComponents {
    metadata: ::std::option::Option<::std::string::String>,
    Tcomponents: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CompositeTensorVariantToComponents {
    /// Creates a new `CompositeTensorVariantToComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tcomponents` attribute.
    pub fn Tcomponents<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tcomponents = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CompositeTensorVariantToComponents` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        encoded: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(encoded.into(), scope)
    }

    fn build_impl(
        &self,
        encoded: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CompositeTensorVariantToComponents", |nd| {
            nd.add_input(encoded);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tcomponents {
                nd.set_attr_type_list("Tcomponents", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CompositeTensorVariantToComponents::new().build(encoded, scope)`.
pub fn composite_tensor_variant_to_components<O0: ::std::convert::Into<crate::Output>>(
    encoded: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CompositeTensorVariantToComponents::new().build(encoded, scope)
}
/// Builder for the `CompressElement` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CompressElement {
    input_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CompressElement {
    /// Creates a new `CompressElement`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `input_types` attribute.
    pub fn input_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CompressElement` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        components: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(components.into(), scope)
    }

    fn build_impl(
        &self,
        components: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CompressElement", |nd| {
            nd.add_input(components);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.input_types {
                nd.set_attr_type_list("input_types", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CompressElement::new().build(components, scope)`.
pub fn compress_element<O0: ::std::convert::Into<crate::Output>>(
    components: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CompressElement::new().build(components, scope)
}
/// Builder for the `ComputeAccidentalHits` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ComputeAccidentalHits {
    num_true: ::std::option::Option<i64>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ComputeAccidentalHits {
    /// Creates a new `ComputeAccidentalHits`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_true` attribute.
    pub fn num_true<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_true = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ComputeAccidentalHits` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        true_classes: O0,
        sampled_candidates: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(true_classes.into(), sampled_candidates.into(), scope)
    }

    fn build_impl(
        &self,
        true_classes: crate::Output,
        sampled_candidates: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ComputeAccidentalHits", |nd| {
            nd.add_input(true_classes);
            nd.add_input(sampled_candidates);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_true {
                nd.set_attr_int("num_true", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ComputeAccidentalHits::new().build(true_classes, sampled_candidates, scope)`.
pub fn compute_accidental_hits<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    true_classes: O0,
    sampled_candidates: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ComputeAccidentalHits::new().build(true_classes, sampled_candidates, scope)
}
/// Builder for the `ComputeBatchSize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ComputeBatchSize {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ComputeBatchSize {
    /// Creates a new `ComputeBatchSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ComputeBatchSize` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input_dataset: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ComputeBatchSize", |nd| {
            nd.add_input(input_dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ComputeBatchSize::new().build(input_dataset, scope)`.
pub fn compute_batch_size<O0: ::std::convert::Into<crate::Output>>(
    input_dataset: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ComputeBatchSize::new().build(input_dataset, scope)
}
/// Builder for the `Concat` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Concat {
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Concat {
    /// Creates a new `Concat`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Concat` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        concat_dim: O0,
        values: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(concat_dim.into(), values.into(), scope)
    }

    fn build_impl(
        &self,
        concat_dim: crate::Output,
        values: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Concat", |nd| {
            nd.add_input(concat_dim);
            nd.add_input(values);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Concat::new().build(concat_dim, values, scope)`.
pub fn concat<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    concat_dim: O0,
    values: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Concat::new().build(concat_dim, values, scope)
}
/// Builder for the `ConcatOffset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConcatOffset {
    N: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConcatOffset {
    /// Creates a new `ConcatOffset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConcatOffset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        concat_dim: O0,
        shape: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(concat_dim.into(), shape.into(), scope)
    }

    fn build_impl(
        &self,
        concat_dim: crate::Output,
        shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ConcatOffset", |nd| {
            nd.add_input(concat_dim);
            nd.add_input(shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConcatOffset::new().build(concat_dim, shape, scope)`.
pub fn concat_offset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    concat_dim: O0,
    shape: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ConcatOffset::new().build(concat_dim, shape, scope)
}
/// Builder for the `ConcatV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConcatV2 {
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConcatV2 {
    /// Creates a new `ConcatV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConcatV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        values: O0,
        axis: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(values.into(), axis.into(), scope)
    }

    fn build_impl(
        &self,
        values: crate::Output,
        axis: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ConcatV2", |nd| {
            nd.add_input(values);
            nd.add_input(axis);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConcatV2::new().build(values, axis, scope)`.
pub fn concat_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    values: O0,
    axis: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ConcatV2::new().build(values, axis, scope)
}
/// Builder for the `ConcatenateDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConcatenateDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConcatenateDataset {
    /// Creates a new `ConcatenateDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConcatenateDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        another_dataset: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), another_dataset.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        another_dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ConcatenateDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(another_dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConcatenateDataset::new().build(input_dataset, another_dataset, scope)`.
pub fn concatenate_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    another_dataset: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ConcatenateDataset::new().build(input_dataset, another_dataset, scope)
}
/// Builder for the `ConditionalAccumulator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConditionalAccumulator {
    dtype: ::std::option::Option<crate::DataType>,
    shape: ::std::option::Option<crate::Shape>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    reduction_type: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConditionalAccumulator {
    /// Creates a new `ConditionalAccumulator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reduction_type` attribute.
    pub fn reduction_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.reduction_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConditionalAccumulator` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("ConditionalAccumulator", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shape {
                nd.set_attr_shape("shape", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.container {
                nd.set_attr_string("container", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.shared_name {
                nd.set_attr_string("shared_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.reduction_type {
                nd.set_attr_string("reduction_type", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConditionalAccumulator::new().build(scope)`.
pub fn conditional_accumulator(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    ConditionalAccumulator::new().build(scope)
}
/// Builder for the `ConfigureDistributedTPU` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConfigureDistributedTPU {
    embedding_config: ::std::option::Option<::std::string::String>,
    tpu_embedding_config: ::std::option::Option<::std::string::String>,
    is_global_init: ::std::option::Option<bool>,
    enable_whole_mesh_compilations: ::std::option::Option<bool>,
    compilation_failure_closes_chips: ::std::option::Option<bool>,
    tpu_cancellation_closes_chips: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConfigureDistributedTPU {
    /// Creates a new `ConfigureDistributedTPU`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `embedding_config` attribute.
    pub fn embedding_config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.embedding_config = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tpu_embedding_config` attribute.
    pub fn tpu_embedding_config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tpu_embedding_config = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_global_init` attribute.
    pub fn is_global_init<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_global_init = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `enable_whole_mesh_compilations` attribute.
    pub fn enable_whole_mesh_compilations<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.enable_whole_mesh_compilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `compilation_failure_closes_chips` attribute.
    pub fn compilation_failure_closes_chips<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.compilation_failure_closes_chips = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tpu_cancellation_closes_chips` attribute.
    pub fn tpu_cancellation_closes_chips<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tpu_cancellation_closes_chips = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConfigureDistributedTPU` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("ConfigureDistributedTPU", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.embedding_config {
                nd.set_attr_string("embedding_config", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tpu_embedding_config {
                nd.set_attr_string("tpu_embedding_config", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.is_global_init {
                nd.set_attr_bool("is_global_init", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.enable_whole_mesh_compilations {
                nd.set_attr_bool("enable_whole_mesh_compilations", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.compilation_failure_closes_chips {
                nd.set_attr_bool("compilation_failure_closes_chips", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tpu_cancellation_closes_chips {
                nd.set_attr_int("tpu_cancellation_closes_chips", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConfigureDistributedTPU::new().build(scope)`.
pub fn configure_distributed_tpu(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    ConfigureDistributedTPU::new().build(scope)
}
/// Builder for the `ConfigureTPUEmbedding` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConfigureTPUEmbedding {
    config: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConfigureTPUEmbedding {
    /// Creates a new `ConfigureTPUEmbedding`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `config` attribute.
    pub fn config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.config = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConfigureTPUEmbedding` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("ConfigureTPUEmbedding", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.config {
                nd.set_attr_string("config", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConfigureTPUEmbedding::new().build(scope)`.
pub fn configure_tpuembedding(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    ConfigureTPUEmbedding::new().build(scope)
}
/// Builder for the `Conj` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conj {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conj {
    /// Creates a new `Conj`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conj` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conj", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conj::new().build(input, scope)`.
pub fn conj<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conj::new().build(input, scope)
}
/// Builder for the `ConjugateTranspose` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConjugateTranspose {
    T: ::std::option::Option<crate::DataType>,
    Tperm: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConjugateTranspose {
    /// Creates a new `ConjugateTranspose`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tperm` attribute.
    pub fn Tperm<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tperm = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConjugateTranspose` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        perm: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), perm.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        perm: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ConjugateTranspose", |nd| {
            nd.add_input(x);
            nd.add_input(perm);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tperm {
                nd.set_attr_type("Tperm", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConjugateTranspose::new().build(x, perm, scope)`.
pub fn conjugate_transpose<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    perm: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ConjugateTranspose::new().build(x, perm, scope)
}
/// Builder for the `Const` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Const {
    value: ::std::option::Option<::std::boxed::Box<dyn crate::AnyTensor>>,
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Const {
    /// Creates a new `Const`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `value` attribute.
    pub fn value<T: crate::TensorType, ArgType: ::std::convert::Into<crate::Tensor<T>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value = ::std::option::Option::Some(
            (::std::boxed::Box::new(value.into()) as ::std::boxed::Box<dyn crate::AnyTensor>),
        );
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Const` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("Const", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.value {
                nd.set_attr_any_tensor("value", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Const::new().build(scope)`.
pub fn const_(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    Const::new().build(scope)
}
/// Builder for the `ConsumeMutexLock` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ConsumeMutexLock {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ConsumeMutexLock {
    /// Creates a new `ConsumeMutexLock`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ConsumeMutexLock` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        mutex_lock: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(mutex_lock.into(), scope)
    }

    fn build_impl(
        &self,
        mutex_lock: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("ConsumeMutexLock", |nd| {
            nd.add_input(mutex_lock);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ConsumeMutexLock::new().build(mutex_lock, scope)`.
pub fn consume_mutex_lock<O0: ::std::convert::Into<crate::Output>>(
    mutex_lock: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    ConsumeMutexLock::new().build(mutex_lock, scope)
}
/// Builder for the `ControlTrigger` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct ControlTrigger {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl ControlTrigger {
    /// Creates a new `ControlTrigger`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `ControlTrigger` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("ControlTrigger", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `ControlTrigger::new().build(scope)`.
pub fn control_trigger(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    ControlTrigger::new().build(scope)
}
/// Builder for the `Conv2D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv2D {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv2D {
    /// Creates a new `Conv2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv2D` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv2D", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
                nd.set_attr_bool("use_cudnn_on_gpu", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv2D::new().build(input, filter, scope)`.
pub fn conv2_d<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    filter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv2D::new().build(input, filter, scope)
}
/// Builder for the `Conv2DBackpropFilter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv2DBackpropFilter {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv2DBackpropFilter {
    /// Creates a new `Conv2DBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv2DBackpropFilter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter_sizes: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            filter_sizes.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter_sizes: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv2DBackpropFilter", |nd| {
            nd.add_input(input);
            nd.add_input(filter_sizes);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
                nd.set_attr_bool("use_cudnn_on_gpu", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv2DBackpropFilter::new().build(input, filter_sizes, out_backprop, scope)`.
pub fn conv2_dbackprop_filter<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter_sizes: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv2DBackpropFilter::new().build(input, filter_sizes, out_backprop, scope)
}
/// Builder for the `Conv2DBackpropInput` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv2DBackpropInput {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv2DBackpropInput {
    /// Creates a new `Conv2DBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv2DBackpropInput` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_sizes: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_sizes.into(),
            filter.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_sizes: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv2DBackpropInput", |nd| {
            nd.add_input(input_sizes);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
                nd.set_attr_bool("use_cudnn_on_gpu", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv2DBackpropInput::new().build(input_sizes, filter, out_backprop, scope)`.
pub fn conv2_dbackprop_input<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_sizes: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv2DBackpropInput::new().build(input_sizes, filter, out_backprop, scope)
}
/// Builder for the `Conv3D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv3D {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv3D {
    /// Creates a new `Conv3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv3D` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv3D", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv3D::new().build(input, filter, scope)`.
pub fn conv3_d<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    input: O0,
    filter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv3D::new().build(input, filter, scope)
}
/// Builder for the `Conv3DBackpropFilter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv3DBackpropFilter {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv3DBackpropFilter {
    /// Creates a new `Conv3DBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv3DBackpropFilter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), out_backprop.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv3DBackpropFilter", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv3DBackpropFilter::new().build(input, filter, out_backprop, scope)`.
pub fn conv3_dbackprop_filter<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv3DBackpropFilter::new().build(input, filter, out_backprop, scope)
}
/// Builder for the `Conv3DBackpropFilterV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv3DBackpropFilterV2 {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv3DBackpropFilterV2 {
    /// Creates a new `Conv3DBackpropFilterV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv3DBackpropFilterV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter_sizes: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            filter_sizes.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter_sizes: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv3DBackpropFilterV2", |nd| {
            nd.add_input(input);
            nd.add_input(filter_sizes);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv3DBackpropFilterV2::new().build(input, filter_sizes, out_backprop, scope)`.
pub fn conv3_dbackprop_filter_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter_sizes: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv3DBackpropFilterV2::new().build(input, filter_sizes, out_backprop, scope)
}
/// Builder for the `Conv3DBackpropInput` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv3DBackpropInput {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv3DBackpropInput {
    /// Creates a new `Conv3DBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv3DBackpropInput` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), out_backprop.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv3DBackpropInput", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv3DBackpropInput::new().build(input, filter, out_backprop, scope)`.
pub fn conv3_dbackprop_input<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv3DBackpropInput::new().build(input, filter, out_backprop, scope)
}
/// Builder for the `Conv3DBackpropInputV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Conv3DBackpropInputV2 {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    Tshape: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Conv3DBackpropInputV2 {
    /// Creates a new `Conv3DBackpropInputV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tshape` attribute.
    pub fn Tshape<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tshape = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Conv3DBackpropInputV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_sizes: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_sizes.into(),
            filter.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_sizes: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Conv3DBackpropInputV2", |nd| {
            nd.add_input(input_sizes);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tshape {
                nd.set_attr_type("Tshape", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Conv3DBackpropInputV2::new().build(input_sizes, filter, out_backprop, scope)`.
pub fn conv3_dbackprop_input_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_sizes: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Conv3DBackpropInputV2::new().build(input_sizes, filter, out_backprop, scope)
}
/// Builder for the `Copy` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Copy {
    T: ::std::option::Option<crate::DataType>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_ops_spec: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Copy {
    /// Creates a new `Copy`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_ops_spec` attribute.
    pub fn debug_ops_spec<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_ops_spec = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Copy` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Copy", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_name {
                nd.set_attr_string("tensor_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_ops_spec {
                nd.set_attr_string_list("debug_ops_spec", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Copy::new().build(input, scope)`.
pub fn copy<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Copy::new().build(input, scope)
}
/// Builder for the `CopyHost` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CopyHost {
    T: ::std::option::Option<crate::DataType>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_ops_spec: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CopyHost {
    /// Creates a new `CopyHost`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_ops_spec` attribute.
    pub fn debug_ops_spec<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_ops_spec = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CopyHost` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CopyHost", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_name {
                nd.set_attr_string("tensor_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_ops_spec {
                nd.set_attr_string_list("debug_ops_spec", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CopyHost::new().build(input, scope)`.
pub fn copy_host<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CopyHost::new().build(input, scope)
}
/// Builder for the `Cos` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cos {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cos {
    /// Creates a new `Cos`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cos` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cos", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cos::new().build(x, scope)`.
pub fn cos<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cos::new().build(x, scope)
}
/// Builder for the `Cosh` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cosh {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cosh {
    /// Creates a new `Cosh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cosh` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cosh", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cosh::new().build(x, scope)`.
pub fn cosh<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cosh::new().build(x, scope)
}
/// Builder for the `CountUpTo` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CountUpTo {
    limit: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CountUpTo {
    /// Creates a new `CountUpTo`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `limit` attribute.
    pub fn limit<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.limit = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CountUpTo` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        ref_: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(ref_.into(), scope)
    }

    fn build_impl(
        &self,
        ref_: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CountUpTo", |nd| {
            nd.add_input(ref_);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.limit {
                nd.set_attr_int("limit", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CountUpTo::new().build(ref_, scope)`.
pub fn count_up_to<O0: ::std::convert::Into<crate::Output>>(
    ref_: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CountUpTo::new().build(ref_, scope)
}
/// Builder for the `CreateSummaryDbWriter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CreateSummaryDbWriter {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CreateSummaryDbWriter {
    /// Creates a new `CreateSummaryDbWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CreateSummaryDbWriter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        writer: O0,
        db_uri: O1,
        experiment_name: O2,
        run_name: O3,
        user_name: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            writer.into(),
            db_uri.into(),
            experiment_name.into(),
            run_name.into(),
            user_name.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        writer: crate::Output,
        db_uri: crate::Output,
        experiment_name: crate::Output,
        run_name: crate::Output,
        user_name: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CreateSummaryDbWriter", |nd| {
            nd.add_input(writer);
            nd.add_input(db_uri);
            nd.add_input(experiment_name);
            nd.add_input(run_name);
            nd.add_input(user_name);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CreateSummaryDbWriter::new().build(writer, db_uri, experiment_name, run_name, user_name, scope)`.
pub fn create_summary_db_writer<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    writer: O0,
    db_uri: O1,
    experiment_name: O2,
    run_name: O3,
    user_name: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CreateSummaryDbWriter::new().build(writer, db_uri, experiment_name, run_name, user_name, scope)
}
/// Builder for the `CreateSummaryFileWriter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CreateSummaryFileWriter {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CreateSummaryFileWriter {
    /// Creates a new `CreateSummaryFileWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CreateSummaryFileWriter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        writer: O0,
        logdir: O1,
        max_queue: O2,
        flush_millis: O3,
        filename_suffix: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            writer.into(),
            logdir.into(),
            max_queue.into(),
            flush_millis.into(),
            filename_suffix.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        writer: crate::Output,
        logdir: crate::Output,
        max_queue: crate::Output,
        flush_millis: crate::Output,
        filename_suffix: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CreateSummaryFileWriter", |nd| {
            nd.add_input(writer);
            nd.add_input(logdir);
            nd.add_input(max_queue);
            nd.add_input(flush_millis);
            nd.add_input(filename_suffix);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CreateSummaryFileWriter::new().build(writer, logdir, max_queue, flush_millis, filename_suffix, scope)`.
pub fn create_summary_file_writer<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    writer: O0,
    logdir: O1,
    max_queue: O2,
    flush_millis: O3,
    filename_suffix: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CreateSummaryFileWriter::new().build(
        writer,
        logdir,
        max_queue,
        flush_millis,
        filename_suffix,
        scope,
    )
}
/// Builder for the `CropAndResize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CropAndResize {
    T: ::std::option::Option<crate::DataType>,
    method: ::std::option::Option<::std::string::String>,
    extrapolation_value: ::std::option::Option<f32>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CropAndResize {
    /// Creates a new `CropAndResize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `extrapolation_value` attribute.
    pub fn extrapolation_value<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.extrapolation_value = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CropAndResize` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        image: O0,
        boxes: O1,
        box_ind: O2,
        crop_size: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            image.into(),
            boxes.into(),
            box_ind.into(),
            crop_size.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        image: crate::Output,
        boxes: crate::Output,
        box_ind: crate::Output,
        crop_size: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CropAndResize", |nd| {
            nd.add_input(image);
            nd.add_input(boxes);
            nd.add_input(box_ind);
            nd.add_input(crop_size);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.method {
                nd.set_attr_string("method", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.extrapolation_value {
                nd.set_attr_float("extrapolation_value", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CropAndResize::new().build(image, boxes, box_ind, crop_size, scope)`.
pub fn crop_and_resize<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    image: O0,
    boxes: O1,
    box_ind: O2,
    crop_size: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CropAndResize::new().build(image, boxes, box_ind, crop_size, scope)
}
/// Builder for the `CropAndResizeGradBoxes` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CropAndResizeGradBoxes {
    T: ::std::option::Option<crate::DataType>,
    method: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CropAndResizeGradBoxes {
    /// Creates a new `CropAndResizeGradBoxes`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CropAndResizeGradBoxes` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        grads: O0,
        image: O1,
        boxes: O2,
        box_ind: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            grads.into(),
            image.into(),
            boxes.into(),
            box_ind.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        grads: crate::Output,
        image: crate::Output,
        boxes: crate::Output,
        box_ind: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CropAndResizeGradBoxes", |nd| {
            nd.add_input(grads);
            nd.add_input(image);
            nd.add_input(boxes);
            nd.add_input(box_ind);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.method {
                nd.set_attr_string("method", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CropAndResizeGradBoxes::new().build(grads, image, boxes, box_ind, scope)`.
pub fn crop_and_resize_grad_boxes<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    grads: O0,
    image: O1,
    boxes: O2,
    box_ind: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CropAndResizeGradBoxes::new().build(grads, image, boxes, box_ind, scope)
}
/// Builder for the `CropAndResizeGradImage` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CropAndResizeGradImage {
    T: ::std::option::Option<crate::DataType>,
    method: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CropAndResizeGradImage {
    /// Creates a new `CropAndResizeGradImage`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CropAndResizeGradImage` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        grads: O0,
        boxes: O1,
        box_ind: O2,
        image_size: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            grads.into(),
            boxes.into(),
            box_ind.into(),
            image_size.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        grads: crate::Output,
        boxes: crate::Output,
        box_ind: crate::Output,
        image_size: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CropAndResizeGradImage", |nd| {
            nd.add_input(grads);
            nd.add_input(boxes);
            nd.add_input(box_ind);
            nd.add_input(image_size);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.method {
                nd.set_attr_string("method", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CropAndResizeGradImage::new().build(grads, boxes, box_ind, image_size, scope)`.
pub fn crop_and_resize_grad_image<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    grads: O0,
    boxes: O1,
    box_ind: O2,
    image_size: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CropAndResizeGradImage::new().build(grads, boxes, box_ind, image_size, scope)
}
/// Builder for the `Cross` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cross {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cross {
    /// Creates a new `Cross`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cross` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        a: O0,
        b: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(a.into(), b.into(), scope)
    }

    fn build_impl(
        &self,
        a: crate::Output,
        b: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cross", |nd| {
            nd.add_input(a);
            nd.add_input(b);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cross::new().build(a, b, scope)`.
pub fn cross<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    a: O0,
    b: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cross::new().build(a, b, scope)
}
/// Builder for the `CrossReplicaSum` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CrossReplicaSum {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CrossReplicaSum {
    /// Creates a new `CrossReplicaSum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CrossReplicaSum` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        group_assignment: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), group_assignment.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        group_assignment: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CrossReplicaSum", |nd| {
            nd.add_input(input);
            nd.add_input(group_assignment);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CrossReplicaSum::new().build(input, group_assignment, scope)`.
pub fn cross_replica_sum<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    group_assignment: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CrossReplicaSum::new().build(input, group_assignment, scope)
}
/// Builder for the `CudnnRNN` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNN {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNN {
    /// Creates a new `CudnnRNN`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNN` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNN", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.is_training {
                nd.set_attr_bool("is_training", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNN::new().build(input, input_h, input_c, params, scope)`.
pub fn cudnn_rnn<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNN::new().build(input, input_h, input_c, params, scope)
}
/// Builder for the `CudnnRNNBackprop` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNBackprop {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNBackprop {
    /// Creates a new `CudnnRNNBackprop`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNBackprop` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        output: O4,
        output_h: O5,
        output_c: O6,
        output_backprop: O7,
        output_h_backprop: O8,
        output_c_backprop: O9,
        reserve_space: O10,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            output.into(),
            output_h.into(),
            output_c.into(),
            output_backprop.into(),
            output_h_backprop.into(),
            output_c_backprop.into(),
            reserve_space.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        output: crate::Output,
        output_h: crate::Output,
        output_c: crate::Output,
        output_backprop: crate::Output,
        output_h_backprop: crate::Output,
        output_c_backprop: crate::Output,
        reserve_space: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNBackprop", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            nd.add_input(output);
            nd.add_input(output_h);
            nd.add_input(output_c);
            nd.add_input(output_backprop);
            nd.add_input(output_h_backprop);
            nd.add_input(output_c_backprop);
            nd.add_input(reserve_space);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNBackprop::new().build(input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, scope)`.
pub fn cudnn_rnnbackprop<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    output: O4,
    output_h: O5,
    output_c: O6,
    output_backprop: O7,
    output_h_backprop: O8,
    output_c_backprop: O9,
    reserve_space: O10,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNBackprop::new().build(
        input,
        input_h,
        input_c,
        params,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
        scope,
    )
}
/// Builder for the `CudnnRNNBackpropV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNBackpropV2 {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNBackpropV2 {
    /// Creates a new `CudnnRNNBackpropV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNBackpropV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
        O11: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        output: O4,
        output_h: O5,
        output_c: O6,
        output_backprop: O7,
        output_h_backprop: O8,
        output_c_backprop: O9,
        reserve_space: O10,
        host_reserved: O11,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            output.into(),
            output_h.into(),
            output_c.into(),
            output_backprop.into(),
            output_h_backprop.into(),
            output_c_backprop.into(),
            reserve_space.into(),
            host_reserved.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        output: crate::Output,
        output_h: crate::Output,
        output_c: crate::Output,
        output_backprop: crate::Output,
        output_h_backprop: crate::Output,
        output_c_backprop: crate::Output,
        reserve_space: crate::Output,
        host_reserved: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNBackpropV2", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            nd.add_input(output);
            nd.add_input(output_h);
            nd.add_input(output_c);
            nd.add_input(output_backprop);
            nd.add_input(output_h_backprop);
            nd.add_input(output_c_backprop);
            nd.add_input(reserve_space);
            nd.add_input(host_reserved);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNBackpropV2::new().build(input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved, scope)`.
pub fn cudnn_rnnbackprop_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
    O11: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    output: O4,
    output_h: O5,
    output_c: O6,
    output_backprop: O7,
    output_h_backprop: O8,
    output_c_backprop: O9,
    reserve_space: O10,
    host_reserved: O11,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNBackpropV2::new().build(
        input,
        input_h,
        input_c,
        params,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
        host_reserved,
        scope,
    )
}
/// Builder for the `CudnnRNNBackpropV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNBackpropV3 {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    time_major: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNBackpropV3 {
    /// Creates a new `CudnnRNNBackpropV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `time_major` attribute.
    pub fn time_major<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.time_major = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNBackpropV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
        O9: ::std::convert::Into<crate::Output>,
        O10: ::std::convert::Into<crate::Output>,
        O11: ::std::convert::Into<crate::Output>,
        O12: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        sequence_lengths: O4,
        output: O5,
        output_h: O6,
        output_c: O7,
        output_backprop: O8,
        output_h_backprop: O9,
        output_c_backprop: O10,
        reserve_space: O11,
        host_reserved: O12,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            sequence_lengths.into(),
            output.into(),
            output_h.into(),
            output_c.into(),
            output_backprop.into(),
            output_h_backprop.into(),
            output_c_backprop.into(),
            reserve_space.into(),
            host_reserved.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        sequence_lengths: crate::Output,
        output: crate::Output,
        output_h: crate::Output,
        output_c: crate::Output,
        output_backprop: crate::Output,
        output_h_backprop: crate::Output,
        output_c_backprop: crate::Output,
        reserve_space: crate::Output,
        host_reserved: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNBackpropV3", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            nd.add_input(sequence_lengths);
            nd.add_input(output);
            nd.add_input(output_h);
            nd.add_input(output_c);
            nd.add_input(output_backprop);
            nd.add_input(output_h_backprop);
            nd.add_input(output_c_backprop);
            nd.add_input(reserve_space);
            nd.add_input(host_reserved);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_proj {
                nd.set_attr_int("num_proj", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.time_major {
                nd.set_attr_bool("time_major", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNBackpropV3::new().build(input, input_h, input_c, params, sequence_lengths, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved, scope)`.
pub fn cudnn_rnnbackprop_v3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
    O9: ::std::convert::Into<crate::Output>,
    O10: ::std::convert::Into<crate::Output>,
    O11: ::std::convert::Into<crate::Output>,
    O12: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    sequence_lengths: O4,
    output: O5,
    output_h: O6,
    output_c: O7,
    output_backprop: O8,
    output_h_backprop: O9,
    output_c_backprop: O10,
    reserve_space: O11,
    host_reserved: O12,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNBackpropV3::new().build(
        input,
        input_h,
        input_c,
        params,
        sequence_lengths,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
        host_reserved,
        scope,
    )
}
/// Builder for the `CudnnRNNCanonicalToParams` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNCanonicalToParams {
    T: ::std::option::Option<crate::DataType>,
    num_params: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNCanonicalToParams {
    /// Creates a new `CudnnRNNCanonicalToParams`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params` attribute.
    pub fn num_params<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNCanonicalToParams` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        num_layers: O0,
        num_units: O1,
        input_size: O2,
        weights: O3,
        biases: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            num_layers.into(),
            num_units.into(),
            input_size.into(),
            weights.into(),
            biases.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        num_layers: crate::Output,
        num_units: crate::Output,
        input_size: crate::Output,
        weights: crate::Output,
        biases: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNCanonicalToParams", |nd| {
            nd.add_input(num_layers);
            nd.add_input(num_units);
            nd.add_input(input_size);
            nd.add_input(weights);
            nd.add_input(biases);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params {
                nd.set_attr_int("num_params", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNCanonicalToParams::new().build(num_layers, num_units, input_size, weights, biases, scope)`.
pub fn cudnn_rnncanonical_to_params<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    num_layers: O0,
    num_units: O1,
    input_size: O2,
    weights: O3,
    biases: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNCanonicalToParams::new()
        .build(num_layers, num_units, input_size, weights, biases, scope)
}
/// Builder for the `CudnnRNNCanonicalToParamsV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNCanonicalToParamsV2 {
    T: ::std::option::Option<crate::DataType>,
    num_params_weights: ::std::option::Option<i64>,
    num_params_biases: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNCanonicalToParamsV2 {
    /// Creates a new `CudnnRNNCanonicalToParamsV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params_weights` attribute.
    pub fn num_params_weights<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_params_weights = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params_biases` attribute.
    pub fn num_params_biases<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params_biases = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNCanonicalToParamsV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        num_layers: O0,
        num_units: O1,
        input_size: O2,
        weights: O3,
        biases: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            num_layers.into(),
            num_units.into(),
            input_size.into(),
            weights.into(),
            biases.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        num_layers: crate::Output,
        num_units: crate::Output,
        input_size: crate::Output,
        weights: crate::Output,
        biases: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNCanonicalToParamsV2", |nd| {
            nd.add_input(num_layers);
            nd.add_input(num_units);
            nd.add_input(input_size);
            nd.add_input(weights);
            nd.add_input(biases);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params_weights {
                nd.set_attr_int("num_params_weights", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params_biases {
                nd.set_attr_int("num_params_biases", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_proj {
                nd.set_attr_int("num_proj", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNCanonicalToParamsV2::new().build(num_layers, num_units, input_size, weights, biases, scope)`.
pub fn cudnn_rnncanonical_to_params_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    num_layers: O0,
    num_units: O1,
    input_size: O2,
    weights: O3,
    biases: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNCanonicalToParamsV2::new()
        .build(num_layers, num_units, input_size, weights, biases, scope)
}
/// Builder for the `CudnnRNNParamsSize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNParamsSize {
    T: ::std::option::Option<crate::DataType>,
    S: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNParamsSize {
    /// Creates a new `CudnnRNNParamsSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `S` attribute.
    pub fn S<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.S = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNParamsSize` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        num_layers: O0,
        num_units: O1,
        input_size: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            num_layers.into(),
            num_units.into(),
            input_size.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        num_layers: crate::Output,
        num_units: crate::Output,
        input_size: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNParamsSize", |nd| {
            nd.add_input(num_layers);
            nd.add_input(num_units);
            nd.add_input(input_size);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.S {
                nd.set_attr_type("S", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_proj {
                nd.set_attr_int("num_proj", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNParamsSize::new().build(num_layers, num_units, input_size, scope)`.
pub fn cudnn_rnnparams_size<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    num_layers: O0,
    num_units: O1,
    input_size: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNParamsSize::new().build(num_layers, num_units, input_size, scope)
}
/// Builder for the `CudnnRNNParamsToCanonical` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNParamsToCanonical {
    T: ::std::option::Option<crate::DataType>,
    num_params: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNParamsToCanonical {
    /// Creates a new `CudnnRNNParamsToCanonical`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params` attribute.
    pub fn num_params<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNParamsToCanonical` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        num_layers: O0,
        num_units: O1,
        input_size: O2,
        params: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            num_layers.into(),
            num_units.into(),
            input_size.into(),
            params.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        num_layers: crate::Output,
        num_units: crate::Output,
        input_size: crate::Output,
        params: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNParamsToCanonical", |nd| {
            nd.add_input(num_layers);
            nd.add_input(num_units);
            nd.add_input(input_size);
            nd.add_input(params);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params {
                nd.set_attr_int("num_params", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNParamsToCanonical::new().build(num_layers, num_units, input_size, params, scope)`.
pub fn cudnn_rnnparams_to_canonical<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    num_layers: O0,
    num_units: O1,
    input_size: O2,
    params: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNParamsToCanonical::new().build(num_layers, num_units, input_size, params, scope)
}
/// Builder for the `CudnnRNNParamsToCanonicalV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNParamsToCanonicalV2 {
    T: ::std::option::Option<crate::DataType>,
    num_params_weights: ::std::option::Option<i64>,
    num_params_biases: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNParamsToCanonicalV2 {
    /// Creates a new `CudnnRNNParamsToCanonicalV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params_weights` attribute.
    pub fn num_params_weights<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_params_weights = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params_biases` attribute.
    pub fn num_params_biases<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params_biases = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNParamsToCanonicalV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        num_layers: O0,
        num_units: O1,
        input_size: O2,
        params: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            num_layers.into(),
            num_units.into(),
            input_size.into(),
            params.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        num_layers: crate::Output,
        num_units: crate::Output,
        input_size: crate::Output,
        params: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNParamsToCanonicalV2", |nd| {
            nd.add_input(num_layers);
            nd.add_input(num_units);
            nd.add_input(input_size);
            nd.add_input(params);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params_weights {
                nd.set_attr_int("num_params_weights", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_params_biases {
                nd.set_attr_int("num_params_biases", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_proj {
                nd.set_attr_int("num_proj", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNParamsToCanonicalV2::new().build(num_layers, num_units, input_size, params, scope)`.
pub fn cudnn_rnnparams_to_canonical_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    num_layers: O0,
    num_units: O1,
    input_size: O2,
    params: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNParamsToCanonicalV2::new().build(num_layers, num_units, input_size, params, scope)
}
/// Builder for the `CudnnRNNV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNV2 {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNV2 {
    /// Creates a new `CudnnRNNV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNV2", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.is_training {
                nd.set_attr_bool("is_training", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNV2::new().build(input, input_h, input_c, params, scope)`.
pub fn cudnn_rnnv2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNV2::new().build(input, input_h, input_c, params, scope)
}
/// Builder for the `CudnnRNNV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CudnnRNNV3 {
    T: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    time_major: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CudnnRNNV3 {
    /// Creates a new `CudnnRNNV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `time_major` attribute.
    pub fn time_major<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.time_major = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CudnnRNNV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        input_h: O1,
        input_c: O2,
        params: O3,
        sequence_lengths: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            input_h.into(),
            input_c.into(),
            params.into(),
            sequence_lengths.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        input_h: crate::Output,
        input_c: crate::Output,
        params: crate::Output,
        sequence_lengths: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CudnnRNNV3", |nd| {
            nd.add_input(input);
            nd.add_input(input_h);
            nd.add_input(input_c);
            nd.add_input(params);
            nd.add_input(sequence_lengths);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rnn_mode {
                nd.set_attr_string("rnn_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.input_mode {
                nd.set_attr_string("input_mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.direction {
                nd.set_attr_string("direction", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dropout {
                nd.set_attr_float("dropout", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed {
                nd.set_attr_int("seed", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.seed2 {
                nd.set_attr_int("seed2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.num_proj {
                nd.set_attr_int("num_proj", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.is_training {
                nd.set_attr_bool("is_training", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.time_major {
                nd.set_attr_bool("time_major", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CudnnRNNV3::new().build(input, input_h, input_c, params, sequence_lengths, scope)`.
pub fn cudnn_rnnv3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    input_h: O1,
    input_c: O2,
    params: O3,
    sequence_lengths: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CudnnRNNV3::new().build(input, input_h, input_c, params, sequence_lengths, scope)
}
/// Builder for the `Cumprod` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cumprod {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cumprod {
    /// Creates a new `Cumprod`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cumprod` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        axis: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), axis.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        axis: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cumprod", |nd| {
            nd.add_input(x);
            nd.add_input(axis);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.exclusive {
                nd.set_attr_bool("exclusive", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.reverse {
                nd.set_attr_bool("reverse", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cumprod::new().build(x, axis, scope)`.
pub fn cumprod<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    x: O0,
    axis: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cumprod::new().build(x, axis, scope)
}
/// Builder for the `Cumsum` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Cumsum {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Cumsum {
    /// Creates a new `Cumsum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Cumsum` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        axis: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), axis.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        axis: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Cumsum", |nd| {
            nd.add_input(x);
            nd.add_input(axis);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.exclusive {
                nd.set_attr_bool("exclusive", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.reverse {
                nd.set_attr_bool("reverse", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Cumsum::new().build(x, axis, scope)`.
pub fn cumsum<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    x: O0,
    axis: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Cumsum::new().build(x, axis, scope)
}
/// Builder for the `CumulativeLogsumexp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct CumulativeLogsumexp {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    Tidx: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl CumulativeLogsumexp {
    /// Creates a new `CumulativeLogsumexp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `CumulativeLogsumexp` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        axis: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), axis.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        axis: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("CumulativeLogsumexp", |nd| {
            nd.add_input(x);
            nd.add_input(axis);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.exclusive {
                nd.set_attr_bool("exclusive", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.reverse {
                nd.set_attr_bool("reverse", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `CumulativeLogsumexp::new().build(x, axis, scope)`.
pub fn cumulative_logsumexp<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    axis: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    CumulativeLogsumexp::new().build(x, axis, scope)
}
/// Builder for the `DataFormatDimMap` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DataFormatDimMap {
    T: ::std::option::Option<crate::DataType>,
    src_format: ::std::option::Option<::std::string::String>,
    dst_format: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DataFormatDimMap {
    /// Creates a new `DataFormatDimMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `src_format` attribute.
    pub fn src_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.src_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dst_format` attribute.
    pub fn dst_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dst_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DataFormatDimMap` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DataFormatDimMap", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.src_format {
                nd.set_attr_string("src_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dst_format {
                nd.set_attr_string("dst_format", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DataFormatDimMap::new().build(x, scope)`.
pub fn data_format_dim_map<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DataFormatDimMap::new().build(x, scope)
}
/// Builder for the `DataFormatVecPermute` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DataFormatVecPermute {
    T: ::std::option::Option<crate::DataType>,
    src_format: ::std::option::Option<::std::string::String>,
    dst_format: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DataFormatVecPermute {
    /// Creates a new `DataFormatVecPermute`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `src_format` attribute.
    pub fn src_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.src_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dst_format` attribute.
    pub fn dst_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dst_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DataFormatVecPermute` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DataFormatVecPermute", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.src_format {
                nd.set_attr_string("src_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dst_format {
                nd.set_attr_string("dst_format", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DataFormatVecPermute::new().build(x, scope)`.
pub fn data_format_vec_permute<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DataFormatVecPermute::new().build(x, scope)
}
/// Builder for the `DataServiceDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DataServiceDataset {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DataServiceDataset {
    /// Creates a new `DataServiceDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DataServiceDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
    >(
        &self,
        dataset_id: O0,
        processing_mode: O1,
        address: O2,
        protocol: O3,
        job_name: O4,
        max_outstanding_requests: O5,
        iteration_counter: O6,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            dataset_id.into(),
            processing_mode.into(),
            address.into(),
            protocol.into(),
            job_name.into(),
            max_outstanding_requests.into(),
            iteration_counter.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        dataset_id: crate::Output,
        processing_mode: crate::Output,
        address: crate::Output,
        protocol: crate::Output,
        job_name: crate::Output,
        max_outstanding_requests: crate::Output,
        iteration_counter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DataServiceDataset", |nd| {
            nd.add_input(dataset_id);
            nd.add_input(processing_mode);
            nd.add_input(address);
            nd.add_input(protocol);
            nd.add_input(job_name);
            nd.add_input(max_outstanding_requests);
            nd.add_input(iteration_counter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
                nd.set_attr_int("task_refresh_interval_hint_ms", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
                nd.set_attr_string("data_transfer_protocol", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.target_workers {
                nd.set_attr_string("target_workers", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DataServiceDataset::new().build(dataset_id, processing_mode, address, protocol, job_name, max_outstanding_requests, iteration_counter, scope)`.
pub fn data_service_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
>(
    dataset_id: O0,
    processing_mode: O1,
    address: O2,
    protocol: O3,
    job_name: O4,
    max_outstanding_requests: O5,
    iteration_counter: O6,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DataServiceDataset::new().build(
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        max_outstanding_requests,
        iteration_counter,
        scope,
    )
}
/// Builder for the `DataServiceDatasetV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DataServiceDatasetV2 {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DataServiceDatasetV2 {
    /// Creates a new `DataServiceDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DataServiceDatasetV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        dataset_id: O0,
        processing_mode: O1,
        address: O2,
        protocol: O3,
        job_name: O4,
        consumer_index: O5,
        num_consumers: O6,
        max_outstanding_requests: O7,
        iteration_counter: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            dataset_id.into(),
            processing_mode.into(),
            address.into(),
            protocol.into(),
            job_name.into(),
            consumer_index.into(),
            num_consumers.into(),
            max_outstanding_requests.into(),
            iteration_counter.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        dataset_id: crate::Output,
        processing_mode: crate::Output,
        address: crate::Output,
        protocol: crate::Output,
        job_name: crate::Output,
        consumer_index: crate::Output,
        num_consumers: crate::Output,
        max_outstanding_requests: crate::Output,
        iteration_counter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DataServiceDatasetV2", |nd| {
            nd.add_input(dataset_id);
            nd.add_input(processing_mode);
            nd.add_input(address);
            nd.add_input(protocol);
            nd.add_input(job_name);
            nd.add_input(consumer_index);
            nd.add_input(num_consumers);
            nd.add_input(max_outstanding_requests);
            nd.add_input(iteration_counter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
                nd.set_attr_int("task_refresh_interval_hint_ms", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
                nd.set_attr_string("data_transfer_protocol", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.target_workers {
                nd.set_attr_string("target_workers", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DataServiceDatasetV2::new().build(dataset_id, processing_mode, address, protocol, job_name, consumer_index, num_consumers, max_outstanding_requests, iteration_counter, scope)`.
pub fn data_service_dataset_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    dataset_id: O0,
    processing_mode: O1,
    address: O2,
    protocol: O3,
    job_name: O4,
    consumer_index: O5,
    num_consumers: O6,
    max_outstanding_requests: O7,
    iteration_counter: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DataServiceDatasetV2::new().build(
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        consumer_index,
        num_consumers,
        max_outstanding_requests,
        iteration_counter,
        scope,
    )
}
/// Builder for the `DataServiceDatasetV3` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DataServiceDatasetV3 {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    uncompress: ::std::option::Option<bool>,
    uncompress_fn: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DataServiceDatasetV3 {
    /// Creates a new `DataServiceDatasetV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `uncompress` attribute.
    pub fn uncompress<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.uncompress = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `uncompress_fn` attribute.
    pub fn uncompress_fn<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.uncompress_fn = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DataServiceDatasetV3` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
        O6: ::std::convert::Into<crate::Output>,
        O7: ::std::convert::Into<crate::Output>,
        O8: ::std::convert::Into<crate::Output>,
    >(
        &self,
        dataset_id: O0,
        processing_mode: O1,
        address: O2,
        protocol: O3,
        job_name: O4,
        consumer_index: O5,
        num_consumers: O6,
        max_outstanding_requests: O7,
        iteration_counter: O8,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            dataset_id.into(),
            processing_mode.into(),
            address.into(),
            protocol.into(),
            job_name.into(),
            consumer_index.into(),
            num_consumers.into(),
            max_outstanding_requests.into(),
            iteration_counter.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        dataset_id: crate::Output,
        processing_mode: crate::Output,
        address: crate::Output,
        protocol: crate::Output,
        job_name: crate::Output,
        consumer_index: crate::Output,
        num_consumers: crate::Output,
        max_outstanding_requests: crate::Output,
        iteration_counter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DataServiceDatasetV3", |nd| {
            nd.add_input(dataset_id);
            nd.add_input(processing_mode);
            nd.add_input(address);
            nd.add_input(protocol);
            nd.add_input(job_name);
            nd.add_input(consumer_index);
            nd.add_input(num_consumers);
            nd.add_input(max_outstanding_requests);
            nd.add_input(iteration_counter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
                nd.set_attr_int("task_refresh_interval_hint_ms", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
                nd.set_attr_string("data_transfer_protocol", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.target_workers {
                nd.set_attr_string("target_workers", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.uncompress {
                nd.set_attr_bool("uncompress", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.uncompress_fn {
                nd.set_attr_string("uncompress_fn", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DataServiceDatasetV3::new().build(dataset_id, processing_mode, address, protocol, job_name, consumer_index, num_consumers, max_outstanding_requests, iteration_counter, scope)`.
pub fn data_service_dataset_v3<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
    O6: ::std::convert::Into<crate::Output>,
    O7: ::std::convert::Into<crate::Output>,
    O8: ::std::convert::Into<crate::Output>,
>(
    dataset_id: O0,
    processing_mode: O1,
    address: O2,
    protocol: O3,
    job_name: O4,
    consumer_index: O5,
    num_consumers: O6,
    max_outstanding_requests: O7,
    iteration_counter: O8,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DataServiceDatasetV3::new().build(
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        consumer_index,
        num_consumers,
        max_outstanding_requests,
        iteration_counter,
        scope,
    )
}
/// Builder for the `DatasetCardinality` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetCardinality {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetCardinality {
    /// Creates a new `DatasetCardinality`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetCardinality` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input_dataset: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetCardinality", |nd| {
            nd.add_input(input_dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetCardinality::new().build(input_dataset, scope)`.
pub fn dataset_cardinality<O0: ::std::convert::Into<crate::Output>>(
    input_dataset: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetCardinality::new().build(input_dataset, scope)
}
/// Builder for the `DatasetFromGraph` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetFromGraph {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetFromGraph {
    /// Creates a new `DatasetFromGraph`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetFromGraph` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        graph_def: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(graph_def.into(), scope)
    }

    fn build_impl(
        &self,
        graph_def: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetFromGraph", |nd| {
            nd.add_input(graph_def);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetFromGraph::new().build(graph_def, scope)`.
pub fn dataset_from_graph<O0: ::std::convert::Into<crate::Output>>(
    graph_def: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetFromGraph::new().build(graph_def, scope)
}
/// Builder for the `DatasetToGraph` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetToGraph {
    stateful_whitelist: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    allow_stateful: ::std::option::Option<bool>,
    strip_device_assignment: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetToGraph {
    /// Creates a new `DatasetToGraph`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `stateful_whitelist` attribute.
    pub fn stateful_whitelist<
        ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>,
    >(
        mut self,
        value: ArgType,
    ) -> Self {
        self.stateful_whitelist = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allow_stateful` attribute.
    pub fn allow_stateful<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.allow_stateful = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strip_device_assignment` attribute.
    pub fn strip_device_assignment<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strip_device_assignment = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetToGraph` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input_dataset: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetToGraph", |nd| {
            nd.add_input(input_dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.stateful_whitelist {
                nd.set_attr_string_list("stateful_whitelist", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.allow_stateful {
                nd.set_attr_bool("allow_stateful", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strip_device_assignment {
                nd.set_attr_bool("strip_device_assignment", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetToGraph::new().build(input_dataset, scope)`.
pub fn dataset_to_graph<O0: ::std::convert::Into<crate::Output>>(
    input_dataset: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetToGraph::new().build(input_dataset, scope)
}
/// Builder for the `DatasetToGraphV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetToGraphV2 {
    external_state_policy: ::std::option::Option<i64>,
    strip_device_assignment: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetToGraphV2 {
    /// Creates a new `DatasetToGraphV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `external_state_policy` attribute.
    pub fn external_state_policy<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.external_state_policy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strip_device_assignment` attribute.
    pub fn strip_device_assignment<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strip_device_assignment = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetToGraphV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input_dataset: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_dataset.into(), scope)
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetToGraphV2", |nd| {
            nd.add_input(input_dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.external_state_policy {
                nd.set_attr_int("external_state_policy", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strip_device_assignment {
                nd.set_attr_bool("strip_device_assignment", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetToGraphV2::new().build(input_dataset, scope)`.
pub fn dataset_to_graph_v2<O0: ::std::convert::Into<crate::Output>>(
    input_dataset: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetToGraphV2::new().build(input_dataset, scope)
}
/// Builder for the `DatasetToSingleElement` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetToSingleElement {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetToSingleElement {
    /// Creates a new `DatasetToSingleElement`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetToSingleElement` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        dataset: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(dataset.into(), scope)
    }

    fn build_impl(
        &self,
        dataset: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetToSingleElement", |nd| {
            nd.add_input(dataset);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.metadata {
                nd.set_attr_string("metadata", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetToSingleElement::new().build(dataset, scope)`.
pub fn dataset_to_single_element<O0: ::std::convert::Into<crate::Output>>(
    dataset: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetToSingleElement::new().build(dataset, scope)
}
/// Builder for the `DatasetToTFRecord` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DatasetToTFRecord {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DatasetToTFRecord {
    /// Creates a new `DatasetToTFRecord`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DatasetToTFRecord` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        filename: O1,
        compression_type: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_dataset.into(),
            filename.into(),
            compression_type.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        filename: crate::Output,
        compression_type: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DatasetToTFRecord", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(filename);
            nd.add_input(compression_type);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DatasetToTFRecord::new().build(input_dataset, filename, compression_type, scope)`.
pub fn dataset_to_tfrecord<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    filename: O1,
    compression_type: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DatasetToTFRecord::new().build(input_dataset, filename, compression_type, scope)
}
/// Builder for the `Dawsn` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Dawsn {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Dawsn {
    /// Creates a new `Dawsn`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Dawsn` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Dawsn", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Dawsn::new().build(x, scope)`.
pub fn dawsn<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Dawsn::new().build(x, scope)
}
/// Builder for the `DebugGradientIdentity` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugGradientIdentity {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugGradientIdentity {
    /// Creates a new `DebugGradientIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugGradientIdentity` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugGradientIdentity", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugGradientIdentity::new().build(input, scope)`.
pub fn debug_gradient_identity<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugGradientIdentity::new().build(input, scope)
}
/// Builder for the `DebugGradientRefIdentity` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugGradientRefIdentity {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugGradientRefIdentity {
    /// Creates a new `DebugGradientRefIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugGradientRefIdentity` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugGradientRefIdentity", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugGradientRefIdentity::new().build(input, scope)`.
pub fn debug_gradient_ref_identity<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugGradientRefIdentity::new().build(input, scope)
}
/// Builder for the `DebugIdentity` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugIdentity {
    T: ::std::option::Option<crate::DataType>,
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    gated_grpc: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugIdentity {
    /// Creates a new `DebugIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugIdentity` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugIdentity", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.device_name {
                nd.set_attr_string("device_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_name {
                nd.set_attr_string("tensor_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_urls {
                nd.set_attr_string_list("debug_urls", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.gated_grpc {
                nd.set_attr_bool("gated_grpc", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugIdentity::new().build(input, scope)`.
pub fn debug_identity<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugIdentity::new().build(input, scope)
}
/// Builder for the `DebugIdentityV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugIdentityV2 {
    T: ::std::option::Option<crate::DataType>,
    tfdbg_context_id: ::std::option::Option<::std::string::String>,
    op_name: ::std::option::Option<::std::string::String>,
    output_slot: ::std::option::Option<i64>,
    tensor_debug_mode: ::std::option::Option<i64>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    circular_buffer_size: ::std::option::Option<i64>,
    tfdbg_run_id: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugIdentityV2 {
    /// Creates a new `DebugIdentityV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tfdbg_context_id` attribute.
    pub fn tfdbg_context_id<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tfdbg_context_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `op_name` attribute.
    pub fn op_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.op_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_slot` attribute.
    pub fn output_slot<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.output_slot = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_debug_mode` attribute.
    pub fn tensor_debug_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_debug_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `circular_buffer_size` attribute.
    pub fn circular_buffer_size<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.circular_buffer_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tfdbg_run_id` attribute.
    pub fn tfdbg_run_id<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tfdbg_run_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugIdentityV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugIdentityV2", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tfdbg_context_id {
                nd.set_attr_string("tfdbg_context_id", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.op_name {
                nd.set_attr_string("op_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_slot {
                nd.set_attr_int("output_slot", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_debug_mode {
                nd.set_attr_int("tensor_debug_mode", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_urls {
                nd.set_attr_string_list("debug_urls", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.circular_buffer_size {
                nd.set_attr_int("circular_buffer_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tfdbg_run_id {
                nd.set_attr_string("tfdbg_run_id", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugIdentityV2::new().build(input, scope)`.
pub fn debug_identity_v2<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugIdentityV2::new().build(input, scope)
}
/// Builder for the `DebugNanCount` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugNanCount {
    T: ::std::option::Option<crate::DataType>,
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    gated_grpc: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugNanCount {
    /// Creates a new `DebugNanCount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugNanCount` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugNanCount", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.device_name {
                nd.set_attr_string("device_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_name {
                nd.set_attr_string("tensor_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_urls {
                nd.set_attr_string_list("debug_urls", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.gated_grpc {
                nd.set_attr_bool("gated_grpc", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugNanCount::new().build(input, scope)`.
pub fn debug_nan_count<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugNanCount::new().build(input, scope)
}
/// Builder for the `DebugNumericSummary` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugNumericSummary {
    T: ::std::option::Option<crate::DataType>,
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    lower_bound: ::std::option::Option<f32>,
    upper_bound: ::std::option::Option<f32>,
    mute_if_healthy: ::std::option::Option<bool>,
    gated_grpc: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugNumericSummary {
    /// Creates a new `DebugNumericSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `lower_bound` attribute.
    pub fn lower_bound<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.lower_bound = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `upper_bound` attribute.
    pub fn upper_bound<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.upper_bound = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `mute_if_healthy` attribute.
    pub fn mute_if_healthy<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.mute_if_healthy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugNumericSummary` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugNumericSummary", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.device_name {
                nd.set_attr_string("device_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_name {
                nd.set_attr_string("tensor_name", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.debug_urls {
                nd.set_attr_string_list("debug_urls", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.lower_bound {
                nd.set_attr_float("lower_bound", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.upper_bound {
                nd.set_attr_float("upper_bound", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.mute_if_healthy {
                nd.set_attr_bool("mute_if_healthy", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.gated_grpc {
                nd.set_attr_bool("gated_grpc", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugNumericSummary::new().build(input, scope)`.
pub fn debug_numeric_summary<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugNumericSummary::new().build(input, scope)
}
/// Builder for the `DebugNumericSummaryV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DebugNumericSummaryV2 {
    output_dtype: ::std::option::Option<crate::DataType>,
    T: ::std::option::Option<crate::DataType>,
    tensor_debug_mode: ::std::option::Option<i64>,
    tensor_id: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DebugNumericSummaryV2 {
    /// Creates a new `DebugNumericSummaryV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_dtype` attribute.
    pub fn output_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_debug_mode` attribute.
    pub fn tensor_debug_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_debug_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_id` attribute.
    pub fn tensor_id<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DebugNumericSummaryV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DebugNumericSummaryV2", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_dtype {
                nd.set_attr_type("output_dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_debug_mode {
                nd.set_attr_int("tensor_debug_mode", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.tensor_id {
                nd.set_attr_int("tensor_id", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DebugNumericSummaryV2::new().build(input, scope)`.
pub fn debug_numeric_summary_v2<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DebugNumericSummaryV2::new().build(input, scope)
}
/// Builder for the `DecodeAndCropJpeg` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeAndCropJpeg {
    channels: ::std::option::Option<i64>,
    ratio: ::std::option::Option<i64>,
    fancy_upscaling: ::std::option::Option<bool>,
    try_recover_truncated: ::std::option::Option<bool>,
    acceptable_fraction: ::std::option::Option<f32>,
    dct_method: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeAndCropJpeg {
    /// Creates a new `DecodeAndCropJpeg`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ratio` attribute.
    pub fn ratio<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.ratio = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fancy_upscaling` attribute.
    pub fn fancy_upscaling<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fancy_upscaling = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `try_recover_truncated` attribute.
    pub fn try_recover_truncated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.try_recover_truncated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `acceptable_fraction` attribute.
    pub fn acceptable_fraction<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.acceptable_fraction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dct_method` attribute.
    pub fn dct_method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dct_method = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeAndCropJpeg` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        contents: O0,
        crop_window: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), crop_window.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        crop_window: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeAndCropJpeg", |nd| {
            nd.add_input(contents);
            nd.add_input(crop_window);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.channels {
                nd.set_attr_int("channels", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ratio {
                nd.set_attr_int("ratio", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.fancy_upscaling {
                nd.set_attr_bool("fancy_upscaling", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.try_recover_truncated {
                nd.set_attr_bool("try_recover_truncated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.acceptable_fraction {
                nd.set_attr_float("acceptable_fraction", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dct_method {
                nd.set_attr_string("dct_method", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeAndCropJpeg::new().build(contents, crop_window, scope)`.
pub fn decode_and_crop_jpeg<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    contents: O0,
    crop_window: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeAndCropJpeg::new().build(contents, crop_window, scope)
}
/// Builder for the `DecodeBase64` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeBase64 {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeBase64 {
    /// Creates a new `DecodeBase64`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeBase64` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeBase64", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeBase64::new().build(input, scope)`.
pub fn decode_base64<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeBase64::new().build(input, scope)
}
/// Builder for the `DecodeBmp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeBmp {
    channels: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeBmp {
    /// Creates a new `DecodeBmp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeBmp` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeBmp", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.channels {
                nd.set_attr_int("channels", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeBmp::new().build(contents, scope)`.
pub fn decode_bmp<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeBmp::new().build(contents, scope)
}
/// Builder for the `DecodeCSV` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeCSV {
    OUT_TYPE: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    field_delim: ::std::option::Option<::std::string::String>,
    use_quote_delim: ::std::option::Option<bool>,
    na_value: ::std::option::Option<::std::string::String>,
    select_cols: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeCSV {
    /// Creates a new `DecodeCSV`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `OUT_TYPE` attribute.
    pub fn OUT_TYPE<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.OUT_TYPE = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `field_delim` attribute.
    pub fn field_delim<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.field_delim = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_quote_delim` attribute.
    pub fn use_quote_delim<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_quote_delim = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `na_value` attribute.
    pub fn na_value<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.na_value = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `select_cols` attribute.
    pub fn select_cols<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.select_cols = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeCSV` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        records: O0,
        record_defaults: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(records.into(), record_defaults.into(), scope)
    }

    fn build_impl(
        &self,
        records: crate::Output,
        record_defaults: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeCSV", |nd| {
            nd.add_input(records);
            nd.add_input(record_defaults);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.OUT_TYPE {
                nd.set_attr_type_list("OUT_TYPE", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.field_delim {
                nd.set_attr_string("field_delim", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.use_quote_delim {
                nd.set_attr_bool("use_quote_delim", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.na_value {
                nd.set_attr_string("na_value", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.select_cols {
                nd.set_attr_int_list("select_cols", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeCSV::new().build(records, record_defaults, scope)`.
pub fn decode_csv<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    records: O0,
    record_defaults: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeCSV::new().build(records, record_defaults, scope)
}
/// Builder for the `DecodeCompressed` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeCompressed {
    compression_type: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeCompressed {
    /// Creates a new `DecodeCompressed`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compression_type` attribute.
    pub fn compression_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.compression_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeCompressed` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        bytes: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(bytes.into(), scope)
    }

    fn build_impl(
        &self,
        bytes: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeCompressed", |nd| {
            nd.add_input(bytes);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.compression_type {
                nd.set_attr_string("compression_type", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeCompressed::new().build(bytes, scope)`.
pub fn decode_compressed<O0: ::std::convert::Into<crate::Output>>(
    bytes: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeCompressed::new().build(bytes, scope)
}
/// Builder for the `DecodeGif` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeGif {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeGif {
    /// Creates a new `DecodeGif`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeGif` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeGif", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeGif::new().build(contents, scope)`.
pub fn decode_gif<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeGif::new().build(contents, scope)
}
/// Builder for the `DecodeImage` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeImage {
    channels: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    expand_animations: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeImage {
    /// Creates a new `DecodeImage`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `expand_animations` attribute.
    pub fn expand_animations<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.expand_animations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeImage` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeImage", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.channels {
                nd.set_attr_int("channels", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.expand_animations {
                nd.set_attr_bool("expand_animations", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeImage::new().build(contents, scope)`.
pub fn decode_image<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeImage::new().build(contents, scope)
}
/// Builder for the `DecodeJSONExample` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeJSONExample {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeJSONExample {
    /// Creates a new `DecodeJSONExample`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeJSONExample` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        json_examples: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(json_examples.into(), scope)
    }

    fn build_impl(
        &self,
        json_examples: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeJSONExample", |nd| {
            nd.add_input(json_examples);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeJSONExample::new().build(json_examples, scope)`.
pub fn decode_jsonexample<O0: ::std::convert::Into<crate::Output>>(
    json_examples: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeJSONExample::new().build(json_examples, scope)
}
/// Builder for the `DecodeJpeg` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeJpeg {
    channels: ::std::option::Option<i64>,
    ratio: ::std::option::Option<i64>,
    fancy_upscaling: ::std::option::Option<bool>,
    try_recover_truncated: ::std::option::Option<bool>,
    acceptable_fraction: ::std::option::Option<f32>,
    dct_method: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeJpeg {
    /// Creates a new `DecodeJpeg`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ratio` attribute.
    pub fn ratio<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.ratio = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fancy_upscaling` attribute.
    pub fn fancy_upscaling<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fancy_upscaling = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `try_recover_truncated` attribute.
    pub fn try_recover_truncated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.try_recover_truncated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `acceptable_fraction` attribute.
    pub fn acceptable_fraction<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.acceptable_fraction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dct_method` attribute.
    pub fn dct_method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dct_method = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeJpeg` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeJpeg", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.channels {
                nd.set_attr_int("channels", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.ratio {
                nd.set_attr_int("ratio", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.fancy_upscaling {
                nd.set_attr_bool("fancy_upscaling", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.try_recover_truncated {
                nd.set_attr_bool("try_recover_truncated", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.acceptable_fraction {
                nd.set_attr_float("acceptable_fraction", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dct_method {
                nd.set_attr_string("dct_method", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeJpeg::new().build(contents, scope)`.
pub fn decode_jpeg<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeJpeg::new().build(contents, scope)
}
/// Builder for the `DecodePaddedRaw` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodePaddedRaw {
    out_type: ::std::option::Option<crate::DataType>,
    little_endian: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodePaddedRaw {
    /// Creates a new `DecodePaddedRaw`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `out_type` attribute.
    pub fn out_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.out_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `little_endian` attribute.
    pub fn little_endian<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.little_endian = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodePaddedRaw` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_bytes: O0,
        fixed_length: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input_bytes.into(), fixed_length.into(), scope)
    }

    fn build_impl(
        &self,
        input_bytes: crate::Output,
        fixed_length: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodePaddedRaw", |nd| {
            nd.add_input(input_bytes);
            nd.add_input(fixed_length);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.out_type {
                nd.set_attr_type("out_type", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.little_endian {
                nd.set_attr_bool("little_endian", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodePaddedRaw::new().build(input_bytes, fixed_length, scope)`.
pub fn decode_padded_raw<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input_bytes: O0,
    fixed_length: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodePaddedRaw::new().build(input_bytes, fixed_length, scope)
}
/// Builder for the `DecodePng` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodePng {
    channels: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodePng {
    /// Creates a new `DecodePng`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodePng` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodePng", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.channels {
                nd.set_attr_int("channels", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodePng::new().build(contents, scope)`.
pub fn decode_png<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodePng::new().build(contents, scope)
}
/// Builder for the `DecodeProtoV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeProtoV2 {
    message_type: ::std::option::Option<::std::string::String>,
    field_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    descriptor_source: ::std::option::Option<::std::string::String>,
    message_format: ::std::option::Option<::std::string::String>,
    sanitize: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeProtoV2 {
    /// Creates a new `DecodeProtoV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `message_type` attribute.
    pub fn message_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `field_names` attribute.
    pub fn field_names<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.field_names = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `descriptor_source` attribute.
    pub fn descriptor_source<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.descriptor_source = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `message_format` attribute.
    pub fn message_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `sanitize` attribute.
    pub fn sanitize<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.sanitize = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeProtoV2` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        bytes: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(bytes.into(), scope)
    }

    fn build_impl(
        &self,
        bytes: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeProtoV2", |nd| {
            nd.add_input(bytes);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.message_type {
                nd.set_attr_string("message_type", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.field_names {
                nd.set_attr_string_list("field_names", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.descriptor_source {
                nd.set_attr_string("descriptor_source", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.message_format {
                nd.set_attr_string("message_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.sanitize {
                nd.set_attr_bool("sanitize", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeProtoV2::new().build(bytes, scope)`.
pub fn decode_proto_v2<O0: ::std::convert::Into<crate::Output>>(
    bytes: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeProtoV2::new().build(bytes, scope)
}
/// Builder for the `DecodeRaw` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeRaw {
    out_type: ::std::option::Option<crate::DataType>,
    little_endian: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeRaw {
    /// Creates a new `DecodeRaw`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `out_type` attribute.
    pub fn out_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.out_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `little_endian` attribute.
    pub fn little_endian<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.little_endian = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeRaw` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        bytes: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(bytes.into(), scope)
    }

    fn build_impl(
        &self,
        bytes: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeRaw", |nd| {
            nd.add_input(bytes);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.out_type {
                nd.set_attr_type("out_type", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.little_endian {
                nd.set_attr_bool("little_endian", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeRaw::new().build(bytes, scope)`.
pub fn decode_raw<O0: ::std::convert::Into<crate::Output>>(
    bytes: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeRaw::new().build(bytes, scope)
}
/// Builder for the `DecodeWav` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DecodeWav {
    desired_channels: ::std::option::Option<i64>,
    desired_samples: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DecodeWav {
    /// Creates a new `DecodeWav`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `desired_channels` attribute.
    pub fn desired_channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.desired_channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `desired_samples` attribute.
    pub fn desired_samples<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.desired_samples = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DecodeWav` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        contents: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(contents.into(), scope)
    }

    fn build_impl(
        &self,
        contents: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DecodeWav", |nd| {
            nd.add_input(contents);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.desired_channels {
                nd.set_attr_int("desired_channels", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.desired_samples {
                nd.set_attr_int("desired_samples", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DecodeWav::new().build(contents, scope)`.
pub fn decode_wav<O0: ::std::convert::Into<crate::Output>>(
    contents: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DecodeWav::new().build(contents, scope)
}
/// Builder for the `DeepCopy` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeepCopy {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeepCopy {
    /// Creates a new `DeepCopy`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeepCopy` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeepCopy", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeepCopy::new().build(x, scope)`.
pub fn deep_copy<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeepCopy::new().build(x, scope)
}
/// Builder for the `DeleteIterator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteIterator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteIterator {
    /// Creates a new `DeleteIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteIterator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        deleter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), deleter.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        deleter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteIterator", |nd| {
            nd.add_input(handle);
            nd.add_input(deleter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteIterator::new().build(handle, deleter, scope)`.
pub fn delete_iterator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    deleter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteIterator::new().build(handle, deleter, scope)
}
/// Builder for the `DeleteMemoryCache` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteMemoryCache {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteMemoryCache {
    /// Creates a new `DeleteMemoryCache`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteMemoryCache` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        deleter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), deleter.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        deleter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteMemoryCache", |nd| {
            nd.add_input(handle);
            nd.add_input(deleter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteMemoryCache::new().build(handle, deleter, scope)`.
pub fn delete_memory_cache<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    deleter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteMemoryCache::new().build(handle, deleter, scope)
}
/// Builder for the `DeleteMultiDeviceIterator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteMultiDeviceIterator {
    N: ::std::option::Option<i64>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteMultiDeviceIterator {
    /// Creates a new `DeleteMultiDeviceIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteMultiDeviceIterator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        multi_device_iterator: O0,
        iterators: O1,
        deleter: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            multi_device_iterator.into(),
            iterators.into(),
            deleter.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        multi_device_iterator: crate::Output,
        iterators: crate::Output,
        deleter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteMultiDeviceIterator", |nd| {
            nd.add_input(multi_device_iterator);
            nd.add_input(iterators);
            nd.add_input(deleter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteMultiDeviceIterator::new().build(multi_device_iterator, iterators, deleter, scope)`.
pub fn delete_multi_device_iterator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    multi_device_iterator: O0,
    iterators: O1,
    deleter: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteMultiDeviceIterator::new().build(multi_device_iterator, iterators, deleter, scope)
}
/// Builder for the `DeleteRandomSeedGenerator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteRandomSeedGenerator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteRandomSeedGenerator {
    /// Creates a new `DeleteRandomSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteRandomSeedGenerator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        deleter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), deleter.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        deleter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteRandomSeedGenerator", |nd| {
            nd.add_input(handle);
            nd.add_input(deleter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteRandomSeedGenerator::new().build(handle, deleter, scope)`.
pub fn delete_random_seed_generator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    deleter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteRandomSeedGenerator::new().build(handle, deleter, scope)
}
/// Builder for the `DeleteSeedGenerator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteSeedGenerator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteSeedGenerator {
    /// Creates a new `DeleteSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteSeedGenerator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        handle: O0,
        deleter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), deleter.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        deleter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteSeedGenerator", |nd| {
            nd.add_input(handle);
            nd.add_input(deleter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteSeedGenerator::new().build(handle, deleter, scope)`.
pub fn delete_seed_generator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    handle: O0,
    deleter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteSeedGenerator::new().build(handle, deleter, scope)
}
/// Builder for the `DeleteSessionTensor` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeleteSessionTensor {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeleteSessionTensor {
    /// Creates a new `DeleteSessionTensor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeleteSessionTensor` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        handle: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(handle.into(), scope)
    }

    fn build_impl(
        &self,
        handle: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeleteSessionTensor", |nd| {
            nd.add_input(handle);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeleteSessionTensor::new().build(handle, scope)`.
pub fn delete_session_tensor<O0: ::std::convert::Into<crate::Output>>(
    handle: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeleteSessionTensor::new().build(handle, scope)
}
/// Builder for the `DenseBincount` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseBincount {
    Tidx: ::std::option::Option<crate::DataType>,
    T: ::std::option::Option<crate::DataType>,
    binary_output: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseBincount {
    /// Creates a new `DenseBincount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tidx` attribute.
    pub fn Tidx<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tidx = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `binary_output` attribute.
    pub fn binary_output<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.binary_output = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseBincount` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        size: O1,
        weights: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), size.into(), weights.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        size: crate::Output,
        weights: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseBincount", |nd| {
            nd.add_input(input);
            nd.add_input(size);
            nd.add_input(weights);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.Tidx {
                nd.set_attr_type("Tidx", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.binary_output {
                nd.set_attr_bool("binary_output", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseBincount::new().build(input, size, weights, scope)`.
pub fn dense_bincount<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    size: O1,
    weights: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseBincount::new().build(input, size, weights, scope)
}
/// Builder for the `DenseCountSparseOutput` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseCountSparseOutput {
    T: ::std::option::Option<crate::DataType>,
    minlength: ::std::option::Option<i64>,
    maxlength: ::std::option::Option<i64>,
    binary_output: ::std::option::Option<bool>,
    output_type: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseCountSparseOutput {
    /// Creates a new `DenseCountSparseOutput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `minlength` attribute.
    pub fn minlength<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.minlength = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `maxlength` attribute.
    pub fn maxlength<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.maxlength = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `binary_output` attribute.
    pub fn binary_output<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.binary_output = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_type` attribute.
    pub fn output_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseCountSparseOutput` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        values: O0,
        weights: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(values.into(), weights.into(), scope)
    }

    fn build_impl(
        &self,
        values: crate::Output,
        weights: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseCountSparseOutput", |nd| {
            nd.add_input(values);
            nd.add_input(weights);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.minlength {
                nd.set_attr_int("minlength", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.maxlength {
                nd.set_attr_int("maxlength", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.binary_output {
                nd.set_attr_bool("binary_output", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_type {
                nd.set_attr_type("output_type", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseCountSparseOutput::new().build(values, weights, scope)`.
pub fn dense_count_sparse_output<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    values: O0,
    weights: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseCountSparseOutput::new().build(values, weights, scope)
}
/// Builder for the `DenseToCSRSparseMatrix` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseToCSRSparseMatrix {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseToCSRSparseMatrix {
    /// Creates a new `DenseToCSRSparseMatrix`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseToCSRSparseMatrix` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        dense_input: O0,
        indices: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(dense_input.into(), indices.into(), scope)
    }

    fn build_impl(
        &self,
        dense_input: crate::Output,
        indices: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseToCSRSparseMatrix", |nd| {
            nd.add_input(dense_input);
            nd.add_input(indices);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseToCSRSparseMatrix::new().build(dense_input, indices, scope)`.
pub fn dense_to_csrsparse_matrix<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    dense_input: O0,
    indices: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseToCSRSparseMatrix::new().build(dense_input, indices, scope)
}
/// Builder for the `DenseToDenseSetOperation` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseToDenseSetOperation {
    set_operation: ::std::option::Option<::std::string::String>,
    validate_indices: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseToDenseSetOperation {
    /// Creates a new `DenseToDenseSetOperation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `set_operation` attribute.
    pub fn set_operation<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.set_operation = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_indices` attribute.
    pub fn validate_indices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_indices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseToDenseSetOperation` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        set1: O0,
        set2: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(set1.into(), set2.into(), scope)
    }

    fn build_impl(
        &self,
        set1: crate::Output,
        set2: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseToDenseSetOperation", |nd| {
            nd.add_input(set1);
            nd.add_input(set2);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.set_operation {
                nd.set_attr_string("set_operation", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.validate_indices {
                nd.set_attr_bool("validate_indices", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseToDenseSetOperation::new().build(set1, set2, scope)`.
pub fn dense_to_dense_set_operation<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    set1: O0,
    set2: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseToDenseSetOperation::new().build(set1, set2, scope)
}
/// Builder for the `DenseToSparseBatchDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseToSparseBatchDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseToSparseBatchDataset {
    /// Creates a new `DenseToSparseBatchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseToSparseBatchDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_dataset: O0,
        batch_size: O1,
        row_shape: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_dataset.into(),
            batch_size.into(),
            row_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_dataset: crate::Output,
        batch_size: crate::Output,
        row_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseToSparseBatchDataset", |nd| {
            nd.add_input(input_dataset);
            nd.add_input(batch_size);
            nd.add_input(row_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseToSparseBatchDataset::new().build(input_dataset, batch_size, row_shape, scope)`.
pub fn dense_to_sparse_batch_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_dataset: O0,
    batch_size: O1,
    row_shape: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseToSparseBatchDataset::new().build(input_dataset, batch_size, row_shape, scope)
}
/// Builder for the `DenseToSparseSetOperation` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DenseToSparseSetOperation {
    set_operation: ::std::option::Option<::std::string::String>,
    validate_indices: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DenseToSparseSetOperation {
    /// Creates a new `DenseToSparseSetOperation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `set_operation` attribute.
    pub fn set_operation<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.set_operation = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_indices` attribute.
    pub fn validate_indices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_indices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DenseToSparseSetOperation` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
    >(
        &self,
        set1: O0,
        set2_indices: O1,
        set2_values: O2,
        set2_shape: O3,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            set1.into(),
            set2_indices.into(),
            set2_values.into(),
            set2_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        set1: crate::Output,
        set2_indices: crate::Output,
        set2_values: crate::Output,
        set2_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DenseToSparseSetOperation", |nd| {
            nd.add_input(set1);
            nd.add_input(set2_indices);
            nd.add_input(set2_values);
            nd.add_input(set2_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.set_operation {
                nd.set_attr_string("set_operation", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.validate_indices {
                nd.set_attr_bool("validate_indices", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DenseToSparseSetOperation::new().build(set1, set2_indices, set2_values, set2_shape, scope)`.
pub fn dense_to_sparse_set_operation<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
>(
    set1: O0,
    set2_indices: O1,
    set2_values: O2,
    set2_shape: O3,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DenseToSparseSetOperation::new().build(set1, set2_indices, set2_values, set2_shape, scope)
}
/// Builder for the `DepthToSpace` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DepthToSpace {
    T: ::std::option::Option<crate::DataType>,
    block_size: ::std::option::Option<i64>,
    data_format: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DepthToSpace {
    /// Creates a new `DepthToSpace`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `block_size` attribute.
    pub fn block_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.block_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DepthToSpace` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DepthToSpace", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.block_size {
                nd.set_attr_int("block_size", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DepthToSpace::new().build(input, scope)`.
pub fn depth_to_space<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DepthToSpace::new().build(input, scope)
}
/// Builder for the `DepthwiseConv2dNative` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DepthwiseConv2dNative {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DepthwiseConv2dNative {
    /// Creates a new `DepthwiseConv2dNative`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DepthwiseConv2dNative` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DepthwiseConv2dNative", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DepthwiseConv2dNative::new().build(input, filter, scope)`.
pub fn depthwise_conv2d_native<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DepthwiseConv2dNative::new().build(input, filter, scope)
}
/// Builder for the `DepthwiseConv2dNativeBackpropFilter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DepthwiseConv2dNativeBackpropFilter {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DepthwiseConv2dNativeBackpropFilter {
    /// Creates a new `DepthwiseConv2dNativeBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DepthwiseConv2dNativeBackpropFilter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter_sizes: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input.into(),
            filter_sizes.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter_sizes: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DepthwiseConv2dNativeBackpropFilter", |nd| {
            nd.add_input(input);
            nd.add_input(filter_sizes);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DepthwiseConv2dNativeBackpropFilter::new().build(input, filter_sizes, out_backprop, scope)`.
pub fn depthwise_conv2d_native_backprop_filter<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter_sizes: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DepthwiseConv2dNativeBackpropFilter::new().build(input, filter_sizes, out_backprop, scope)
}
/// Builder for the `DepthwiseConv2dNativeBackpropInput` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DepthwiseConv2dNativeBackpropInput {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DepthwiseConv2dNativeBackpropInput {
    /// Creates a new `DepthwiseConv2dNativeBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DepthwiseConv2dNativeBackpropInput` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input_sizes: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            input_sizes.into(),
            filter.into(),
            out_backprop.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        input_sizes: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DepthwiseConv2dNativeBackpropInput", |nd| {
            nd.add_input(input_sizes);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.explicit_paddings {
                nd.set_attr_int_list("explicit_paddings", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.data_format {
                nd.set_attr_string("data_format", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dilations {
                nd.set_attr_int_list("dilations", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DepthwiseConv2dNativeBackpropInput::new().build(input_sizes, filter, out_backprop, scope)`.
pub fn depthwise_conv2d_native_backprop_input<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input_sizes: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DepthwiseConv2dNativeBackpropInput::new().build(input_sizes, filter, out_backprop, scope)
}
/// Builder for the `Dequantize` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Dequantize {
    T: ::std::option::Option<crate::DataType>,
    mode: ::std::option::Option<::std::string::String>,
    narrow_range: ::std::option::Option<bool>,
    axis: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Dequantize {
    /// Creates a new `Dequantize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `mode` attribute.
    pub fn mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `narrow_range` attribute.
    pub fn narrow_range<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.narrow_range = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `axis` attribute.
    pub fn axis<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.axis = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Dequantize` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        min_range: O1,
        max_range: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), min_range.into(), max_range.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        min_range: crate::Output,
        max_range: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Dequantize", |nd| {
            nd.add_input(input);
            nd.add_input(min_range);
            nd.add_input(max_range);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.mode {
                nd.set_attr_string("mode", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.narrow_range {
                nd.set_attr_bool("narrow_range", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.axis {
                nd.set_attr_int("axis", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Dequantize::new().build(input, min_range, max_range, scope)`.
pub fn dequantize<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    min_range: O1,
    max_range: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Dequantize::new().build(input, min_range, max_range, scope)
}
/// Builder for the `DeserializeIterator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeserializeIterator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeserializeIterator {
    /// Creates a new `DeserializeIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeserializeIterator` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        resource_handle: O0,
        serialized: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource_handle.into(), serialized.into(), scope)
    }

    fn build_impl(
        &self,
        resource_handle: crate::Output,
        serialized: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeserializeIterator", |nd| {
            nd.add_input(resource_handle);
            nd.add_input(serialized);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeserializeIterator::new().build(resource_handle, serialized, scope)`.
pub fn deserialize_iterator<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    resource_handle: O0,
    serialized: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeserializeIterator::new().build(resource_handle, serialized, scope)
}
/// Builder for the `DeserializeManySparse` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeserializeManySparse {
    dtype: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeserializeManySparse {
    /// Creates a new `DeserializeManySparse`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeserializeManySparse` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        serialized_sparse: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(serialized_sparse.into(), scope)
    }

    fn build_impl(
        &self,
        serialized_sparse: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeserializeManySparse", |nd| {
            nd.add_input(serialized_sparse);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeserializeManySparse::new().build(serialized_sparse, scope)`.
pub fn deserialize_many_sparse<O0: ::std::convert::Into<crate::Output>>(
    serialized_sparse: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeserializeManySparse::new().build(serialized_sparse, scope)
}
/// Builder for the `DeserializeSparse` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeserializeSparse {
    dtype: ::std::option::Option<crate::DataType>,
    Tserialized: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeserializeSparse {
    /// Creates a new `DeserializeSparse`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tserialized` attribute.
    pub fn Tserialized<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tserialized = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeserializeSparse` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        serialized_sparse: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(serialized_sparse.into(), scope)
    }

    fn build_impl(
        &self,
        serialized_sparse: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DeserializeSparse", |nd| {
            nd.add_input(serialized_sparse);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.dtype {
                nd.set_attr_type("dtype", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tserialized {
                nd.set_attr_type("Tserialized", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeserializeSparse::new().build(serialized_sparse, scope)`.
pub fn deserialize_sparse<O0: ::std::convert::Into<crate::Output>>(
    serialized_sparse: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DeserializeSparse::new().build(serialized_sparse, scope)
}
/// Builder for the `DestroyResourceOp` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DestroyResourceOp {
    ignore_lookup_error: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DestroyResourceOp {
    /// Creates a new `DestroyResourceOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ignore_lookup_error` attribute.
    pub fn ignore_lookup_error<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ignore_lookup_error = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DestroyResourceOp` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        resource: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(resource.into(), scope)
    }

    fn build_impl(
        &self,
        resource: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DestroyResourceOp", |nd| {
            nd.add_input(resource);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.ignore_lookup_error {
                nd.set_attr_bool("ignore_lookup_error", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DestroyResourceOp::new().build(resource, scope)`.
pub fn destroy_resource_op<O0: ::std::convert::Into<crate::Output>>(
    resource: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DestroyResourceOp::new().build(resource, scope)
}
/// Builder for the `DestroyTemporaryVariable` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DestroyTemporaryVariable {
    T: ::std::option::Option<crate::DataType>,
    var_name: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DestroyTemporaryVariable {
    /// Creates a new `DestroyTemporaryVariable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `var_name` attribute.
    pub fn var_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.var_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DestroyTemporaryVariable` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        ref_: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(ref_.into(), scope)
    }

    fn build_impl(
        &self,
        ref_: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DestroyTemporaryVariable", |nd| {
            nd.add_input(ref_);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.var_name {
                nd.set_attr_string("var_name", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DestroyTemporaryVariable::new().build(ref_, scope)`.
pub fn destroy_temporary_variable<O0: ::std::convert::Into<crate::Output>>(
    ref_: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DestroyTemporaryVariable::new().build(ref_, scope)
}
/// Builder for the `DeviceIndex` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DeviceIndex {
    device_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DeviceIndex {
    /// Creates a new `DeviceIndex`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `device_names` attribute.
    pub fn device_names<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_names = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DeviceIndex` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("DeviceIndex", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.device_names {
                nd.set_attr_string_list("device_names", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DeviceIndex::new().build(scope)`.
pub fn device_index(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    DeviceIndex::new().build(scope)
}
/// Builder for the `Diag` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Diag {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Diag {
    /// Creates a new `Diag`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Diag` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        diagonal: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(diagonal.into(), scope)
    }

    fn build_impl(
        &self,
        diagonal: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Diag", |nd| {
            nd.add_input(diagonal);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Diag::new().build(diagonal, scope)`.
pub fn diag<O0: ::std::convert::Into<crate::Output>>(
    diagonal: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Diag::new().build(diagonal, scope)
}
/// Builder for the `DiagPart` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DiagPart {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DiagPart {
    /// Creates a new `DiagPart`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DiagPart` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DiagPart", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DiagPart::new().build(input, scope)`.
pub fn diag_part<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DiagPart::new().build(input, scope)
}
/// Builder for the `Digamma` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Digamma {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Digamma {
    /// Creates a new `Digamma`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Digamma` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        x: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Digamma", |nd| {
            nd.add_input(x);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Digamma::new().build(x, scope)`.
pub fn digamma<O0: ::std::convert::Into<crate::Output>>(
    x: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Digamma::new().build(x, scope)
}
/// Builder for the `Dilation2D` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Dilation2D {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    rates: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Dilation2D {
    /// Creates a new `Dilation2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rates` attribute.
    pub fn rates<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rates = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Dilation2D` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Dilation2D", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rates {
                nd.set_attr_int_list("rates", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Dilation2D::new().build(input, filter, scope)`.
pub fn dilation2_d<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Dilation2D::new().build(input, filter, scope)
}
/// Builder for the `Dilation2DBackpropFilter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Dilation2DBackpropFilter {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    rates: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Dilation2DBackpropFilter {
    /// Creates a new `Dilation2DBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rates` attribute.
    pub fn rates<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rates = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Dilation2DBackpropFilter` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), out_backprop.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Dilation2DBackpropFilter", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rates {
                nd.set_attr_int_list("rates", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Dilation2DBackpropFilter::new().build(input, filter, out_backprop, scope)`.
pub fn dilation2_dbackprop_filter<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Dilation2DBackpropFilter::new().build(input, filter, out_backprop, scope)
}
/// Builder for the `Dilation2DBackpropInput` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Dilation2DBackpropInput {
    T: ::std::option::Option<crate::DataType>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    rates: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Dilation2DBackpropInput {
    /// Creates a new `Dilation2DBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rates` attribute.
    pub fn rates<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rates = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Dilation2DBackpropInput` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        input: O0,
        filter: O1,
        out_backprop: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), filter.into(), out_backprop.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        filter: crate::Output,
        out_backprop: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Dilation2DBackpropInput", |nd| {
            nd.add_input(input);
            nd.add_input(filter);
            nd.add_input(out_backprop);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.strides {
                nd.set_attr_int_list("strides", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.rates {
                nd.set_attr_int_list("rates", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.padding {
                nd.set_attr_string("padding", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Dilation2DBackpropInput::new().build(input, filter, out_backprop, scope)`.
pub fn dilation2_dbackprop_input<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    input: O0,
    filter: O1,
    out_backprop: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Dilation2DBackpropInput::new().build(input, filter, out_backprop, scope)
}
/// Builder for the `DirectedInterleaveDataset` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DirectedInterleaveDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    N: ::std::option::Option<i64>,
    stop_on_empty_dataset: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DirectedInterleaveDataset {
    /// Creates a new `DirectedInterleaveDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `stop_on_empty_dataset` attribute.
    pub fn stop_on_empty_dataset<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.stop_on_empty_dataset = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DirectedInterleaveDataset` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        selector_input_dataset: O0,
        data_input_datasets: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            selector_input_dataset.into(),
            data_input_datasets.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        selector_input_dataset: crate::Output,
        data_input_datasets: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DirectedInterleaveDataset", |nd| {
            nd.add_input(selector_input_dataset);
            nd.add_input(data_input_datasets);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.output_types {
                nd.set_attr_type_list("output_types", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.output_shapes {
                nd.set_attr_shape_list("output_shapes", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.stop_on_empty_dataset {
                nd.set_attr_bool("stop_on_empty_dataset", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DirectedInterleaveDataset::new().build(selector_input_dataset, data_input_datasets, scope)`.
pub fn directed_interleave_dataset<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    selector_input_dataset: O0,
    data_input_datasets: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DirectedInterleaveDataset::new().build(selector_input_dataset, data_input_datasets, scope)
}
/// Builder for the `Div` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Div {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Div {
    /// Creates a new `Div`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Div` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Div", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Div::new().build(x, y, scope)`.
pub fn div<O0: ::std::convert::Into<crate::Output>, O1: ::std::convert::Into<crate::Output>>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Div::new().build(x, y, scope)
}
/// Builder for the `DivNoNan` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DivNoNan {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DivNoNan {
    /// Creates a new `DivNoNan`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DivNoNan` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        x: O0,
        y: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(x.into(), y.into(), scope)
    }

    fn build_impl(
        &self,
        x: crate::Output,
        y: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DivNoNan", |nd| {
            nd.add_input(x);
            nd.add_input(y);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DivNoNan::new().build(x, y, scope)`.
pub fn div_no_nan<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    x: O0,
    y: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DivNoNan::new().build(x, y, scope)
}
/// Builder for the `DrawBoundingBoxes` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DrawBoundingBoxes {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DrawBoundingBoxes {
    /// Creates a new `DrawBoundingBoxes`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DrawBoundingBoxes` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        boxes: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(images.into(), boxes.into(), scope)
    }

    fn build_impl(
        &self,
        images: crate::Output,
        boxes: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DrawBoundingBoxes", |nd| {
            nd.add_input(images);
            nd.add_input(boxes);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DrawBoundingBoxes::new().build(images, boxes, scope)`.
pub fn draw_bounding_boxes<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    boxes: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DrawBoundingBoxes::new().build(images, boxes, scope)
}
/// Builder for the `DrawBoundingBoxesV2` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DrawBoundingBoxesV2 {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DrawBoundingBoxesV2 {
    /// Creates a new `DrawBoundingBoxesV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DrawBoundingBoxesV2` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
    >(
        &self,
        images: O0,
        boxes: O1,
        colors: O2,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(images.into(), boxes.into(), colors.into(), scope)
    }

    fn build_impl(
        &self,
        images: crate::Output,
        boxes: crate::Output,
        colors: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DrawBoundingBoxesV2", |nd| {
            nd.add_input(images);
            nd.add_input(boxes);
            nd.add_input(colors);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DrawBoundingBoxesV2::new().build(images, boxes, colors, scope)`.
pub fn draw_bounding_boxes_v2<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
>(
    images: O0,
    boxes: O1,
    colors: O2,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DrawBoundingBoxesV2::new().build(images, boxes, colors, scope)
}
/// Builder for the `DummyIterationCounter` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DummyIterationCounter {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DummyIterationCounter {
    /// Creates a new `DummyIterationCounter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DummyIterationCounter` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("DummyIterationCounter", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DummyIterationCounter::new().build(scope)`.
pub fn dummy_iteration_counter(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    DummyIterationCounter::new().build(scope)
}
/// Builder for the `DummyMemoryCache` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DummyMemoryCache {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DummyMemoryCache {
    /// Creates a new `DummyMemoryCache`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DummyMemoryCache` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("DummyMemoryCache", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DummyMemoryCache::new().build(scope)`.
pub fn dummy_memory_cache(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    DummyMemoryCache::new().build(scope)
}
/// Builder for the `DummySeedGenerator` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DummySeedGenerator {
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DummySeedGenerator {
    /// Creates a new `DummySeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DummySeedGenerator` operation.
    pub fn build(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        self.build_impl(scope)
    }

    fn build_impl(&self, scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
        scope.new_operation("DummySeedGenerator", |nd| {
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DummySeedGenerator::new().build(scope)`.
pub fn dummy_seed_generator(scope: &mut crate::Scope) -> crate::Result<crate::Operation> {
    DummySeedGenerator::new().build(scope)
}
/// Builder for the `DynamicEnqueueTPUEmbeddingArbitraryTensorBatch` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DynamicEnqueueTPUEmbeddingArbitraryTensorBatch {
    T1: ::std::option::Option<crate::DataType>,
    T2: ::std::option::Option<crate::DataType>,
    T3: ::std::option::Option<crate::DataType>,
    N: ::std::option::Option<i64>,
    combiners: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DynamicEnqueueTPUEmbeddingArbitraryTensorBatch {
    /// Creates a new `DynamicEnqueueTPUEmbeddingArbitraryTensorBatch`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T1` attribute.
    pub fn T1<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T1 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T2` attribute.
    pub fn T2<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T3` attribute.
    pub fn T3<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T3 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `combiners` attribute.
    pub fn combiners<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.combiners = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DynamicEnqueueTPUEmbeddingArbitraryTensorBatch` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
    >(
        &self,
        sample_indices_or_row_lengths: O0,
        embedding_indices: O1,
        aggregation_weights: O2,
        mode_override: O3,
        device_ordinal: O4,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            sample_indices_or_row_lengths.into(),
            embedding_indices.into(),
            aggregation_weights.into(),
            mode_override.into(),
            device_ordinal.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        sample_indices_or_row_lengths: crate::Output,
        embedding_indices: crate::Output,
        aggregation_weights: crate::Output,
        mode_override: crate::Output,
        device_ordinal: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DynamicEnqueueTPUEmbeddingArbitraryTensorBatch", |nd| {
            nd.add_input(sample_indices_or_row_lengths);
            nd.add_input(embedding_indices);
            nd.add_input(aggregation_weights);
            nd.add_input(mode_override);
            nd.add_input(device_ordinal);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T1 {
                nd.set_attr_type("T1", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T2 {
                nd.set_attr_type("T2", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T3 {
                nd.set_attr_type("T3", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.combiners {
                nd.set_attr_string_list("combiners", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DynamicEnqueueTPUEmbeddingArbitraryTensorBatch::new().build(sample_indices_or_row_lengths, embedding_indices, aggregation_weights, mode_override, device_ordinal, scope)`.
pub fn dynamic_enqueue_tpuembedding_arbitrary_tensor_batch<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
>(
    sample_indices_or_row_lengths: O0,
    embedding_indices: O1,
    aggregation_weights: O2,
    mode_override: O3,
    device_ordinal: O4,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DynamicEnqueueTPUEmbeddingArbitraryTensorBatch::new().build(
        sample_indices_or_row_lengths,
        embedding_indices,
        aggregation_weights,
        mode_override,
        device_ordinal,
        scope,
    )
}
/// Builder for the `DynamicPartition` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DynamicPartition {
    num_partitions: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DynamicPartition {
    /// Creates a new `DynamicPartition`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_partitions` attribute.
    pub fn num_partitions<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_partitions = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DynamicPartition` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        data: O0,
        partitions: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(data.into(), partitions.into(), scope)
    }

    fn build_impl(
        &self,
        data: crate::Output,
        partitions: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DynamicPartition", |nd| {
            nd.add_input(data);
            nd.add_input(partitions);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.num_partitions {
                nd.set_attr_int("num_partitions", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DynamicPartition::new().build(data, partitions, scope)`.
pub fn dynamic_partition<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    data: O0,
    partitions: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DynamicPartition::new().build(data, partitions, scope)
}
/// Builder for the `DynamicStitch` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct DynamicStitch {
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl DynamicStitch {
    /// Creates a new `DynamicStitch`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `DynamicStitch` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        indices: O0,
        data: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(indices.into(), data.into(), scope)
    }

    fn build_impl(
        &self,
        indices: crate::Output,
        data: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("DynamicStitch", |nd| {
            nd.add_input(indices);
            nd.add_input(data);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `DynamicStitch::new().build(indices, data, scope)`.
pub fn dynamic_stitch<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    indices: O0,
    data: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    DynamicStitch::new().build(indices, data, scope)
}
/// Builder for the `EagerPyFunc` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct EagerPyFunc {
    token: ::std::option::Option<::std::string::String>,
    is_async: ::std::option::Option<bool>,
    Tin: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    Tout: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl EagerPyFunc {
    /// Creates a new `EagerPyFunc`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `token` attribute.
    pub fn token<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.token = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_async` attribute.
    pub fn is_async<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_async = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tin` attribute.
    pub fn Tin<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tin = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `EagerPyFunc` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("EagerPyFunc", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.token {
                nd.set_attr_string("token", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.is_async {
                nd.set_attr_bool("is_async", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tin {
                nd.set_attr_type_list("Tin", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type_list("Tout", value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `EagerPyFunc::new().build(input, scope)`.
pub fn eager_py_func<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    EagerPyFunc::new().build(input, scope)
}
/// Builder for the `EditDistance` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct EditDistance {
    normalize: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl EditDistance {
    /// Creates a new `EditDistance`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `normalize` attribute.
    pub fn normalize<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.normalize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `EditDistance` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
        O2: ::std::convert::Into<crate::Output>,
        O3: ::std::convert::Into<crate::Output>,
        O4: ::std::convert::Into<crate::Output>,
        O5: ::std::convert::Into<crate::Output>,
    >(
        &self,
        hypothesis_indices: O0,
        hypothesis_values: O1,
        hypothesis_shape: O2,
        truth_indices: O3,
        truth_values: O4,
        truth_shape: O5,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(
            hypothesis_indices.into(),
            hypothesis_values.into(),
            hypothesis_shape.into(),
            truth_indices.into(),
            truth_values.into(),
            truth_shape.into(),
            scope,
        )
    }

    fn build_impl(
        &self,
        hypothesis_indices: crate::Output,
        hypothesis_values: crate::Output,
        hypothesis_shape: crate::Output,
        truth_indices: crate::Output,
        truth_values: crate::Output,
        truth_shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("EditDistance", |nd| {
            nd.add_input(hypothesis_indices);
            nd.add_input(hypothesis_values);
            nd.add_input(hypothesis_shape);
            nd.add_input(truth_indices);
            nd.add_input(truth_values);
            nd.add_input(truth_shape);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.normalize {
                nd.set_attr_bool("normalize", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `EditDistance::new().build(hypothesis_indices, hypothesis_values, hypothesis_shape, truth_indices, truth_values, truth_shape, scope)`.
pub fn edit_distance<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
    O2: ::std::convert::Into<crate::Output>,
    O3: ::std::convert::Into<crate::Output>,
    O4: ::std::convert::Into<crate::Output>,
    O5: ::std::convert::Into<crate::Output>,
>(
    hypothesis_indices: O0,
    hypothesis_values: O1,
    hypothesis_shape: O2,
    truth_indices: O3,
    truth_values: O4,
    truth_shape: O5,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    EditDistance::new().build(
        hypothesis_indices,
        hypothesis_values,
        hypothesis_shape,
        truth_indices,
        truth_values,
        truth_shape,
        scope,
    )
}
/// Builder for the `Eig` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Eig {
    compute_v: ::std::option::Option<bool>,
    T: ::std::option::Option<crate::DataType>,
    Tout: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Eig {
    /// Creates a new `Eig`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compute_v` attribute.
    pub fn compute_v<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.compute_v = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Eig` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        input: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(input.into(), scope)
    }

    fn build_impl(
        &self,
        input: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Eig", |nd| {
            nd.add_input(input);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.compute_v {
                nd.set_attr_bool("compute_v", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.Tout {
                nd.set_attr_type("Tout", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Eig::new().build(input, scope)`.
pub fn eig<O0: ::std::convert::Into<crate::Output>>(
    input: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Eig::new().build(input, scope)
}
/// Builder for the `Einsum` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Einsum {
    equation: ::std::option::Option<::std::string::String>,
    N: ::std::option::Option<i64>,
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Einsum {
    /// Creates a new `Einsum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `equation` attribute.
    pub fn equation<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.equation = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `N` attribute.
    pub fn N<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.N = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Einsum` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        inputs: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(inputs.into(), scope)
    }

    fn build_impl(
        &self,
        inputs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Einsum", |nd| {
            nd.add_input(inputs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.equation {
                nd.set_attr_string("equation", value)?;
            }
            if let ::std::option::Option::Some(value) = &self.N {
                nd.set_attr_int("N", *value)?;
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Einsum::new().build(inputs, scope)`.
pub fn einsum<O0: ::std::convert::Into<crate::Output>>(
    inputs: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Einsum::new().build(inputs, scope)
}
/// Builder for the `Elu` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Elu {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Elu {
    /// Creates a new `Elu`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Elu` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        features: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(features.into(), scope)
    }

    fn build_impl(
        &self,
        features: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Elu", |nd| {
            nd.add_input(features);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `Elu::new().build(features, scope)`.
pub fn elu<O0: ::std::convert::Into<crate::Output>>(
    features: O0,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    Elu::new().build(features, scope)
}
/// Builder for the `EluGrad` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct EluGrad {
    T: ::std::option::Option<crate::DataType>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl EluGrad {
    /// Creates a new `EluGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `EluGrad` operation.
    pub fn build<
        O0: ::std::convert::Into<crate::Output>,
        O1: ::std::convert::Into<crate::Output>,
    >(
        &self,
        gradients: O0,
        outputs: O1,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(gradients.into(), outputs.into(), scope)
    }

    fn build_impl(
        &self,
        gradients: crate::Output,
        outputs: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("EluGrad", |nd| {
            nd.add_input(gradients);
            nd.add_input(outputs);
            for op in &self.control_inputs {
                nd.add_control_input(op);
            }
            if let ::std::option::Option::Some(value) = &self.T {
                nd.set_attr_type("T", *value)?;
            }
            ::std::result::Result::Ok(())
        })
    }
}

/// Shorthand for `EluGrad::new().build(gradients, outputs, scope)`.
pub fn elu_grad<
    O0: ::std::convert::Into<crate::Output>,
    O1: ::std::convert::Into<crate::Output>,
>(
    gradients: O0,
    outputs: O1,
    scope: &mut crate::Scope,
) -> crate::Result<crate::Operation> {
    EluGrad::new().build(gradients, outputs, scope)
}
/// Builder for the `Empty` operation.
#[derive(::std::fmt::Debug, ::std::default::Default)]
pub struct Empty {
    dtype: ::std::option::Option<crate::DataType>,
    init: ::std::option::Option<bool>,
    control_inputs: ::std::vec::Vec<crate::Operation>,
}

impl Empty {
    /// Creates a new `Empty`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `init` attribute.
    pub fn init<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.init = ::std::option::Option::Some(value.into());
        self
    }

    /// Adds a control input.
    pub fn add_control_input(mut self, op: crate::Operation) -> Self {
        self.control_inputs.push(op);
        self
    }

    /// Builds the `Empty` operation.
    pub fn build<O0: ::std::convert::Into<crate::Output>>(
        &self,
        shape: O0,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        self.build_impl(shape.into(), scope)
    }

    fn build_impl(
        &self,
        shape: crate::Output,
        scope: &mut crate::Scope,
    ) -> crate::Result<crate::Operation> {
        scope.new_operation("Empty", |nd| {
            nd.add_input(s